<?php

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include 'conexion.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorTitulo = "AFCEEB";
$colorIntercalado = "DDEBF7";
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";
//$sheet->setCellValue('A1', 'Hello World !');
//fechas
$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];
$idusuario = $_REQUEST["idusuario"];

$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));
$contarFila = 15;
//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//DATOS EMPRESA
$info = DevolverUnArreglo("select * from auditoria");
$datosEmpresa = DevolverUnArreglo("select * from datosempresa");
$nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
$NIT = $datosEmpresa[0]['nit'];

$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:E4');
$drawing->setName('LOGO');
$drawing->setDescription('INGETRONIK');
$drawing->setPath('imagenreportes/logo.png');
$drawing->setCoordinates('A1');
$drawing->setWidthAndHeight(420, 200);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//
$sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$sheet->mergeCells('A5:E6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);
//
$sheet->getStyle('A7:E7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A7:E7');
$sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A7')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A7')->getAlignment()->setVertical('center');
$sheet->setCellValue("A7", $NIT);
//
$sheet->getStyle('A9:B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A9:B9');
$sheet->getStyle('A9')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A9')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A9')->getAlignment()->setVertical('center');
$sheet->setCellValue("A9", "FECHA REPORTE");
//
$sheet->getStyle('A10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A10')->getAlignment()->setVertical('left');
$sheet->setCellValue("A10", "FECHA INICIAL");
//
$sheet->getStyle('B10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B10')->getAlignment()->setVertical('left');
$sheet->setCellValue("B10", $fechaInicial);
//
$sheet->getStyle('A11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A11')->getAlignment()->setVertical('left');
$sheet->setCellValue("A11", "FECHA FINAL");
//
$sheet->getStyle('B11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B11')->getAlignment()->setVertical('left');
$sheet->setCellValue("B11", $fechafinal);
/*****/
$sheet->setCellValue("A1", $nombreempresa);
$sheet->setCellValue("A2", $NIT);

$ListaUsuarios = DevolverUnArreglo("SELECT * from usuario join calificacion on (calificacion.IdUsuario = usuario.IdUsuario) WHERE usuario.IdUsuario IN (SELECT IdUsuario from calificacion WHERE calificacion.FechaCalif > '$fechaInicial 00:00:00' and calificacion.FechaCalif < '$fechafinal 23:59:59') GROUP by usuario.IdUsuario");
//$preguntas = DevolverUnArreglo("SELECT preguntas.* from preguntas join calificacion on (calificacion.IdPregunta = preguntas.IdPregunta) WHERE calificacion.FechaCalif > '$fechaInicial 00:00:00' and calificacion.FechaCalif < '$fechafinal 23:59:59' GROUP by preguntas.IdPregunta");
//$sheet->mergeCells('A6:F6');

//
$sheet->getStyle('A13:C13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A13:C13');
$sheet->getStyle('A13')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A13')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A13')->getAlignment()->setVertical('center');
$sheet->setCellValue("A13", "CALIFICACIONES");

$contarCalif = 0;
$contarInicial = $contarFila;
$Calificaciones = DevolverUnArreglo("select valorcalif.Valor,NumCalif,count(*) as conteo from calificacion join valorcalif on (valorcalif.IdValorCalif = calificacion.NumCalif) where IdUsuario = $idusuario and FechaCalif BETWEEN '$fechaInicial 00:00:00' and '$fechafinal 23:59:59' GROUP by NumCalif");
foreach ($Calificaciones as $value) {
    //$Total = $value['conteo'] + $Total;
    $sheet->setCellValue("A$contarFila", $value['Valor']);
    $sheet->setCellValue("B$contarFila", $value['conteo']);
    $contarFila += 1;
    $contarCalif += $value['conteo'];
    if ($contarFila % 2 == 0) {
        $sheet->getStyle("A$contarFila:B$contarFila")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorFondoTituloRojoClaro);
    }
}
$sheet->setCellValue("A$contarFila", "TOTAL");
$sheet->setCellValue("B$contarFila", "$contarCalif");
$sheet->getStyle("A" . ($contarInicial - 1) . ":B$contarFila")->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));


//DETALLE
$contarFila += 2;
$sheet->mergeCells("A$contarFila:D$contarFila");
$sheet->setCellValue("A$contarFila", "DETALLE DE LAS CALIFICACIONES");
$sheet->getStyle("A$contarFila")->getAlignment()->setHorizontal('center');
$sheet->getStyle("A$contarFila:D" . ($contarFila + 1))->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorFondoTituloRojoClaro);

$contarFila += 1;
$sheet->setCellValue("A$contarFila", "NOMBRE DEL USUARIO");
$sheet->setCellValue("B$contarFila", "CALIFICACIÓN");
$sheet->setCellValue("C$contarFila", "FECHA Y HORA");
$sheet->setCellValue("D$contarFila", "ID");
$contarFila += 1;
$contarInicial = $contarFila;
//echo "select usuario.NombreUsuario,valorcalif.valor, Calificacion.NumCalif, Calificacion.FechaCalif, Calificacion.IdCalificacion from Calificacion join valorcalif on (calificacion.NumCalif = valorcalif.valor) join usuario on (usuario.IdUsuario = Calificacion.IdUsuario) where (Calificacion.FechaCalif BETWEEN '$fechaInicial 11:54:25' and '$fechafinal 11:54:25') and Calificacion.IdUsuario = $idusuario ORDER by Calificacion.IdCalificacion";

$Detalle = DevolverUnArreglo("select usuario.NombreUsuario,valorcalif.Valor, calificacion.NumCalif, calificacion.FechaCalif, calificacion.IdCalificacion from calificacion join valorcalif on (valorcalif.IdValorCalif = calificacion.NumCalif) join usuario on (usuario.IdUsuario = calificacion.IdUsuario) where (calificacion.FechaCalif BETWEEN '$fechaInicial 11:54:25' and '$fechafinal 11:54:25') and calificacion.IdUsuario = $idusuario ORDER by calificacion.IdCalificacion");
//$Detalle = DevolverUnArreglo("select usuario.NombreUsuario,valorcalif.valor, Calificacion.NumCalif, Calificacion.FechaCalif, Calificacion.IdCalificacion from Calificacion join valorcalif on (calificacion.NumCalif = valorcalif.valor) join usuario on (usuario.IdUsuario = Calificacion.IdUsuario) where (Calificacion.FechaCalif BETWEEN '$fechaInicial 11:54:25' and '$fechafinal 11:54:25') and Calificacion.IdUsuario = $idusuario ORDER by Calificacion.IdCalificacion");
foreach ($Detalle as $value) {
    $sheet->setCellValue("A$contarFila", $value['NombreUsuario']);
    $sheet->setCellValue("B$contarFila", $value['Valor']);
    $sheet->setCellValue("C$contarFila", $value['FechaCalif']);
    $sheet->setCellValue("D$contarFila", $value['IdCalificacion']);
    $contarFila += 1;
    if ($contarFila % 2 != 0) {
        $sheet->getStyle("A$contarFila:D$contarFila")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorFondoTituloRojoClaro);
    }
}
$sheet->getStyle("A" . ($contarInicial - 2) . ":D" . ($contarFila - 1))->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));

//diseño
$sheet->getStyle("E6")->getAlignment()->setHorizontal('center');
$sheet->getStyle("A$contarFila:D$contarFila")->getAlignment()->setHorizontal('center');
foreach (range('A', 'D') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

//GUARDAR ARCHIVO

$files = glob('reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}
$writer = new Xlsx($spreadsheet);
$writer->save('reportes/Reporte.xlsx');

$validar = array('respuesta' => 'Enviado Correctamente');

echo json_encode($validar, JSON_FORCE_OBJECT);

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    return $horas . ':' . $minutos . ":" . $segundos;
}

?>
