<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include 'conexion.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Chart\Chart;
use PhpOffice\PhpSpreadsheet\Chart\DataSeries;
use PhpOffice\PhpSpreadsheet\Chart\DataSeriesValues;
use PhpOffice\PhpSpreadsheet\Chart\Layout;
use PhpOffice\PhpSpreadsheet\Chart\Legend;
use PhpOffice\PhpSpreadsheet\Chart\PlotArea;
use PhpOffice\PhpSpreadsheet\Chart\Title;

$styleArrayBorder = array(
    'borders' => array(
        'outline' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
            'color' => array('argb' => '395980'),
        ),
    ),
);

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";
$nombreEmpresaColor = "A0B9CC";
//fechas
$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];
$IdEmpresa = $_REQUEST["IdEmpresa"];
$IdSede = $_REQUEST["IdSede"];

$ListaUsuarios = DevolverUnArreglo("SELECT usuario.NombreCompleto,usuario.IdUsuario,usuario.Cedula FROM usuario JOIN calificacion ON (calificacion.IdUsuario = usuario.IdUsuario) WHERE usuario.IdUsuario IN (SELECT IdUsuario FROM calificacion WHERE calificacion.FechaCalif > '$fechaInicial 00:00:00' AND calificacion.FechaCalif < '$fechafinal 23:59:59') GROUP BY usuario.IdUsuario ORDER BY usuario.NombreCompleto ASC");
$nombreempresa = DevolverUnDato("SELECT emp_nombre FROM empresa WHERE emp_id = '$IdEmpresa'");

for ($i=0; $i <COUNT($ListaUsuarios) ; $i++) { 
    $datos_pregunta = DevolverUnArreglo("SELECT pre.Pregunta, cali.IdPregunta FROM calificacion cali JOIN preguntas pre ON cali.IdPregunta = pre.IdPregunta WHERE cali.IdUsuario = '".$ListaUsuarios[$i]["IdUsuario"]."' and cali.FechaCalif > '$fechaInicial 00:00:00' and cali.FechaCalif < '$fechafinal 23:59:59' GROUP BY cali.IdPregunta ORDER BY pre.Pregunta ASC");
    $ListaUsuarios[$i]["preguntas"] = $datos_pregunta;
    for ($j=0; $j <count($ListaUsuarios[$i]["preguntas"]); $j++) { 
        $total_calif = DevolverUnArreglo("SELECT val.Valor,count(val.valor) AS total FROM calificacion cali JOIN valorcalif val ON cali.NumCalif = val.IdValorCalif WHERE cali.IdUsuario = '".$ListaUsuarios[$i]["IdUsuario"]."' and cali.FechaCalif > '$fechaInicial 00:00:00' and cali.FechaCalif < '$fechafinal 23:59:59' and cali.IdPregunta = '".$ListaUsuarios[$i]["preguntas"][$j]["IdPregunta"]."' GROUP BY cali.NumCalif ORDER BY cali.NumCalif DESC");
        $ListaUsuarios[$i]["preguntas"][$j]["valores"] = $total_calif;
    }
}


$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:E4');
$sheet->getStyle('A1:E4')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$drawing->setName('LOGO');
$drawing->setDescription('INGETRONIK');
$drawing->setPath('imagenreportes/logoTurnoMaster.png');
$drawing->setCoordinates('B1');
$drawing->setWidthAndHeight(250, 150);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());

$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A8:E11');
$drawing->setName('LogoCliente');
$drawing->setDescription('LogoCliente');
$drawing->setPath('imagenreportes/logoCliente.png');
$drawing->setCoordinates('B8');
$drawing->setWidthAndHeight(300, 300);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());

$sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($nombreEmpresaColor);
$sheet->mergeCells('A5:E6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);

$contador_fila = 15;
$inicio_chart = 0;
$fin_chart = 0;
$top_chart = 0;

for ($u=0; $u <COUNT($ListaUsuarios); $u++) {
    //
    $sheet->mergeCells("A".$contador_fila.":D".$contador_fila."");
    $sheet->setCellValue("A".$contador_fila."", $ListaUsuarios[$u]["NombreCompleto"]);
    $sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->applyFromArray($styleArrayBorder);
    $sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->getAlignment()->setHorizontal('center');
    $sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->getAlignment()->setVertical('center');
    $contador_fila = $contador_fila + 2;
    //
    for ($p=0; $p <COUNT($ListaUsuarios[$u]["preguntas"]); $p++) { 
        if($top_chart == 0){
            $top_chart = $contador_fila;
        }
        $sheet->mergeCells("A".$contador_fila.":B".$contador_fila."");
        $sheet->setCellValue("A".$contador_fila."", $ListaUsuarios[$u]["preguntas"][$p]["Pregunta"]);
        $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
        $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->applyFromArray($styleArrayBorder);
        $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->getAlignment()->setHorizontal('center');
        $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->getAlignment()->setVertical('center');
        $contador_fila = $contador_fila + 2;
        $total_conteo_preguntas = 0;
        //
       
        for ($v=0; $v <COUNT($ListaUsuarios[$u]["preguntas"][$p]["valores"]); $v++) {
            if($inicio_chart == 0){
                $inicio_chart = $contador_fila;
            }
            $sheet->setCellValue("A".$contador_fila."", $ListaUsuarios[$u]["preguntas"][$p]["valores"][$v]["Valor"]);
            $sheet->setCellValue("B".$contador_fila."", $ListaUsuarios[$u]["preguntas"][$p]["valores"][$v]["total"]);
            $sheet->getStyle("A".$contador_fila."")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
            $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->applyFromArray($styleArrayBorder);
            $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->getAlignment()->setHorizontal('center');
            $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->getAlignment()->setVertical('center');
            $total_conteo_preguntas = $total_conteo_preguntas + $ListaUsuarios[$u]["preguntas"][$p]["valores"][$v]["total"];
            $contador_fila++;
        }
        //
        if($fin_chart == 0){
            $fin_chart = ($contador_fila - 1);
        }
        
        $sheet->setCellValue("A".$contador_fila."", "Total");
        $sheet->setCellValue("B".$contador_fila."", $total_conteo_preguntas);
        $sheet->getStyle("A".$contador_fila."")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
        $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->applyFromArray($styleArrayBorder);
        $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->getAlignment()->setHorizontal('center');
        $sheet->getStyle("A".$contador_fila.":B".$contador_fila."")->getAlignment()->setVertical('center');
        //
        $contador_fila = $contador_fila + 2;

        ///AQUI DEBO CONSTRUIR LAS GRAFICAS!
        $colors = [
            'FF5733', '00abb8', 'b8292f', 'eb8500','eb8500',
        ];

        $dataSeriesLabels1 = [
            new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_STRING, 'Worksheet!$C$1', null, 1), // 2011
        ];

        $xAxisTickValues1 = [
            new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_STRING, 'Worksheet!$A$'.$inicio_chart.':$A$'.$fin_chart, null, 3), // Q1 to Q4 'Worksheet!$A$2:$A$5'
        ];

        $dataSeriesValues1 = [
            new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_NUMBER, 'Worksheet!$B$'.$inicio_chart.':$B$'.$fin_chart, null, 3, [], null, $colors),
            //new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_NUMBER, 'Worksheet!$B$5:$B$7', null, 3),
        ];

        $series1 = new DataSeries(
            DataSeries::TYPE_PIECHART, // plotType
            null, // plotGrouping (Pie charts don't have any grouping)
            range(0, count($dataSeriesValues1) - 1), // plotOrder
            $dataSeriesLabels1, // plotLabel
            $xAxisTickValues1, // plotCategory
            $dataSeriesValues1 // plotValues
        );
        // Set up a layout object for the Pie chart
        $layout1 = new Layout();
        $layout1->setShowVal(true);
        $layout1->setShowPercent(true);
        // Set the series in the plot area
        $plotArea1 = new PlotArea($layout1, [$series1]);
        // Set the chart legend
        $legend1 = new Legend(Legend::POSITION_RIGHT, null, false);
        //$legend1 = new ChartLegend(ChartLegend::POSITION_RIGHT, null, false);

        $title1 = new Title($ListaUsuarios[$u]["preguntas"][$p]["Pregunta"]);

        // Create the chart
        $chart1 = new Chart(
                'chart1', // name
                $title1, // title
                $legend1, // legend
                $plotArea1, // plotArea
                true, // plotVisibleOnly
                //DataSeries::EMPTY_AS_GAP, // displayBlanksAs
                0, // displayBlanksAs
                null, // xAxisLabel
                null   // yAxisLabel - Pie charts don't have a Y-Axis
        );
        // Set the position where the chart should appear in the worksheet
        $contador_fila = $contador_fila + 3;
        $chart1->setTopLeftPosition('D'.$top_chart);
        $chart1->setBottomRightPosition('G'.$contador_fila);
        $sheet->addChart($chart1);
        $top_chart = 0;
        $fin_chart = 0;
        $inicio_chart = 0;
        $contador_fila = $contador_fila + 2;
    }
    $contador_fila = $contador_fila + 2;
}

//////////////////////////////////////////////

//////////////////////////////////////////////

$contador_fila = $contador_fila + 2;
$detalle = DevolverUnArreglo("SELECT usu.NombreCompleto,pre.Pregunta,cali.FechaCalif,val.Valor FROM calificacion cali JOIN valorcalif val JOIN preguntas pre JOIN usuario usu ON cali.NumCalif = val.IdValorCalif AND cali.IdUsuario = usu.IdUsuario AND cali.IdPregunta = pre.IdPregunta WHERE cali.FechaCalif > '$fechaInicial 00:00:00' and cali.FechaCalif < '$fechafinal 23:59:59' ORDER BY cali.IdCalificacion DESC");

$sheet->setCellValue("A".$contador_fila."", "NOMBRE ASESOR");
$sheet->setCellValue("B".$contador_fila."", "PREGUNTA");
$sheet->setCellValue("C".$contador_fila."", "CALIFICACIÓN");
$sheet->setCellValue("D".$contador_fila."", "FECHA DE CALIFICACIÓN");
$sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->applyFromArray($styleArrayBorder);
$sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->getAlignment()->setHorizontal('center');
$sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->getAlignment()->setVertical('center');
$contador_fila++;
for ($i=0; $i <COUNT($detalle); $i++) { 
    $sheet->setCellValue("A".$contador_fila."", $detalle[$i]["NombreCompleto"]);
    $sheet->setCellValue("B".$contador_fila."", $detalle[$i]["Pregunta"]);
    $sheet->setCellValue("C".$contador_fila."", $detalle[$i]["Valor"]);
    $sheet->setCellValue("D".$contador_fila."", $detalle[$i]["FechaCalif"]);
    $sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->applyFromArray($styleArrayBorder);
    $sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->getAlignment()->setHorizontal('center');
    $sheet->getStyle("A".$contador_fila.":D".$contador_fila."")->getAlignment()->setVertical('center');
    $contador_fila++;
}

$detalle_mostrar;

for ($i=0; $i < 10; $i++) { 
    if(!empty($detalle[$i])){
        $detalle_mostrar[$i] = $detalle[$i];
    }
}

foreach (range('A', 'Z') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

$files = glob('reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}

$writer = new Xlsx($spreadsheet);
$writer->setIncludeCharts(true);
$writer->save('reportes/Reporte.xlsx');
if(empty($detalle_mostrar)){
    $detalle_mostrar = "";
}
$validar = array('respuesta' => 'Enviado Correctamente', 'detalle' => $detalle_mostrar);
echo json_encode($validar, JSON_FORCE_OBJECT);




/*
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorTitulo = "AFCEEB";
$colorIntercalado = "DDEBF7";

//fechas
$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];

$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));
$contarFila = 8;

//DATOS EMPRESA
$info = DevolverUnArreglo("select * from auditoria");
$datosEmpresa = DevolverUnArreglo("select * from datosempresa");
$nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
$NIT = $datosEmpresa[0]['nit'];


$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";

$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];


$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));
//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//DATOS EMPRESA
$info = DevolverUnArreglo("select * from auditoria");
$datosEmpresa = DevolverUnArreglo("select * from datosempresa");
$nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
$NIT = $datosEmpresa[0]['nit'];
//
$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:E4');
$drawing->setName('LOGO');
$drawing->setDescription('');
$drawing->setPath('imagenreportes/logo.png');
$drawing->setCoordinates('A1');
$drawing->setWidthAndHeight(420, 200);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//
$sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$sheet->mergeCells('A5:E6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);
//
$sheet->getStyle('A7:E7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A7:E7');
$sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A7')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A7')->getAlignment()->setVertical('center');
$sheet->setCellValue("A7", $NIT);
//
$sheet->getStyle('A9:B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A9:B9');
$sheet->getStyle('A9')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A9')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A9')->getAlignment()->setVertical('center');
$sheet->setCellValue("A9", "FECHA REPORTE");
//
$sheet->getStyle('A10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A10')->getAlignment()->setVertical('left');
$sheet->setCellValue("A10", "FECHA INICIAL");
//
$sheet->getStyle('B10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B10')->getAlignment()->setVertical('left');
$sheet->setCellValue("B10", $fechaInicial);
//
$sheet->getStyle('A11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A11')->getAlignment()->setVertical('left');
$sheet->setCellValue("A11", "FECHA FINAL");
//
$sheet->getStyle('B11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B11')->getAlignment()->setVertical('left');
$sheet->setCellValue("B11", $fechafinal);

// $sheet->setCellValue("A1", $nombreempresa);
// $sheet->setCellValue("A2", $NIT);

$ListaUsuarios = DevolverUnArreglo("SELECT * from usuario join calificacion on (calificacion.IdUsuario = usuario.IdUsuario) WHERE usuario.IdUsuario IN (SELECT IdUsuario from calificacion WHERE calificacion.FechaCalif > '$fechaInicial 00:00:00' and calificacion.FechaCalif < '$fechafinal 23:59:59') GROUP by usuario.IdUsuario");
//$preguntas = DevolverUnArreglo("SELECT preguntas.* from preguntas join calificacion on (calificacion.IdPregunta = preguntas.IdPregunta) WHERE calificacion.FechaCalif > '$fechaInicial 00:00:00' and calificacion.FechaCalif < '$fechafinal 23:59:59' GROUP by preguntas.IdPregunta");
//$sheet->mergeCells('A6:F6');

//
$sheet->getStyle('A13:C13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A13:C13');
$sheet->getStyle('A13')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A13')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A13')->getAlignment()->setVertical('center');
$sheet->setCellValue("A13", "CALIFICACIONES");

$contarFila = 15;
$contarColumna = 1;

$total = 0;
$conteoInicio = 0;
foreach ($ListaUsuarios as $value) {
    $sheet->setCellValue("A$contarFila", $value["NombreCompleto"]);
    $sheet->setCellValue("B$contarFila", "Calificación");
    $sheet->setCellValue("C$contarFila", "Cantidad");
    $sheet->getStyle("A$contarFila:C$contarFila")->getFont()->setBold(true);

    $contarFila += 1;
    $conteoInicio = $contarFila;
    $preguntas = DevolverUnArreglo("SELECT preguntas.* from preguntas join calificacion on (calificacion.IdPregunta = preguntas.IdPregunta) WHERE calificacion.FechaCalif > '$fechaInicial 00:00:00' and calificacion.FechaCalif < '$fechafinal 23:59:59' and calificacion.idusuario = " . $value["IdUsuario"] . " GROUP by preguntas.IdPregunta");
    foreach ($preguntas as $valuePreguntas) {
        $sheet->mergeCells("A$contarFila:C$contarFila");
        $sheet->setCellValue("A$contarFila", $valuePreguntas["Pregunta"]);
        $sheet->getStyle("A$contarFila")->getAlignment()->setHorizontal('center');
        $sheet->getStyle("A$contarFila:C$contarFila")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
        $contarFila += 1;
        $arrayCalif = DevolverUnArreglo("SELECT valorcalif.Valor, (SELECT count(*) from calificacion as c WHERE c.NumCalif = calificacion.NumCalif and c.IdUsuario = {$value["IdUsuario"]} and c.IdPregunta ={$valuePreguntas["IdPregunta"]} and c.FechaCalif >='$fechaInicial 00:00:00' and c.FechaCalif <='$fechafinal 23:59:59') as Numero from calificacion join valorcalif on (valorcalif.IdValorCalif = calificacion.NumCalif) GROUP by calificacion.NumCalif");
        foreach ($arrayCalif as $valueCalif) {
            $sheet->setCellValue("B$contarFila", $valueCalif["Valor"]);
            $sheet->setCellValue("C$contarFila", $valueCalif["Numero"]);
            $total =  $valueCalif["Numero"] + $total;
            $contarFila += 1;
        }
    }
    $sheet->setCellValue("B$contarFila", "Total");
    $sheet->setCellValue("C$contarFila", "$total");
    $total = 0;
    $sheet->getStyle("B$contarFila:C$contarFila")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle("B$contarFila:C$contarFila")->getFont()->setBold(true);
    $sheet->getStyle("A" . ($conteoInicio - 1) . ":C$contarFila")->getBorders()->getOutline()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
    $contarFila += 2;
}



$sheet->getStyle("E6")->getAlignment()->setHorizontal('center');
$sheet->getStyle("A$contarFila:C$contarFila")->getAlignment()->setHorizontal('center');
foreach (range('A', 'C') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}
//GUARDAR ARCHIVO

$files = glob('reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}

$writer = new Xlsx($spreadsheet);
$writer->save('reportes/Reporte.xlsx');

$validar = array('respuesta' => 'Enviado Correctamente');
echo json_encode($validar, JSON_FORCE_OBJECT);

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    return $horas . ':' . $minutos . ":" . $segundos;
}
*/


?>
