<?php

set_time_limit(9000);
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../conexion.php';
require '../vendor/autoload.php';

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    return $horas . ':' . $minutos . ":" . $segundos;
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";

$DatosReportes = $_REQUEST["DatosReportes"];
$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];
$IdUsuario = $_REQUEST["idusuario"];
$emp_id = $_REQUEST["IdEmpresa"];
$IdSede = $_REQUEST["IdSede"];
$campos = '';
$DatosReportes = explode(",", $DatosReportes);
//
for ($i=0; $i <count($DatosReportes) ; $i++) { 
    if($DatosReportes[$i] == 'cliente'){
        $campos = $campos . 'personas.NombreCompleto, personas.Cedula,';
    }else if($DatosReportes[$i] == 'asesor'){
        $campos = $campos . 't1.NombreCompleto as NombreAsesor, t2.NombreCompleto as NombreMedico,';
    }else if ($DatosReportes[$i] == 'turnos'){
        $campos = $campos . 'auditoria.IdAuditoria,auditoria.Turno,auditoria.Estado,auditoria.NumeroLlamados,auditoria.Observacion,';
    }else if($DatosReportes[$i] == 'servicio'){
        $campos = $campos . 'servicio.Servicio,servicio.EstadoSub,servicio.IdServicio,';
    }else if($DatosReportes[$i] == 'fechas'){
        $campos = $campos . 'auditoria.FechaLlegada,auditoria.FechaLlamado,auditoria.Fechasalio,auditoria.FLlamadoDocGeneral,auditoria.FSalioDocGeneral,auditoria.idDoctorGeneral,';
    }else if($DatosReportes[$i] == 'observaciones'){
        $campos = $campos . 'auditoria.ObservacionAsesor, auditoria.ObservacionRetraso,auditoria.ObservacionDoctorGeneral,';
    }
}

$campos = substr($campos, 0, -1);
//
$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));
//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//DATOS EMPRESA
$info = DevolverUnArreglo("select * from auditoria");
$datosEmpresa = DevolverUnArreglo("select * from datosempresa");
$nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
$NIT = $datosEmpresa[0]['nit'];

//imagen

$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:E4');
$drawing->setName('LOGO');
$drawing->setDescription('INGETRONIK');
$drawing->setPath('../imagenreportes/logo.png');
$drawing->setCoordinates('A1');
$drawing->setWidthAndHeight(420, 200);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//
$sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$sheet->mergeCells('A5:E6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);
//
$sheet->getStyle('A7:E7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A7:E7');
$sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A7')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A7')->getAlignment()->setVertical('center');
$sheet->setCellValue("A7", $NIT);
//
$sheet->getStyle('A9:B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A9:B9');
$sheet->getStyle('A9')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A9')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A9')->getAlignment()->setVertical('center');
$sheet->setCellValue("A9", "FECHA REPORTE");
//
$sheet->getStyle('A10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A10')->getAlignment()->setVertical('left');
$sheet->setCellValue("A10", "FECHA INICIAL");
//
$sheet->getStyle('B10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B10')->getAlignment()->setVertical('left');
$sheet->setCellValue("B10", $fechaInicial);
//
$sheet->getStyle('A11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A11')->getAlignment()->setVertical('left');
$sheet->setCellValue("A11", "FECHA FINAL");
//
$sheet->getStyle('B11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B11')->getAlignment()->setVertical('left');
$sheet->setCellValue("B11", $fechafinal);


//REPORTE DE TURNOS
$TurnosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado != 'NORMAL' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
$TurnosAtendidosCount = DevolverUnDato("select count(*) from auditoria  JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'TERMINADO'  and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
$TurnosAusentesCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'AUSENTE'  and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
$TurnosTransferidosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado = 'TERMINADO' and Observacion = 'TRANSFERIDO' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
//
$sheet->getStyle('A13:B13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A13:B13');
$sheet->getStyle('A13')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A13')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A13')->getAlignment()->setVertical('center');
$sheet->setCellValue("A13", "INFORMACIÓN DE TURNOS");
//
$sheet->getStyle('A14')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A14')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A14')->getAlignment()->setVertical('center');
$sheet->setCellValue("A14", "TURNOS TOTALES");
//
$sheet->getStyle('B14')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B14')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B14')->getAlignment()->setVertical('left');
$sheet->setCellValue("B14", $TurnosCount);
//
$sheet->getStyle('A15')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A15')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A15')->getAlignment()->setVertical('center');
$sheet->setCellValue("A15", "TURNOS ATENDIDOS");
//
$sheet->getStyle('B15')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B15')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B15')->getAlignment()->setVertical('center');
$sheet->setCellValue("B15", $TurnosAtendidosCount);
//
$sheet->getStyle('A16')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A16')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A16')->getAlignment()->setVertical('center');
$sheet->setCellValue("A16", "TURNOS AUSENTES");
//
$sheet->getStyle('B16')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B16')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B16')->getAlignment()->setVertical('center');
$sheet->setCellValue("B16", $TurnosAusentesCount);
//
$sheet->getStyle('A17')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A17')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A17')->getAlignment()->setVertical('center');
$sheet->setCellValue("A17", "TURNOS TRANSFERIDOS");
//
$sheet->getStyle('B17')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B17')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B17')->getAlignment()->setVertical('center');
$sheet->setCellValue("B17", $TurnosTransferidosCount);
//
$servicios = DevolverUnArreglo("select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' GROUP by auditoria.IdServicio");
$ServiciosCount = $TurnosCount;
$totalPorcentaje = 0;
//
$sheet->getStyle('A20:C20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A20:C20');
$sheet->getStyle('A20')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A20')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A20')->getAlignment()->setVertical('center');
$sheet->setCellValue("A20", "INFORMACIÓN DE LOS SERVICIOS");
//
$sheet->getStyle('A21:C21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A21')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A21')->getAlignment()->setVertical('center');
$sheet->setCellValue("A21", "SERVICIO");
//
$sheet->getStyle('B21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B21')->getAlignment()->setVertical('center');
$sheet->setCellValue("B21", "TOTAL");
//
$sheet->getStyle('C21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('C21')->getAlignment()->setVertical('center');
$sheet->setCellValue("C21", "PORCENTAJE");
//
$contar = 22;
for ($i=0; $i <count($servicios) ; $i++) { 
    $porcentaje = 0;
    //
    if ($i%2==0){
        $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
    }else{
        $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
    }
    $sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A' . $contar)->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A' . $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue('A' . $contar, $servicios[$i]['Servicio']);
    //
    $sheet->getStyle('B'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("B". $contar, $servicios[$i]['Cantidad']);
    //
    $porcentaje = ($servicios[$i]['Cantidad'] / $ServiciosCount) * 100;
    $totalPorcentaje = $totalPorcentaje + $porcentaje;
    //
    $sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("C". $contar, round($porcentaje, 2) . "%");
    //
    $contar = $contar + 1;
}
//
$sheet->mergeCells('A'. $contar .':B'. $contar);
$sheet->getStyle('A'. $contar .':B'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("A". $contar, "TOTAL");
//
$sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("C". $contar, $totalPorcentaje . "%");
//
//INFORMACION DE LOS DOCTORES
$sheet->getStyle('F20:H20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('F20:H20');
$sheet->getStyle('F20')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('F20')->getAlignment()->setHorizontal('center');
$sheet->getStyle('F20')->getAlignment()->setVertical('center');
$sheet->setCellValue("F20", "INFORMACIÓN DE LOS MEDICOS");
//
$sheet->getStyle('F21:H21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('F21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('F21')->getAlignment()->setHorizontal('left');
$sheet->getStyle('F21')->getAlignment()->setVertical('center');
$sheet->setCellValue("A21", "NOMBRE DOCTOR");
////
$sheet->getStyle('G21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('G21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('G21')->getAlignment()->setVertical('center');
$sheet->setCellValue("G21", "ATENDIDOS");
//
$sheet->getStyle('H21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('H21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('H21')->getAlignment()->setVertical('center');
$sheet->setCellValue("H21", "PORCENTAJE");
//
$doctores = DevolverUnArreglo("select usuario.NombreCompleto, COUNT(auditoria.idDoctorGeneral) as Cantidad from auditoria JOIN usuario on (auditoria.idDoctorGeneral = usuario.IdUsuario) JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' GROUP by auditoria.idDoctorGeneral");
$doctoresCount = 0;
$totalPorcentajeDoctor = 0;
$contarDoctores = 22;
//
if($doctores){
    foreach ($doctores as &$valor) {
        $doctoresCount = $valor['Cantidad'] + $doctoresCount;
    }
    foreach ($doctores as &$valor) {
        $porcentaje = 0;
        $sheet->setCellValue("F" . $contarDoctores, $valor['NombreCompleto']);
        $sheet->setCellValue("G" . $contarDoctores, $valor['Cantidad']);
        $porcentaje = ($valor['Cantidad'] / $doctoresCount) * 100;
        $totalPorcentajeDoctor = $totalPorcentajeDoctor + $porcentaje;
        $sheet->setCellValue("H" . $contarDoctores, round($porcentaje, 2) . "%");
        if ($contarDoctores % 2 == 1) {
            $sheet->getStyle('F' . $contarDoctores . ':H' . $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
        }
        $contarDoctores = $contarDoctores + 1;
    }
}else{
    $contarDoctores = $contarDoctores + 3;
}
$sheet->mergeCells('F'. $contarDoctores .':G'. $contarDoctores);
$sheet->getStyle('F'. $contarDoctores .':G'. $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('F' . $contarDoctores)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('F'. $contarDoctores)->getAlignment()->setHorizontal('center');
$sheet->getStyle('F'. $contarDoctores)->getAlignment()->setVertical('center');
$sheet->setCellValue("F". $contarDoctores, "TOTAL");
//
$sheet->getStyle('H'. $contarDoctores)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('H'. $contarDoctores)->getAlignment()->setHorizontal('center');
$sheet->getStyle('H'. $contarDoctores)->getAlignment()->setVertical('center');
$sheet->setCellValue("H". $contarDoctores, $totalPorcentajeDoctor . "%");
if($contar > $contarDoctores){
    $contar = $contar + 1;
}else{
    $contar = $contarDoctores;
}

$contar = $contar + 1;
echo("SELECT  ".$campos." from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'  ORDER by auditoria.IdAuditoria ASC");
$detalle = DevolverUnArreglo("SELECT  ".$campos." from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'  ORDER by auditoria.IdAuditoria ASC");
if($detalle){
$titulos = array_keys($detalle[0]);

if (in_array("fechas", $DatosReportes)) {
    $TiempoEsperaAsesor = 0;
    $TiempoAtencionAsesor = 0;
    $tiempoTotalAsesor = 0;
    $TiempoEsperaDoctor = 0;
    $TiempoAtencionDoctor = 0;
    $tiempoTotalDoctor = 0;
    $tiempoTotalEstadia = 0;
    array_push($titulos,"TIEMPO DE ESPERA EN SALA ASESOR [hh:mm:ss]","TIEMPO DE ATENCION ASESOR [hh:mm:ss]","TIEMPO TOTAL ASESOR [hh:mm:ss]","TIEMPO TOTAL DE PERMANENCIA DEL PACIENTE","TIEMPO DE ESPERA EN SALA DOCTOR [hh:mm:ss]","TIEMPO DE ATENCION DOCTOR [hh:mm:ss]","TIEMPO TOTAL DOCTOR [hh:mm:ss]");
    for ($i=0; $i <count($detalle); $i++) { 
        $TiempoEsperaAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlegada']), new DateTime($detalle[$i]['FechaLlamado']));
        $TiempoAtencionAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlamado']), new DateTime($detalle[$i]['Fechasalio']));
        $tiempoTotalAsesor = $TiempoEsperaAsesor + $TiempoAtencionAsesor;
        $detalle[$i]['TIEMPO DE ESPERA EN SALA ASESOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoEsperaAsesor);
        $detalle[$i]['TIEMPO DE ATENCION ASESOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoAtencionAsesor);
        $detalle[$i]['TIEMPO TOTAL ASESOR [hh:mm:ss]'] = conversorSegundosHoras($tiempoTotalAsesor);
        $tiempoTotalEstadia = $tiempoTotalAsesor;
        $TiempoEsperaDoctor = CalcularMinutos(new DateTime($detalle[$i]['FSalioDocGeneral']), new DateTime($detalle[$i]['FLlamadoDocGeneral']));
        $TiempoAtencionDoctor = CalcularMinutos(new DateTime($detalle[$i]['FLlamadoDocGeneral']), new DateTime($detalle[$i]['FSalioDocGeneral']));      
        $detalle[$i]['TIEMPO DE ESPERA EN SALA DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoEsperaDoctor);
        $detalle[$i]['TIEMPO DE ATENCION DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoAtencionDoctor);
        $tiempoTotalDoctor = $TiempoEsperaDoctor + $TiempoAtencionDoctor;
        $detalle[$i]['TIEMPO TOTAL DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($tiempoTotalDoctor);
        $tiempoTotalEstadia = $tiempoTotalAsesor + $tiempoTotalDoctor;
        $detalle[$i]['TIEMPO TOTAL DE PERMANENCIA DEL PACIENTE'] = conversorSegundosHoras($tiempoTotalEstadia);
    }
}

if(in_array("servicio", $DatosReportes)){
    array_push($titulos,"PERTENECE AL SERVICIO");
    for ($i=0; $i <count($detalle); $i++) { 
        if($detalle[$i]['EstadoSub'] != 'SERVICIO'){
            $ServiPertenece = DevolverUnDato("SELECT ser.Servicio FROM relacionservicios rela JOIN servicio ser on ser.IdServicio = rela.servicio WHERE rela.subservicio = '".$detalle[$i]['IdServicio']."' ORDER BY rela.idrelacionservicio DESC LIMIT 1"); //
            $detalle[$i]['PERTENECE AL SERVICIO'] = $ServiPertenece;
        }else{
            $detalle[$i]['PERTENECE AL SERVICIO'] = $detalle[$i]['Servicio'];
        }
    }
}

if (in_array("turnos", $DatosReportes)) {
    for ($i=0; $i <count($detalle); $i++) { 
        if ($detalle[$i]['Observacion'] == "TRANSFERIDO") {
            $detalle[$i]['Estado'] = 'TRANSFERIDO';
        } else {
            $detalle[$i]['Estado'] =  $detalle[$i]['Estado'];
        }
    }
}

$columnasExcel = '';
$miletra = "A";

for ($i =0; $i < count($detalle[0]) ; $i++){
    
    $columnasExcel = $columnasExcel.$miletra++.',';
}

$columnasExcel = explode(",", $columnasExcel);
array_pop($columnasExcel);

$cantidad = 0 ; 
foreach ($detalle[0] as $key => $value) {
    $cantidad ++;
}

for ($i=0; $i < $cantidad; $i++) { 
    $sheet->setCellValue($columnasExcel[$i]. $contar, $titulos[$i]);
    $ultimaposicion = $columnasExcel[$i];
}
        
$sheet->getStyle('A' . $contar . ':' .$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar . ':'.$ultimaposicion .  $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setVertical('center');

$contar = $contar + 1;
for ($i=0; $i <count($detalle); $i++) { 
    for ($j=0; $j <$cantidad; $j++) { 
        if ($i%2==0){
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
        }else{
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
        }
        $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue($columnasExcel[$j]. $contar, $detalle[$i][$titulos[$j]]);
    }
    $contar++;
}

foreach ($columnasExcel as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

$files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}
//
$writer = new Xlsx($spreadsheet);
$writer->save('../reportes/Reporte.xlsx');

$validar = array('respuesta' => 'Enviado Correctamente','DatosG' => $detalle , 'CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount );
echo json_encode($validar, JSON_FORCE_OBJECT);
}else{
    $files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
    foreach ($files as $file) {
        if (is_file($file))
            unlink($file); //elimino el fichero
    }
    //
    $writer = new Xlsx($spreadsheet);
    $writer->save('../reportes/Reporte.xlsx');
    //
    $validar = array('respuesta' => 'Enviado Correctamente','CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount );
    echo json_encode($validar, JSON_FORCE_OBJECT);
}
?>
