<?php

//consulta para traer los servicios diferentes de traige
//select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' GROUP by auditoria.IdServicio

set_time_limit(9000);
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../conexion.php';
require '../vendor/autoload.php';

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    return $horas . ':' . $minutos . ":" . $segundos;
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";

$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];
$IdServicio = $_REQUEST["idservicio"];

$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));
//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//DATOS EMPRESA
$info = DevolverUnArreglo("select * from auditoria");
$datosEmpresa = DevolverUnArreglo("select * from datosempresa");
$nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
$NIT = $datosEmpresa[0]['nit'];

//imagen

$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:E4');
$drawing->setName('LOGO');
$drawing->setDescription('INGETRONIK');
$drawing->setPath('../imagenreportes/logo.png');
$drawing->setCoordinates('A1');
$drawing->setWidthAndHeight(420, 200);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//
$sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$sheet->mergeCells('A5:E6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);
//
$sheet->getStyle('A7:E7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A7:E7');
$sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A7')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A7')->getAlignment()->setVertical('center');
$sheet->setCellValue("A7", $NIT);
//
$sheet->getStyle('A9:B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A9:B9');
$sheet->getStyle('A9')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A9')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A9')->getAlignment()->setVertical('center');
$sheet->setCellValue("A9", "FECHA REPORTE");
//
$sheet->getStyle('A10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A10')->getAlignment()->setVertical('left');
$sheet->setCellValue("A10", "FECHA INICIAL");
//
$sheet->getStyle('B10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B10')->getAlignment()->setVertical('left');
$sheet->setCellValue("B10", $fechaInicial);
//
$sheet->getStyle('A11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A11')->getAlignment()->setVertical('left');
$sheet->setCellValue("A11", "FECHA FINAL");
//
$sheet->getStyle('B11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B11')->getAlignment()->setVertical('left');
$sheet->setCellValue("B11", $fechafinal);
//
$TurnosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado != 'NORMAL' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdServicio = $IdServicio) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
$TurnosAtendidosCount = DevolverUnDato("select count(*) from auditoria  JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'TERMINADO'  and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdServicio = $IdServicio) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
$TurnosAusentesCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'AUSENTE' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdServicio = $IdServicio) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
$TurnosTransferidosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado = 'TERMINADO' and Observacion = 'TRANSFERIDO' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdServicio = $IdServicio) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
//
$sheet->getStyle('A13:B13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A13:B13');
$sheet->getStyle('A13')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A13')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A13')->getAlignment()->setVertical('center');
$sheet->setCellValue("A13", "INFORMACIÓN DE TURNOS");
//
$sheet->getStyle('A14')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A14')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A14')->getAlignment()->setVertical('center');
$sheet->setCellValue("A14", "TURNOS TOTALES");
//
$sheet->getStyle('B14')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B14')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B14')->getAlignment()->setVertical('left');
$sheet->setCellValue("B14", $TurnosCount);
//
$sheet->getStyle('A15')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A15')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A15')->getAlignment()->setVertical('center');
$sheet->setCellValue("A15", "TURNOS ATENDIDOS");
//
$sheet->getStyle('B15')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B15')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B15')->getAlignment()->setVertical('center');
$sheet->setCellValue("B15", $TurnosAtendidosCount);
//
$sheet->getStyle('A16')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A16')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A16')->getAlignment()->setVertical('center');
$sheet->setCellValue("A16", "TURNOS AUSENTES");
//
$sheet->getStyle('B16')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B16')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B16')->getAlignment()->setVertical('center');
$sheet->setCellValue("B16", $TurnosAusentesCount);
//
$sheet->getStyle('A17')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A17')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A17')->getAlignment()->setVertical('center');
$sheet->setCellValue("A17", "TURNOS TRANSFERIDOS");
//
$sheet->getStyle('B17')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B17')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B17')->getAlignment()->setVertical('center');
$sheet->setCellValue("B17", $TurnosTransferidosCount);
////
$servicios = DevolverUnArreglo("select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdServicio = $IdServicio) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' GROUP by auditoria.IdServicio");
$ServiciosCount = $TurnosCount;
$totalPorcentaje = 0;
//
$sheet->getStyle('A20:C20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A20:C20');
$sheet->getStyle('A20')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A20')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A20')->getAlignment()->setVertical('center');
$sheet->setCellValue("A20", "INFORMACIÓN DE LOS SERVICIOS");
//
$sheet->getStyle('A21:C21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A21')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A21')->getAlignment()->setVertical('center');
$sheet->setCellValue("A21", "SERVICIO");
//
$sheet->getStyle('B21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B21')->getAlignment()->setVertical('center');
$sheet->setCellValue("B21", "TOTAL");
//
$sheet->getStyle('C21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('C21')->getAlignment()->setVertical('center');
$sheet->setCellValue("C21", "PORCENTAJE");
//
$contar = 22;
for ($i=0; $i <count($servicios) ; $i++) { 
    $porcentaje = 0;
    //
    if ($i%2==0){
        $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
    }else{
        $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
    }
    $sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A' . $contar)->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A' . $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue('A' . $contar, $servicios[$i]['Servicio']);
    //
    $sheet->getStyle('B'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("B". $contar, $servicios[$i]['Cantidad']);
    //
    $porcentaje = ($servicios[$i]['Cantidad'] / $ServiciosCount) * 100;
    $totalPorcentaje = $totalPorcentaje + $porcentaje;
    //
    $sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("C". $contar, round($porcentaje, 2) . "%");
    //
    $contar = $contar + 1;
}
///
$sheet->mergeCells('A'. $contar .':B'. $contar);
$sheet->getStyle('A'. $contar .':B'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("A". $contar, "TOTAL");
//
$sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("C". $contar, $totalPorcentaje . "%");
//
//INFORMACION DE LOS DOCTORES
$sheet->getStyle('F20:H20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('F20:H20');
$sheet->getStyle('F20')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('F20')->getAlignment()->setHorizontal('center');
$sheet->getStyle('F20')->getAlignment()->setVertical('center');
$sheet->setCellValue("F20", "INFORMACIÓN DE LOS MEDICOS");
//
$sheet->getStyle('F21:H21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('F21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('F21')->getAlignment()->setHorizontal('left');
$sheet->getStyle('F21')->getAlignment()->setVertical('center');
$sheet->setCellValue("A21", "NOMBRE DOCTOR");
////
$sheet->getStyle('G21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('G21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('G21')->getAlignment()->setVertical('center');
$sheet->setCellValue("G21", "ATENDIDOS");
//
$sheet->getStyle('H21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('H21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('H21')->getAlignment()->setVertical('center');
$sheet->setCellValue("H21", "PORCENTAJE");
//
$doctores = DevolverUnArreglo("select usuario.NombreCompleto, COUNT(auditoria.idDoctorGeneral) as Cantidad from auditoria JOIN usuario on (auditoria.idDoctorGeneral = usuario.IdUsuario) JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdServicio = $IdServicio) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' GROUP by auditoria.idDoctorGeneral");
$doctoresCount = 0;
$totalPorcentajeDoctor = 0;
$contarDoctores = 22;
//



if($doctores){
    foreach ($doctores as &$valor) {
        $doctoresCount = $valor['Cantidad'] + $doctoresCount;
    }
    foreach ($doctores as &$valor) {
        $porcentaje = 0;
        $sheet->setCellValue("F" . $contarDoctores, $valor['NombreCompleto']);
        $sheet->setCellValue("G" . $contarDoctores, $valor['Cantidad']);
        $porcentaje = ($valor['Cantidad'] / $doctoresCount) * 100;
        $totalPorcentajeDoctor = $totalPorcentajeDoctor + $porcentaje;
        $sheet->setCellValue("H" . $contarDoctores, round($porcentaje, 2) . "%");
        if ($contarDoctores % 2 == 1) {
            $sheet->getStyle('F' . $contarDoctores . ':H' . $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
        }
        $contarDoctores = $contarDoctores + 1;
    }
}else{
    $contarDoctores = $contarDoctores + 3;
}


$sheet->mergeCells('F'. $contar .':G'. $contar);
$sheet->getStyle('F'. $contar .':G'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('F' . $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('F'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('F'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("F". $contar, "TOTAL");
//
$sheet->getStyle('H'. $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('H'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('H'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("C". $contar, $totalPorcentajeDoctor . "%");
$contar = $contarDoctores;
//
$contar += 2;
$sheet->getStyle('A' . $contar . ':X' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar . ':X' . $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar. ':X' . $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar. ':X' . $contar)->getAlignment()->setVertical('center');
//
$sheet->setCellValue("A". $contar, "NOMBRE DEL PACIENTE");
//
$sheet->setCellValue("B". $contar, "CEDULA DEL PACIENTE");
//
$sheet->setCellValue("C". $contar, "SERVICIO");
//
$sheet->setCellValue("D". $contar, "NIVEL");
//
$sheet->setCellValue("E". $contar, "PERTENECE AL SERVICIO");
//
$sheet->setCellValue("F". $contar, "TURNO");
//
$sheet->setCellValue("G". $contar, "NUMERO DE LLAMADOS");
//
$sheet->setCellValue("H". $contar, "ESTADO");
//
$sheet->setCellValue("I". $contar, "ASESOR");
//
$sheet->setCellValue("J". $contar, "TIEMPO DE ESPERA EN SALA ASESOR");
//
$sheet->setCellValue("K". $contar, "TIEMPO DE ATENCION ASESOR");
//
$sheet->setCellValue("L". $contar, "TIEMPO TOTAL ASESOR");
//
$sheet->setCellValue("M". $contar, "FECHA DE SOLICITUD ASESOR");
//
$sheet->setCellValue("N". $contar, "FECHA DE LLAMADO ASESOR");
//
$sheet->setCellValue("O". $contar, "FECHA DE TERMINACION DE TURNO ASESOR");
//
$sheet->setCellValue("P". $contar, "MEDICO");
//
$sheet->setCellValue("Q". $contar, "TIEMPO DE ESPERA EN SALA MEDICO");
//
$sheet->setCellValue("R". $contar, "TIEMPO DE ATENCION MEDICO");
//
$sheet->setCellValue("S". $contar, "TIEMPO TOTAL MEDICO");
//
$sheet->setCellValue("T". $contar, "FECHA DE LLAMADO MEDICO");
//
$sheet->setCellValue("U". $contar, "FECHA DE TERMINACION MEDICO");
//
$sheet->setCellValue("V". $contar, "TIEMPO TOTAL DE PERMANENCIA PACIENTE");
//
$sheet->setCellValue("W". $contar, "OBSERVACION ASESOR");
//
$sheet->setCellValue("X". $contar, "OBSERVACION MEDICO");
//
//
$detalle = DevolverUnArreglo("SELECT personas.NombreCompleto as Paciente,personas.Cedula,servicio.Servicio,servicio.EstadoSub,servicio.IdServicio,auditoria.Turno,auditoria.Estado,auditoria.NumeroLlamados, t1.NombreCompleto as Asesor,auditoria.FechaLlegada,auditoria.FechaLlamado,auditoria.Fechasalio,auditoria.Observacion,auditoria.ObservacionAsesor,auditoria.ObservacionRetraso, t2.NombreCompleto as NombreMedico,auditoria.FLlamadoDocGeneral as FLlmamadoMedico,auditoria.FSalioDocGeneral as FSalioMedico,auditoria.ObservacionDoctorGeneral as ObservacionMedico from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and (auditoria.IdServicio = $IdServicio) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'  ORDER by auditoria.IdAuditoria ASC");
//
for ($i=0; $i <count($detalle); $i++) { 
    if($detalle[$i]['Paciente'] == "0" || $detalle[$i]['Paciente'] == "" || $detalle[$i]['Paciente'] == "undefined" || $detalle[$i]['Paciente'] == null){
        $detalle[$i]['Paciente'] = "Sin Registro";
    }
    ///CEDULA DEL CLIENTE
    if($detalle[$i]['Cedula'] == "0" || $detalle[$i]['Cedula'] == "" || $detalle[$i]['Cedula'] == "undefined" || $detalle[$i]['Cedula'] == null){
        $detalle[$i]['Cedula'] = "Sin Registro";
    }
    if($detalle[$i]['NombreMedico'] == "0" || $detalle[$i]['NombreMedico'] == "" || $detalle[$i]['NombreMedico'] == "undefined" || $detalle[$i]['NombreMedico'] == null){
        $detalle[$i]['NombreMedico'] = "Sin Registro";
    }
}

$contar = $contar + 1;


for($i=0; $i <count($detalle) ; $i++){
    //
    $TiempoEsperaAsesor = 0;
    $TiempoAtencionAsesor = 0;
    $tiempoTotalAsesor = 0;

    $TiempoEsperaDoctor = 0;
    $TiempoAtencionDoctor = 0;
    $tiempoTotalDoctor = 0;
    $tiempoTotalEstadia = 0;

    if ($i%2==0){
        $sheet->getStyle('A' . $contar . ':X' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
    }else{
        $sheet->getStyle('A' . $contar . ':X' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
    }
    //
    $sheet->getStyle('A' . $contar . ':X' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar . ':X' . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar . ':X' . $contar)->getAlignment()->setVertical('center');
    //
    $sheet->setCellValue("A" . $contar, $detalle[$i]['Paciente']);
    $sheet->setCellValue("B" . $contar, $detalle[$i]['Cedula']);
    $sheet->setCellValue("C" . $contar, $detalle[$i]['Servicio']);
    if($detalle[$i]['EstadoSub'] != 'SERVICIO'){
        $sheet->setCellValue("D" . $contar, $detalle[$i]['EstadoSub']);
        
        $ServiPertenece = DevolverUnDato("SELECT ser.Servicio FROM relacionservicios rela JOIN servicio ser on ser.IdServicio = rela.servicio WHERE rela.subservicio = '".$detalle[$i]['IdServicio']."' ORDER BY rela.idrelacionservicio DESC LIMIT 1"); //
        $sheet->setCellValue("E" . $contar, $ServiPertenece);
    }else{
        $sheet->setCellValue("D" . $contar, $detalle[$i]['EstadoSub']);
        $sheet->setCellValue("E" . $contar, $detalle[$i]['Servicio']);
    }
    $sheet->setCellValue("F" . $contar, $detalle[$i]['Turno']);
    $sheet->setCellValue("G" . $contar, $detalle[$i]['NumeroLlamados']);

    if ($detalle[$i]['Observacion'] == "TRANSFERIDO") {
        $sheet->setCellValue("H" . $contar, "TRANSFERIDO");
    } else {
        $sheet->setCellValue("H" . $contar, $detalle[$i]['Estado']);
    }

    $sheet->setCellValue("I" . $contar, $detalle[$i]['Asesor']);

    $TiempoEsperaAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlegada']), new DateTime($detalle[$i]['FechaLlamado']));
    $TiempoAtencionAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlamado']), new DateTime($detalle[$i]['Fechasalio']));
    $tiempoTotalAsesor = $TiempoEsperaAsesor + $TiempoAtencionAsesor;

    $sheet->setCellValue("J" . $contar, conversorSegundosHoras($TiempoEsperaAsesor));
    $sheet->setCellValue("K" . $contar, conversorSegundosHoras($TiempoAtencionAsesor));
    $sheet->setCellValue("L" . $contar, conversorSegundosHoras($tiempoTotalAsesor));
    $sheet->setCellValue("M" . $contar, $detalle[$i]['FechaLlegada']);
    $sheet->setCellValue("N" . $contar, $detalle[$i]['FechaLlamado']);
    $sheet->setCellValue("O" . $contar, $detalle[$i]['Fechasalio']);
    $sheet->setCellValue("P" . $contar, $detalle[$i]['NombreMedico']);

    if ($detalle[$i]['idDoctorGeneral'] != 0) {
        $TiempoEsperaDoctor = CalcularMinutos(new DateTime($detalle[$i]['Fechasalio']), new DateTime($detalle[$i]['FLlmamadoMedico']));
    }

    $TiempoAtencionDoctor = CalcularMinutos(new DateTime($detalle[$i]['FLlmamadoMedico']), new DateTime($detalle[$i]['FSalioMedico']));
    $tiempoTotalDoctor = $TiempoEsperaDoctor + $TiempoAtencionDoctor;
    $sheet->setCellValue("Q" . $contar, conversorSegundosHoras($TiempoEsperaDoctor));
    $sheet->setCellValue("R" . $contar, conversorSegundosHoras($TiempoAtencionDoctor));
    $sheet->setCellValue("S" . $contar, conversorSegundosHoras($tiempoTotalDoctor));
    $sheet->setCellValue("T" . $contar, $detalle[$i]['FLlmamadoMedico']);
    $sheet->setCellValue("U" . $contar, $detalle[$i]['FSalioMedico']);
    $tiempoTotalEstadia = $tiempoTotalAsesor + $tiempoTotalDoctor;
    $sheet->setCellValue("V" . $contar, conversorSegundosHoras($tiempoTotalEstadia));
    $sheet->setCellValue("W" . $contar, $detalle[$i]['ObservacionAsesor']);
    $sheet->setCellValue("X" . $contar, $detalle[$i]['ObservacionMedico']);
    $contar = $contar + 1;
}

foreach (range('A', 'X') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}


$files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}
$writer = new Xlsx($spreadsheet);
$writer->save('../reportes/Reporte.xlsx');

for ($i=0; $i < COUNT($detalle); $i++) { 
    unset($detalle[$i]['IdServicio']);
}

$validar = array('respuesta' => 'Enviado Correctamente','DatosG' => $detalle ,'CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount );
echo json_encode($validar, JSON_FORCE_OBJECT);
?>
