<?php

//consulta para traer los servicios diferentes de traige
//select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' GROUP by auditoria.IdServicio


header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../conexion.php';
require '../vendor/autoload.php';

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    return $horas . ':' . $minutos . ":" . $segundos;
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorTitulo = "AFCEEB";
$colorIntercalado = "DDEBF7";

$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];

$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));


//DATOS EMPRESA
$info = DevolverUnArreglo("select * from auditoria");
$datosEmpresa = DevolverUnArreglo("select * from datosempresa");
$nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
$NIT = $datosEmpresa[0]['nit'];

$sheet->setCellValue("A1", $nombreempresa);
$sheet->setCellValue("A2", $NIT);

//unirCeldas
$sheet->mergeCells('A1:F1');
$sheet->mergeCells('A2:F2');
//centrar celdas
$sheet->getStyle('A1:F2')->getAlignment()->setHorizontal('center');
//borde de celdas
$sheet->getStyle('A1:F2')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
//Color de celda background
$sheet->getStyle('A1:F2')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorTitulo);



//FECHAS DE FILTRO
$sheet->getStyle('A3:B3')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('A4:B4')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->setCellValue("A3", "FECHA INICIAL");
$sheet->setCellValue("B3", $fechaInicial);

$sheet->setCellValue("A4", "FECHA FINAL");
$sheet->setCellValue("B4", $fechafinal);

//REPORTE DE TURNOS

$TurnosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado != 'NORMAL' and( servicio.Servicio = 'TRIAGE' or servicio.Servicio = 'TRIAGE 1' or servicio.Servicio = 'TRIAGE 2' or servicio.Servicio = 'TRIAGE 3' or servicio.Servicio = 'TRIAGE 4' or servicio.Servicio = 'TRIAGE 5')and auditoria.FechaLlegadaTriage >= '$fechaInicial 00:00:00' and auditoria.FechaLlegadaTriage <='$fechafinal 23:59:59'");
$TurnosAtendidosCount = DevolverUnDato("select count(*) from auditoria  JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'TERMINADO' and Observacion = '' and( servicio.Servicio = 'TRIAGE' or servicio.Servicio = 'TRIAGE 1' or servicio.Servicio = 'TRIAGE 2' or servicio.Servicio = 'TRIAGE 3' or servicio.Servicio = 'TRIAGE 4' or servicio.Servicio = 'TRIAGE 5') and auditoria.FechaLlegadaTriage >= '$fechaInicial 00:00:00' and auditoria.FechaLlegadaTriage <='$fechafinal 23:59:59'");
$TurnosAusentesCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'AUSENTE' and Observacion = '' and( servicio.Servicio = 'TRIAGE' or servicio.Servicio = 'TRIAGE 1' or servicio.Servicio = 'TRIAGE 2' or servicio.Servicio = 'TRIAGE 3' or servicio.Servicio = 'TRIAGE 4' or servicio.Servicio = 'TRIAGE 5')and auditoria.FechaLlegadaTriage >= '$fechaInicial 00:00:00' and auditoria.FechaLlegadaTriage <='$fechafinal 23:59:59'");
$TurnosTransferidosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado = 'TERMINADO' and Observacion = 'TRANSFERIDO' and( servicio.Servicio = 'TRIAGE' or servicio.Servicio = 'TRIAGE 1' or servicio.Servicio = 'TRIAGE 2' or servicio.Servicio = 'TRIAGE 3' or servicio.Servicio = 'TRIAGE 4' or servicio.Servicio = 'TRIAGE 5') and auditoria.FechaLlegadaTriage >= '$fechaInicial 00:00:00' and auditoria.FechaLlegadaTriage <='$fechafinal 23:59:59'");

$sheet->mergeCells('A6:B6');
$sheet->setCellValue("A6", "INFORMACION DE TURNOS");
$sheet->setCellValue("A7", "TURNOS TOTALES");
$sheet->setCellValue("B7", $TurnosCount);
$sheet->setCellValue("A8", "TURNOS ATENDIDOS");
$sheet->setCellValue("B8", $TurnosAtendidosCount);
$sheet->setCellValue("A9", "TURNOS AUSENTES");
$sheet->setCellValue("B9", $TurnosAusentesCount);
$sheet->setCellValue("A10", "TURNOS TRANSFERIDOS");
$sheet->setCellValue("B10", $TurnosTransferidosCount);
$sheet->getStyle('A6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorTitulo);
$sheet->getStyle('A7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
$sheet->getStyle('B7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
$sheet->getStyle('A9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
$sheet->getStyle('B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
$sheet->getStyle('A6:B6')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('A6:B6')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B6:B10')->getAlignment()->setHorizontal('center');

$contar = 14;


//REPORTE DE LOS SERVICIOS
$sheet->mergeCells('A12:C12');
$sheet->setCellValue("A12", "INFORMACION DE LOS SERVICIOS");
$sheet->setCellValue("A13", "SERVICIO");
$sheet->setCellValue("B13", "TOTAL");
$sheet->setCellValue("C13", "PORCENTAJE");
$sheet->getStyle('A13:C13')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('A13:C13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
//..........select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' GROUP by auditoria.IdServicio
//$servicios = DevolverUnArreglo("select servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' GROUP by auditoria.IdServicio");

$servicios = DevolverUnArreglo("select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and( servicio.Servicio = 'TRIAGE' or servicio.Servicio = 'TRIAGE 1' or servicio.Servicio = 'TRIAGE 2' or servicio.Servicio = 'TRIAGE 3' or servicio.Servicio = 'TRIAGE 4' or servicio.Servicio = 'TRIAGE 5') and auditoria.FechaLlegadaTriage >= '$fechaInicial 00:00:00' and auditoria.FechaLlegadaTriage<='$fechafinal 23:59:59' GROUP by auditoria.IdServicio");
$ServiciosCount = $TurnosCount;
$ServiciosCount = ($ServiciosCount <= 0) ? 1 : $ServiciosCount;

//$ServiciosCount = DevolverUnDato("select count(*) from auditoria where (Estado = 'TERMINADO' or Estado = 'AUSENTE') and Observacion != 'TRANSFERIDO' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
$totalPorcentaje = 0;
foreach ($servicios as &$valor) {

    $porcentaje = 0;
    $sheet->setCellValue("A" . $contar, $valor['Servicio']);
    $sheet->setCellValue("B" . $contar, $valor['Cantidad']);
    $porcentaje = ($valor['Cantidad'] / $ServiciosCount * 100);
    $totalPorcentaje = $totalPorcentaje + $porcentaje;

    $sheet->setCellValue("C" . $contar, round($porcentaje, 2) . "%");
    $sheet->getStyle('A1:F2')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
    if ($contar % 2 == 1) {
        $sheet->getStyle('A' . $contar . ':C' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
    }
    $contar = $contar + 1;
}

$sheet->mergeCells('A' . $contar . ':B' . $contar);
$sheet->setCellValue("A" . $contar, "TOTAL");
$sheet->setCellValue("C" . $contar, $totalPorcentaje . "%");

$sheet->getStyle('A1:F2')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
if ($contar % 2 == 1) {
    $sheet->getStyle('A' . $contar . ':C' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
}
$sheet->getStyle('A1:F2')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));

$contar = $contar + 2;
$sheet->getStyle('A12')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorTitulo);
$sheet->getStyle('A12:C12')->getAlignment()->setHorizontal('center');


//Informacion de Doctores
$contarDoctores = 14;
$sheet->mergeCells('E12:G12');
$sheet->setCellValue("E12", "INFORMACION SOBRE ATENCION DE DOCTORES");
$sheet->setCellValue("E13", "NOMBRE DOCTOR");
$sheet->setCellValue("F13", "ATENDIDOS");
$sheet->setCellValue("G13", "PORCENTAJE");
$sheet->getStyle('E13:G13')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('E13:G13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);

$doctores = DevolverUnArreglo("select usuario.NombreCompleto, COUNT(auditoria.idDoctorTriage) as Cantidad from auditoria JOIN usuario on (auditoria.idDoctorTriage = usuario.IdUsuario) JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (auditoria.Estado != 'NORMAL') and( servicio.Servicio = 'TRIAGE' or servicio.Servicio = 'TRIAGE 1' or servicio.Servicio = 'TRIAGE 2' or servicio.Servicio = 'TRIAGE 3' or servicio.Servicio = 'TRIAGE 4' or servicio.Servicio = 'TRIAGE 5') and auditoria.FechaLlegadaTriage >= '$fechaInicial 00:00:00' and auditoria.FechaLlegadaTriage <='$fechafinal 23:59:59' GROUP by auditoria.idDoctorGeneral");
$doctoresCount = 0;
$totalPorcentajeDoctor = 0;
foreach ($doctores as &$valor) {
    $doctoresCount = $valor['Cantidad'] + $doctoresCount;
}
foreach ($doctores as &$valor) {
//    print_r($valor);
    $porcentaje = 0;
//
    $sheet->setCellValue("E" . $contarDoctores, $valor['NombreCompleto']);
    $sheet->setCellValue("F" . $contarDoctores, $valor['Cantidad']);
    $porcentaje = ($valor['Cantidad'] / $doctoresCount) * 100;
    $totalPorcentajeDoctor = $totalPorcentajeDoctor + $porcentaje;
//
    $sheet->setCellValue("G" . $contarDoctores, round($porcentaje, 2) . "%");
//    $sheet->getStyle('E1:F2')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
    if ($contarDoctores % 2 == 1) {
        $sheet->getStyle('E' . $contarDoctores . ':G' . $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
    }
    $contarDoctores = $contarDoctores + 1;
}
$sheet->mergeCells('E' . $contarDoctores . ':F' . $contarDoctores);
$sheet->setCellValue("E" . $contarDoctores, "TOTAL");
$sheet->setCellValue("G" . $contarDoctores, $totalPorcentajeDoctor . "%");
$sheet->getStyle('E12')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorTitulo);
$sheet->getStyle('E12:G12')->getAlignment()->setHorizontal('center');
$contarDoctores = $contarDoctores + 2;
if ($contarDoctores > $contar) {
    $contar = $contarDoctores;
}


//DETALLE

$sheet->setCellValue("A" . $contar, "ID");
$sheet->mergeCells('A' . $contar . ':A' . ( $contar + 1));

$sheet->setCellValue("B" . $contar, "SERVICIO");
$sheet->mergeCells('B' . $contar . ':B' . ( $contar + 1));

$sheet->setCellValue("C" . $contar, "TURNO");
$sheet->mergeCells('C' . $contar . ':C' . ( $contar + 1));

$sheet->setCellValue("D" . $contar, "NOMBRE DEL PACIENTE");
$sheet->mergeCells('D' . $contar . ':D' . ( $contar + 1));

$sheet->setCellValue("E" . $contar, "CEDULA DEL PACIENTE");
$sheet->mergeCells('E' . $contar . ':E' . ( $contar + 1));

$sheet->setCellValue("F" . $contar, "ESTADO");
$sheet->mergeCells('F' . $contar . ':F' . ( $contar + 1));


$sheet->setCellValue("G" . $contar, "ASESOR");
$sheet->mergeCells('G' . $contar . ':G' . ( $contar + 1));

$sheet->setCellValue("H" . $contar, "ENFERMERIA");
$sheet->mergeCells('H' . $contar . ':O' . $contar);
//
$sheet->setCellValue("H" . ($contar + 1), "NOMBRE ENFERMERIA");
//
$sheet->setCellValue("I" . ($contar + 1), "TIEMPO DE ESPERA EN SALA \r ENFERMERIA [hh:mm:ss] ");
//$sheet->mergeCells('H' . $contar . ':H' . ( $contar + 1));

$sheet->setCellValue("J" . ($contar + 1), "TIEMPO DE ATENCION \r ENFERMERIA [hh:mm:ss]");
//$sheet->mergeCells('I' . $contar . ':I' . ( $contar + 1));

$sheet->setCellValue("K" . ($contar + 1), "TIEMPO TOTAL \r ENFERMERIA [hh:mm:ss]");
//$sheet->mergeCells('J' . $contar . ':J' . ( $contar + 1));

$sheet->setCellValue("L" . ($contar + 1), "HORA Y FECHA DE REGISTRO \r DE LLEGADA");
//$sheet->mergeCells('K' . $contar . ':K' . ( $contar + 1));
//
$sheet->setCellValue("M" . ($contar + 1), "HORA Y FECHA DE LLAMADO \r DE ENFERMERIA");
$sheet->setCellValue("N" . ($contar + 1), "HORA Y FECHA DE TERMINACION \r DE ATENCION ENFERMERIA");
$sheet->setCellValue("O" . ($contar + 1), "TIEMPO TOTAL \r DE ATENCION ENFERMERIA");
//
//
$sheet->setCellValue("P" . $contar, "DOCTOR");
$sheet->mergeCells('P' . $contar . ':U' . $contar);

$sheet->setCellValue("P" . ( $contar + 1), "NOMBRE DOCTOR");

$sheet->setCellValue("Q" . ($contar + 1), "TIEMPO DE ESPERA EN SALA \r DOCTOR [hh:mm:ss] ");

$sheet->setCellValue("R" . ($contar + 1), "TIEMPO DE ATENCION \r DOCTOR [hh:mm:ss] ");

$sheet->setCellValue("S" . ($contar + 1), "TIEMPO TOTAL \r DOCTOR [hh:mm:ss] ");

$sheet->setCellValue("T" . ($contar + 1), "HORA Y FECHA DE LLAMADO \r DE TURNO DOCTOR");
$sheet->setCellValue("U" . ($contar + 1), "HORA Y FECHA DE TERMINACION \r DE TURNO DOCTOR");

$sheet->setCellValue("V" . $contar, "TIEMPO TOTAL DE PERMANENCIA \r DEL PACIENTE");
$sheet->mergeCells('V' . $contar . ':V' . ( $contar + 1));
//$sheet->mergeCells('W' . $contar . ':T' . ( $contar + 1));
//$sheet->setCellValue("U" . $contar, "NUMERO DE LLAMADOS");
//$sheet->mergeCells('U' . $contar . ':U' . ( $contar + 1));
$sheet->setCellValue("W" . $contar, "OBSERVACION ASESOR");
$sheet->mergeCells('W' . $contar . ':W' . ( $contar + 1));
$sheet->setCellValue("X" . $contar, "OBSERVACION ENFERMERIA");
$sheet->mergeCells('X' . $contar . ':X' . ( $contar + 1));
$sheet->setCellValue("Y" . $contar, "OBSERVACION DOCTOR");
$sheet->mergeCells('Y' . $contar . ':Y' . ( $contar + 1));


$sheet->setAutoFilter('A' . ( $contar + 1) . ':Y' . ( $contar + 1));
$sheet->getStyle('A' . $contar . ':Y' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorTitulo);
$sheet->getStyle('A' . ( $contar + 1) . ':Y' . ( $contar + 1))->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorTitulo);
$sheet->getStyle('A' . $contar . ':Y' . $contar)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('A' . ( $contar + 1) . ':Y' . ( $contar + 1))->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('A' . ( $contar + 1) . ':Y' . ( $contar + 1))->getAlignment()->setHorizontal('center');
$sheet->getStyle('A' . $contar . ':Y' . $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A' . $contar . ':Y' . $contar)->getAlignment()->setVertical('center');
$sheet->getStyle('A' . ( $contar + 1) . ':Y' . ( $contar + 1))->getAlignment()->setVertical('center');
$sheet->getStyle("A" . ( $contar + 1), "Y" . ( $contar + 1))->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle("A" . ($contar + 1) . ":Y" . ($contar + 1))->getAlignment()->setWrapText(true);
$sheet->getStyle("A" . $contar . ":Y" . $contar)->getAlignment()->setWrapText(true);
$sheet->getStyle('I:O')->getAlignment()->setHorizontal('center');
$sheet->getStyle('Q:V')->getAlignment()->setHorizontal('center');
$sheet->getStyle('H' . $contar . ':U' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB('4F6CFF');
//$sheet->getStyle('A' . $contar . ':W' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorTitulo);
$contar = $contar + 2;


$detalle = DevolverUnArreglo("select servicio.Servicio, auditoria.*, t1.NombreCompleto as NombreAsesor, t2.NombreCompleto as NombreMedico,t3.NombreCompleto as NombreEnfermeria, personas.* from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorTriage) left join usuario as t3 on (t3.IdUsuario = auditoria.idEmfermeria) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and( servicio.Servicio = 'TRIAGE' or servicio.Servicio = 'TRIAGE 1' or servicio.Servicio = 'TRIAGE 2' or servicio.Servicio = 'TRIAGE 3' or servicio.Servicio = 'TRIAGE 4' or servicio.Servicio = 'TRIAGE 5') and auditoria.FechaLlegadaTriage >= '$fechaInicial 00:00:00' and auditoria.FechaLlegadaTriage <='$fechafinal 23:59:59'  ORDER by auditoria.IdAuditoria ASC");
//print_r($detalle);
//exit();
//$tiempoPromedioEspera = 0;
foreach ($detalle as &$valor) {
    $TiempoEsperaAsesor = 0;
    $TiempoAtencionAsesor = 0;
    $tiempoTotalAsesor = 0;

    $TiempoEsperaDoctor = 0;
    $TiempoAtencionDoctor = 0;
    $tiempoTotalDoctor = 0;
    $tiempoTotalEstadia = 0;
    if ($contar % 2 == 1) {
        $sheet->getStyle('A' . $contar . ':Y' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
    }
    $sheet->setCellValue("A" . $contar, $valor['IdAuditoria']);
    $sheet->setCellValue("B" . $contar, $valor['Servicio']);
    $sheet->setCellValue("C" . $contar, $valor['Turno']);
    $sheet->setCellValue("D" . $contar, $valor['NombreCompleto']);
    $sheet->setCellValue("E" . $contar, $valor['Cedula']);

    if ($valor['Observacion'] == "TRANSFERIDO") {
        $sheet->setCellValue("F" . $contar, "TRANSFERIDO");
    } else {
        $sheet->setCellValue("F" . $contar, $valor['Estado']);
    }

    $sheet->setCellValue("G" . $contar, $valor['NombreAsesor']);
    $sheet->setCellValue("H" . $contar, $valor['NombreEnfermeria']);

    $TiempoEsperaAsesor = CalcularMinutos(new DateTime($valor['FechaLlegadaTriage']), new DateTime($valor['FLlamadoEnf']));
    $TiempoAtencionAsesor = CalcularMinutos(new DateTime($valor['FLlamadoEnf']), new DateTime($valor['FSalioEnf']));
    $tiempoTotalAsesor = $TiempoEsperaAsesor + $TiempoAtencionAsesor;
////    if ($valor['Observacion'] != "AUSENTE") {
////        $tiempoPromedioEspera = $tiempoPromedioEspera + $tiempoTotal;
////    }
    $sheet->setCellValue("I" . $contar, conversorSegundosHoras($TiempoEsperaAsesor));
    $sheet->setCellValue("J" . $contar, conversorSegundosHoras($TiempoAtencionAsesor));
    $sheet->setCellValue("K" . $contar, conversorSegundosHoras($tiempoTotalAsesor));
    $sheet->setCellValue("L" . $contar, $valor['FechaLlegadaTriage']);
    $sheet->setCellValue("M" . $contar, $valor['FLlamadoEnf']);
    $sheet->setCellValue("N" . $contar, $valor['FSalioEnf']);
    $sheet->setCellValue("O" . $contar, $tiempoTotalAsesor);
    $sheet->setCellValue("p" . $contar, $valor['NombreMedico']);


    $TiempoEsperaDoctor = CalcularMinutos(new DateTime($valor['FSalioEnf']), new DateTime($valor['FLlamadoDocTriage']));
    $TiempoAtencionDoctor = CalcularMinutos(new DateTime($valor['FLlamadoDocTriage']), new DateTime($valor['FSalioDocTriage']));
    $tiempoTotalDoctor = $TiempoEsperaDoctor + $TiempoAtencionDoctor;
    $sheet->setCellValue("Q" . $contar, conversorSegundosHoras($TiempoEsperaDoctor));
    $sheet->setCellValue("R" . $contar, conversorSegundosHoras($TiempoAtencionDoctor));
    $sheet->setCellValue("S" . $contar, conversorSegundosHoras($tiempoTotalDoctor));
    $sheet->setCellValue("T" . $contar, $valor['FLlamadoDocTriage']);
    $sheet->setCellValue("U" . $contar, $valor['FSalioDocTriage']);
    $tiempoTotalEstadia = $tiempoTotalAsesor + $tiempoTotalDoctor;
    $sheet->setCellValue("V" . $contar, conversorSegundosHoras($tiempoTotalEstadia));
    $sheet->setCellValue("W" . $contar, $valor['ObservacionAsesor']);
    $sheet->setCellValue("X" . $contar, $valor['ObservacionEnfermeraTriage']);
    $sheet->setCellValue("Y" . $contar, $valor['ObservacionDoctorTriage']);
//    $contar = $contar + 1;
}

foreach (range('A', 'Y') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}
//GUARDAR ARCHIVO

$files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}
$writer = new Xlsx($spreadsheet);
$writer->save('../reportes/Reporte.xlsx');

$validar = array('respuesta' => 'Enviado Correctamente');
echo json_encode($validar, JSON_FORCE_OBJECT);


//select servicio.Servicio, auditoria.*, t1.NombreCompleto as NombreAsesor, t2.NombreCompleto as NombreMedico, personas.* from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' ORDER by auditoria.IdAuditoria ASC