<?php

set_time_limit(9000);
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');

include '../conexion.php';
require '../vendor/autoload.php';
require '../vendor/autoload.php';

require '../../../src/Exception.php';
require '../../../src/PHPMailer.php';
require '../../../src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    return $horas . ':' . $minutos . ":" . $segundos;
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$accion = $_REQUEST['accion'];
if($accion == "reporteProgramado"){



$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";

///********************************************** *///
$anioActual = date("Y");
$mesActual = date("n");
$cantidadDias = cal_days_in_month(CAL_GREGORIAN, $mesActual, $anioActual);
//echo $cantidadDias;
//
$enviarReporte = false;
$enviarReporteDiaI = '';
$enviarReporteDiaF = '';
///
$diaA = DevolverUnDato("select DAY(NOW())");

$mesA = DevolverUnDato("select MONTH(NOW())");
$anoA = DevolverUnDato("select YEAR(NOW())");

$ProgramacionDB = DevolverUnArreglo("SELECT * FROM reporteprogramado WHERE repo_mes = '$mesA' limit 1");
$conteo = DevolverUnArreglo("SELECT * FROM reporteprogramado");
///
// print_r($conteo);


if($ProgramacionDB){
    //echo "hola0";
    //
    
    if(count($conteo) == 1){
        if($ProgramacionDB[0]['repo_dia'] == $diaA && $ProgramacionDB[0]['repo_mes'] == $mesA){
            $enviarReporte = true;
            $enviarReporteDiaI = '01';
            $enviarReporteDiaF = $cantidadDias;
            $mesA += 1;
            hacerConsulta("UPDATE reporteprogramado SET repo_mes = $mesA");
        }
    }else if(count($conteo) == 2){
        if($ProgramacionDB[0]['repo_dia'] == $diaA && $ProgramacionDB[0]['repo_mes'] == $mesA){
            if($diaA == 28){
                $enviarReporte = true;
                $enviarReporteDiaI = '01';
                $enviarReporteDiaF = '15';
                $mesA += 1;
                hacerConsulta("UPDATE reporteprogramado SET repo_mes = $mesA WHERE repo_id = '".$ProgramacionDB[0]['repo_id']."'");
            }else if($diaA == 30){
                $enviarReporte = true;
                $enviarReporteDiaI = '16';
                $enviarReporteDiaF = $cantidadDias;
                $mesA += 1;
                hacerConsulta("UPDATE reporteprogramado SET repo_mes = $mesA WHERE repo_id = '".$ProgramacionDB[0]['repo_id']."'");
            }
        }
    }else if(count($conteo) == 4){
        if($ProgramacionDB[0]['repo_dia'] == $diaA && $ProgramacionDB[0]['repo_mes'] == $mesA){
            if($diaA == 8){
                $enviarReporte = true;
                $enviarReporteDiaI = '01';
                $enviarReporteDiaF = '08';
                $mesA += 1;
                hacerConsulta("UPDATE reporteprogramado SET repo_mes = $mesA WHERE repo_id = '".$ProgramacionDB[0]['repo_id']."'");
            }else if($diaA == 15){
                $enviarReporte = true;
                $enviarReporteDiaI = '09';
                $enviarReporteDiaF = '15';
                $mesA += 1;
                hacerConsulta("UPDATE reporteprogramado SET repo_mes = $mesA WHERE repo_id = '".$ProgramacionDB[0]['repo_id']."'");
            }else if($diaA == 23){
                $enviarReporte = true;
                $enviarReporteDiaI = '16';
                $enviarReporteDiaF = '23';
                $mesA += 1;
                hacerConsulta("UPDATE reporteprogramado SET repo_mes = $mesA WHERE repo_id = '".$ProgramacionDB[0]['repo_id']."'");
            }else if($diaA == 31){
               // echo "hola";
                $enviarReporte = true;
                $enviarReporteDiaI = '24';
                $enviarReporteDiaF = $cantidadDias;
                $mesA += 1;
                hacerConsulta("UPDATE reporteprogramado SET repo_mes = $mesA WHERE repo_id = '".$ProgramacionDB[0]['repo_id']."'");
            }
        }
    }
}


if($enviarReporte){
    $fechaInicial =  $anoA . '-' . $mesA . '-' . $enviarReporteDiaI;
    $fechafinal =  $anoA . '-' . $mesA . '-' . $enviarReporteDiaF;
    $fechaInicial = date("Y-m-d", strtotime($fechaInicial));
    $fechafinal = date("Y-m-d", strtotime($fechafinal));
    //PARAMETROS
    $tamañoLetraTitulo = 15;
    $tamañoLetraTexto = 12;
    //DATOS EMPRESA
    $info = DevolverUnArreglo("select * from auditoria");
    $datosEmpresa = DevolverUnArreglo("select * from datosempresa");
    $nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
    $NIT = $datosEmpresa[0]['nit'];
    //
    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $sheet->mergeCells('A1:E4');
    $drawing->setName('LOGO');
    $drawing->setDescription('INGETRONIK');
    $drawing->setPath('../imagenreportes/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(420, 200);
    $drawing->setResizeProportional(true);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    //
    $sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
    $sheet->mergeCells('A5:E6');
    $sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
    $sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A5", $nombreempresa);
    //
    $sheet->getStyle('A7:E7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->mergeCells('A7:E7');
    $sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTitulo);
    $sheet->getStyle('A7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A7')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A7", $NIT);
    //
    $sheet->getStyle('A9:B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->mergeCells('A9:B9');
    $sheet->getStyle('A9')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A9')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A9')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A9", "FECHA REPORTE");
    //
    $sheet->getStyle('A10')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A10')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A10')->getAlignment()->setVertical('left');
    $sheet->setCellValue("A10", "FECHA INICIAL");
    //
    $sheet->getStyle('B10')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B10')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('B10')->getAlignment()->setVertical('left');
    $sheet->setCellValue("B10", $fechaInicial);
    //
    $sheet->getStyle('A11')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A11')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A11')->getAlignment()->setVertical('left');
    $sheet->setCellValue("A11", "FECHA FINAL");
    //
    $sheet->getStyle('B11')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B11')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('B11')->getAlignment()->setVertical('left');
    $sheet->setCellValue("B11", $fechafinal);
    //
    $TurnosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado != 'NORMAL' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
    $TurnosAtendidosCount = DevolverUnDato("select count(*) from auditoria  JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'TERMINADO' and Observacion = '' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
    $TurnosAusentesCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'AUSENTE' and Observacion = '' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
    $TurnosTransferidosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado = 'TERMINADO' and Observacion = 'TRANSFERIDO' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'");
    //
    $sheet->getStyle('A13:B13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->mergeCells('A13:B13');
    $sheet->getStyle('A13')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A13')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A13')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A13", "INFORMACIÓN DE TURNOS");
    //
    $sheet->getStyle('A14')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A14')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A14')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A14", "TURNOS TOTALES");
    //
    $sheet->getStyle('B14')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B14')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B14')->getAlignment()->setVertical('left');
    $sheet->setCellValue("B14", $TurnosCount);
    //
    $sheet->getStyle('A15')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A15')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A15')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A15", "TURNOS ATENDIDOS");
    //
    $sheet->getStyle('B15')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B15')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B15')->getAlignment()->setVertical('center');
    $sheet->setCellValue("B15", $TurnosAtendidosCount);
    //
    $sheet->getStyle('A16')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A16')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A16')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A16", "TURNOS AUSENTES");
    //
    $sheet->getStyle('B16')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B16')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B16')->getAlignment()->setVertical('center');
    $sheet->setCellValue("B16", $TurnosAusentesCount);
    //
    $sheet->getStyle('A17')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A17')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A17')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A17", "TURNOS TRANSFERIDOS");
    //
    $sheet->getStyle('B17')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B17')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B17')->getAlignment()->setVertical('center');
    $sheet->setCellValue("B17", $TurnosTransferidosCount);
    //
    $servicios = DevolverUnArreglo("select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' GROUP by auditoria.IdServicio");
    $ServiciosCount = $TurnosCount;
    $totalPorcentaje = 0;
    //
    $sheet->getStyle('A20:C20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->mergeCells('A20:C20');
    $sheet->getStyle('A20')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A20')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A20')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A20", "INFORMACIÓN DE LOS SERVICIOS");
    //
    $sheet->getStyle('A21:C21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A21')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A21", "SERVICIO");
    //
    $sheet->getStyle('B21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B21')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("B21", "TOTAL");
    //
    $sheet->getStyle('C21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('C21')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('C21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("C21", "PORCENTAJE");
    //
    $contar = 22;
    //
    for ($i=0; $i <count($servicios) ; $i++) { 
        $porcentaje = 0;
        //
        if ($i%2==0){
            $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
        }else{
            $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
        }
        $sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('A' . $contar)->getAlignment()->setHorizontal('left');
        $sheet->getStyle('A' . $contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue('A' . $contar, $servicios[$i]['Servicio']);
        //
        $sheet->getStyle('B'. $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('B'. $contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('B'. $contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue("B". $contar, $servicios[$i]['Cantidad']);
        //
        $porcentaje = ($servicios[$i]['Cantidad'] / $ServiciosCount) * 100;
        $totalPorcentaje = $totalPorcentaje + $porcentaje;
        //
        $sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue("C". $contar, round($porcentaje, 2) . "%");
        //
        $contar = $contar + 1;
    }
    
    //
    $sheet->mergeCells('A'. $contar .':B'. $contar);
    $sheet->getStyle('A'. $contar .':B'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("A". $contar, "TOTAL");
    //
    $sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("C". $contar, $totalPorcentaje . "%");

    //INFORMACION DE LOS DOCTORES
    $sheet->getStyle('F20:H20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->mergeCells('F20:H20');
    $sheet->getStyle('F20')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('F20')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('F20')->getAlignment()->setVertical('center');
    $sheet->setCellValue("F20", "INFORMACIÓN DE LOS MEDICOS");
    //
    $sheet->getStyle('F21:H21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('F21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('F21')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('F21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A21", "NOMBRE DOCTOR");
    ////
    $sheet->getStyle('G21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('G21')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('G21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("G21", "ATENDIDOS");
    //
    $sheet->getStyle('H21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('H21')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('H21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("H21", "PORCENTAJE");
    //
    $doctores = DevolverUnArreglo("select usuario.NombreCompleto, COUNT(auditoria.idDoctorGeneral) as Cantidad from auditoria JOIN usuario on (auditoria.idDoctorGeneral = usuario.IdUsuario) JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' GROUP by auditoria.idDoctorGeneral");
    $doctoresCount = 0;
    $totalPorcentajeDoctor = 0;
    //
    $contarDoctores = 22;
    //
    if($doctores){
        foreach ($doctores as &$valor) {
            $doctoresCount = $valor['Cantidad'] + $doctoresCount;
        }
        foreach ($doctores as &$valor) {
            $porcentaje = 0;
            $sheet->setCellValue("F" . $contarDoctores, $valor['NombreCompleto']);
            $sheet->setCellValue("G" . $contarDoctores, $valor['Cantidad']);
            $porcentaje = ($valor['Cantidad'] / $doctoresCount) * 100;
            $totalPorcentajeDoctor = $totalPorcentajeDoctor + $porcentaje;
            $sheet->setCellValue("H" . $contarDoctores, round($porcentaje, 2) . "%");
            if ($contarDoctores % 2 == 1) {
                $sheet->getStyle('F' . $contarDoctores . ':H' . $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
            }
            $contarDoctores = $contarDoctores + 1;
        }
    }else{
        $contarDoctores = $contarDoctores + 3;
    }
    
    //
    $sheet->mergeCells('F'. $contar .':G'. $contar);
    $sheet->getStyle('F'. $contar .':G'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('F' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('F'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('F'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("F". $contar, "TOTAL");
    //
    $sheet->getStyle('H'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('H'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('H'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("C". $contar, $totalPorcentajeDoctor . "%");
    $contar = $contarDoctores;

    $contar += 2;
    $sheet->getStyle('A' . $contar . ':X' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A' . $contar . ':X' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar. ':X' . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar. ':X' . $contar)->getAlignment()->setVertical('center');
    //
    $sheet->setCellValue("A". $contar, "ID");
    //
    $sheet->setCellValue("B". $contar, "SERVICIO");
    //
    $sheet->setCellValue("C". $contar, "TURNO");
    //
    $sheet->setCellValue("D". $contar, "NOMBRE DEL PACIENTE");
    //
    $sheet->setCellValue("E". $contar, "TIPO DE DOCUMENTO");
    //
    $sheet->setCellValue("F". $contar, "CEDULA DEL PACIENTE");
    //
    $sheet->setCellValue("G". $contar, "ESTADO");
    //
    $sheet->setCellValue("H". $contar, "ASESOR");
    //
    $sheet->setCellValue("I". $contar, "TIEMPO DE ESPERA EN SALA \r ASESOR [hh:mm:ss] ");
    //
    $sheet->setCellValue("J". $contar, "TIEMPO DE ATENCION \r ASESOR [hh:mm:ss]");
    //
    $sheet->setCellValue("K". $contar, "TIEMPO TOTAL \r ASESOR [hh:mm:ss]");
    //
    $sheet->setCellValue("L". $contar, "HORA Y FECHA DE SOLICITUD \r DE TURNO ASESOR");
    //
    $sheet->setCellValue("M". $contar, "HORA Y FECHA DE LLAMADO \r DE TURNO ASESOR");
    //
    $sheet->setCellValue("N". $contar, "HORA Y FECHA DE TERMINACION \r DE TURNO ASESOR");
    //
    $sheet->setCellValue("O". $contar, "DOCTOR");
    //
    $sheet->setCellValue("P". $contar, "TIEMPO DE ESPERA EN SALA \r DOCTOR [hh:mm:ss]");
    //
    $sheet->setCellValue("Q". $contar, "TIEMPO DE ATENCION \r DOCTOR [hh:mm:ss]");
    //
    $sheet->setCellValue("R". $contar, "TIEMPO TOTAL \r DOCTOR [hh:mm:ss]");
    //
    $sheet->setCellValue("S". $contar, "HORA Y FECHA DE LLAMADO \r DE TURNO DOCTOR");
    //
    $sheet->setCellValue("T". $contar, "HORA Y FECHA DE TERMINACION \r DE TURNO DOCTOR");
    //
    $sheet->setCellValue("U". $contar, "TIEMPO TOTAL DE PERMANENCIA \r DEL PACIENTE");
    //
    $sheet->setCellValue("V". $contar, "NUMERO DE LLAMADOS");
    //
    $sheet->setCellValue("W". $contar, "OBSERVACION ASESOR");
    //
    $sheet->setCellValue("X". $contar, "OBSERVACION DOCTOR");
    //
    $detalle = DevolverUnArreglo("select servicio.Servicio, auditoria.*, t1.NombreCompleto as NombreAsesor, t2.NombreCompleto as NombreMedico, personas.* from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'  ORDER by auditoria.IdAuditoria ASC");
    $contar = $contar + 1;
    //
    
    for($i=0; $i <count($detalle) ; $i++){
        //
        $TiempoEsperaAsesor = 0;
        $TiempoAtencionAsesor = 0;
        $tiempoTotalAsesor = 0;

        $TiempoEsperaDoctor = 0;
        $TiempoAtencionDoctor = 0;
        $tiempoTotalDoctor = 0;
        $tiempoTotalEstadia = 0;

        if ($i%2==0){
            $sheet->getStyle('A' . $contar . ':X' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
        }else{
            $sheet->getStyle('A' . $contar . ':X' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
        }
        //
        $sheet->getStyle('A' . $contar . ':X' . $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('A'. $contar . ':X' . $contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A'. $contar . ':X' . $contar)->getAlignment()->setVertical('center');
        //
        $sheet->setCellValue("A" . $contar, $detalle[$i]['IdAuditoria']);
        $sheet->setCellValue("B" . $contar, $detalle[$i]['Servicio']);
        $sheet->setCellValue("C" . $contar, $detalle[$i]['Turno']);
        $sheet->setCellValue("D" . $contar, $detalle[$i]['NombreCompleto']);
        $sheet->setCellValue("E" . $contar, $detalle[$i]['TipoDocumento']);
        $sheet->setCellValue("F" . $contar, $detalle[$i]['Cedula']);

        if ($detalle[$i]['Observacion'] == "TRANSFERIDO") {
            $sheet->setCellValue("G" . $contar, "TRANSFERIDO");
        } else {
            $sheet->setCellValue("G" . $contar, $detalle[$i]['Estado']);
        }

        $sheet->setCellValue("H" . $contar, $detalle[$i]['NombreAsesor']);

        $TiempoEsperaAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlegada']), new DateTime($detalle[$i]['FechaLlamado']));
        $TiempoAtencionAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlamado']), new DateTime($detalle[$i]['Fechasalio']));
        $tiempoTotalAsesor = $TiempoEsperaAsesor + $TiempoAtencionAsesor;

        $sheet->setCellValue("I" . $contar, conversorSegundosHoras($TiempoEsperaAsesor));
        $sheet->setCellValue("J" . $contar, conversorSegundosHoras($TiempoAtencionAsesor));
        $sheet->setCellValue("K" . $contar, conversorSegundosHoras($tiempoTotalAsesor));
        $sheet->setCellValue("L" . $contar, $detalle[$i]['FechaLlegada']);
        $sheet->setCellValue("M" . $contar, $detalle[$i]['FechaLlamado']);
        $sheet->setCellValue("N" . $contar, $detalle[$i]['Fechasalio']);
        $sheet->setCellValue("O" . $contar, $detalle[$i]['NombreMedico']);

        if ($detalle[$i]['idDoctorGeneral'] != 0) {
            $TiempoEsperaDoctor = CalcularMinutos(new DateTime($detalle[$i]['Fechasalio']), new DateTime($detalle[$i]['FLlamadoDocGeneral']));
        }

        $TiempoAtencionDoctor = CalcularMinutos(new DateTime($detalle[$i]['FLlamadoDocGeneral']), new DateTime($detalle[$i]['FSalioDocGeneral']));
        $tiempoTotalDoctor = $TiempoEsperaDoctor + $TiempoAtencionDoctor;
        $sheet->setCellValue("P" . $contar, conversorSegundosHoras($TiempoEsperaDoctor));
        $sheet->setCellValue("Q" . $contar, conversorSegundosHoras($TiempoAtencionDoctor));
        $sheet->setCellValue("R" . $contar, conversorSegundosHoras($tiempoTotalDoctor));
        $sheet->setCellValue("S" . $contar, $detalle[$i]['FLlamadoDocGeneral']);
        $sheet->setCellValue("T" . $contar, $detalle[$i]['FSalioDocGeneral']);
        $tiempoTotalEstadia = $tiempoTotalAsesor + $tiempoTotalDoctor;
        $sheet->setCellValue("U" . $contar, conversorSegundosHoras($tiempoTotalEstadia));
        $sheet->setCellValue("V" . $contar, $detalle[$i]['NumeroLlamados']);
        $sheet->setCellValue("W" . $contar, $detalle[$i]['ObservacionAsesor']);
        $sheet->setCellValue("X" . $contar, $detalle[$i]['ObservacionDoctorGeneral']);
        $contar = $contar + 1;
    }

    foreach (range('A', 'x') as $columnID) {
        $sheet->getColumnDimension($columnID)->setAutoSize(true);
    }

    $files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
    foreach ($files as $file) {
        if (is_file($file))
            unlink($file); //elimino el fichero
    }
    //
    $writer = new Xlsx($spreadsheet);
    $writer->save('../reportes/ReporteProgramado.xlsx');
    ///
    $ciphering = "AES-128-CTR";
    $options = 0;
    $decryption_iv = '1234567891011121';
    $decryption_key = "gato";
    ///
    $datosReporte = DevolverUnArreglo("SELECT pconf_correo, pconf_contrasena FROM pconfig");
    $contrasena = openssl_decrypt($datosReporte[0]['pconf_contrasena'], $ciphering, $decryption_key, $options, $decryption_iv);
   
    $correoDestinos = DevolverUnArreglo("SELECT `repoco_correo` FROM `reporteprogramado_correos`");
    
    for ($i=0; $i <count($correoDestinos) ; $i++) { 
        # code...
    $mail = new PHPMailer(true);
    $mail->SMTPDebug = 2;                                 // Enable verbose debug output
    $mail->isSMTP();                                      // Set mailer to use SMTP
    $mail->CharSet = 'UTF-8';
    $mail->Host = "smtp.gmail.com";
    $mail->SMTPAuth = true;                               // Enable SMTP authentication
    $mail->Username = $datosReporte[0]['pconf_correo'];                 // SMTP username
    $mail->Password = $contrasena;                           // SMTP password
    $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
    $mail->Port = 587;                                    // TCP port to connect to
    $mail->setFrom($datosReporte[0]['pconf_correo'], $datosReporte[0]['pconf_correo']);
    $mail->addAddress($correoDestinos[$i]['repoco_correo'], '');  
    $archivo = '../reportes/ReporteProgramado.xlsx';
    $mail->AddAttachment($archivo,'ReporteSemanal');   // Add a recipient
    $imagenIngetronik = "https://media.vandal.net/m/27675/dont-starve-together-201642193235_14.jpg";
    $mail->isHTML(true);                                  // Set email format to HTML
    $mail->Subject = 'HOLA MUNDO';
    $mail->Body = "<html>" .
                "<head>" .
                "    <title>TODO supply a title</title>" .
                "  <meta charset=\"UTF-8\">" .
                "  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">" .
                "</head>" .
                "<body style=\"font-family:'Century Gothic'\">" .
                "<div>" .
                "<center><h1>HOLA MUNDO 2</h1></center> " .
                "</div>" .
                "<div>" .
                "  <h4><b>HOLA MUNDO,</b></h4>" .
                "   HOLA MUNDO HOLA MUNDO" .
                "  <br>" .
                "  <br>" .
                "  HOLA MUNDO: " .
                " <h4>HOLA MUNDO HOLA MUNDO HOLA MUNDO</h4>" .
                "</div>" .
                "  <div>" .
                "   <hr/>" .
                "  <center> <img src=\"" . $imagenIngetronik . "\"  width=\"130\" height=\"70\"> </center><br>" .
                "   <center> <a href=\"www.HOLA MUNDO.com\">www.HOLA MUNDO.com</a>  </center>" .
                " </div>" .
                " </body>" .
                "</html>";
    $mail->send();
    }


    
}


}


?>