<?php
set_time_limit(9000);
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../conexion.php';
require '../vendor/autoload.php';

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);
    return $horas . ':' . $minutos . ":" . $segundos;
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;


$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";
$nombreEmpresaColor = "A0B9CC";

$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];
$servicios = 0;
$DatosReportes = $_REQUEST["DatosReportes"];
$campos = '';
$DatosReportes = explode(",", $DatosReportes);
//
$IdEmpresa = $_REQUEST["IdEmpresa"];
$IdSede = $_REQUEST["IdSede"];
//
for ($i=0; $i <count($DatosReportes) ; $i++) { 
    if($DatosReportes[$i] == 'cliente'){
        $campos = $campos . 'personas.NombreCompleto, personas.Cedula, personas.eps,';
    }else if($DatosReportes[$i] == 'asesor'){
        $campos = $campos . 't1.NombreCompleto as Asesor, t2.NombreCompleto as NombreMedico,';
    }else if ($DatosReportes[$i] == 'turnos'){
        $campos = $campos . 'auditoria.Turno,auditoria.Estado,auditoria.NumeroLlamados,auditoria.Observacion,';
    }else if($DatosReportes[$i] == 'fechas'){
        $campos = $campos . 'auditoria.idDoctorGeneral,servicio.Servicio,servicio.EstadoSub,servicio.IdServicio,';
    }else if($DatosReportes[$i] == 'observaciones'){
        $campos = $campos . 'auditoria.ObservacionAsesor, auditoria.ObservacionRetraso,auditoria.ObservacionDoctorGeneral,';
    }
}

$campos = substr($campos, 0, -1);

$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));
//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//DATOS EMPRESA
$nombreempresa = DevolverUnDato("SELECT emp_nombre FROM empresa WHERE emp_id = '$IdEmpresa'");
//
$styleArrayBorder = array(
    'borders' => array(
        'outline' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
            'color' => array('argb' => '395980'),
        ),
    ),
);
$styleArray = array(
    'font'  => array(
        'bold'  => true,
        'color' => array('rgb' => 'FFFFFF'),
        'size'  => 12,
        'name'  => 'Calibri'
    )
);
$styleArrayColorBlack = array(
    'font'  => array(
        'bold'  => true,
        'color' => array('rgb' => '000000'),
        'size'  => 12,
        'name'  => 'Calibri'
    )
);

$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:E4');
$sheet->getStyle('A1:E4')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$drawing->setName('LOGO');
$drawing->setDescription('INGETRONIK');
$drawing->setPath('../imagenreportes/logoTurnoMaster.png');
$drawing->setCoordinates('B1');
$drawing->setWidthAndHeight(250, 150);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//

$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A8:E11');
$drawing->setName('LogoCliente');
$drawing->setDescription('LogoCliente');
$drawing->setPath('../imagenreportes/logoCliente.png');
$drawing->setCoordinates('B8');
$drawing->setWidthAndHeight(300, 300);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
// $sheet->getStyle('C1')->getAlignment()->setHorizontal('center');
//$sheet->getStyle('C1')->getAlignment()->setVertical('center');


$sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($nombreEmpresaColor);
$sheet->mergeCells('A5:E6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);
//
// $sheet->getStyle('A7:E7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
// $sheet->mergeCells('A7:E7');
// $sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTitulo);
// $sheet->getStyle('A7')->getAlignment()->setHorizontal('center');
// $sheet->getStyle('A7')->getAlignment()->setVertical('center');
// $sheet->setCellValue("A7", $NIT);
//
$sheet->getStyle('A13:B13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('B14:B17')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($nombreEmpresaColor);
$sheet->mergeCells('A13:B13');
$sheet->getStyle('A13')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A13')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A13')->getAlignment()->setVertical('center');
$sheet->getStyle('A14:B17')->applyFromArray($styleArrayBorder);

$sheet->setCellValue("A13", "FECHA REPORTE");
//
$sheet->getStyle('A14')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A14')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A14')->getAlignment()->setVertical('left');
$sheet->setCellValue("A14", "FECHA INICIAL");
//
$sheet->getStyle('B14')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B14')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B14')->getAlignment()->setVertical('left');
$sheet->setCellValue("B14", $fechaInicial);
//
$sheet->getStyle('A15')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A15')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A15')->getAlignment()->setVertical('left');
$sheet->setCellValue("A15", "FECHA FINAL");
//
$sheet->getStyle('B15')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B15')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B15')->getAlignment()->setVertical('left');
$sheet->setCellValue("B15", $fechafinal);
//
if(in_array("asesor",$DatosReportes)){
    $IdUsuario = $_REQUEST['asesor'];
    $Rol = $_REQUEST['rol'];
    if($Rol == "ASESOR"){
        $serviciosvsql = "AND auditoria.IdUsuario =".$IdUsuario;
    }else{
        $serviciosvsql = "AND auditoria.idDoctorGeneral =".$IdUsuario;
    }
}else{
    $serviciosvsql = '';
}


if (in_array("cliente", $DatosReportes)) {  
    $idcliente = $_REQUEST['clientes'];
    $DatosHistorialCliente = DevolverUnArreglo("SELECT personas.NombreCompleto as paciente,personas.Cedula,servicio.Servicio,servicio.EstadoSub as tipodeservicio,servicio.IdServicio,auditoria.Turno,auditoria.Estado,auditoria.NumeroLlamados, t1.NombreCompleto as Asesor,auditoria.FechaLlegada,auditoria.FechaLlamado,auditoria.Fechasalio,auditoria.Observacion,auditoria.ObservacionAsesor,auditoria.ObservacionRetraso,t2.NombreCompleto as NombreMedico,auditoria.FLlamadoDocGeneral as FLlmamadoMedico,auditoria.FSalioDocGeneral as FSalioMedico,auditoria.ObservacionDoctorGeneral as ObservacionMedico from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.IdPersona = '$idcliente' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' ORDER by auditoria.IdAuditoria ASC");
    $TurnosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado != 'NORMAL' and auditoria.FechaLlegada  and IdPersona = $idcliente and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
    $TurnosAtendidosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'TERMINADO'  and IdPersona = $idcliente and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
    $TurnosAusentesCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'AUSENTE' and IdPersona = $idcliente and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
    $TurnosTransferidosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'TERMINADO' and Observacion = 'TRANSFERIDO' and IdPersona = $idcliente and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
}else if(in_array("asesor", $DatosReportes)){
    $IdUsuario = $_REQUEST['asesor'];
    $Rol = $_REQUEST['rol'];
    if($Rol == "ASESOR"){
        $TurnosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado != 'NORMAL' and auditoria.FechaLlegada  and IdUsuario = $IdUsuario and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
        $TurnosAtendidosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'TERMINADO'  and IdUsuario = $IdUsuario and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
        $TurnosAusentesCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'AUSENTE' and IdUsuario = $IdUsuario and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
        $TurnosTransferidosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'TERMINADO' and Observacion = 'TRANSFERIDO' and IdUsuario = $IdUsuario and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
    }else{
        $TurnosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado != 'NORMAL' and auditoria.FechaLlegada  and idDoctorGeneral = $IdUsuario and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
        $TurnosAtendidosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'TERMINADO'  and idDoctorGeneral = $IdUsuario and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
        $TurnosAusentesCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'AUSENTE' and idDoctorGeneral = $IdUsuario and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
        $TurnosTransferidosCount = DevolverUnDato("SELECT count(*) from auditoria where Estado = 'TERMINADO' and Observacion = 'TRANSFERIDO' and idDoctorGeneral = $IdUsuario and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa'");
    }
}else{
    $TurnosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado != 'NORMAL' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' " .$serviciosvsql);
    $TurnosAtendidosCount = DevolverUnDato("select count(*) from auditoria  JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'TERMINADO' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' " . $serviciosvsql );
    $TurnosAusentesCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio)  where Estado = 'AUSENTE'  and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' ". $serviciosvsql);
    $TurnosTransferidosCount = DevolverUnDato("select count(*) from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where Estado = 'TERMINADO' and Observacion = 'TRANSFERIDO' and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' ". $serviciosvsql);
}



$sheet->getStyle('A13:B13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('B14:B17')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($nombreEmpresaColor);
$sheet->mergeCells('A13:B13');
$sheet->getStyle('A13')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A13')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A13')->getAlignment()->setVertical('center');
$sheet->getStyle('A14:A17')->applyFromArray($styleArrayBorder);
$sheet->setCellValue("A13", "INFORMACIÓN DE TURNOS");
//
$sheet->getStyle('A14')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A14')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A14')->getAlignment()->setVertical('center');
$sheet->setCellValue("A14", "TURNOS TOTALES");
//
$sheet->getStyle('B14')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B14')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B14')->getAlignment()->setVertical('left');
$sheet->setCellValue("B14", $TurnosCount);
//
$sheet->getStyle('A15')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A15')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A15')->getAlignment()->setVertical('center');
$sheet->setCellValue("A15", "TURNOS ATENDIDOS");
//
$sheet->getStyle('B15')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B15')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B15')->getAlignment()->setVertical('center');
$sheet->setCellValue("B15", $TurnosAtendidosCount);
//
$sheet->getStyle('A16')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A16')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A16')->getAlignment()->setVertical('center');
$sheet->setCellValue("A16", "TURNOS AUSENTES");
//
$sheet->getStyle('B16')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B16')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B16')->getAlignment()->setVertical('center');
$sheet->setCellValue("B16", $TurnosAusentesCount);
//
$sheet->getStyle('A17')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A17')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A17')->getAlignment()->setVertical('center');
$sheet->setCellValue("A17", "TURNOS TRANSFERIDOS");
//
$sheet->getStyle('B17')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B17')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B17')->getAlignment()->setVertical('center');
$sheet->setCellValue("B17", $TurnosTransferidosCount);
$contar = 22;



$serviciosv = DevolverUnArreglo("select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' ". $serviciosvsql." GROUP by auditoria.IdServicio");

$ServiciosvCount = $TurnosCount;
$totalPorcentaje = 0;
//
$sheet->getStyle('A20:C20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A20:C20');
$sheet->getStyle('A20')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A20')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A20')->getAlignment()->setVertical('center');
$sheet->setCellValue("A20", "INFORMACIÓN DE LOS SERVICIOS");
//
$sheet->getStyle('A21:C21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A21')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A21')->getAlignment()->setVertical('center');
$sheet->setCellValue("A21", "SERVICIO");
//
$sheet->getStyle('B21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B21')->getAlignment()->setVertical('center');
$sheet->setCellValue("B21", "TOTAL");
//
$sheet->getStyle('C21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('C21')->getAlignment()->setVertical('center');
$sheet->setCellValue("C21", "PORCENTAJE");
//


//
$TotalServiciosTurnos = 0;
for ($i=0; $i <count($serviciosv) ; $i++) { 

    $porcentaje = 0;
    //
    if ($i%2==0){
        $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
    }else{
        $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
    }
    $sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A' . $contar)->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A' . $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue('A' . $contar, $serviciosv[$i]['Servicio']);
    //
    $sheet->getStyle('B'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("B". $contar, $serviciosv[$i]['Cantidad']);
    //
    $porcentaje = ($serviciosv[$i]['Cantidad'] / $ServiciosvCount) * 100;
    $totalPorcentaje = $totalPorcentaje + $porcentaje;
    //
    $TotalServiciosTurnos = ($TotalServiciosTurnos + $serviciosv[$i]['Cantidad']);
    //
    $sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("C". $contar, round($porcentaje, 2) . "%");
    //
    
    $contar = $contar + 1;
}

//
$sheet->mergeCells('A'. $contar .':A'. $contar);
$sheet->getStyle('A'. $contar .':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("A". $contar, "TOTAL");
//
$sheet->getStyle('B'. $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('B'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("B". $contar, $TotalServiciosTurnos);
//
$sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("C". $contar, $totalPorcentaje . "%");

//INFORMACION DE LOS DOCTORES
$sheet->getStyle('E20:G20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('E20:G20');
$sheet->getStyle('E20')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('E20')->getAlignment()->setHorizontal('center');
$sheet->getStyle('E20')->getAlignment()->setVertical('center');
$sheet->setCellValue("E20", "INFORMACIÓN DE LOS MEDICOS");
//
$sheet->getStyle('E21:G21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('E21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('E21')->getAlignment()->setHorizontal('left');
$sheet->getStyle('E21')->getAlignment()->setVertical('center');
$sheet->setCellValue("E21", "NOMBRE DOCTOR");
////
$sheet->getStyle('F21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('F21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('F21')->getAlignment()->setVertical('center');
$sheet->setCellValue("F21", "ATENDIDOS");
//
$sheet->getStyle('G21')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('G21')->getAlignment()->setHorizontal('center');
$sheet->getStyle('G21')->getAlignment()->setVertical('center');
$sheet->setCellValue("G21", "PORCENTAJE");
//
$doctores = DevolverUnArreglo("select usuario.NombreCompleto, COUNT(auditoria.idDoctorGeneral) as Cantidad from auditoria JOIN usuario on (auditoria.idDoctorGeneral = usuario.IdUsuario) JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' GROUP by auditoria.idDoctorGeneral");

$doctoresCount = 0;
$totalPorcentajeDoctor = 0;
//
$contarDoctores = 22;
//
$TotalMedicoTurnos = 0;
if($doctores){
    foreach ($doctores as &$valor) {
        $doctoresCount = $valor['Cantidad'] + $doctoresCount;
    }
    foreach ($doctores as &$valor) {
        $porcentaje = 0;
        $sheet->setCellValue("E" . $contarDoctores, $valor['NombreCompleto']);
        $sheet->setCellValue("F" . $contarDoctores, $valor['Cantidad']);
        $porcentaje = ($valor['Cantidad'] / $doctoresCount) * 100;
        $totalPorcentajeDoctor = $totalPorcentajeDoctor + $porcentaje;
        $TotalMedicoTurnos = ($TotalMedicoTurnos + $valor['Cantidad']);
        $sheet->setCellValue("G" . $contarDoctores, round($porcentaje, 2) . "%");
        if ($contarDoctores % 2 == 1) {
            $sheet->getStyle('E' . $contarDoctores . ':G' . $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
        }
        $contarDoctores = $contarDoctores + 1;
    }
}else{
    $contarDoctores = $contarDoctores + 3;
}
//
//$sheet->mergeCells('E'. $contarDoctores .':F'. $contarDoctores);
$sheet->getStyle('E'. $contarDoctores .':G'. $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('E' . $contarDoctores)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('E'. $contarDoctores)->getAlignment()->setHorizontal('center');
$sheet->getStyle('E'. $contarDoctores)->getAlignment()->setVertical('center');
$sheet->setCellValue("E". $contarDoctores, "TOTAL");
//
$sheet->getStyle('F'. $contarDoctores)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('F'. $contarDoctores)->getAlignment()->setHorizontal('center');
$sheet->getStyle('F'. $contarDoctores)->getAlignment()->setVertical('center');
$sheet->setCellValue("F". $contarDoctores, $TotalMedicoTurnos);
//
$sheet->getStyle('G'. $contarDoctores)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('G'. $contarDoctores)->getAlignment()->setHorizontal('center');
$sheet->getStyle('G'. $contarDoctores)->getAlignment()->setVertical('center');
$sheet->setCellValue("G". $contarDoctores, $totalPorcentajeDoctor . "%");

if($contar > $contarDoctores){
    $contar = $contar + 1;
}else{
    $contar = $contarDoctores;
}
//
$contar = $contar + 2;
//
$detalle = DevolverUnArreglo("SELECT personas.NombreCompleto as paciente, personas.Cedula, personas.eps, auditoria.nivel as Nivel, auditoria.Turno,auditoria.Estado,t1.NombreCompleto as Asesor,auditoria.FechaLlegada,auditoria.FechaLlamado,auditoria.Fechasalio,".$campos." ,t2.NombreCompleto as NombreMedico,auditoria.FLlamadoDocGeneral,auditoria.FSalioDocGeneral FROM auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' ORDER by auditoria.IdAuditoria ASC");



$ServiciosCount = $TurnosCount;

if($detalle){
$titulos = array_keys($detalle[0]);
//select servicio.Servicio,servicio.EstadoSub,servicio.IdServicio, auditoria.*, t1.NombreCompleto as Asesor, t2.NombreCompleto as NombreMedico, personas.* from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59'  ORDER by auditoria.IdAuditoria ASC

if (in_array("fechas", $DatosReportes)) {
    $TiempoEsperaAsesor = 0;
    $TiempoAtencionAsesor = 0;
    $tiempoTotalAsesor = 0;
    $TiempoEsperaDoctor = 0;
    $TiempoAtencionDoctor = 0;
    $tiempoTotalDoctor = 0;
    $tiempoTotalEstadia = 0;
    $totalPorcentaje = 0;
    $servicios = DevolverUnArreglo("select servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) as Cantidad from auditoria JOIN servicio on (auditoria.IdServicio = servicio.IdServicio) where (Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' GROUP by auditoria.IdServicio");
    $countfechasservicios = DevolverUnArreglo("SELECT DATE_FORMAT(FechaLlamado,'%d/%m/%Y') as Fecha, COUNT(DATE_FORMAT(FechaLlamado,'%d/%m/%Y')) AS total FROM auditoria WHERE Estado = 'TERMINADO' AND FechaLlamado BETWEEN '$fechaInicial 00:00:00' AND '$fechafinal 23:59:59' AND IdSede = '$IdSede' AND emp_id = '$IdEmpresa' GROUP BY Fecha ORDER BY total DESC;");
    array_push($titulos,"TIEMPO DE ESPERA EN SALA ASESOR [hh:mm:ss]","TIEMPO DE ATENCION ASESOR [hh:mm:ss]","TIEMPO TOTAL ASESOR [hh:mm:ss]","TIEMPO TOTAL DE PERMANENCIA DEL PACIENTE","TIEMPO DE ESPERA EN SALA DOCTOR [hh:mm:ss]","TIEMPO DE ATENCION DOCTOR [hh:mm:ss]","TIEMPO TOTAL DOCTOR [hh:mm:ss]","PERTENECE AL SERVICIO");
    for ($i=0; $i <count($detalle); $i++) { 
    //for ($i=0; $i < 1; $i++) { 
        //
        if($detalle[$i]["Estado"] == "AUSENTE"){
            $TiempoEsperaAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlegada']), new DateTime($detalle[$i]['FechaLlamado']));
            $TiempoAtencionAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlamado']), new DateTime($detalle[$i]['FechaLlamado']));
            $tiempoTotalAsesor = $TiempoEsperaAsesor + $TiempoAtencionAsesor;
            $detalle[$i]['TIEMPO DE ESPERA EN SALA ASESOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoEsperaAsesor);
            $detalle[$i]['TIEMPO DE ATENCION ASESOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoAtencionAsesor);
            $detalle[$i]['TIEMPO TOTAL ASESOR [hh:mm:ss]'] = conversorSegundosHoras($tiempoTotalAsesor);
            $tiempoTotalEstadia = $tiempoTotalAsesor;
            $TiempoEsperaDoctor = CalcularMinutos(new DateTime($detalle[$i]['FSalioDocGeneral']), new DateTime($detalle[$i]['FLlamadoDocGeneral']));
            $TiempoAtencionDoctor = CalcularMinutos(new DateTime($detalle[$i]['FLlamadoDocGeneral']), new DateTime($detalle[$i]['FSalioDocGeneral']));      
            $detalle[$i]['TIEMPO DE ESPERA EN SALA DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoEsperaDoctor);
            $detalle[$i]['TIEMPO DE ATENCION DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoAtencionDoctor);
            $tiempoTotalDoctor = $TiempoEsperaDoctor + $TiempoAtencionDoctor;
            $detalle[$i]['TIEMPO TOTAL DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($tiempoTotalDoctor);
            $tiempoTotalEstadia = $tiempoTotalAsesor + $tiempoTotalDoctor;
            $detalle[$i]['TIEMPO TOTAL DE PERMANENCIA DEL PACIENTE'] = conversorSegundosHoras($tiempoTotalEstadia);
            //
            for ($j=0; $j < COUNT($servicios); $j++) { 
                if ($detalle[$i]["Servicio"] == $servicios[$j]["Servicio"]) {
                    if(empty($servicios[$j]["tiempoAsesor"])){
                        $servicios[$j]["tiempoAsesor"] = $TiempoAtencionAsesor;
                    }else{
                        $servicios[$j]["tiempoAsesor"] =  $servicios[$j]["tiempoAsesor"] + $TiempoAtencionAsesor;
                    }
                    if(empty($servicios[$j]["tiempoDoctor"])){
                        $servicios[$j]["tiempoDoctor"] = $TiempoAtencionDoctor;
                    }else{
                        $servicios[$j]["tiempoDoctor"] =  $servicios[$j]["tiempoDoctor"] + $TiempoAtencionDoctor;
                    }
                }else{
                    // if(empty($servicios[$j]["tiempoAsesor"])){
                    //     $servicios[$j]["tiempoAsesor"] = $TiempoAtencionAsesor;
                    // }else{
                    //     $servicios[$j]["tiempoAsesor"] =  $servicios[$j]["tiempoAsesor"] + $TiempoAtencionAsesor;
                    // }
                    // if(empty($servicios[$j]["tiempoDoctor"])){
                    //     $servicios[$j]["tiempoDoctor"] = $TiempoAtencionDoctor;
                    // }else{
                    //     $servicios[$j]["tiempoDoctor"] =  $servicios[$j]["tiempoDoctor"] + $TiempoAtencionDoctor;
                    // }
                }
            }
        }else{
            $TiempoEsperaAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlegada']), new DateTime($detalle[$i]['FechaLlamado']));
            $TiempoAtencionAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlamado']), new DateTime($detalle[$i]['Fechasalio']));
            $tiempoTotalAsesor = $TiempoEsperaAsesor + $TiempoAtencionAsesor;
            $detalle[$i]['TIEMPO DE ESPERA EN SALA ASESOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoEsperaAsesor);
            $detalle[$i]['TIEMPO DE ATENCION ASESOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoAtencionAsesor);
            $detalle[$i]['TIEMPO TOTAL ASESOR [hh:mm:ss]'] = conversorSegundosHoras($tiempoTotalAsesor);
            $tiempoTotalEstadia = $tiempoTotalAsesor;
            $TiempoEsperaDoctor = CalcularMinutos(new DateTime($detalle[$i]['FSalioDocGeneral']), new DateTime($detalle[$i]['FLlamadoDocGeneral']));
            $TiempoAtencionDoctor = CalcularMinutos(new DateTime($detalle[$i]['FLlamadoDocGeneral']), new DateTime($detalle[$i]['FSalioDocGeneral']));      
            $detalle[$i]['TIEMPO DE ESPERA EN SALA DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoEsperaDoctor);
            $detalle[$i]['TIEMPO DE ATENCION DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($TiempoAtencionDoctor);
            $tiempoTotalDoctor = $TiempoEsperaDoctor + $TiempoAtencionDoctor;
            $detalle[$i]['TIEMPO TOTAL DOCTOR [hh:mm:ss]'] = conversorSegundosHoras($tiempoTotalDoctor);
            $tiempoTotalEstadia = $tiempoTotalAsesor + $tiempoTotalDoctor;
            $detalle[$i]['TIEMPO TOTAL DE PERMANENCIA DEL PACIENTE'] = conversorSegundosHoras($tiempoTotalEstadia);
            // 
            for ($j=0; $j < COUNT($servicios); $j++) {
                if ($detalle[$i]["Servicio"] == $servicios[$j]["Servicio"]) {
                    if(empty($servicios[$j]["tiempoAsesor"])){
                        $servicios[$j]["tiempoAsesor"] = $TiempoAtencionAsesor;
                    }else{
                        $servicios[$j]["tiempoAsesor"] =  $servicios[$j]["tiempoAsesor"] + $TiempoAtencionAsesor;
                    }
                    if(empty($servicios[$j]["tiempoDoctor"])){
                        $servicios[$j]["tiempoDoctor"] = $TiempoAtencionDoctor;
                    }else{
                        $servicios[$j]["tiempoDoctor"] =  $servicios[$j]["tiempoDoctor"] + $TiempoAtencionDoctor;
                    }
                }else{
                    // if(empty($servicios[$j]["tiempoAsesor"])){
                    //     $servicios[$j]["tiempoAsesor"] = $TiempoAtencionAsesor;
                    // }else{
                    //     $servicios[$j]["tiempoAsesor"] =  $servicios[$j]["tiempoAsesor"] + $TiempoAtencionAsesor;
                    // }
                    // if(empty($servicios[$j]["tiempoDoctor"])){
                    //     $servicios[$j]["tiempoDoctor"] = $TiempoAtencionDoctor;
                    // }else{
                    //     $servicios[$j]["tiempoDoctor"] =  $servicios[$j]["tiempoDoctor"] + $TiempoAtencionDoctor;
                    // }
                }
            }
            //
        }
        if($detalle[$i]['EstadoSub'] != 'SERVICIO'){
            $ServiPertenece = DevolverUnDato("SELECT ser.Servicio FROM relacionservicios rela JOIN servicio ser on ser.IdServicio = rela.servicio WHERE rela.subservicio = '".$detalle[$i]['IdServicio']."' AND rela.IdSede = '$IdSede' AND rela.emp_id = '$IdEmpresa' ORDER BY rela.idrelacionservicio DESC LIMIT 1"); //
            $detalle[$i]['PERTENECE AL SERVICIO'] = $ServiPertenece;
        }else{
            $detalle[$i]['PERTENECE AL SERVICIO'] = $detalle[$i]['Servicio'];
        }
        unset($detalle[$i]['IdServicio']);
        unset($servicios[$i]['idservicio']);
    }
    
    //
    if(COUNT($countfechasservicios)>1){
        for ($h=0; $h < COUNT($countfechasservicios); $h++) { 
                $countfechasservicios[0]["fecha mayor/menor numero turnos"] = "fecha mayor numero de turnos";
                $countfechasservicios[$h]["fecha mayor/menor numero turnos"] = "";
                $countfechasservicios[COUNT($countfechasservicios)-1]["fecha mayor/menor numero turnos"] = "fecha menor numero de turnos";
        }
    }else{
        $countfechasservicios[0]["fecha mayor/menor numero turnos"] = "fecha mayor numero de turnos";
    }

    for ($j=0; $j < COUNT($servicios); $j++) { 
            $porcentaje = 0;
            $totalTiempos = $servicios[$j]["tiempoAsesor"] + $servicios[$j]["tiempoDoctor"];
            $servicios[$j]["tiempoAsesor"] =  conversorSegundosHoras($servicios[$j]["tiempoAsesor"]);
            $servicios[$j]["tiempoDoctor"] =  conversorSegundosHoras($servicios[$j]["tiempoDoctor"]);
            $servicios[$j]["promedio tiempo"] = conversorSegundosHoras(round($totalTiempos/$servicios[$j]["Cantidad"]));
            $porcentaje = ($servicios[$j]["Cantidad"] / $ServiciosCount) * 100;
            $servicios[$j]["Porcentaje"] = round($porcentaje, 2). "%";
    }

    for ($j=0; $j < COUNT($titulos); $j++) { 
        if($titulos[$j] == 'IdServicio')
        unset($titulos[$j]);
    }
    $titulos = array_values($titulos);

    $totalPorcentaje = $totalPorcentaje + $porcentaje;
    
    
    $titulosFechaServicio = array_keys($servicios[0]);
    $columnasExcel = '';
    $miletra = "A";

    for ($i =0; $i < count($servicios[0]) ; $i++){
        $columnasExcel = $columnasExcel.$miletra++.',';
    }

    $columnasExcel = explode(",", $columnasExcel);
    array_pop($columnasExcel);

    $cantidad = 0 ; 
    foreach ($servicios[0] as $key => $value) {
        $cantidad ++;
    }

    for ($i=0; $i < $cantidad; $i++) { 
        $sheet->setCellValue($columnasExcel[$i]. $contar, $titulosFechaServicio[$i]);
        $ultimaposicion = $columnasExcel[$i];
    }
    $sheet->getStyle('A' . $contar . ':' .$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A' . $contar . ':'.$ultimaposicion .  $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setVertical('center');

    $contar = $contar + 1;
    for ($i=0; $i <count($servicios); $i++) { 
        for ($j=0; $j <$cantidad; $j++) { 
            if ($i%2==0){
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
            }else{
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
            }
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFont()->setSize($tamañoLetraTexto);
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setVertical('center');
            $sheet->setCellValue($columnasExcel[$j]. $contar, $servicios[$i][$titulosFechaServicio[$j]]);
        }
        $contar++;
    }

    $contar = $contar + 1;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $tituloscountfechasservicios = array_keys($countfechasservicios[0]);
    $columnasExcel = '';
    $miletra = "A";

    for ($i =0; $i < count($countfechasservicios[0]) ; $i++){
        
        $columnasExcel = $columnasExcel.$miletra++.',';
    }

    $columnasExcel = explode(",", $columnasExcel);
    array_pop($columnasExcel);

    $cantidad = 0 ; 
    foreach ($countfechasservicios[0] as $key => $value) {
        $cantidad ++;
    }

    for ($i=0; $i < $cantidad; $i++) { 
        $sheet->setCellValue($columnasExcel[$i]. $contar, $tituloscountfechasservicios[$i]);
        $ultimaposicion = $columnasExcel[$i];
    }
    $sheet->getStyle('A' . $contar . ':' .$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A' . $contar . ':'.$ultimaposicion .  $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setVertical('center');

    $contar = $contar + 1;
    for ($i=0; $i <count($countfechasservicios); $i++) { 
        for ($j=0; $j <$cantidad; $j++) { 
            if ($i%2==0){
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
            }else{
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
            }
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFont()->setSize($tamañoLetraTexto);
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setVertical('center');
            $sheet->setCellValue($columnasExcel[$j]. $contar, $countfechasservicios[$i][$tituloscountfechasservicios[$j]]);
        }
        $contar++;
    } 
    $contar = $contar + 1;
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    $datoshoras = DevolverUnArreglo("SELECT DATE_FORMAT(FechaLlamado,'%H') as Hora, COUNT(DATE_FORMAT(FechaLlamado,'%H'))AS total FROM auditoria WHERE Estado = 'TERMINADO' AND FechaLlamado BETWEEN '$fechaInicial 00:00:00' AND '$fechafinal 23:59:59' AND IdSede = '$IdSede' AND emp_id = '$IdEmpresa' GROUP BY Hora ORDER BY `Hora` ASC");

    $titulosdatoshoras = array_keys($datoshoras[0]);
    $columnasExcel = '';
    $miletra = "A";

    for ($i =0; $i < count($datoshoras[0]) ; $i++){
        
        $columnasExcel = $columnasExcel.$miletra++.',';
    }

    $columnasExcel = explode(",", $columnasExcel);
    array_pop($columnasExcel);

    $cantidad = 0 ; 
    foreach ($datoshoras[0] as $key => $value) {
        $cantidad ++;
    }

    for ($i=0; $i < $cantidad; $i++) { 
        $sheet->setCellValue($columnasExcel[$i]. $contar, $titulosdatoshoras[$i]);
        $ultimaposicion = $columnasExcel[$i];
    }
    $sheet->getStyle('A' . $contar . ':' .$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A' . $contar . ':'.$ultimaposicion .  $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setVertical('center');

    $contar = $contar + 1;
    for ($i=0; $i <count($datoshoras); $i++) { 
        for ($j=0; $j <$cantidad; $j++) { 
            if ($i%2==0){
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
            }else{
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
            }
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFont()->setSize($tamañoLetraTexto);
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setVertical('center');
            $sheet->setCellValue($columnasExcel[$j]. $contar, $datoshoras[$i][$titulosdatoshoras[$j]]);
        }
        $contar++;
    }
    $contar = $contar + 1;
}


if(in_array("asesor",$DatosReportes)){
    $IdUsuario = $_REQUEST['asesor'];
    $Rol = $_REQUEST['rol'];
    if($Rol == "ASESOR"){
        $DatosHistorialUsuario = DevolverUnArreglo("SELECT personas.NombreCompleto as paciente,personas.Cedula,servicio.Servicio,servicio.EstadoSub as tipodeservicio,servicio.IdServicio,auditoria.Turno,auditoria.Estado,auditoria.NumeroLlamados, t1.NombreCompleto as Asesor,auditoria.FechaLlegada,auditoria.FechaLlamado,auditoria.Fechasalio,auditoria.Observacion,auditoria.ObservacionAsesor,auditoria.ObservacionRetraso,t2.NombreCompleto as NombreMedico,auditoria.FLlamadoDocGeneral as FLlmamadoMedico,auditoria.FSalioDocGeneral as FSalioMedico,auditoria.ObservacionDoctorGeneral as ObservacionMedico from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and (auditoria.IdUsuario = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' ORDER by auditoria.IdAuditoria ASC");
    }else{
        $DatosHistorialUsuario = DevolverUnArreglo("SELECT personas.NombreCompleto as paciente,personas.Cedula,servicio.Servicio,servicio.EstadoSub as tipodeservicio,servicio.IdServicio,auditoria.Turno,auditoria.Estado,auditoria.NumeroLlamados, t1.NombreCompleto as Asesor,auditoria.FechaLlegada,auditoria.FechaLlamado,auditoria.Fechasalio,auditoria.Observacion,auditoria.ObservacionAsesor,auditoria.ObservacionRetraso,t2.NombreCompleto as NombreMedico,auditoria.FLlamadoDocGeneral as FLlmamadoMedico,auditoria.FSalioDocGeneral as FSalioMedico,auditoria.ObservacionDoctorGeneral as ObservacionMedico from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and (auditoria.idDoctorGeneral = $IdUsuario or auditoria.idDoctorGeneral = $IdUsuario) and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' ORDER by auditoria.IdAuditoria ASC");
    }
    
    //
    $titulosDatosHistorialUsuario = array_keys($DatosHistorialUsuario[0]);
    $columnasExcel = '';
    $miletra = "A";

    for ($j=0; $j < COUNT($titulosDatosHistorialUsuario); $j++) { 
        if($titulosDatosHistorialUsuario[$j] == 'IdServicio')
        unset($titulosDatosHistorialUsuario[$j]);
    }
    
    $titulosDatosHistorialUsuario = array_values($titulosDatosHistorialUsuario);

    for ($i =0; $i < count($DatosHistorialUsuario[0]) ; $i++){
        unset($DatosHistorialUsuario[$i]['IdServicio']);
        $columnasExcel = $columnasExcel.$miletra++.',';
    }

    $columnasExcel = explode(",", $columnasExcel);
    array_pop($columnasExcel);

    $cantidad = 0 ; 
    foreach ($DatosHistorialUsuario[0] as $key => $value) {
        $cantidad ++;
    }
    
    for ($i=0; $i <count($DatosHistorialUsuario); $i++) { 
        if($DatosHistorialUsuario[$i]['paciente'] == "0" || $DatosHistorialUsuario[$i]['paciente'] == "" || $DatosHistorialUsuario[$i]['paciente'] == "undefined" || $DatosHistorialUsuario[$i]['paciente'] == null){
            $DatosHistorialUsuario[$i]['paciente'] = "Sin Registro";
        }
        ///CEDULA DEL CLIENTENombreMedico
        if($DatosHistorialUsuario[$i]['Cedula'] == "0" || $DatosHistorialUsuario[$i]['Cedula'] == "" || $DatosHistorialUsuario[$i]['Cedula'] == "undefined" || $DatosHistorialUsuario[$i]['Cedula'] == null){
            $DatosHistorialUsuario[$i]['Cedula'] = "Sin Registro";
        }
        if($DatosHistorialUsuario[$i]['NombreMedico'] == "0" || $DatosHistorialUsuario[$i]['NombreMedico'] == "" || $DatosHistorialUsuario[$i]['NombreMedico'] == "undefined" || $DatosHistorialUsuario[$i]['NombreMedico'] == null){
            $DatosHistorialUsuario[$i]['NombreMedico'] = "Sin Registro";
        }
    }

    for ($i=0; $i < $cantidad; $i++) { 
        $sheet->setCellValue($columnasExcel[$i]. $contar, $titulosDatosHistorialUsuario[$i]);
        $ultimaposicion = $columnasExcel[$i];
    }
    $sheet->getStyle('A' . $contar . ':' .$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A' . $contar . ':'.$ultimaposicion .  $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setVertical('center');

    $contar = $contar + 1;
    for ($i=0; $i <count($DatosHistorialUsuario); $i++) { 
        for ($j=0; $j <$cantidad; $j++) { 
            if ($i%2==0){
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
            }else{
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
            }
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFont()->setSize($tamañoLetraTexto);
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setVertical('center');
            $sheet->setCellValue($columnasExcel[$j]. $contar, $DatosHistorialUsuario[$i][$titulosDatosHistorialUsuario[$j]]);
        }
        $contar++;
    }
    $contar = $contar + 1;
    
    

    foreach ($columnasExcel as $columnID) {
        $sheet->getColumnDimension($columnID)->setAutoSize(true);
    }

    $files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
    foreach ($files as $file) {
        if (is_file($file))
            unlink($file); //elimino el fichero
    }

    $writer = new Xlsx($spreadsheet);
    $writer->save('../reportes/Reporte.xlsx');
    //
    $validar = array('respuesta' => 'Enviado Correctamente','DatosG' => $DatosHistorialUsuario ,'CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount);
    echo json_encode($validar, JSON_FORCE_OBJECT);
    exit();
}




if (in_array("turnos", $DatosReportes)) {
    for ($i=0; $i <count($detalle); $i++) { 
        if ($detalle[$i]['Observacion'] == "TRANSFERIDO") {
            $detalle[$i]['Estado'] = 'TRANSFERIDO';
        } else {
            $detalle[$i]['Estado'] =  $detalle[$i]['Estado'];
        }
    }
}

if (in_array("cliente", $DatosReportes)) {  
    $idcliente = $_REQUEST['clientes'];
    $DatosHistorialCliente = DevolverUnArreglo("SELECT personas.NombreCompleto as paciente,personas.Cedula,servicio.Servicio,servicio.EstadoSub as tipodeservicio,servicio.IdServicio,auditoria.Turno,auditoria.Estado,auditoria.NumeroLlamados, t1.NombreCompleto as Asesor,auditoria.FechaLlegada,auditoria.FechaLlamado,auditoria.Fechasalio,auditoria.Observacion,auditoria.ObservacionAsesor,auditoria.ObservacionRetraso,t2.NombreCompleto as NombreMedico,auditoria.FLlamadoDocGeneral as FLlmamadoMedico,auditoria.FSalioDocGeneral as FSalioMedico,auditoria.ObservacionDoctorGeneral as ObservacionMedico from auditoria join usuario as t1 on (t1.IdUsuario = auditoria.IdUsuario) left join usuario as t2 on (t2.IdUsuario = auditoria.idDoctorGeneral) join servicio on (servicio.IdServicio = auditoria.IdServicio) left join personas on (personas.IdPersona = auditoria.IdPersona) where (auditoria.Estado != 'NORMAL') and servicio.Servicio != 'TRIAGE' and servicio.Servicio != 'TRIAGE 1' and servicio.Servicio != 'TRIAGE 2' and servicio.Servicio != 'TRIAGE 3' and servicio.Servicio != 'TRIAGE 4' and servicio.Servicio != 'TRIAGE 5' and auditoria.IdPersona = '$idcliente' and auditoria.FechaLlegada >= '$fechaInicial 00:00:00' and auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' ORDER by auditoria.IdAuditoria ASC");
    //
    
    //
    
    ////////////////////////////////////////
    /*$ServiciosvCount = $TurnosCountClient;
    $totalPorcentaje = 0;
    //
    $sheet->getStyle('A20:C20')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->mergeCells('A20:C20');
    $sheet->getStyle('A20')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A20')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A20')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A20", "INFORMACIÓN DE LOS SERVICIOS");
    //
    $sheet->getStyle('A21:C21')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A21')->getAlignment()->setHorizontal('left');
    $sheet->getStyle('A21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("A21", "SERVICIO");
    //
    $sheet->getStyle('B21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B21')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("B21", "TOTAL");
    //
    $sheet->getStyle('C21')->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('C21')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('C21')->getAlignment()->setVertical('center');
    $sheet->setCellValue("C21", "PORCENTAJE");
    //

    $TotalServiciosTurnos = 0;
    for ($i=0; $i <count($serviciosv) ; $i++) { 

        $porcentaje = 0;
        //
        if ($i%2==0){
            $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
        }else{
            $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
        }
        $sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('A' . $contar)->getAlignment()->setHorizontal('left');
        $sheet->getStyle('A' . $contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue('A' . $contar, $serviciosv[$i]['Servicio']);
        //
        $sheet->getStyle('B'. $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('B'. $contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('B'. $contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue("B". $contar, $serviciosv[$i]['Cantidad']);
        //
        $porcentaje = ($serviciosv[$i]['Cantidad'] / $ServiciosvCount) * 100;
        $totalPorcentaje = $totalPorcentaje + $porcentaje;
        //
        $TotalServiciosTurnos = ($TotalServiciosTurnos + $serviciosv[$i]['Cantidad']);
        //
        $sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue("C". $contar, round($porcentaje, 2) . "%");
        //
        
        $contar = $contar + 1;
    }*/
/////////////////////////////////////////////////////

    $titulosDatosHistorialCliente = array_keys($DatosHistorialCliente[0]);
    $columnasExcel = '';
    $miletra = "A";


    for ($i=0; $i <count($DatosHistorialCliente); $i++) { 
        if($DatosHistorialCliente[$i]['paciente'] == "0" || $DatosHistorialCliente[$i]['paciente'] == "" || $DatosHistorialCliente[$i]['paciente'] == "undefined" || $DatosHistorialCliente[$i]['paciente'] == null){
            $DatosHistorialCliente[$i]['paciente'] = "Sin Registro";
        }
        ///CEDULA DEL CLIENTE
        $CedulaCliente = $DatosHistorialCliente[$i]['Cedula'];
        if($DatosHistorialCliente[$i]['Cedula'] == "0" || $DatosHistorialCliente[$i]['Cedula'] == "" || $DatosHistorialCliente[$i]['Cedula'] == "undefined" || $DatosHistorialCliente[$i]['Cedula'] == null){
            $DatosHistorialCliente[$i]['Cedula'] = "Sin Registro";
        }
        if($DatosHistorialCliente[$i]['NombreMedico'] == "0" || $DatosHistorialCliente[$i]['NombreMedico'] == "" || $DatosHistorialCliente[$i]['NombreMedico'] == "undefined" || $DatosHistorialCliente[$i]['NombreMedico'] == null){
            $DatosHistorialCliente[$i]['NombreMedico'] = "Sin Registro";
        }
    }
    
    for ($j=0; $j < COUNT($titulosDatosHistorialCliente); $j++) { 
        if($titulosDatosHistorialCliente[$j] == 'IdServicio')
        unset($titulosDatosHistorialCliente[$j]);
    }
    $titulosDatosHistorialCliente = array_values($titulosDatosHistorialCliente);

    for ($i =0; $i < count($DatosHistorialCliente[0]) ; $i++){
        unset($DatosHistorialCliente[$i]['IdServicio']);
        $columnasExcel = $columnasExcel.$miletra++.',';
    }

    $columnasExcel = explode(",", $columnasExcel);
    array_pop($columnasExcel);

    $cantidad = 0 ; 
    foreach ($DatosHistorialCliente[0] as $key => $value) {
        $cantidad ++;
    }

    for ($i=0; $i < $cantidad; $i++) { 
        $sheet->setCellValue($columnasExcel[$i]. $contar, $titulosDatosHistorialCliente[$i]);
        $ultimaposicion = $columnasExcel[$i];
    }

    $sheet->getStyle('A' . $contar . ':' .$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A' . $contar . ':'.$ultimaposicion .  $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setVertical('center');

    $contar = $contar + 1;
    for ($i=0; $i <count($DatosHistorialCliente); $i++) { 
        for ($j=0; $j <$cantidad; $j++) { 
            if ($i%2==0){
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
            }else{
                $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
            }
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFont()->setSize($tamañoLetraTexto);
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
            $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setVertical('center');
            $sheet->setCellValue($columnasExcel[$j]. $contar, $DatosHistorialCliente[$i][$titulosDatosHistorialCliente[$j]]);
        }
        $contar++;
    }

    $contar = $contar + 1;
    

    foreach ($columnasExcel as $columnID) {
        $sheet->getColumnDimension($columnID)->setAutoSize(true);
    }

    $files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
    foreach ($files as $file) {
        if (is_file($file))
            unlink($file); //elimino el fichero
    }
    //
    $writer = new Xlsx($spreadsheet);
    $writer->save('../reportes/Reporte.xlsx');
    
    $validar = array('respuesta' => 'Enviado Correctamente','DatosG' => $DatosHistorialCliente ,'CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount);
    echo json_encode($validar, JSON_FORCE_OBJECT);
    exit();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
for ($i=0; $i <count($detalle); $i++) { 
    if($detalle[$i]['paciente'] == "0" || $detalle[$i]['paciente'] == "" || $detalle[$i]['paciente'] == "undefined" || $detalle[$i]['paciente'] == null){
        $detalle[$i]['paciente'] = "Sin Registro";
    }
    ///CEDULA DEL CLIENTE
    if($detalle[$i]['Cedula'] == "0" || $detalle[$i]['Cedula'] == "" || $detalle[$i]['Cedula'] == "undefined" || $detalle[$i]['Cedula'] == null){
        $detalle[$i]['Cedula'] = "Sin Registro";
    }
    if($detalle[$i]['NombreMedico'] == "0" || $detalle[$i]['NombreMedico'] == "" || $detalle[$i]['NombreMedico'] == "undefined" || $detalle[$i]['NombreMedico'] == null){
        $detalle[$i]['NombreMedico'] = "Sin Registro";
    }
}

$columnasExcel = '';
$miletra = "A";

for ($i =0; $i < count($detalle[0]) ; $i++){
    
    $columnasExcel = $columnasExcel.$miletra++.',';
}

$columnasExcel = explode(",", $columnasExcel);
array_pop($columnasExcel);

$cantidad = 0 ; 
foreach ($detalle[0] as $key => $value) {
    $cantidad ++;
}

for ($i=0; $i < $cantidad; $i++) { 
    $sheet->setCellValue($columnasExcel[$i]. $contar, $titulos[$i]);
    $ultimaposicion = $columnasExcel[$i];
}
        
$sheet->getStyle('A' . $contar . ':' .$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar . ':'.$ultimaposicion .  $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar. ':' .$ultimaposicion . $contar)->getAlignment()->setVertical('center');

$contar = $contar + 1;
for ($i=0; $i <count($detalle); $i++) { 
    for ($j=0; $j <$cantidad; $j++) { 
        if ($i%2==0){
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
        }else{
            $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
        }
        $sheet->getStyle('A' . $contar . ':'.$ultimaposicion . $contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A'. $contar . ':'.$ultimaposicion . $contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue($columnasExcel[$j]. $contar, $detalle[$i][$titulos[$j]]);
    }
    $contar++;
}

foreach ($columnasExcel as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

$files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros

foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}

$writer = new Xlsx($spreadsheet);
$writer->save('../reportes/Reporte.xlsx');

    if($servicios == 0){
        $validar = array('respuesta' => 'Enviado Correctamente','DatosG' => $detalle , 'CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount);
        echo json_encode($validar, JSON_FORCE_OBJECT);
    }else{
        $validar = array('respuesta' => 'Enviado Correctamente','DatosG' => $servicios ,'Fechas' => $countfechasservicios,'horas' => $datoshoras, 'CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount);
        echo json_encode($validar, JSON_FORCE_OBJECT);
    }

}else{
    $files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
    foreach ($files as $file) {
        if (is_file($file))
            unlink($file); //elimino el fichero
    }
    //
    $writer = new Xlsx($spreadsheet);
    $writer->save('../reportes/Reporte.xlsx');
    //
    $validar = array('respuesta' => 'Enviado Correctamente','CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount );
    echo json_encode($validar, JSON_FORCE_OBJECT);
}

?>
