<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
set_time_limit(9000);
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../conexion.php';
require '../vendor/autoload.php';

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function menorDiezTiempo($dato){
    if($dato < 10){
        return $dato = 0 . $dato;
    }else{
        return $dato;
    }
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);
    return menorDiezTiempo($horas) . ':' . menorDiezTiempo($minutos) . ":" . menorDiezTiempo($segundos);
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;


$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";

$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];
$IdEmpresa = $_REQUEST["IdEmpresa"];
$IdSede = $_REQUEST["IdSede"];

$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));

// $fechaInicial = "2023-04-20";
// $fechafinal = "2023-04-20";

//USUARIOS EXISTENTE EN ESTADO
$usuariosExistentesEstado = DevolverUnArreglo("SELECT usu.NombreCompleto, usu.IdUsuario FROM usuario usu JOIN estado_usuario esu on usu.IdUsuario = esu.IdUsuario WHERE esu.esta_usu_fecha >= '$fechaInicial' AND esu.esta_usu_fecha <= '$fechafinal' AND usu.IdSede = '$IdSede' AND usu.emp_id = '$IdEmpresa' GROUP BY usu.IdUsuario"); //AND usu.Eliminado = 0
for ($i=0; $i <COUNT($usuariosExistentesEstado); $i++) { 
    $DatosEstadoAsesor = DevolverUnArreglo("SELECT est.estado_titulo, esu.esta_usu_fecha,esu.esta_usu_tiempo_inicio,esu.esta_usu_tiempo_final FROM estado_usuario esu JOIN usuario usu JOIN estado est on esu.IdUsuario = usu.IdUsuario AND esu.est_id = est.estado_id WHERE esu.IdUsuario = '".$usuariosExistentesEstado[$i]["IdUsuario"]."' AND esu.esta_usu_fecha >= '$fechaInicial' AND esu.esta_usu_fecha <= '$fechafinal' AND esu.esta_usu_tiempo_inicio != '0000-00-00' AND esu.esta_usu_tiempo_final != '0000-00-00' AND usu.IdSede = '$IdSede' AND usu.emp_id = '$IdEmpresa'");
    $usuariosExistentesEstado[$i]["datos"] = $DatosEstadoAsesor;
    $arregloFechas = [];
    $arregloFechasTiempos = [];
    for ($j=0; $j <Count($usuariosExistentesEstado[$i]["datos"]); $j++) { 
        $usuariosExistentesEstado[$i]["datos"][$j]["tiempo"] = CalcularMinutos(new DateTime($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_tiempo_inicio"]),new DateTime($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_tiempo_final"]));
        if (in_array($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_fecha"], $arregloFechas)) {            
            $clave = array_search($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_fecha"], $arregloFechas);
            $arregloG =  array(
                'Titulo' => $usuariosExistentesEstado[$i]["datos"][$j]["estado_titulo"],
                'Tiempo' => CalcularMinutos(new DateTime($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_tiempo_inicio"]),new DateTime($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_tiempo_final"]))                
            );
            $arregloFechasTiempos[$clave][COUNT($arregloFechasTiempos[$clave])] = $arregloG;
        }else{
            array_push($arregloFechas,  $usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_fecha"]);
            $clave = array_search($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_fecha"], $arregloFechas);
            $arregloG =  array(
                'Titulo' => $usuariosExistentesEstado[$i]["datos"][$j]["estado_titulo"],
                'Tiempo' => CalcularMinutos(new DateTime($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_tiempo_inicio"]),new DateTime($usuariosExistentesEstado[$i]["datos"][$j]["esta_usu_tiempo_final"]))                
            );
            $arregloFechasTiempos[$clave][0] = $arregloG;
        }
    }
    $usuariosExistentesEstado[$i]["Fecha"] = $arregloFechas;
    $usuariosExistentesEstado[$i]["FechaTiempos"] = $arregloFechasTiempos;
}

for ($i=0; $i <count($usuariosExistentesEstado) ; $i++) { 
    for ($j=0; $j <count($usuariosExistentesEstado[$i]["FechaTiempos"]); $j++) { 
        $arregloTitulosEstado = [];
        $arregloTiemposEstado = [];
        for ($k=0; $k < count($usuariosExistentesEstado[$i]["FechaTiempos"][$j]); $k++) { 
            if (in_array($usuariosExistentesEstado[$i]["FechaTiempos"][$j][$k]["Titulo"], $arregloTitulosEstado)){
                $clave = array_search($usuariosExistentesEstado[$i]["FechaTiempos"][$j][$k]["Titulo"], $arregloTitulosEstado);
                $arregloTiemposEstado[$clave] += $usuariosExistentesEstado[$i]["FechaTiempos"][$j][$k]["Tiempo"];
            }else{
                array_push($arregloTitulosEstado, $usuariosExistentesEstado[$i]["FechaTiempos"][$j][$k]["Titulo"]);
                array_push($arregloTiemposEstado, $usuariosExistentesEstado[$i]["FechaTiempos"][$j][$k]["Tiempo"]);
            }
        }
        $arregloTotal = [];
        for ($p=0; $p <count($arregloTitulosEstado) ; $p++) { 
            $arregloTotal[$p] = array(
                'Titulo' => $arregloTitulosEstado[$p],
                'Tiempo' => $arregloTiemposEstado[$p]
            );
        }
        $usuariosExistentesEstado[$i]["FechaTiempos"][$j] = $arregloTotal;
    }
}

// print_r($usuariosExistentesEstado);
// exit();

//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//DATOS EMPRESA
$nombreempresa = DevolverUnDato("SELECT emp_nombre FROM empresa WHERE emp_id = '$IdEmpresa'");
//

$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:H4');
$drawing->setName('LOGO');
$drawing->setDescription('INGETRONIK');
$drawing->setPath('../imagenreportes/logo.png');
$drawing->setCoordinates('B1');
$drawing->setWidthAndHeight(300, 100);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//
$sheet->getStyle('A5:H6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$sheet->mergeCells('A5:H6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);
//
//
$sheet->getStyle('A9:D9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A9:D9');
$sheet->getStyle('A9')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A9')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A9')->getAlignment()->setVertical('center');
$sheet->setCellValue("A9", "FECHA REPORTE");
//
$sheet->mergeCells('A10:B10');
$sheet->getStyle('A10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A10')->getAlignment()->setVertical('left');
$sheet->setCellValue("A10", "FECHA INICIAL");
//
$sheet->getStyle('C10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('C10')->getAlignment()->setVertical('left');
$sheet->setCellValue("C10", $fechaInicial);
//
$sheet->mergeCells('A11:B11');
$sheet->getStyle('A11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A11')->getAlignment()->setVertical('left');
$sheet->setCellValue("A11", "FECHA FINAL");
//
$sheet->getStyle('C11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('C11')->getAlignment()->setVertical('left');
$sheet->setCellValue("C11", $fechafinal);


$contar = 15;


for ($i=0; $i <count($usuariosExistentesEstado); $i++) { 
    $sheet->getStyle('A'.$contar.':'.'D'.$contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->mergeCells('A'.$contar.':'.'D'.$contar);
    $sheet->getStyle('A'.$contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'.$contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'.$contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("A".$contar, $usuariosExistentesEstado[$i]["NombreCompleto"]);
    $contar += 2;
    $contar += 1;
    
    for ($j=0; $j <count($usuariosExistentesEstado[$i]["Fecha"]) ; $j++) { 
        $sheet->getStyle('A'.$contar.':'.'B'.$contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
        $sheet->mergeCells('A'.$contar.':'.'B'.$contar);
        $sheet->getStyle('A'.$contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('A'.$contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A'.$contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue("A".$contar, "Fecha");

        $sheet->mergeCells('C'.$contar.':'.'D'.$contar);
        $sheet->getStyle('C'.$contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('C'.$contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue("C".$contar, $usuariosExistentesEstado[$i]["Fecha"][$j]);

        $contar += 1;
        $sheet->getStyle('A'.$contar.':'.'B'.$contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
        $sheet->mergeCells('A'.$contar.':'.'B'.$contar);
        $sheet->getStyle('A'.$contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('A'.$contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A'.$contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue("A".$contar, "Estado");

        $sheet->getStyle('C'.$contar.':'.'D'.$contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
        $sheet->mergeCells('C'.$contar.':'.'D'.$contar);
        $sheet->getStyle('C'.$contar)->getFont()->setSize($tamañoLetraTexto);
        $sheet->getStyle('C'.$contar)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('C'.$contar)->getAlignment()->setVertical('center');
        $sheet->setCellValue("C".$contar, "Tiempo");
        $contar += 1;
        for ($l=0; $l <count($usuariosExistentesEstado[$i]["FechaTiempos"][$j]); $l++) { 
            $sheet->mergeCells('A'.$contar.':'.'B'.$contar);
            $sheet->getStyle('A'.$contar)->getAlignment()->setHorizontal('center');
            $sheet->getStyle('A'.$contar)->getAlignment()->setVertical('center');
            $sheet->setCellValue("A".$contar, $usuariosExistentesEstado[$i]["FechaTiempos"][$j][$l]["Titulo"]);

            $sheet->mergeCells('C'.$contar.':'.'D'.$contar);
            $sheet->getStyle('C'.$contar)->getAlignment()->setHorizontal('center');
            $sheet->getStyle('C'.$contar)->getAlignment()->setVertical('center');
            $sheet->setCellValue("C".$contar, conversorSegundosHoras($usuariosExistentesEstado[$i]["FechaTiempos"][$j][$l]["Tiempo"]));
            $contar += 1;
        }
        $contar += 1;
    }
    $contar += 3;
}

$files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}
$writer = new Xlsx($spreadsheet);
$writer->save('../reportes/ReporteEstados.xlsx');
$validar = array('respuesta' => 'Enviado Correctamente','datos' => $usuariosExistentesEstado);
echo json_encode($validar, JSON_FORCE_OBJECT);
?>
