<?php
set_time_limit(9000);
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../conexion.php';
require '../vendor/autoload.php';
//
function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}
//
function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}
//
function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}
//
function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    return $horas . ':' . $minutos . ":" . $segundos;
}
//
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
//
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorFondoTituloRojoOscuro = "395980";
$colorFondoTituloRojoClaro = "729ECA";
$colorIntercalado = "AECFEA";
//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//DATOS EMPRESA
$info = DevolverUnArreglo("select * from auditoria");
$datosEmpresa = DevolverUnArreglo("select * from datosempresa");
$nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
$NIT = $datosEmpresa[0]['nit'];
$IdUsuario = $_REQUEST['IdUsuario'];
//
$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:E4');
$drawing->setName('LOGO');
$drawing->setDescription('logo');
$drawing->setPath('../imagenreportes/logo.png');
$drawing->setCoordinates('A1');
$drawing->setWidthAndHeight(420, 200);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//
$sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$sheet->mergeCells('A5:E6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);
//
$sheet->getStyle('A7:E7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A7:E7');
$sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A7')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A7')->getAlignment()->setVertical('center');
$sheet->setCellValue("A7", $NIT);
//
$sheet->getStyle('A10')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A10')->getAlignment()->setVertical('left');
$sheet->setCellValue("A10", "Agenda filtrada por");
//
$sheet->getStyle('B10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B10')->getAlignment()->setVertical('left');
//
if($IdUsuario == 'Todos'){
    $citaespecialidad  = DevolverUnArreglo("SELECT cita.Idcita, cita.IdPersona, cita.IdUsuario, cita.IdTipoRol, cita.FechaCita, cita.Estado, cita.IdSede,espe.NombreRol as NombreCompletoMedico, per.NombreCompleto as pacienteNombre, per.Cedula FROM cita JOIN personas per JOIN especialidad espe ON cita.IdPersona = per.IdPersona and cita.IdTipoRol = espe.IdTipoRol AND FechaCita BETWEEN (SELECT DATE_FORMAT((select now()), '%Y-%m-%d 00:00:00') ) and (SELECT DATE_FORMAT((select now()), '%Y-%m-%d 23:59:59'))");
    $citamedico = DevolverUnArreglo("SELECT cita.Idcita, cita.IdPersona, cita.IdUsuario, cita.IdTipoRol, cita.FechaCita, cita.Estado, cita.IdSede,usu.NombreCompleto as NombreCompletoMedico, per.NombreCompleto as pacienteNombre, per.Cedula FROM cita JOIN personas per JOIN usuario usu ON cita.IdPersona = per.IdPersona and cita.IdUsuario = usu.IdUsuario  AND FechaCita BETWEEN (SELECT DATE_FORMAT((select now()), '%Y-%m-%d 00:00:00') ) and (SELECT DATE_FORMAT((select now()), '%Y-%m-%d 23:59:59'))");
    $datos = array_merge ($citaespecialidad,$citamedico);
    $sheet->setCellValue("B10", 'Todos Los Medicos');
}else{
    $idespecialidad = DevolverUnDato("SELECT IdTipoRol FROM `usuario` WHERE IdUsuario = $IdUsuario");
    $citaespecialidad  = DevolverUnArreglo("SELECT cita.Idcita, cita.IdPersona, cita.IdUsuario, cita.IdTipoRol, cita.FechaCita, cita.Estado, cita.IdSede,espe.NombreRol as NombreCompletoMedico, per.NombreCompleto as pacienteNombre, per.Cedula FROM cita JOIN personas per JOIN especialidad espe ON cita.IdPersona = per.IdPersona and cita.IdTipoRol = espe.IdTipoRol AND cita.IdTipoRol = $idespecialidad AND FechaCita BETWEEN (SELECT DATE_FORMAT((select now()), '%Y-%m-%d 00:00:00') ) and (SELECT DATE_FORMAT((select now()), '%Y-%m-%d 23:59:59'))");
    $citamedico = DevolverUnArreglo("SELECT cita.Idcita, cita.IdPersona, cita.IdUsuario, cita.IdTipoRol, cita.FechaCita, cita.Estado, cita.IdSede,usu.NombreCompleto as NombreCompletoMedico, per.NombreCompleto as pacienteNombre, per.Cedula FROM cita JOIN personas per JOIN usuario usu ON cita.IdPersona = per.IdPersona and cita.IdUsuario = usu.IdUsuario AND  cita.IdUsuario = $IdUsuario AND FechaCita BETWEEN (SELECT DATE_FORMAT((select now()), '%Y-%m-%d 00:00:00') ) and (SELECT DATE_FORMAT((select now()), '%Y-%m-%d 23:59:59'))");
    $datos = array_merge ($citaespecialidad,$citamedico);
    $sheet->setCellValue("B10","Medico " . $datos[0]['NombreCompletoMedico']);
}
//
$contar = 10;
//
$contar += 2;
$sheet->getStyle('A' . $contar . ':C' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar . ':C' . $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar. ':C' . $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar. ':C' . $contar)->getAlignment()->setVertical('center');
//
$sheet->setCellValue("A". $contar, "Medico/Especialidad");
//
$sheet->setCellValue("B". $contar, "Paciente");
//
$sheet->setCellValue("C". $contar, "Fecha y hora de la cita");
//
$contar += 1;
for ($i=0; $i <count($datos) ; $i++) { 
    if ($i%2==0){
        $sheet->getStyle('A' . $contar . ':C' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
    }else{
        $sheet->getStyle('A' . $contar . ':C' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
    }
    $sheet->getStyle('A' . $contar . ':C' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar . ':C' . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar . ':C' . $contar)->getAlignment()->setVertical('center');
    //
    $sheet->setCellValue("A" . $contar, $datos[$i]['NombreCompletoMedico']);
    $sheet->setCellValue("B" . $contar, $datos[$i]['NombreCompleto']);
    $sheet->setCellValue("C" . $contar, $datos[$i]['FechaCita']);
    //
    $contar += 1;
}

//
foreach (range('A', 'C') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}
//
$files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}
//
$writer = new Xlsx($spreadsheet);
$writer->save('../reportes/ReporteAgendaMedicos.xlsx');
//
$validar = array('respuesta' => 'Enviado Correctamente');
echo json_encode($validar, JSON_FORCE_OBJECT);
?>