<?php

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../conexion.php';
require '../vendor/autoload.php';
//
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
//
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
//
function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}
//
function segundosahoras($tiempo_en_segundos){
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    if($horas < 10){
        $horas = '0'.$horas;
    }
    if($minutos < 10){
        $minutos = '0'.$minutos;
    }
    if($segundos < 10){
        $segundos = '0'.$segundos;
    }
    return $horas . ':' . $minutos . ":" . $segundos;
}
// backupBD();
// die();
//
$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];
$emp_id = $_REQUEST["IdEmpresa"];
$IdSede = $_REQUEST["IdSede"];

$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));

//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//
$colorFondoTituloRojoOscuro = "366092";
$colorFondoTituloRojoClaro = "95B3D7";
$colorIntercalado = "C5D9F1";


//
$datosEmpresa = DevolverUnArreglo("select * from datosempresa");
$nombreempresa = $datosEmpresa[0]['NombreEmpresa'];
$NIT = $datosEmpresa[0]['nit'];

//
$arreglo = [];
//
$usuarios = DevolverUnArreglo("SELECT * FROM usuario WHERE Eliminado = 0 AND Rol = 'ASESOR' AND IdSede = '$IdSede' AND emp_id = '$emp_id'");
//
$estados = DevolverUnArreglo("SELECT * FROM estado WHERE estado_eliminado != 1 AND IdSede = '$IdSede' AND emp_id = '$emp_id'");
//
for ($i=0; $i <count($usuarios); $i++) {
    //
    $arreglo[$i]["usuario"] =  $usuarios[$i]["NombreCompleto"];
    //
    for ($j=0; $j <count($estados); $j++) { 
        //
        $datosEstado = DevolverUnArreglo("SELECT esta_usu_tiempo_inicio,esta_usu_tiempo_final,esta_usu_fecha FROM estado_usuario WHERE IdUsuario = '". $usuarios[$i]["IdUsuario"] ."' and esta_usu_fecha  >= '$fechaInicial' and esta_usu_fecha  <= '$fechafinal' and est_id = '". $estados[$j]["estado_id"] ."' AND IdSede = '$IdSede' AND emp_id = '$emp_id'");
        //
        $fechaFinals = '';
        $tiempo = 0;
        //
        if($datosEstado){
            //
            for ($k=0; $k <count($datosEstado); $k++) { 
                //
                $tiempo += CalcularMinutos(new DateTime($datosEstado[$k]['esta_usu_tiempo_inicio']), new DateTime($datosEstado[$k]['esta_usu_tiempo_final']));
                $fechaFinals = $datosEstado[0]['esta_usu_fecha'];
                //
            }
            //
        }
        //
        $arreglo[$i]["estado"][$j] =  $estados[$j]["estado_titulo"];
        $arreglo[$i]["tiempoEstado"][$j] =  $tiempo;
        $arreglo[$i]["fecha"][$j] =  $fechaFinals;
        //
    }
    //
}

//imagen
$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:E4');
$drawing->setName('LOGO');
$drawing->setDescription('INGETRONIK');
$drawing->setPath('../imagenreportes/logo.png');
$drawing->setCoordinates('A1');
$drawing->setWidthAndHeight(420, 200);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//tamaño letra
$sheet->getStyle('A5:E6')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoOscuro);
$sheet->mergeCells('A5:E6');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", $nombreempresa);
//
$sheet->getStyle('A7:E7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A7:E7');
$sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTitulo);
$sheet->getStyle('A7')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A7')->getAlignment()->setVertical('center');
$sheet->setCellValue("A7", $NIT);
//
$sheet->getStyle('A9:B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A9:B9');
$sheet->getStyle('A9')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A9')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A9')->getAlignment()->setVertical('center');
$sheet->setCellValue("A9", "FECHA REPORTE");
//
$sheet->getStyle('A10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A10')->getAlignment()->setVertical('left');
$sheet->setCellValue("A10", "FECHA INICIAL");
//
$sheet->getStyle('B10')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B10')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B10')->getAlignment()->setVertical('left');
$sheet->setCellValue("B10", $fechaInicial);
//
$sheet->getStyle('A11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A11')->getAlignment()->setVertical('left');
$sheet->setCellValue("A11", "FECHA FINAL");
//
$sheet->getStyle('B11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B11')->getAlignment()->setHorizontal('left');
$sheet->getStyle('B11')->getAlignment()->setVertical('left');
$sheet->setCellValue("B11", $fechafinal);

$contar = 14;

for ($i=0; $i <count($arreglo) ; $i++) {

    $sheet->mergeCells('A'. $contar .':C'. $contar);
    $sheet->setCellValue('A'. $contar, $arreglo[$i]['usuario']);
    $sheet->getStyle('A'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
    $sheet->getStyle('A'. $contar)->getFont()->setSize($tamañoLetraTitulo);
    $sheet->getStyle('A'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar)->getAlignment()->setVertical('center');
    //
    $contar += 1;
    //
    $sheet->setCellValue('A'. $contar, "Estado");
    //
    $sheet->setCellValue('B'. $contar, "Tiempo");
    //
    $sheet->setCellValue('C'. $contar, "fecha");
    //
    $sheet->getStyle('A'. $contar .':B'. $contar.':C')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar .':B'. $contar.':C')->getAlignment()->setVertical('center');
    for ($j=0; $j <count($arreglo[$i]['estado']) ; $j++) { 
        $contar += 1;
        $sheet->setCellValue('A'. $contar, $arreglo[$i]['estado'][$j]);
        $sheet->setCellValue('B'. $contar, segundosahoras($arreglo[$i]['tiempoEstado'][$j]));
        $sheet->setCellValue('C'. $contar, $arreglo[$i]['fecha'][$j]);
    }
    $contar += 2;
}

foreach (range('A', 'W') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

$files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}
$writer = new Xlsx($spreadsheet);
$writer->save('../reportes/ReporteEstadoAsesores.xlsx');

$validar = array('respuesta' => 'Enviado Correctamente','datos' => $arreglo);
echo json_encode($validar, JSON_FORCE_OBJECT);



?>