<?php
set_time_limit(9000);
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../conexion.php';
require '../vendor/autoload.php';

function CalcularMinutos($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    $segundos = $interval->format('%s');
    return ((($hours * 60) * 60) + ($minutes * 60) + $segundos);
}

function CalcularMinutos2($fecha1, $fecha2) {
    $interval = $fecha1->diff($fecha2);
    $hours = $interval->format('%h');
    $minutes = $interval->format('%i');
    return ($hours * 60) + $minutes;
}

function busca_edad($fecha_nacimiento) {
    $dia = date("d");
    $mes = date("m");
    $ano = date("Y");
    $dianaz = date("d", strtotime($fecha_nacimiento));
    $mesnaz = date("m", strtotime($fecha_nacimiento));
    $anonaz = date("Y", strtotime($fecha_nacimiento));
    if (($mesnaz == $mes) && ($dianaz > $dia)) {
        $ano = ($ano - 1);
    }
    if ($mesnaz > $mes) {
        $ano = ($ano - 1);
    }
    $edad = ($ano - $anonaz);
    return $edad;
}

function conversorSegundosHoras($tiempo_en_segundos) {
    $horas = floor($tiempo_en_segundos / 3600);
    $minutos = floor(($tiempo_en_segundos - ($horas * 3600)) / 60);
    $segundos = $tiempo_en_segundos - ($horas * 3600) - ($minutos * 60);

    return $horas . ':' . $minutos . ":" . $segundos;
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;


$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorPrincipal = "540AC1";
$colorFondoTituloRojoClaro = "A288FC";
$colorIntercalado = "CED0F6";
$nombreEmpresaColor = "CED0F6";

$fechaInicial = $_REQUEST["fechaInicial"];
$fechafinal = $_REQUEST["fechafinal"];
$IdEmpresa = $_REQUEST["IdEmpresa"];
$IdSede = $_REQUEST["IdSede"];

$fechaInicial = date("Y-m-d", strtotime($fechaInicial));
$fechafinal = date("Y-m-d", strtotime($fechafinal));
//PARAMETROS
$tamañoLetraTitulo = 15;
$tamañoLetraTexto = 12;
//DATOS EMPRESA
$nombreempresa = DevolverUnDato("SELECT emp_nombre FROM empresa WHERE emp_id = '$IdEmpresa'");

$styleArrayBorder = array(
    'borders' => array(
        'outline' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
            'color' => array('argb' => '395980'),
        ),
    ),
);
$styleArray = array(
    'font'  => array(
        'bold'  => true,
        'color' => array('rgb' => 'FFFFFF'),
        'size'  => 12,
        'name'  => 'Calibri'
    )
);
$styleArrayColorBlack = array(
    'font'  => array(
        'bold'  => true,
        'color' => array('rgb' => '000000'),
        'size'  => 12,
        'name'  => 'Calibri'
    )
);

$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('A1:B4');
$sheet->getStyle('A1:B4')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorPrincipal);
$drawing->setName('LOGO');
$drawing->setDescription('TurnoMaster');
$drawing->setPath('../imagenreportes/logoTurnoMaster.png');
$drawing->setCoordinates('A1');
$drawing->setWidthAndHeight(150, 150);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());
//
$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$sheet->mergeCells('C1:D4');
$sheet->getStyle('C1:D4')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorPrincipal);
$drawing->setName('LOGO');
$drawing->setDescription('TurnoMaster');
$drawing->setPath('../imagenreportes/logoTurnoMaster.png');
$drawing->setCoordinates('D1');
$drawing->setWidthAndHeight(150, 150);
$drawing->setResizeProportional(true);
$drawing->setWorksheet($spreadsheet->getActiveSheet());

// $sheet->mergeCells('A6:A7');
// $sheet->getStyle('A6:A7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
// $sheet->getStyle('A6')->getFont()->setSize($tamañoLetraTexto);
// $sheet->getStyle('A6')->getAlignment()->setHorizontal('left');
// $sheet->getStyle('A6')->getAlignment()->setVertical('left');
// $sheet->setCellValue("A6", "FECHA INICIAL");
// //
$sheet->mergeCells('E1:F2');
$sheet->getStyle('E1')->applyFromArray($styleArray);
$sheet->getStyle('E1:E1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorPrincipal);
$sheet->getStyle('E1')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('E1')->getAlignment()->setHorizontal('right');
$sheet->getStyle('E1')->getAlignment()->setVertical('right');
$sheet->setCellValue("E1", $fechaInicial);
// //
$sheet->mergeCells('E3:F4');
$sheet->getStyle('E3')->applyFromArray($styleArray);
$sheet->getStyle('E3:E4')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorPrincipal);
$sheet->getStyle('E3')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('E3')->getAlignment()->setHorizontal('right');
$sheet->getStyle('E3')->getAlignment()->setVertical('right');
$sheet->setCellValue("E3", $fechafinal);
// $sheet->mergeCells('A6:E6');
// $sheet->getStyle('A6')->getFont()->setSize($tamañoLetraTexto);
// $sheet->getStyle('A6')->getAlignment()->setHorizontal('left');
// $sheet->getStyle('A6')->getAlignment()->setVertical('left');
// $sheet->setCellValue("A6", "FECHA FINAL");
// //
// $sheet->getStyle('B6')->getFont()->setSize($tamañoLetraTexto);
// $sheet->getStyle('B6')->getAlignment()->setHorizontal('left');
// $sheet->getStyle('B6')->getAlignment()->setVertical('left');
// $sheet->setCellValue("B6", $fechafinal);

//


$TurnosCount = DevolverUnDato("SELECT COUNT(*)
FROM auditoria
JOIN servicio ON auditoria.IdServicio = servicio.IdServicio
WHERE Estado != 'NORMAL'
    AND servicio.Servicio NOT IN ('TRIAGE', 'TRIAGE 1', 'TRIAGE 2', 'TRIAGE 3', 'TRIAGE 4', 'TRIAGE 5')
    AND auditoria.FechaLlegada BETWEEN '$fechaInicial 00:00:00' AND '$fechafinal 23:59:59'
    AND auditoria.IdSede = '$IdSede'
    AND auditoria.emp_id = '$IdEmpresa'");
$TurnosAtendidosCount = DevolverUnDato("SELECT COUNT(*)
FROM auditoria
JOIN servicio ON auditoria.IdServicio = servicio.IdServicio
WHERE Estado= 'TERMINADO'

  AND Observacion != 'TRANSFERIDO'
  AND servicio.Servicio NOT IN ('TRIAGE', 'TRIAGE 1', 'TRIAGE 2', 'TRIAGE 3', 'TRIAGE 4', 'TRIAGE 5')
  AND auditoria.FechaLlegada BETWEEN '$fechaInicial 00:00:00' AND '$fechafinal 23:59:59'
  AND auditoria.IdSede = '$IdSede'
  AND auditoria.emp_id = '$IdEmpresa'");
$TurnosAusentesCount = DevolverUnDato("SELECT COUNT(*)
FROM auditoria
JOIN servicio ON auditoria.IdServicio = servicio.IdServicio
WHERE Estado = 'AUSENTE'
  AND servicio.Servicio NOT IN ('TRIAGE', 'TRIAGE 1', 'TRIAGE 2', 'TRIAGE 3', 'TRIAGE 4', 'TRIAGE 5')
  AND auditoria.FechaLlegada BETWEEN '$fechaInicial 00:00:00' AND '$fechafinal 23:59:59'
  AND auditoria.IdSede = '$IdSede'
  AND auditoria.emp_id = '$IdEmpresa'");
$TurnosTransferidosCount = DevolverUnDato("SELECT COUNT(*)
FROM auditoria
JOIN servicio ON auditoria.IdServicio = servicio.IdServicio
WHERE Estado = 'TERMINADO'
  AND Observacion = 'TRANSFERIDO'
  AND servicio.Servicio NOT IN ('TRIAGE', 'TRIAGE 1', 'TRIAGE 2', 'TRIAGE 3', 'TRIAGE 4', 'TRIAGE 5')
  AND auditoria.FechaLlegada BETWEEN '$fechaInicial 00:00:00' AND '$fechafinal 23:59:59'
  AND auditoria.IdSede = '$IdEmpresa'
  AND auditoria.emp_id = '$IdSede'");
$sheet->getStyle('A5:B5')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('B5:B9')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($nombreEmpresaColor);
$sheet->mergeCells('A5:B5');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');

$sheet->getStyle('A5:B5')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A5:B5');
$sheet->getStyle('A5')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A5')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A5')->getAlignment()->setVertical('center');
$sheet->setCellValue("A5", "INFORMACIÓN GENERAL DE TURNOS");
//
$sheet->getStyle('A6')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A6')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A6')->getAlignment()->setVertical('center');
$sheet->setCellValue("A6", "TURNOS TOTALES");
//
$sheet->getStyle('B6')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B6')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B6')->getAlignment()->setVertical('left');
$sheet->setCellValue("B6", $TurnosCount);
//
$sheet->getStyle('A7')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A7')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A7')->getAlignment()->setVertical('center');
$sheet->setCellValue("A7", "TURNOS ATENDIDOS");
//
$sheet->getStyle('B7')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B7')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B7')->getAlignment()->setVertical('center');
$sheet->setCellValue("B7", $TurnosAtendidosCount);
//
$sheet->getStyle('A8')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A8')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A8')->getAlignment()->setVertical('center');
$sheet->setCellValue("A8", "TURNOS AUSENTES");
//
$sheet->getStyle('B8')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B8')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B8')->getAlignment()->setVertical('center');
$sheet->setCellValue("B8", $TurnosAusentesCount);
//
$sheet->getStyle('A9')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A9')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A9')->getAlignment()->setVertical('center');
$sheet->setCellValue("A9", "TURNOS TRANSFERIDOS");
//
$sheet->getStyle('B9')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B9')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B9')->getAlignment()->setVertical('center');
$sheet->setCellValue("B9", $TurnosTransferidosCount);

$servicios = DevolverUnArreglo("SELECT servicio.idservicio, servicio.Servicio, COUNT(auditoria.IdServicio) AS Cantidad
FROM auditoria
JOIN servicio ON auditoria.IdServicio = servicio.IdServicio
WHERE Estado != 'NORMAL'
  AND servicio.Servicio NOT IN ('TRIAGE', 'TRIAGE 1', 'TRIAGE 2', 'TRIAGE 3', 'TRIAGE 4', 'TRIAGE 5')
  AND auditoria.FechaLlegada BETWEEN '$fechaInicial 00:00:00' AND '$fechafinal 23:59:59'
  AND auditoria.IdSede = '$IdSede'
  AND auditoria.emp_id = '$IdEmpresa'
GROUP BY auditoria.IdServicio");

$ServiciosCount = $TurnosCount;
$totalPorcentaje = 0;
//
$sheet->getStyle('A11:C11')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A11:C11');
$sheet->getStyle('A11')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A11')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A11')->getAlignment()->setVertical('center');
$sheet->setCellValue("A11", "INFORMACIÓN GENERAL DE LOS SERVICIOS");
//
$sheet->getStyle('A12:C12')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A12')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A12')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A12')->getAlignment()->setVertical('center');
$sheet->setCellValue("A12", "SERVICIO");
//
$sheet->getStyle('B12')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B12')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B12')->getAlignment()->setVertical('center');
$sheet->setCellValue("B12", "TOTAL");
//
$sheet->getStyle('C12')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C12')->getAlignment()->setHorizontal('center');
$sheet->getStyle('C12')->getAlignment()->setVertical('center');
$sheet->setCellValue("C12", "PORCENTAJE");
//
$contar = 13;
//
$TotalServiciosTurnos = 0;
for ($i=0; $i <count($servicios) ; $i++) { 
    $porcentaje = 0;
    //
    if ($i%2==0){
        $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
    }else{
        $sheet->getStyle('A' . $contar . ':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
    }
    $sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A' . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A' . $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue('A' . $contar, $servicios[$i]['Servicio']);
    //
    $sheet->getStyle('B'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('B'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('B'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("B". $contar, $servicios[$i]['Cantidad']);
    //
    $porcentaje = ($servicios[$i]['Cantidad'] / $ServiciosCount) * 100;
    
    $totalPorcentaje = $totalPorcentaje + $porcentaje;
    
    //
    $TotalServiciosTurnos = ($TotalServiciosTurnos + $servicios[$i]['Cantidad']);
    //
    $sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
    $sheet->setCellValue("C". $contar, round($porcentaje, 2) . "%");
    //
    $contar = $contar + 1;
}


//
//$sheet->mergeCells('A'. $contar);   
$sheet->getStyle('A'. $contar .':C'. $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("A". $contar, "TOTAL");
//
$sheet->getStyle('B'. $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('B'. $contar)->getAlignment()->setVertical('center');
$sheet->setCellValue("B". $contar, $TotalServiciosTurnos);
//
$sheet->getStyle('C'. $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C'. $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('C'. $contar)->getAlignment()->setVertical('center');
//echo $totalPorcentaje;
$sheet->setCellValue("C". $contar, $totalPorcentaje . "%");
//INFORMACION DE LOS PROFESIONALES
$sheet->getStyle('A18:C18')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->mergeCells('A18:C18');
$sheet->getStyle('A18')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A18')->getAlignment()->setHorizontal('center');
$sheet->getStyle('A18')->getAlignment()->setVertical('center');
$sheet->setCellValue("A18", "INFORMACIÓN GENERAL DE LOS PROFESIONALES");
//
$sheet->getStyle('A19:C19')->getFill(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A19')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A19')->getAlignment()->setHorizontal('left');
$sheet->getStyle('A19')->getAlignment()->setVertical('center');
$sheet->setCellValue("A19", "NOMBRE PROFESIONAL");
////
$sheet->getStyle('B19')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B19')->getAlignment()->setHorizontal('center');
$sheet->getStyle('B19')->getAlignment()->setVertical('center');
$sheet->setCellValue("B19", "ATENDIDOS");
//
$sheet->getStyle('C19')->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C19')->getAlignment()->setHorizontal('center');
$sheet->getStyle('C19')->getAlignment()->setVertical('center');
$sheet->setCellValue("C19", "PORCENTAJE");
//
$doctores = DevolverUnArreglo("SELECT usuario.NombreCompleto, COUNT(auditoria.idDoctorGeneral) AS Cantidad
FROM auditoria
JOIN usuario ON auditoria.idDoctorGeneral = usuario.IdUsuario
JOIN servicio ON auditoria.IdServicio = servicio.IdServicio
WHERE auditoria.Estado != 'NORMAL'
  AND servicio.Servicio NOT IN ('TRIAGE', 'TRIAGE 1', 'TRIAGE 2', 'TRIAGE 3', 'TRIAGE 4', 'TRIAGE 5')
  AND auditoria.FechaLlegada BETWEEN '$fechaInicial 00:00:00' AND '$fechafinal 23:59:59'
  AND auditoria.IdSede = '$IdSede'
  AND auditoria.emp_id = '$IdEmpresa'
GROUP BY auditoria.idDoctorGeneral");

$doctoresCount = 0;
$totalPorcentajeDoctor = 0;
$contarDoctores = 22;
$TotalMedicoTurnos = 0;

if($doctores){
    foreach ($doctores as &$valor) {
        $doctoresCount = $valor['Cantidad'] + $doctoresCount;
    }
    foreach ($doctores as &$valor) {
        $porcentaje = 0;
        $sheet->setCellValue("A" . $contarDoctores, $valor['NombreCompleto']);
        $sheet->getStyle('A' . $contarDoctores)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A' . $contarDoctores)->getAlignment()->setVertical('center');
        $sheet->setCellValue("B" . $contarDoctores, $valor['Cantidad']);
        $sheet->getStyle('B' . $contarDoctores)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('B' . $contarDoctores)->getAlignment()->setVertical('center');
        $porcentaje = ($valor['Cantidad'] / $doctoresCount) * 100;
        $totalPorcentajeDoctor = $totalPorcentajeDoctor + $porcentaje;
        $TotalMedicoTurnos = ($TotalMedicoTurnos + $valor['Cantidad']);
        $sheet->setCellValue("C" . $contarDoctores, round($porcentaje, 2) . "%");
        $sheet->getStyle('C' . $contarDoctores)->getAlignment()->setHorizontal('center');
        $sheet->getStyle('C' . $contarDoctores)->getAlignment()->setVertical('center');
        if ($contarDoctores % 2 == 1) {
            $sheet->getStyle('A' . $contarDoctores . ':C' . $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB($colorIntercalado);
        }
        $contarDoctores = $contarDoctores + 1;
    }
}else{
    $contarDoctores = $contarDoctores + 1;
}
//
//$sheet->mergeCells('F'. $contar .':G'. $contar);
$sheet->getStyle('A'. $contarDoctores .':C'. $contarDoctores)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contarDoctores)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contarDoctores)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contarDoctores)->getAlignment()->setVertical('center');
$sheet->setCellValue("A". $contarDoctores, "TOTAL");
//
$sheet->getStyle('B'. $contarDoctores)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('B'. $contarDoctores)->getAlignment()->setHorizontal('center');
$sheet->getStyle('B'. $contarDoctores)->getAlignment()->setVertical('center');
$sheet->setCellValue("B". $contarDoctores, $TotalMedicoTurnos);
//
$sheet->getStyle('C'. $contarDoctores)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('C'. $contarDoctores)->getAlignment()->setHorizontal('center');
$sheet->getStyle('C'. $contarDoctores)->getAlignment()->setVertical('center');
$sheet->setCellValue("C". $contarDoctores, $totalPorcentajeDoctor . "%");

if($contarDoctores > $contar){
    $contar = $contarDoctores + 2;
}else{
    $contar+=2;
}

//
$contar += 1;
$sheet->getStyle('A' . $contar . ':AA' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
$sheet->getStyle('A' . $contar . ':AA' . $contar)->getFont()->setSize($tamañoLetraTexto);
$sheet->getStyle('A'. $contar. ':AA' . $contar)->getAlignment()->setHorizontal('center');
$sheet->getStyle('A'. $contar. ':AA' . $contar)->getAlignment()->setVertical('center');
//
$sheet->setCellValue("A". $contar, "NOMBRE DEL CIUDADANO");
//
$sheet->setCellValue("B". $contar, "CEDULA DEL CIUDADANO");
//
$sheet->setCellValue("C". $contar, "ENTIDAD DEL CIUDADANO");
//
$sheet->setCellValue("D". $contar, "NIVEL");
//
$sheet->setCellValue("E". $contar, "SERVICIO");
//
$sheet->setCellValue("F". $contar, "NIVEL");
//
$sheet->setCellValue("G". $contar, "PERTENECE AL SERVICIO");
//
$sheet->setCellValue("H". $contar, "TURNO");
//
$sheet->setCellValue("I". $contar, "NUMERO DE LLAMADOS");
//
$sheet->setCellValue("J". $contar, "ESTADO");
//
$sheet->setCellValue("K". $contar, "ASESOR");
//
$sheet->setCellValue("L". $contar, "TIEMPO DE ESPERA EN SALA ASESOR");
//
$sheet->setCellValue("M". $contar, "TIEMPO DE ATENCION ASESOR");
//
$sheet->setCellValue("N". $contar, "TIEMPO TOTAL ASESOR");
//
$sheet->setCellValue("O". $contar, "FECHA DE SOLICITUD ASESOR");
//
$sheet->setCellValue("P". $contar, "FECHA DE LLAMADO ASESOR");
//
$sheet->setCellValue("Q". $contar, "FECHA DE TERMINACION DE TURNO ASESOR");
//
$sheet->setCellValue("R". $contar, "PROFESIONAL");
//
$sheet->setCellValue("S". $contar, "TIEMPO DE ESPERA EN SALA PROFESIONAL");
//
$sheet->setCellValue("T". $contar, "TIEMPO DE ATENCION PROFESIONAL");
//
$sheet->setCellValue("U". $contar, "TIEMPO TOTAL PROFESIONAL");
//
$sheet->setCellValue("V". $contar, "FECHA DE LLAMADO PROFESIONAL");
//
$sheet->setCellValue("W". $contar, "FECHA DE TERMINACION PROFESIONAL");
//
$sheet->setCellValue("X". $contar, "TIEMPO TOTAL DE PERMANENCIA CIUDADANO");
//
$sheet->setCellValue("Y". $contar, "OBSERVACION ASESOR");
//
$sheet->setCellValue("Z". $contar, "OBSERVACION PROFESIONAL");
//
$sheet->setCellValue("AA". $contar, "OBSERVACION RETRASO");
//

$detalle = DevolverUnArreglo("SELECT personas.NombreCompleto AS Paciente,personas.Cedula,personas.eps,servicio.Servicio,servicio.EstadoSub,servicio.IdServicio,auditoria.Turno,auditoria.Estado,auditoria.NumeroLlamados, t1.NombreCompleto AS Asesor,auditoria.FechaLlegada,auditoria.FechaLlamado,auditoria.Fechasalio,auditoria.Observacion,auditoria.ObservacionAsesor,auditoria.ObservacionRetraso, t2.NombreCompleto AS NombreMedico,auditoria.FLlamadoDocGeneral AS FLlmamadoMedico,auditoria.FSalioDocGeneral AS FSalioMedico,auditoria.ObservacionDoctorGeneral AS ObservacionMedico, auditoria.nivel FROM auditoria JOIN usuario AS t1 ON (t1.IdUsuario = auditoria.IdUsuario) LEFT JOIN usuario AS t2 ON (t2.IdUsuario = auditoria.idDoctorGeneral) JOIN servicio ON (servicio.IdServicio = auditoria.IdServicio) LEFT JOIN personas ON (personas.IdPersona = auditoria.IdPersona) WHERE (auditoria.Estado != 'NORMAL') AND servicio.Servicio != 'TRIAGE' AND servicio.Servicio != 'TRIAGE 1' AND servicio.Servicio != 'TRIAGE 2' AND servicio.Servicio != 'TRIAGE 3' AND servicio.Servicio != 'TRIAGE 4' AND servicio.Servicio != 'TRIAGE 5' AND auditoria.FechaLlegada >= '$fechaInicial 00:00:00' AND auditoria.FechaLlegada<='$fechafinal 23:59:59' AND auditoria.IdSede = '$IdSede' AND auditoria.emp_id = '$IdEmpresa' GROUP BY auditoria.IdAuditoria ORDER BY auditoria.IdAuditoria");

$contar = $contar + 1;
//
for ($i=0; $i <count($detalle); $i++) { 
    if($detalle[$i]['Paciente'] == "0" || $detalle[$i]['Paciente'] == "" || $detalle[$i]['Paciente'] == "undefined" || $detalle[$i]['Paciente'] == null){
        $detalle[$i]['Paciente'] = "Sin Registro";
    }
    ///CEDULA DEL CLIENTE
    if($detalle[$i]['Cedula'] == "0" || $detalle[$i]['Cedula'] == "" || $detalle[$i]['Cedula'] == "undefined" || $detalle[$i]['Cedula'] == null){
        $detalle[$i]['Cedula'] = "Sin Registro";
    }
    if($detalle[$i]['NombreMedico'] == "0" || $detalle[$i]['NombreMedico'] == "" || $detalle[$i]['NombreMedico'] == "undefined" || $detalle[$i]['NombreMedico'] == null){
        $detalle[$i]['NombreMedico'] = "Sin Registro";
    }
}

for($i=0; $i <count($detalle) ; $i++){
    //
    $TiempoEsperaAsesor = 0;
    $TiempoAtencionAsesor = 0;
    $tiempoTotalAsesor = 0;
    //
    $TiempoEsperaDoctor = 0;
    $TiempoAtencionDoctor = 0;
    $tiempoTotalDoctor = 0;
    $tiempoTotalEstadia = 0;

    if ($i%2==0){
        $sheet->getStyle('A' . $contar . ':AA' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorIntercalado);
    }else{
        $sheet->getStyle('A' . $contar . ':AA' . $contar)->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFFF');
    }
    //
    $sheet->getStyle('A' . $contar . ':AA' . $contar)->getFont()->setSize($tamañoLetraTexto);
    $sheet->getStyle('A'. $contar . ':AA' . $contar)->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A'. $contar . ':AA' . $contar)->getAlignment()->setVertical('center');
    //
    $sheet->setCellValue("A" . $contar, $detalle[$i]['Paciente']);
    $sheet->setCellValue("B" . $contar, $detalle[$i]['Cedula']);
    $sheet->setCellValue("C" . $contar, $detalle[$i]['eps']);
    $sheet->setCellValue("D" . $contar, $detalle[$i]['nivel']);
    $sheet->setCellValue("E" . $contar, $detalle[$i]['Servicio']);

    if($detalle[$i]['EstadoSub'] != 'SERVICIO'){
        $sheet->setCellValue("F" . $contar, $detalle[$i]['EstadoSub']);
        
        $ServiPertenece = DevolverUnDato("SELECT ser.Servicio
        FROM relacionservicios rela
        JOIN servicio ser ON ser.IdServicio = rela.servicio
        WHERE rela.subservicio = '".$detalle[$i]['IdServicio']."'
          AND rela.IdSede = '$IdSede'
          AND rela.emp_id = '$IdEmpresa'
        ORDER BY rela.idrelacionservicio DESC
        LIMIT 1"); //
        $sheet->setCellValue("G" . $contar, $ServiPertenece);
    }else{
        $sheet->setCellValue("F" . $contar, $detalle[$i]['EstadoSub']);
        $sheet->setCellValue("G" . $contar, $detalle[$i]['Servicio']);
    }
    $sheet->setCellValue("H" . $contar, $detalle[$i]['Turno']);
    $sheet->setCellValue("I" . $contar, $detalle[$i]['NumeroLlamados']);

    if ($detalle[$i]['Observacion'] == "TRANSFERIDO") {
        $sheet->setCellValue("J" . $contar, "TRANSFERIDO");
    } else {
        $sheet->setCellValue("J" . $contar, $detalle[$i]['Estado']);
    }

    $sheet->setCellValue("K" . $contar, $detalle[$i]['Asesor']);

    $TiempoEsperaAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlegada']), new DateTime($detalle[$i]['FechaLlamado']));
    $TiempoAtencionAsesor = CalcularMinutos(new DateTime($detalle[$i]['FechaLlamado']), new DateTime($detalle[$i]['Fechasalio']));
    $tiempoTotalAsesor = $TiempoEsperaAsesor + $TiempoAtencionAsesor;

    $sheet->setCellValue("L" . $contar, conversorSegundosHoras($TiempoEsperaAsesor));
    $sheet->setCellValue("M" . $contar, conversorSegundosHoras($TiempoAtencionAsesor));
    $sheet->setCellValue("N" . $contar, conversorSegundosHoras($tiempoTotalAsesor));
    $sheet->setCellValue("O" . $contar, $detalle[$i]['FechaLlegada']);
    $sheet->setCellValue("P" . $contar, $detalle[$i]['FechaLlamado']);
    $sheet->setCellValue("Q" . $contar, $detalle[$i]['Fechasalio']);
    $sheet->setCellValue("R" . $contar, $detalle[$i]['NombreMedico']);

    if (isset($detalle[$i]['idDoctorGeneral']) && $detalle[$i]['idDoctorGeneral'] != 0) {
        $TiempoEsperaDoctor = CalcularMinutos(new DateTime($detalle[$i]['Fechasalio']), new DateTime($detalle[$i]['FLlmamadoMedico']));
    }
    $TiempoAtencionDoctor = CalcularMinutos(new DateTime($detalle[$i]['FLlmamadoMedico']), new DateTime($detalle[$i]['FSalioMedico']));
    $tiempoTotalDoctor = $TiempoEsperaDoctor + $TiempoAtencionDoctor;
    $sheet->setCellValue("S" . $contar, conversorSegundosHoras($TiempoEsperaDoctor));
    $sheet->setCellValue("T" . $contar, conversorSegundosHoras($TiempoAtencionDoctor));
    $sheet->setCellValue("U" . $contar, conversorSegundosHoras($tiempoTotalDoctor));
    $sheet->setCellValue("V" . $contar, $detalle[$i]['FLlmamadoMedico']);
    $sheet->setCellValue("W" . $contar, $detalle[$i]['FSalioMedico']);
    $tiempoTotalEstadia = $tiempoTotalAsesor + $tiempoTotalDoctor;
    $sheet->setCellValue("X" . $contar, conversorSegundosHoras($tiempoTotalEstadia));
    $sheet->setCellValue("Y" . $contar, $detalle[$i]['ObservacionAsesor']);
    $sheet->setCellValue("Z" . $contar, $detalle[$i]['ObservacionMedico']);
    $sheet->setCellValue("AA" . $contar, $detalle[$i]['ObservacionRetraso']);
    $contar = $contar + 1;
}

foreach (range('A', 'Z') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}
$sheet->getColumnDimension('AA')->setAutoSize(true);

$files = glob('../reportes/*'); //obtenemos todos los nombres de los ficheros
foreach ($files as $file) {
    if (is_file($file))
        unlink($file); //elimino el fichero
}
//
$writer = new Xlsx($spreadsheet);
$writer->save('../reportes/Reporte.xlsx');
//
for ($i=0; $i < COUNT($detalle); $i++) { 
    unset($detalle[$i]['IdServicio']);
}

$validar = array('respuesta' => 'Enviado Correctamente','DatosG' => $detalle, 'CountTurnos' => $TurnosCount,'CountAtendidos' => $TurnosAtendidosCount,'CountAusentes' => $TurnosAusentesCount,'CountTransferidos' => $TurnosTransferidosCount);
echo json_encode($validar, JSON_FORCE_OBJECT);
?>
