<?php
ini_set('error_reporting', E_ALL & ~E_WARNING & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include 'conexion.php';

require 'vendor/autoload.php';

function CambiarFormatoFechaLaConcepcion($newstring) {
    $tamañoFecha = strlen($newstring);
    $posicionEspacio = strpos($newstring, ' ', 0);
    $soloFecha = substr($newstring, 0, $posicionEspacio);
    $arregloFecha = explode("/", $soloFecha);
    $fechaConvertida = $arregloFecha[2] . "-" . $arregloFecha[1] . "-" . $arregloFecha[0];
    $soloHora = substr($newstring, $posicionEspacio + 1, $tamañoFecha);
    $fecha_Completa = $fechaConvertida . " " . $soloHora;
    return $fecha_Completa;
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

$ruta = "archivo/Magisoft.xlsx";

$reader = PhpOffice\PhpSpreadsheet\IOFactory::createReader("Xlsx");

$spreadsheet = $reader->load($ruta);

$sheet = $spreadsheet->getActiveSheet();

$IdSede = $_REQUEST["IdSede"];
$emp_id = $_REQUEST["emp_id"];

$NombreDoctores = DevolverUnArreglo("SELECT NombreCompleto FROM usuario WHERE Rol = 'MEDICOGENERAL' AND (Eliminado = 0 OR Eliminado IS NULL) AND IdSede = '$IdSede' AND emp_id = '$emp_id'");
$ArregloEspecialidades = DevolverUnArreglo("SELECT NombreRol FROM especialidad WHERE (Eliminado = 0 OR Eliminado IS NULL ) AND IdSede = '$IdSede' AND emp_id = '$emp_id'");
$contar = $sheet->getHighestRow('A');

$conteoLinea = 2;
$consultaInsertarPersonas = "";
$consultaInsertarCitas = "";
$consultaInsertar = "INSERT INTO cita (IdPersona,IdUsuario,IdTipoRol,FechaCita,Estado,IdSede,emp_id) VALUES ";
$arregloDatos = array();
foreach ($sheet->getRowIterator(2) as $row) {
    $NombrePaciente = $sheet->getCellByColumnAndRow(1, $row->getRowIndex())->getValue();
    $NombrePaciente = strtoupper($NombrePaciente);
    $Cedula = $sheet->getCellByColumnAndRow(2, $row->getRowIndex())->getValue();
    $NombreDoctor = $sheet->getCellByColumnAndRow(3, $row->getRowIndex())->getValue();
    $FechaCita = $sheet->getCellByColumnAndRow(4, $row->getRowIndex())->getFormattedValue();
    $HoraCita = $sheet->getCellByColumnAndRow(5, $row->getRowIndex())->getFormattedValue();
    $EspecialidadImportar = $sheet->getCellByColumnAndRow(6, $row->getRowIndex())->getValue();
    $arr = [];
    //
    $FechaCita = strtotime($FechaCita);
    $anio = date("Y", $FechaCita);
    $mes = date("m", $FechaCita);
    $dia = date("d", $FechaCita);
    $FechaCita = $anio . "-" . $mes . "-" . $dia . " " . $HoraCita;

    if ($NombrePaciente == "" || $Cedula == "" || $FechaCita == "") {
        $validar = array('respuesta' => "codigo: 1.1 Error en el archivo, falta un dato para registrar (Linea: " . $conteoLinea . ")");
        echo json_encode($validar, JSON_FORCE_OBJECT);
        exit();
    }
    if (($EspecialidadImportar == "" && $NombreDoctor == "") || ($EspecialidadImportar != "" && $NombreDoctor != "")) {
        $validar = array('respuesta' => "codigo: 1.2 Error en el archivo, Tiene que llenar el Nombre Medico, o el Nombre de la Especialidad. (Linea: $conteoLinea)");
        echo json_encode($validar, JSON_FORCE_OBJECT);
        exit();
    }
    $iddoctor = 0;
    $IdEspecialidad = 0;
    if ($NombreDoctor != "") {
        
        $iddoctor = DevolverUnDato("SELECT idusuario FROM usuario WHERE nombrecompleto = '$NombreDoctor' AND IdSede = '$IdSede' AND emp_id = '$emp_id'");
        if (!validarDoctor($NombreDoctor)) {
            $validar = array('respuesta' => "codigo: 2.1 Error en el nombre del doctor ya que no se encuentra registrado en el sfotware (Linea: $conteoLinea)");
            echo json_encode($validar, JSON_FORCE_OBJECT);
            exit();
        }
    } else {
        $IdEspecialidad = DevolverUnDato("SELECT idtiporol FROM especialidad WHERE nombrerol = '$EspecialidadImportar' AND IdSede = '$IdSede' AND emp_id = '$emp_id'");
        if (!validarEspecialidad($EspecialidadImportar)) {
            $validar = array('respuesta' => "codigo: 2.2 Error en el nombre de la especialidad ya que no se encuentra registrada en el sfotware (Linea: $conteoLinea)");
            echo json_encode($validar, JSON_FORCE_OBJECT);
            exit();
        }
    }


    $idPersona = DevolverUnDato("SELECT idpersona FROM personas WHERE cedula = '$Cedula' AND IdSede = '$IdSede' AND emp_id = '$emp_id'");

    if (empty($idPersona)){
        $idPersona = InsertDevolviendoID("INSERT INTO personas 
        (NombreCompleto,Cedula,Sexo,Direccion,Barrio,Telefono,FechaNacimiento,eps,IdSede,emp_id,EstadoNube,Eliminado) 
        VALUES ('$NombrePaciente','$Cedula','','','','','0000-00-00','','$IdSede','$emp_id','0','0')");
    }
    $consultaInsertar = $consultaInsertar . "($idPersona,$iddoctor,$IdEspecialidad,'$FechaCita','NORMAL','$IdSede','$emp_id')";
    array_push($arregloDatos, array("NombrePaciente" => $NombrePaciente, "Cedula" => $Cedula, "NombreDoctor" => $NombreDoctor, "Especialidad" => $EspecialidadImportar, "FechaCita" => $FechaCita));

    if ($conteoLinea >= $contar) {
        insertar($consultaInsertar, $arregloDatos);
        exit();
    } else {
        $consultaInsertar = $consultaInsertar . ",";
    }
    $conteoLinea += 1;
}

function convertirFecha($fecha) {

    $fecha = str_replace("/", "-", $fecha);
    $date = strtotime($fecha);
    return date('Y-m-d h:i:s', $date);
}

function validarDoctor($Nombredoctor) {
    global $NombreDoctores;
    foreach ($NombreDoctores as $value) {
        if (in_array($Nombredoctor, $value)) {
            return true;
        }
    }
    return false;
}

function validarEspecialidad($NombreEspecialidad) {
    global $ArregloEspecialidades;
    foreach ($ArregloEspecialidades as $value) {
        if (in_array($NombreEspecialidad, $value)) {
            return true;
        }
    }
    return false;
}

function insertar($consultainsertar, $arregloDatos) {
    hacerConsulta($consultainsertar);
    $validar = array('respuesta' => "bien", 'insertados' => $arregloDatos);
    echo json_encode($validar, JSON_FORCE_OBJECT);
    exit();
}


header('Content-Type: application/json');
echo json_encode($validar, JSON_FORCE_OBJECT);
?>
