<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include 'conexion.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

//
$emp_id = $_REQUEST["emp_id"];
$IdSede = $_REQUEST["IdSede"];
//
$colorFondoTituloRojoOscuro = "366092";
$colorFondoTituloRojoClaro = "95B3D7";
$colorIntercalado = "C5D9F1";
//
$EPS = DevolverUnArreglo("SELECT nombre_eps FROM eps WHERE IdSede = '$IdSede' AND emp_id ='$emp_id' AND Eliminado = '0'");
//FECHAS DE FILTRO
$sheet->getStyle('J1:K1')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('J2:K2')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('J3:K3')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));

foreach (range('A', 'W') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
} 

$sheet->setCellValue("A1", "NOMBRE COMPLETO");
$sheet->setCellValue("B1", "CEDULA");
$sheet->setCellValue("C1", "GÉNERO");
$sheet->setCellValue("D1", "DIRECCION");
$sheet->setCellValue("E1", "BARRIO");
$sheet->setCellValue("F1", "TELEFONO");
$sheet->setCellValue("G1", "FECHA NACIMIENTO");
$sheet->setCellValue("H1", "EPS");
$sheet->getStyle('A1:H1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);

$sheet->setCellValue("J1", "EJEMPLO DE FECHA NACIMIENTO");
$sheet->setCellValue("J2", "1998-05-16");
$sheet->setCellValue("J3", "2019-06-22");
$sheet->setCellValue("K1", "EJEMPLO DE GÉNERO");
$sheet->setCellValue("K2", "M");
$sheet->setCellValue("K3", "F");
$sheet->setCellValue("L1", "EPS DISPONIBLE");
$sheet->setCellValue("M1", "NOTA");
$sheet->setCellValue("M2", "LA EPS SE DEBE COPIAR Y PEGAR EN LA CASILLA CORRESPONDIENTE A CADA CIUDADANO");
$sheet->getStyle('J1:M1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);

$conteo = 2;
for ($i=0; $i <count($EPS) ; $i++) { 
    $sheet->setCellValue("L".$conteo, $EPS[$i]["nombre_eps"]);
    $sheet->getStyle("L".$conteo)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
    $conteo++;
}



//GUARDAR ARCHIVO
$files = glob('reportes/*');
foreach ($files as $file) {
    if (is_file($file))
        unlink($file);
}

$writer = new Xlsx($spreadsheet);
$writer->save('Formatos/Formato.xlsx');

$validar = array('respuesta' => 'Enviado Correctamente');
echo json_encode($validar, JSON_FORCE_OBJECT);

?>
