<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include 'conexion.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

//
$emp_id = $_REQUEST["emp_id"];
$IdSede = $_REQUEST["IdSede"];
//
$colorFondoTituloRojoOscuro = "366092";
$colorFondoTituloRojoClaro = "95B3D7";
$colorIntercalado = "C5D9F1";
//
$sheet->getStyle('A1:A1')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
//
foreach (range('A', 'W') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
} 
//
$sheet->setCellValue("A1", "CEDULA");
$sheet->setCellValue("B1", "FECHA MAXIMO DE ENTREGA");
$sheet->getStyle('A1:B1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);
//
$sheet->setCellValue("D1", "EJEMPLO DE FECHA");
$sheet->setCellValue("D2", "2020-05-16");
$sheet->getStyle('D1:D1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($colorFondoTituloRojoClaro);

//GUARDAR ARCHIVO
$files = glob('reportes/*');
foreach ($files as $file) {
    if (is_file($file))
        unlink($file);
}

$writer = new Xlsx($spreadsheet);
$writer->save('Formatos/FormatoEntrega.xlsx');

$validar = array('respuesta' => 'Enviado Correctamente');
echo json_encode($validar, JSON_FORCE_OBJECT);

?>
