<?php

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include 'conexion.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$colorTitulo = "AFCEEB";
$colorIntercalado = "DDEBF7";

//FECHAS DE FILTRO
$sheet->getStyle('I1:I2')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('J1:J2')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('I4')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));

foreach (range('A', 'W') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

$sheet->setCellValue("A1", "NOMBRE COMPLETO");
$sheet->setCellValue("B1", "CEDULA");
$sheet->setCellValue("C1", "NOMBRE DOCTOR");
$sheet->setCellValue("D1", "FECHA CITA");
$sheet->setCellValue("E1", "HORA CITA");
$sheet->setCellValue("F1", "ESPECIALIDAD");
$sheet->setCellValue("I1", "EJEMPLO DE FECHA");
$sheet->setCellValue("I2", "2019-06-22");
$sheet->setCellValue("j1", "EJEMPLO DE HORA");
$sheet->setCellValue("j2", "19:00");
$sheet->setCellValue("I4", "DOCTORES");
$sheet->setCellValue("K4", "ESPECIALIDAD");
$sheet->setCellValue("M1", "Nota: Instrucciones de uso del formulario.");
$sheet->setCellValue("M2", "1. En la columna A debe ingresarse el nombre completo del paciente");
$sheet->setCellValue("M3", "2. En la columna B debe ingresarse el número de la cedula del paciente");
$sheet->setCellValue("M4", "3. En la columna C debe ingresarse el nombre del doctor, Atención: este nombre debe ser ingresado igual como se encuentra en la columna I, para evitar errores preferiblemente copiar y pegar.");
$sheet->setCellValue("M5", "4. En la columna D debe ingresarse la fecha y hora de la cita, Atención:  debe ingresarse con el siguiente formato, ejemplo: (año-mes-dia hora:minutos) asi: 2019-06-22 19:00");
$sheet->setCellValue("M6", "5. En la columna E debe ingresarse la especialidad del doctor, Atención: este nombre debe ser ingresado igual como se encuentra en la columna K, para evitar errores preferiblemente copiar y pegar.");
$sheet->setCellValue("M7", "6. Atención: si se quiere que el paciente sea visualizado por un doctor en específico se debe llenar la columna C y dejar en blanco la columna E. Nota: nunca llenar ambas columnas.");
$sheet->setCellValue("M8", "7. Atención: si se quiere que el paciente sea visualizado por todos los doctores asociados a una especialidad, se debe llenar la columna E y dejar en blanco la columna C. Nota: nunca llenar ambas columnas.");
$sheet->getStyle('M1:M8')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB("F8FF6B");
$sheet->getStyle('A1:F1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB("32BBFF");
$sheet->getStyle('I1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB("32BBFF");
$sheet->getStyle('J1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB("32BBFF");
$sheet->getStyle('I4')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB("32BBFF");
$sheet->getStyle('K4')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setRGB("32BBFF");
$sheet->getStyle('A1:F1')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('K4')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));
$sheet->getStyle('M1:M8')->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN)->setColor(new Color('00000000'));

$sheet->getStyle("D")->getNumberFormat()->setFormatCode("DD-MM-YYYY");
$sheet->getStyle("E")->getNumberFormat()->setFormatCode("H:mm");
$sheet->getStyle("I2")->getNumberFormat()->setFormatCode("YYYY-MM-DD H:mm");

$contar = 5;

$servicios = DevolverUnArreglo("SELECT NombreCompleto FROM `usuario` WHERE Rol ='MEDICOGENERAL' AND Eliminado = 0");

foreach ($servicios as &$valor) {
    $sheet->setCellValue("I" . $contar, $valor['NombreCompleto']);
    $contar = $contar + 1;
}

$contar = 5;
$Dependencias = DevolverUnArreglo("SELECT NombreRol FROM `especialidad` WHERE Eliminado = 0");
foreach ($Dependencias as &$valor) {
    $sheet->setCellValue("K" . $contar, $valor['NombreRol']);
    $contar = $contar + 1;
}

//GUARDAR ARCHIVO
$files = glob('reportes/*');
foreach ($files as $file) {
    if (is_file($file))
        unlink($file);
}

$writer = new Xlsx($spreadsheet);
$writer->save('reportes/TurnoMaster.xlsx');

$validar = array('respuesta' => 'Enviado Correctamente');
echo json_encode($validar, JSON_FORCE_OBJECT);
?>
