angular.module('TurnoMasterV2').controller('dashboardController', dashboardController);
dashboardController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', '$interval'];
function dashboardController($scope, $state, $sessionStorage, servicios, $interval) {
    
    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;
    $sessionStorage.MenuSelect = 'dashboard';
    console.log($sessionStorage.rol);
    var IdUsuario = $sessionStorage.idusuario;
    $scope.MostrarTurnosAgendado = false;
    $scope.MostrarTurnosCola = true;
    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    CambiarEstadoUsuario();
    function CambiarEstadoUsuario() {
        var datos = {};
        datos = {accion: "CambiarEstadoUsuario", idusuario: IdUsuario, estado: 'DISPONIBLE'};
        servicios.Mando(datos).then(function success(response) {
        });
    }

    CargarTablas();
    function CargarTablas() {
        $scope.usuario = {};
        datos = {accion: "cargarTabla", idusuario: IdUsuario};
        servicios.Dashboard(datos).then(function success(response) {
            $scope.usuario = response.data.respuesta;
            $scope.servicio = response.data.respuestaServicios;
            $scope.ausentes = response.data.turnosausentes;
            $scope.ServiciosCola = response.data.turnosenCOla;
            $scope.usuariosatendidos = response.data.TERMINADOSUsu;
            $scope.calificaciones = response.data.Calificaciones;
           // AnimacionRojoTiempoAsesor($scope.usuario);
        });
        if($sessionStorage.MenuSelect == 'dashboard'){
            setTimeout(CargarTablas, 10000);
        }
    }

    $scope.TurnosAgendadosF = function() {
        console.log("aaa");
        $scope.TurnosAgendados = {};
        if($scope.MostrarTurnosCola){
            let datos = {accion: "TurnosAgendados",
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.ServicoNube(datos).then(function success(response) {
                $scope.TurnosAgendados = response.data.respuesta;
                $scope.MostrarTurnosAgendado = true;
                $scope.MostrarTurnosCola = false;
            });
        }else{
            $scope.MostrarTurnosAgendado = false;
            $scope.MostrarTurnosCola = true;
        }
    }
    
    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    console.log(datos[clave].menu_direccion);
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }

    

}