angular.module('TurnoMasterV2').controller('dashboardController', dashboardController);
dashboardController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', '$interval'];
function dashboardController($scope, $state, $sessionStorage, servicios, $interval) {
    
    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;
    $sessionStorage.MenuSelect = 'dashboard';
    console.log($sessionStorage.rol);
    var IdUsuario = $sessionStorage.idusuario;
    $scope.MostrarTurnosAgendado = false;
    $scope.MostrarTurnosCola = true;
    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    CambiarEstadoUsuario();
    function CambiarEstadoUsuario() {
        var datos = {};
        datos = {accion: "CambiarEstadoUsuario", idusuario: IdUsuario, estado: 'DISPONIBLE'};
        servicios.Mando(datos).then(function success(response) {
        });
    }

    //CargarTablas();
    function CargarTablas() {
        $scope.usuario = {};
        datos = {accion: "cargarTabla", idusuario: IdUsuario};
        servicios.Dashboard(datos).then(function success(response) {
            $scope.usuario = response.data.respuesta;
            $scope.servicio = response.data.respuestaServicios;
            $scope.ausentes = response.data.turnosausentes;
            $scope.ServiciosCola = response.data.turnosenCOla;
            $scope.usuariosatendidos = response.data.TERMINADOSUsu;
            $scope.calificaciones = response.data.Calificaciones;
           // AnimacionRojoTiempoAsesor($scope.usuario);
        });
        if($sessionStorage.MenuSelect == 'dashboard'){
            setTimeout(CargarTablas, 30000);
        }
    }

    $scope.TurnosAgendadosF = function() {
        console.log("aaa");
        $scope.TurnosAgendados = {};
        if($scope.MostrarTurnosCola){
            let datos = {accion: "TurnosAgendados",
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.ServicoNube(datos).then(function success(response) {
                $scope.TurnosAgendados = response.data.respuesta;
                $scope.MostrarTurnosAgendado = true;
                $scope.MostrarTurnosCola = false;
            });
        }else{
            $scope.MostrarTurnosAgendado = false;
            $scope.MostrarTurnosCola = true;
        }
    }
    
    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    console.log(datos[clave].menu_direccion);
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }

    ConsultarDatosDashboard();
    function ConsultarDatosDashboard() {
        datos = {
            accion: "DatosDash",
            idusuario: IdUsuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Dashboard(datos).then(function success(response) {
            console.log(response);
            graficas(
                response.data.TurnosDiaSemMes,
                response.data.TurnosAsesor,
                response.data.TurnosServicio,
                response.data.TurnosHoraDia,
                response.data.TurnosHoraMes,
                response.data.TurnosDiaMes,
                response.data.Calificaciones,
                response.data.TurnosEnCola,
                response.data.TurnosAsesorTotal,
                response.data.TurnosServicioTotal,
            );
            if($sessionStorage.MenuSelect == 'dashboard'){
                setTimeout(ConsultarDatosDashboard, 30000);
            }
        });
        
    }

    function graficas(
        TurnosDiaSemMes,
        TurnosAsesor,
        TurnosServicio,
        TurnosHoraDia,
        TurnosHoraMes,
        TurnosDiaMes,
        Calificaciones,
        TurnosEnCola,
        TurnosAsesorTotal,
        TurnosServicioTotal
        ) {
        var colores = ["#149ead","#0072a0","#00b6f7","#3ee1fa","#00d390","#004f72","#00b168","#00a289","#282c34"];
        // var colores3 = ["#E74C3C","#7D3C98","#2471A3","#2E86C1","#D4AC0D","#28B463","#A04000","#17A589","#F39C12"];
        // var colores4 = ["#E74C3C","#7D3C98","#2471A3","#2E86C1","#D4AC0D","#28B463","#A04000","#17A589","#F39C12"];
        //TURNOS POR ASESORES PIE
        var myChartP = Highcharts.chart('container', {
            colors: colores,
            chart: {
                type: 'pie'
            },
            accessibility: {
                point: {
                    valueSuffix: '%'
                }
            },
            title: {
                text: 'Turnos atendidos por asesor / médico',
                align: 'left'
            },
            subtitle: {
                text: 'Cantidad de turnos: ' + TurnosAsesorTotal
            },
            tooltip: {
                pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>'
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}: {y} %'
                    },
                    showInLegend: true
                }
            },
            series: [{
                name: 'Registrations',
                colorByPoint: true,
                innerSize: '45%',
                data: TurnosAsesor
                // [{
                //     name: 'EV',
                //     y: 68.1
                // }, {
                //     name: 'Hybrids',
                //     y: 11.0
                // }, {
                //     name: 'Diesel',
                //     y: 11.2
                // }, {
                //     name: 'Petrol',
                //     y: 9.7
                // }]
            }]
        });
        //TURNOS POR SERVICIOS PIE
        var myChartP2 = Highcharts.chart('container2', {
            colors: colores,
            chart: {
                type: 'pie'
            },
            accessibility: {
                point: {
                    valueSuffix: '%'
                }
            },
            title: {
                text: 'Turnos atendidos por servicio',
                align: 'left'
            },
            subtitle: {
                text: 'Cantidad de turnos: ' + TurnosServicioTotal
            },
            
            tooltip: {
                pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>'
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}: {y} %'
                    },
                    showInLegend: true
                }
            },
            series: [{
                name: 'Registrations',
                colorByPoint: true,
                innerSize: '45%',
                data: TurnosServicio
                // [{
                //     name: 'EV',
                //     y: 68.1
                // }, {
                //     name: 'Hybrids',
                //     y: 11.0
                // }, {
                //     name: 'Diesel',
                //     y: 11.2
                // }, {
                //     name: 'Petrol',
                //     y: 9.7
                // }]
            }]
        });
        //TURNOS ATENDIDOS POR HORA DIA
        var myChartP3 = Highcharts.chart('container3', {
            colors: colores,
            title: {
                // text: 'TITULO?',
                text: 'Turnos atendidos por hora del día',
                align: 'left'
            },
        
            
        
            yAxis: {
                title: {
                    text: 'Cantidad de turnos'
                }
            },
        
            xAxis: {
                // accessibility: {
                //     rangeDescription: [1,2,3,4,5,6,7,8,9,10,11]
                // }
                //categories: [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,2]
                categories: TurnosHoraDia.categorias
                // {
                //     rangeDescription: 'Range: 1 to 24',
                // }
            },
        
            legend: {
                layout: 'vertical',
                align: 'right',
                verticalAlign: 'middle'
            },
        
            plotOptions: {
                series: {
                    label: {
                        connectorAllowed: false
                    },
                    pointStart: 0
                }
            },
        
            series: [{
                name: ' ',
                data: TurnosHoraDia.datos
                //[12,1,3,4,54,12,43,16,1,45,6,0,0,0,0,0,0,0,0]
            }],
        
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 500
                    },
                    chartOptions: {
                        legend: {
                            layout: 'horizontal',
                            align: 'center',
                            verticalAlign: 'bottom'
                        }
                    }
                }]
            }
        
        });
        
        //TURNOS ATENDIDOS POR HORA MES
        var myChartP3B = Highcharts.chart('container3B', {
            colors: colores,
            title: {
                // text: 'TITULO?',
                text: 'Turnos atendidos por hora / Mes',
                align: 'left'
            },
        
            yAxis: {
                title: {
                    text: 'Cantidad de turnos'
                }
            },
        
            xAxis: {
                // accessibility: {
                //     rangeDescription: [1,2,3,4,5,6,7,8,9,10,11]
                // }
                //categories: [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,2]
                categories: TurnosHoraMes.categorias
                // {
                //     rangeDescription: 'Range: 1 to 24',
                // }
            },
        
            legend: {
                layout: 'vertical',
                align: 'right',
                verticalAlign: 'middle'
            },
        
            plotOptions: {
                series: {
                    label: {
                        connectorAllowed: false
                    },
                    pointStart: 0
                }
            },
        
            series: [{
                name: ' ',
                data: TurnosHoraMes.datos
                //[12,1,3,4,54,12,43,16,1,45,6,0,0,0,0,0,0,0,0]
            }],
        
            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 500
                    },
                    chartOptions: {
                        legend: {
                            layout: 'horizontal',
                            align: 'center',
                            verticalAlign: 'bottom'
                        }
                    }
                }]
            }
        
        });
        //TURNOS ATENDIDOS POR DIA MES
        var myChartP4 = Highcharts.chart('container4', {
            colors: ["#0072a0"],
            chart: {
                type: 'column'
            },
            title: {
                // text: 'TITULO?',
                text: 'Turnos atendidos por día',
                align: 'left'
            },
            subtitle: {
                text: ' '
            },
            xAxis: {
                categories: TurnosDiaMes.categorias,
                // categories: {
                //     rangeDescription: 'Range: 1 to 31',
                // },
                crosshair: true
            },
            yAxis: {
                min: 0,
                title: {
                    text: 'Cantidad de turnos'
                }
            },
            // tooltip: {
            //     headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            //     pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            //         '<td style="padding:0"><b>{point.y:.1f} mm</b></td></tr>',
            //     footerFormat: '</table>',
            //     shared: true,
            //     useHTML: true
            // },
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },
            series: [{
                name: ' ',
                data: TurnosDiaMes.datos,
                // [49.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4,
                //     194.1, 95.6, 54.4]
            }]
        });
        var myChartP5 = Highcharts.chart('container5', {
            colors: ["#3ee1fa"],
            chart: {
                type: 'column'
            },
        
            title: {
                // text: 'TITULO?',
                text: 'Turnos en cola',
                align: 'left'
            },
        
            xAxis: {
                categories: TurnosEnCola.categorias
                //categories: ['Servicio1', 'Servicio2', 'Servicio3']
            },
        
            yAxis: {
                allowDecimals: false,
                min: 0,
                title: {
                    text: 'Cantidad de turnos'
                }
            },
        
            // tooltip: {
            //     format: '<b>{key}</b><br/>{series.name}: {y}<br/>' +
            //         'Total: {point.stackTotal}'
            // },
        
            plotOptions: {
                column: {
                    stacking: 'normal'
                }
            },
            series: [{
                name: 'Normal',
                data: TurnosEnCola.datos,
                color: "Black",
                stack: 'S1'
            }
            // ,{
            //     name: 'Agendado',
            //     data: [12,0],
            //     color: "Black",
            //     stack: 'S1'
            // }
            ]
        });
        //CAIFICACIONES
        var myChartP6 = Highcharts.chart('container6', {
            
            colors: ["#00b6f7"],
            chart: {
                type: 'column'
            },
            title: {
                // text: 'TITULO?',
                text: 'Calificaciones',
                align: 'left'
            },
            xAxis: {
                categories: Calificaciones.categorias,
                // categories: [
                //     'Excelente',
                //     'Bueno',
                //     'Regular',
                //     'Malo'
                // ],
                crosshair: true
            },
            yAxis: {
                min: 0,
                title: {
                    text: 'Cantidad'
                }
            },
            // tooltip: {
            //     headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            //     pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            //         '<td style="padding:0"><b>{point.y:.1f} mm</b></td></tr>',
            //     footerFormat: '</table>',
            //     shared: true,
            //     useHTML: true
            // },
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },
            series: [{data:Calificaciones.datos}],
            
            // series:[{
            //     data: [
            //      { y: 2, color: "blue" }
            //     ,{ y: 26,  color: "#FF00FF" }
            //     ,{ y: 41.5,color: "#00FF00" }
            //     ,{ y: 100.5,color: "#FF00FF" }
                
            //     ]
            // }]

            // series: [{
            //     name: ' ',
            //     data: Calificaciones.datos
                
            // }]
        });

        document.getElementById("DatoDia").innerHTML =  "<span>" + TurnosDiaSemMes.DIA+ "</span>";
        document.getElementById("DatoSem").innerHTML =  "<span>" + TurnosDiaSemMes.SEM+ "</span>";
        document.getElementById("DatoMes").innerHTML =  "<span>" + TurnosDiaSemMes.MES+ "</span>";
    }

}