angular.module('TurnoMasterV2').controller('dashboardController', dashboardController);
dashboardController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', '$interval'];
function dashboardController($scope, $state, $sessionStorage, servicios, $interval) {
    
    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;
    $scope.servicios = {};
    $scope.colors= ["#540AC1",
    "#37EFEF",
    "#FCD400",
    "#FE4564",
    "#01C3A8",
    "#0002BF",
    "#FF3389",
    "#FF33AC",
    "#AC33FF",
    "#33ACFF"];
    $sessionStorage.MenuSelect = 'dashboard';
    var IdUsuario = $sessionStorage.idusuario;
    $scope.MostrarTurnosAgendado = false;
    $scope.MostrarTurnosCola = true;
    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    CambiarEstadoUsuario();
    function CambiarEstadoUsuario() {
        var datos = {};
        datos = {accion: "CambiarEstadoUsuario", idusuario: IdUsuario, estado: 'DISPONIBLE'};
        servicios.Mando(datos).then(function success(response) {
        });
    }
        
    $scope.obtenerFechaHoraActual = function() {
        var fecha = new Date();
        var diasSemana = ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'];
        var diaSemana = diasSemana[fecha.getDay()];
        var opcionesFecha = { year: 'numeric', month: 'long', day: 'numeric' };
        var opcionesHora = { hour: 'numeric', minute: 'numeric'};
        var fechaFormateada = fecha.toLocaleDateString('es-ES', opcionesFecha);
        // var horaFormateada = fecha.toLocaleTimeString('es-ES', opcionesHora);
        $scope.diaSemana = diaSemana;
        $scope.fechaHoraActual = fechaFormateada;
      };
    
      $scope.obtenerFechaHoraActual();

    CargarTablas();
    function CargarTablas() {
        $scope.usuario = {};
        datos = {accion: "cargarTabla", idusuario: IdUsuario};
        servicios.Dashboard(datos).then(function success(response) {
            $scope.usuario = response.data.respuesta;
            $scope.servicio = response.data.respuestaServicios;
            $scope.ausentes = response.data.turnosausentes;
            $scope.ServiciosCola = response.data.turnosenCOla;
            $scope.usuariosatendidos = response.data.TERMINADOSUsu;
            $scope.calificaciones = response.data.Calificaciones;
           // AnimacionRojoTiempoAsesor($scope.usuario);
           $scope.servicios = {};
           response.data.servicios.forEach(servicio_info => {
                let servicio = servicio_info["Servicio"];
                $scope.servicios[servicio] = {"Cola": 0, "Ausentes": 0, "Terminados": 0};
            });
            response.data.respuestaServicios.forEach(servicio_info => {
                let servicio = servicio_info["Servicio"];
                $scope.servicios[servicio]["Terminados"] += parseInt(servicio_info["Cantidad"]);
            });
            
            response.data.turnosausentes.forEach(servicio_info => {
                let servicio = servicio_info["Servicio"];
                $scope.servicios[servicio]["Ausentes"] += parseInt(servicio_info["Cantidad"]);
            });
            
            response.data.turnosenCOla.forEach(servicio_info => {
                let servicio = servicio_info["Servicio"];
                $scope.servicios[servicio]["Cola"] += parseInt(servicio_info["Cantidad"]);
            });
            for (const key in $scope.servicios) {
                const element = $scope.servicios[key];
                let total = (element.Terminados / (element.Terminados + element.Cola))* 100;
                $scope.servicios[key]['Promedio'] = Math.round(total / 5) * 5;
            }
            let labels = [];
            let data = [];
            
            let count = [];
            response.data.TERMINADOSUsu.forEach(servicio_info => {
                labels.push(servicio_info["NombreUsuario"]);
                count.push(parseInt(servicio_info["Cantidad"]))
                data.push({data:[],name:servicio_info["NombreUsuario"]});
            });
            dataCalificaciones = [];
            response.data.Calificaciones.forEach(servicio_info => {
                dataCalificaciones.push({
                    name: servicio_info["Valor"],
                    y: parseFloat(servicio_info["conteo"])
                });
            });
            data[0]['data'] = count;
            var myChartB = Highcharts.chart('graAsesor', {
                chart: {
                    type: 'bar'
                },
                title: {
                    text: "Turnos atendidos por asesor"
                },
                xAxis: {
                    categories: labels,
                    title: {
                        text: null
                    },
                    gridLineWidth: 1,
                    lineWidth: 0
                },
                legend: {
                    layout: 'horizontal',
                    borderWidth: 1
                },credits: {
                    enabled: false
                },
                colors:['rgba(123, 86, 251, 1)','rgba(123, 86, 251, 0.7)','rgba(123, 90, 251, 0.4)','rgba(123, 86, 251, 1)'],
                yAxis: {
                    title: {
                        text: "Turnos atendidos por asesor"
                    }
                },
                series: data
            });
            var myChartB2 = Highcharts.chart('graCalificaciones', {
                chart: {
                    type: 'pie'
                },
                title: {
                    text: 'Calificaciones'
                },
                tooltip: {
                    valueSuffix: ' Calificacion'
                },
                
                colors:$scope.colors, 
                plotOptions: {
                    series: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: [{
                            enabled: true,
                            distance: 20
                        }, {
                            enabled: true,
                            distance: -40,
                            format: '{point.percentage:.1f}%',
                            style: {
                                fontSize: '1.2em',
                                textOutline: 'none',
                                opacity: 0.7
                            },
                            filter: {
                                operator: '>',
                                property: 'Promedio',
                                value: 10
                            }
                        }]
                    }
                },
                series: [
                    {
                        name: 'Calificaiones',
                        colorByPoint: true,
                        data: dataCalificaciones
                    }
                ]
            });
        });
        if($sessionStorage.MenuSelect == 'dashboard'){
            setTimeout(CargarTablas, 10000);
        }
    }

    $scope.TurnosAgendadosF = function() {
        console.log("aaa");
        $scope.TurnosAgendados = {};
        if($scope.MostrarTurnosCola){
            let datos = {accion: "TurnosAgendados",
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.ServicoNube(datos).then(function success(response) {
                $scope.TurnosAgendados = response.data.respuesta;
                $scope.MostrarTurnosAgendado = true;
                $scope.MostrarTurnosCola = false;
            });
        }else{
            $scope.MostrarTurnosAgendado = false;
            $scope.MostrarTurnosCola = true;
        }
    }
    
    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    console.log(datos[clave].menu_direccion);
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }

    

}