angular.module("TurnoMasterV2").controller("UsuariosController", InitController);
InitController.$inject = ["$scope", "$state", "$sessionStorage", "servicios"];
function InitController($scope, $state, $sessionStorage, servicios) {

  if ($sessionStorage.idusuario === undefined) {
    $state.go("login");
  }else {
    if($sessionStorage.rol == "ASESOR") {
      $state.go("Mando");
    }else if($sessionStorage.rol == "SUPERVISOR"){
      $scope.permisoAdmin = true;
    }
  }

  function validarPermisoSupervisor() {
    if($sessionStorage.rol == "SUPERVISOR"){
      return false;
    }else{
      return true;
    }
  }

  if($sessionStorage.rol == "SUPERVISOR"){
    $scope.MenuNormal = false;
    $scope.MenuSupervisor = true;
    ValidarMenuSupervisor($sessionStorage.idusuario);
  }else{
      $scope.MenuSupervisor = false;
      $scope.MenuNormal = true;
  }

  function comprobarempty(objeto) {
    if (objeto == "" || objeto == undefined) {
        return true;
    } else {
        return false;
    }
  }

  $scope.TipoUsuario = $sessionStorage.rol;
  $scope.NombreUsuario = $sessionStorage.nombreUsuario;
  var IdUsuario = "";
  var idUsuarioEliminar = "";
  $scope.FormularioUsuarios = true;
  $scope.FormularioRolDoctor = false;
  $scope.EstadoAsesores = false;
  $scope.btnconfroles = "Configurar Profesionales";
  $scope.ShowRolMedico = false;
  $scope.ShowTVMedico = false;
  $scope.ShowRolMedicoEditar = false;
  var datos = {};

  llenarTabla();
  function llenarTabla() {
    datos = { 
      accion: "cargarTabla",
      IdSede: $sessionStorage.IdSede,
      emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Usuarios(datos).then(function success(response) {
      $scope.usuario = response.data.respuesta;
      $scope.listatv = response.data.tvs;
    });
  }
  
  $scope.conTriage = true;
  $scope.sinTriage = false;
  datos = { accion: "SaberTriage" };
  servicios.Usuarios(datos).then(function success(response) {
    if (response.data.respuesta == 1) {
      $scope.conTriage = true;
      $scope.sinTriage = false;
    } else {
      $scope.conTriage = false;
      $scope.sinTriage = true;
    }
  });

  //registrar un usuario
  $scope.usu = {};
  $scope.guardarUsuario = function () {
    if(comprobarempty($scope.usu.NombreCompleto) || 
      comprobarempty($scope.usu.Cedula) || 
      comprobarempty($scope.usu.Correo) || 
      comprobarempty($scope.usu.NombreUsuario) || 
      comprobarempty($scope.usu.Contrasena)
    ){
      swal("Atención", "Debe ingresar todos los datos");
    }else{
      if (
        $scope.usu.RolMedico == "" ||
        $scope.usu.RolMedico == undefined ||
        $scope.usu.Rol != "MEDICOGENERAL"
      ) {
        $scope.usu.RolMedico = 0;
        $scope.usu.TVMedico = 0;
      }
      $scope.usu.accion = "guardarUsuario";
      $scope.usu.IdSede = $sessionStorage.IdSede;
      $scope.usu.emp_id = $sessionStorage.IdEmpresa;
      servicios.Usuarios($scope.usu).then(function success(response) {
        if (response.data.respuesta == "Registro Guardado Correctamente") {
          swal("Atención", response.data.respuesta);
          llenarTabla();
          $scope.usu = {};
          $scope.serv = {};
        } else {
          swal("Atención", response.data.respuesta);
        }
        $scope.servicio = response.data.respuesta;
      });
    }
  };
  
  //eliminar un usuario
  $scope.EliminarUsuario = function (IdUsuario, nombreUsuario, opcion,rol) {
    let Validar = true;
    if(rol == "SUPERVISOR" || rol == "ADMINISTRADOR"){
      if(!validarPermisoSupervisor()){
        Validar = false;
        swal("Atención", "No tiene permitido eliminar usuario: " + rol);
      }
    }
    if(Validar){
      $("#eliminarUsuario").modal("show");
      if (opcion == "var") {
        idUsuarioEliminar = IdUsuario;
        $scope.UsuarioEliminar = nombreUsuario;
      }
      //eliminarUsuario
      if (opcion == "Eliminar") {
        datos = {
          accion: "eliminarUsuario",
          IdUsuario: idUsuarioEliminar,
          IdSede: $sessionStorage.IdSede,
          emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Usuarios(datos).then(function success(response) {
          if (response.data.respuesta == "Eliminado") {
            $("#eliminarUsuario").modal("hide");
            swal("Atención", "Usuario Eliminado correctamente");
            llenarTabla();
          }
        });
      }
    }
  };

  //editar un usuario
  $scope.EditarUsuario = function (idusuario) {
    datos = { 
      accion: "TraerDatosEditar",
      IdUsuario: idusuario,
      IdSede: $sessionStorage.IdSede,
      emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Usuarios(datos).then(function success(response) {
      $scope.usuEditar = {
        NombreCompleto: response.data.respuesta[0].NombreCompleto,
        Cedula: response.data.respuesta[0].Cedula,
        Correo: response.data.respuesta[0].Correo,
        Usuario: response.data.respuesta[0].NombreUsuario,
        Rol: response.data.respuesta[0].Rol,
        RolMedico: parseInt(response.data.respuesta[0].IdTipoRol),
        Contrasena: response.data.respuesta[0].Cotrasena,
        IdUsuario: idusuario,
        Telefono: response.data.respuesta[0].Telefono,
        TVMedicoEditar: isNaN(response.data.respuesta[0].LlamadoTv) ? response.data.respuesta[0].LlamadoTv : parseInt(response.data.respuesta[0].LlamadoTv),
      };
      if ($scope.usuEditar.Rol == "MEDICOGENERAL") {
        $scope.ShowRolMedicoEditar = true;
        $scope.ShowTVMedicoEditar = true;
      } else {
        $scope.ShowRolMedicoEditar = false;
        $scope.ShowTVMedicoEditar = false;
      }
    });
  };

  //formulario editar un usuario
  $scope.FormEditarUsuario = function () {
    if (
      $scope.usuEditar.RolMedico == "" ||
      $scope.usuEditar.RolMedico == undefined ||
      $scope.usuEditar.RolMedico == 0 ||
      $scope.usuEditar.Rol != "MEDICOGENERAL"
    ) {
      $scope.usuEditar.RolMedico = 0;
      $scope.usuEditar.TVMedicoEditar = 0;
    }
    $scope.usuEditar.accion = "editarUsuario";
    $scope.usuEditar.IdSede = $sessionStorage.IdSede;
    $scope.usuEditar.emp_id = $sessionStorage.IdEmpresa;
    servicios.Usuarios($scope.usuEditar).then(function success(response) {
      if (response.data.respuesta == "Editado Correctamente") {
        swal("Atención", "Editado Correctamente");
        llenarTabla();
        $("#exampleModal").modal("hide");
      }else{
        swal("Atención", response.data.respuesta);
      }
    });
  };
  
  //boton configuracion de roles
  $scope.ConfigurarRoles = function () {
    if ($scope.FormularioUsuarios == false) {
      $scope.FormularioUsuarios = true;
      $scope.FormularioRolDoctor = false;
      $scope.EstadoAsesores = false;
      $scope.btnconfroles = "Configurar Profesionales";
    } else {
      $scope.FormularioUsuarios = false;
      $scope.FormularioRolDoctor = true;
      $scope.EstadoAsesores = false;
      $scope.btnconfroles = "Atrás";
      llenarTablaRolDoctor();
    }
  };

  //boton configuracion de estados 
  $scope.ConfigurarEstados = function() {
    $scope.FormularioUsuarios = false;
    $scope.FormularioRolDoctor = false;
    $scope.EstadoAsesores = true;
    $scope.btnconfroles = "Atrás";
  }

  //crear roles
  $scope.CrearRolDoctor = function () {
    if ($scope.rolDoctorModel == "" || $scope.rolDoctorModel == undefined) {
      swal("Atención", "Debe ingresar un rol Doctor Valido");
      return;
    }
    datos = {
      accion: "crearRolDoctor",
      rolDoctor: $scope.rolDoctorModel,
      IdSede: $sessionStorage.IdSede,
      emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Usuarios(datos).then(function success(response) {
      llenarTablaRolDoctor();
    });
    $scope.rolDoctorModel = "";
  };

  //traer los roles
  llenarTablaRolDoctor();
  function llenarTablaRolDoctor() {
    let datos = {
      accion: "TraerRolesDoctores",
      IdSede: $sessionStorage.IdSede,
      emp_id: $sessionStorage.IdEmpresa
    }
    servicios.Usuarios(datos).then(function success(response) {
        $scope.rolesDoctores = response.data.roles;
        $scope.rolesMedicorepeat = response.data.roles;
        $scope.rolesMedicorepeatEditar = response.data.roles;
      });
  }

  //eliminar roles
  $scope.EliminarRolDoctor = function (idRolDoctor, NombreRol) {
    swal({
      title: "Esta seguro que desea eliminar el rol: " + NombreRol,
      type: "warning",
      showCancelButton: true,
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Eliminar",
      closeOnConfirm: false
    },
    function () {
      datos = {
        accion: "eliminarRolDoctor",
        idRolDoctor: idRolDoctor,
        IdSede: $sessionStorage.IdSede,
        emp_id: $sessionStorage.IdEmpresa
      };
      servicios.Usuarios(datos).then(function success(response) {
        swal("Atención", "Rol eliminado correctamente");
        llenarTablaRolDoctor();
      });
    });
  };

  $(function () {
    $('[data-toggle="modal"]').tooltip();
  });

  //seleccion del rol medico
  $scope.seleccionarRolMedico = function () {
    if ($scope.usu.Rol == "MEDICOGENERAL") {
      $scope.ShowRolMedico = true;
      $scope.ShowTVMedico = true;
    } else {
      $scope.ShowRolMedico = false;
      $scope.ShowTVMedico = false;
    }
  };

  //traer dato a editar de roles
  var IdRolDoctorEditar = 0;
  $scope.EditarRolDoctor = function (idRol, NombreRol) {
    $scope.rolDocEditarNombre = NombreRol;
    IdRolDoctorEditar = idRol;
  };

  //formulario para editar el rol
  $scope.FormEditarRolDoctor = function () {
    datos = {
      accion: "ediarRolDoctor",
      rolDoctor: $scope.rolDocEditarNombre,
      idRolDoctor: IdRolDoctorEditar,
      IdSede: $sessionStorage.IdSede,
      emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Usuarios(datos).then(function success(response) {
      $("#ModalEditarRolDoctor").modal("hide");
      llenarTablaRolDoctor();
    });
  };

  //cambiar los roles
  $scope.CambiarRolEditarUsuario = function () {
    if ($scope.usuEditar.Rol == "MEDICOGENERAL") {
      $scope.ShowRolMedicoEditar = true;
      $scope.ShowTVMedicoEditar = true;
    } else {
      $scope.ShowRolMedicoEditar = false;
      $scope.ShowTVMedicoEditar = false;
    }
  };
  
  //crear estados
  $scope.CrearEstadoAsesor = function () {
    if ($scope.estadoAsesorModel == "" || $scope.estadoAsesorModel == undefined) {
      swal("Atención", "Debe ingresar un estado Valido");
      return;
    }else{
      if (isNaN($scope.estadoAsesorModel)) {
        datos = {
          accion: "CrearEstadoAsesor",
          estado: $scope.estadoAsesorModel,
          IdSede: $sessionStorage.IdSede,
          emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Usuarios(datos).then(function success(response) {
          if(response.data.respuesta == 'existe'){
            swal("Atención", "El estado ya se encuentra registrado");
          }else{
            swal("Atención", "Estado registrado correctamente");
            llenarTablaEstadoAsesor();
          }
        });
        $scope.estadoAsesorModel = "";
      }else{
        swal("Atención", "El estado no puede ser numérico");
      }
    }
  };

  //llenar tabla estados
  llenarTablaEstadoAsesor();
  function llenarTablaEstadoAsesor() {
    datos = {
      accion: "TraerEstadoAsesores",
      IdSede: $sessionStorage.IdSede,
      emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Usuarios(datos).then(function success(response) {
        $scope.estadoAsesores = response.data.respuesta;
      });
  }
  
  //trear estado a editar
  var IdEstadoAsesorEditar = 0;
  $scope.EditarEstadoAsesor = function (idestado, nombreestado) {
    $scope.estadoEditarNombre = nombreestado;
    IdEstadoAsesorEditar = idestado;
  };

  //formulario editar estados
  $scope.FormEditarEstadoAsesor = function () {
    datos = {
      accion: "ediarEstadoAsesor",
      estadoAsesor: $scope.estadoEditarNombre,
      idEstadoAsesor: IdEstadoAsesorEditar,
      IdSede: $sessionStorage.IdSede,
      emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Usuarios(datos).then(function success(response) {
      $("#ModalEditarEstadoAsesor").modal("hide");
      swal("Atención", "Estado editado correctamente");
      llenarTablaEstadoAsesor();
    });
  };

  ///eliminar estados
  $scope.EliminarEstadoAsesor = function(idestado, nombreestado) {
    swal({
      title: "Esta seguro que desea eliminar el estado: " + nombreestado,
      type: "warning",
      showCancelButton: true,
      confirmButtonClass: "btn-danger",
      confirmButtonText: "Eliminar",
      closeOnConfirm: false
    },
    function () {
        datos = {
          accion: "EliminarEstadoAsesor",
          idestado: idestado,
          IdSede: $sessionStorage.IdSede,
          emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Usuarios(datos).then(function success(response) {
          swal("Atención", "Estado eliminado correctamente");
          llenarTablaEstadoAsesor();
        });
    });
  }
  
  var IdUsusSupervisor = '';
  $scope.AbrirConfigSupervisor = function(idUsu) {
    let Validar = true;
    if(!validarPermisoSupervisor()){
      Validar = false;
      swal("Atención", "No tiene permitido administrar ");
    }
    if(Validar){
      IdUsusSupervisor = idUsu;
        let datos = {
            idUsuario : idUsu,
            accion: "CargarConfigSupervisor",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Usuarios(datos).then(function success(response) {
            $scope.datosMenu = response.data.respuesta;
            $('#ModalConfigSupervisor').modal('show');
        });
    }
        
  }

  $scope.AsignarModuloSupervisor = function(menu_id) {
    let datos = {
        idUsuario : IdUsusSupervisor,
        menu_id : menu_id,
        accion: "AsignarModuloSupervisor",
        IdSede: $sessionStorage.IdSede,
        emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Usuarios(datos).then(function success(response) {
        if(response.data.respuesta == "Bien"){
            swal("Atención", "Módulo asignado correctamente");
            $scope.AbrirConfigSupervisor(IdUsusSupervisor);
        }
    });
  }

  $scope.QuitarModuloSupervisor = function(menu_id) {
    let datos = {
        idUsuario : IdUsusSupervisor,
        menu_id : menu_id,
        accion: "QuitarModuloSupervisor",
        IdSede: $sessionStorage.IdSede,
        emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Usuarios(datos).then(function success(response) {
        if(response.data.respuesta == "Bien"){
            swal("Atención", "Módulo se ha dejado de asignar correctamente");
            $scope.AbrirConfigSupervisor(IdUsusSupervisor);
        }
    });
  }
  
  function ValidarMenuSupervisor(idusuarioAdmin) {
    let datos = {
        accion: "ValidarMenuSupervisor",
        idusuarioAdmin: idusuarioAdmin
    };
    servicios.Dashboard(datos).then(function success(response) {
        let datos = response.data.respuesta;
        let claves = Object.keys(datos);
        for(let i=0; i< claves.length; i++){
            let clave = claves[i];
            if(datos[clave].control == '1' ){
                switch (datos[clave].menu_direccion) {                        
                    case "Usuarios":
                        datos[clave].stilo = "estiloselecUsuarios";
                        datos[clave].icono = "fas fa-user";
                        break;
                    case "Modulo":
                        datos[clave].stilo = "estiloselecModulo";
                        datos[clave].icono = "fa fa-user-md";
                        break;
                    case "Servicios":
                        datos[clave].stilo = "estiloselecServicio";
                        datos[clave].icono = "fas fa-users";
                        break;
                    case "AsigServicios":
                        datos[clave].stilo = "estiloselecAsingServicio";
                        datos[clave].icono = "fa fa-user-plus";
                        break;
                    case "ConfigTurnosPerdidos":
                        datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                        datos[clave].icono = "fas fa-cogs";
                        break;
                    case "Graficos":
                        datos[clave].stilo = "estiloselecGraficos";
                        datos[clave].icono = "fas fa-chart-area";
                        break;
                    case "Reportes":
                        datos[clave].stilo = "estiloselecReportes";
                        datos[clave].icono = "fas fa-file-invoice";
                        break;
                    case "ConfigTv":
                        datos[clave].stilo = "estiloselecConfigTv";
                        datos[clave].icono = "fa fa-desktop";
                        break;
                    case "Pacientes":
                        datos[clave].stilo = "estiloselecPacientes";
                        datos[clave].icono = "fa fa-user";
                        break;
                    case "Preguntas":
                        datos[clave].stilo = "estiloselecPreguntas";
                        datos[clave].icono = "fa fa-question-circle";
                        break;
                    case "HoraAgenda":
                        datos[clave].stilo = "estiloselecHoraAgenda";
                        datos[clave].icono = "fa fa-book";
                        break;
                    case "ConfigAtril":
                        datos[clave].stilo = "estiloselecConfigAtril";
                        datos[clave].icono = "fa fa-cog";
                        break;
                  }
            }
        }
        $scope.direcciones = datos;
    });
  }
}