angular.module('TurnoMasterV2').controller('ServiciosController', InitController);
InitController.$inject = ['$scope','$state','$sessionStorage','$localStorage','servicios','Upload'];
function InitController($scope,$state,$sessionStorage,$localStorage,servicios,$Upload) {

    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;
    
    $scope.ServicioParaCita = false;

    var ipservidor;

    trearipservidor();
    function trearipservidor() {
        datos = { accion: "trearipservidor" };
        servicios.ConfigTv(datos).then(function success(response) {
            ipservidor = response.data.respuesta;
        });
    }
    
    function comprobarempty(objeto) {
        if (objeto == "" || objeto == undefined) {
            return true;
        } else {
            return false;
        }
    }

    function convertirHora(str) {
        var month, day, year, hours, minutes, seconds;
        var date = new Date(str),
        month = ("0" + (date.getMonth() + 1)).slice(-2),
        day = ("0" + date.getDate()).slice(-2);
        hours = ("0" + date.getHours()).slice(-2);
        minutes = ("0" + date.getMinutes()).slice(-2);
        seconds = ("0" + date.getSeconds()).slice(-2);
        var mySQLDate = [date.getFullYear(), month, day].join("-");
        var mySQLTime = [hours, minutes, seconds].join(":");
        return [mySQLTime].join(" ");
    }

    function tiene_numeros(texto) {
        var numeros = "0123456789.-/!·$%&/()=?¿+`´Ç¨^`+_:-.;|@#~€¬| ";
        for (i = 0; i < texto.length; i++) {
            if (numeros.indexOf(texto.charAt(i), 0) != -1) {
                return true;
            }
        }
        return false;
    }

    var idServicioEliminar = 0;
    
    $scope.serv = {};
    $scope.servEditar = {};
    $scope.MostrarAlerta = false;
    $scope.serv.AtencionCita = false;
    $scope.serv.Entrega = false;
    var  cantidadTvs = 0;

    llenarTabla();
    function llenarTabla() {
        datos = {
            accion: "cargarTabla",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Servicios(datos).then(function success(response) {
            $scope.servicio = response.data.respuesta;
            $scope.listatv = response.data.tvs;
            cantidadTvs = response.data.Cantidadtvs;
            $localStorage.CantidadDeTvs = "";
            $localStorage.CantidadDeTvs = response.data.tvs;
        });
    }

    $scope.ActivarTiempoCita = function(control) {
        if(control){
            let activarTiempo = document.getElementById('ActivarTiempoCita').checked;
            if(activarTiempo){
                $scope.ServicioParaCita = true;
            }else{
                $scope.ServicioParaCita = false;
            }
        }else{
            let activarTiempo = document.getElementById('EditActivarTiempoCita').checked;
            if(activarTiempo){
                $scope.ServicioParaCita = true;
            }else{
                $scope.ServicioParaCita = false;
            }
        }
    }

    $scope.guardarServicio = function () {
        let Tvs = "";
        let tvsViusal = $localStorage.CantidadDeTvs;
        tvsViusal = Object.values(tvsViusal);
        for (let i = 0; i < tvsViusal.length; i++) {
            var isChecked = document.getElementById('customCheck'+tvsViusal[i].estado).checked;
            if(isChecked){
                Tvs += ','+tvsViusal[i].estado;
            }
        }
        let validacion = 0;
        if(($scope.serv.HoraInicio == '' || $scope.serv.HoraInicio == undefined) || ($scope.serv.HoraFin == '' || $scope.serv.HoraFin == undefined) ){
            swal("Atención", "Debe seleccionar una hora de inicio y una hora final para el servicio");
            return;
        }else{
            validacion = 1;
        }
        if($scope.serv.HoraInicio > $scope.serv.HoraFin){
            swal("Atención", "La hora de inicio no puede ser mayor a la hora final");
            return;
        }else{
            validacion = 1;
        }
        if(Tvs == ""){
            swal("Atención", "Debe Seleccionar minimo 1 visualizador");
            return;
        }else{
            validacion = 1;
        }
        if (comprobarempty($scope.serv.atril)) {
            swal("Atención", "Debe Seleccionar un Atril");
            return;
        }else{
            validacion = 1;
        }
        if ($scope.serv.ConteoMaximo.length > 3) {
            swal("Atención", "El Conteo Maximo no puede ser mayor a 999");
            return;
        }else{
            validacion = 1;
        }
        if ($scope.serv.ConteoMinimo.length > 3) {
            swal("Atención", "El Conteo Minimo no puede ser mayor a 999");
            return;
        }else{
            validacion = 1;
        }
        if ($scope.serv.ConteoMinimo > $scope.serv.ConteoMaximo) {
            swal("Atención", "El Conteo Minimo debe de ser minimo al Contemo Maximo");
            return;
        }else{
            validacion = 1;
        }
        if (tiene_numeros($scope.serv.Prefijo)) {
            swal("Atención", "El Prefijo solo puede contener Letras");
            return;
        }else{
            validacion = 1;
        }

        if(validacion == 1){
            $scope.serv.accion = "guardarServicio";
            $scope.serv.Prefijo = $scope.serv.Prefijo.toUpperCase();
            $scope.serv.nombreServicio = $scope.serv.nombreServicio.toUpperCase();
            $scope.serv.Secuencia = 0;
            $scope.serv.IdSede = $sessionStorage.IdSede;
            $scope.serv.emp_id = $sessionStorage.IdEmpresa;
            let horainicio = convertirHora($scope.serv.HoraInicio);
            let horafin = convertirHora($scope.serv.HoraFin);
            $scope.serv.HoraInicio = horainicio;
            $scope.serv.HoraFin = horafin;
            $scope.serv.tv = Tvs;
            servicios.Servicios($scope.serv).then(function success(response) {
                if (response.data.respuesta == "Registro Guardado Correctamente") {
                    swal("Atención", response.data.respuesta);
                    llenarTabla();
                    $scope.serv = {};
                    $scope.ServicioParaCita = false;
                } else {
                    swal("Atención", response.data.respuesta);                
                }
                $scope.servicio = response.data.respuesta;
            });
        }
    }

    $scope.EliminarServicio = function (idservicio, nombreServicio, opcion) {
        if (opcion == "var") {
            idServicioEliminar = idservicio;
            $scope.ServicioEliminar = nombreServicio;
        }
        if (opcion == "Eliminar") {
            datos = {
                accion: "EliminarServicio",
                IdServicio: idServicioEliminar,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Servicios(datos).then(function success(response) {
                if (response.data.respuesta == "Eliminado") {
                    $('#eliminarServicio').modal('hide');
                    llenarTabla();
                }else{
                    swal("Alerta", response.data.respuesta);
                }
            });
        }
    }
    
    $scope.EditarServicio = function (idservicio) {
        $scope.ServicioParaCita = false;
        for (let i = 1; i <= cantidadTvs; i++) {
            document.getElementById('customCheckEdit'+i).checked = false;
        }
        datos = { 
            accion: "TraerDatosEditar", 
            IdServicio: idservicio,
            IdSede: $sessionStorage.IdSede, 
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Servicios(datos).then(function success(response) {
            $scope.servEditar = {
                IdServicio: response.data.respuesta[0].IdServicio,
                Servicio: response.data.respuesta[0].Servicio,
                Prefijo: response.data.respuesta[0].Prefijo,
                Cmin: response.data.respuesta[0].Cont_min,
                Cmax: response.data.respuesta[0].Cont_max,
                Secuencia: response.data.respuesta[0].Secuencia,
                prioridad: response.data.respuesta[0].Prioridad,
                Atril: response.data.respuesta[0].atril,
                Visible: response.data.respuesta[0].VisibleDispe,
                tiempoMax: parseInt(response.data.respuesta[0].tiempoMax),
                nivel: response.data.respuesta[0].EstadoSub,
                AtencionCita: (response.data.respuesta[0].atencioncita == 1) ? true : false,
                Entrega: (response.data.respuesta[0].entrega == 1) ? true : false,
                HoraInicio: response.data.respuesta[0].HoraInicio,
                HoraFin: response.data.respuesta[0].HoraFin,
                TiempoCita: parseInt(response.data.intervalocita)
            };
            if($scope.servEditar.AtencionCita){
                $scope.ServicioParaCita = true;
            }
            let tvs = response.data.respuesta[0].LlamadoTv.split(',');
            for (let i = 1; i < tvs.length; i++) {
                document.getElementById('customCheckEdit'+tvs[i]).checked = true;
            }
            $('#exampleModal').modal('show');
        });
    }

    $scope.FormEditarServicio = function () {
        let Tvs = "";
        let tvsViusal = $localStorage.CantidadDeTvs;
        tvsViusal = Object.values(tvsViusal)
        for (let i = 0; i < tvsViusal.length; i++) {
            var isChecked = document.getElementById('customCheckEdit'+tvsViusal[i].estado).checked;
            if(isChecked){
                Tvs += ','+tvsViusal[i].estado;
            }
        }
        $scope.servEditar.tv = Tvs;
        $scope.servEditar.IdSede = $sessionStorage.IdSede;
        $scope.servEditar.emp_id = $sessionStorage.IdEmpresa;
        $scope.servEditar.accion = "editarServicio";
        if(!comprobarempty($scope.servEditar.HoraInicio2)){
            let horainicio = convertirHora($scope.servEditar.HoraInicio2);
            $scope.servEditar.HoraInicio2 = horainicio;
        }
        if(!comprobarempty($scope.servEditar.HoraFin2)){
            let horafin = convertirHora($scope.servEditar.HoraFin2);
            $scope.servEditar.HoraFin2 = horafin;
        }
        servicios.Servicios($scope.servEditar).then(function success(response) {

            if (response.data.respuesta == "Editado Correctamente") {
                for (let i = 0; i < tvsViusal.length; i++) {
                    document.getElementById('customCheckEdit'+tvsViusal[i].estado).checked = false;
                }
                swal("Atención", response.data.respuesta);
                llenarTabla();
                $scope.ServicioParaCita = false;
                $('#exampleModal').modal('hide');
            }
            else {
                swal("Atención", response.data.respuesta);
                $('#exampleModal').modal('hide');
            }
        });
    }

    $scope.EliminarTurnoEspera = function (IdServicio, Servicio, opcion) {
        if (opcion == "var") {
            idServicioEliminar = IdServicio;
            $scope.ServicioEliminar = Servicio;
            datos = {
                accion: "TraerTurnosEspera",
                IdServicio: idServicioEliminar,
                IdSede: $sessionStorage.IdSede, 
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Servicios(datos).then(function success(response) {
                $scope.numTurnosEspera = response.data.respuesta;
            });
        }
        if (opcion == "Eliminar") {
            datos = {
                accion: "EliminarTurnoEspera",
                IdServicio: idServicioEliminar,
                IdSede: $sessionStorage.IdSede, 
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Servicios(datos).then(function success(response) {
                if (response.data.respuesta == "Eliminado") {
                    $('#EliminarTurnosEspera').modal('hide');
                    llenarTabla();
                }
            });
        }
    }
    
    $scope.irRelacion = function () {
        $state.go('SubServicios');
    }

    var IdServicoImg;
    $scope.ModalSubirImgServ = function(IdServicio) {
        IdServicoImg = IdServicio;
        $('#ModalSubirImgServ').modal('show');

    }

    $scope.cargarImagen = function (file) {
        trearipservidor();
        let UrlPahtName = window.location.pathname;
        ruta = 'http://' + ipservidor + UrlPahtName + 'app/model';
        $Upload.upload({
            url: ruta + '/EnviarImagenIDR.php?IdServicio='+IdServicoImg, data: {file: file},
        }).then(function success(response) {
            if (response.data.accion == "hecho") {
                $('#ModalSubirImgServ').modal('hide');
            }
        }, function (resp) {

        }, function (evt) {
        });
    }


    $scope.eliminarImagenServicio = function (file) {
        datos = {
            accion: "eliminarImagenServicio",
            IdServicio: IdServicoImg,
            IdSede: $sessionStorage.IdSede, 
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Servicios(datos).then(function success(response) {
            ///
            if(response.data == 'Existe'){
                swal("Atención", "Eliminado correctamente");
            }else{
                swal("Atención", "No existe archivo para eliminar");
            }
        });
    }



    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}