angular.module('TurnoMasterV2').controller('ReportesController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', 'urlBase', '$http'];
function InitController($scope, $state, $sessionStorage, servicios, $urlBase, $http) {
    $scope.isLoading = false;
    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }


    if ($sessionStorage.idusuario === undefined) {
        $state.go('login');
    } else {
        if ($sessionStorage.rol == "ASESOR") {
            $state.go('Mando');
        }
    }

    var DatosReportes = [];
    $scope.showcalificaciones = false;
    
    $scope.check = function (posicion,stringdatos) {
        check = document.getElementById("check");
        if (document.getElementById("check"+posicion).checked == true) {
            if(posicion == '1'){
                document.getElementById('check2').checked = false;
                document.getElementById('check3').disabled = true;
                document.getElementById('check3').checked = false;
                document.getElementById('check4').disabled = true;
                document.getElementById('check4').checked = false;
                document.getElementById('check5').disabled = true;
                document.getElementById('check5').checked = false;
                DatosReportes = ['cliente'];

            }else if(posicion == '2'){
                document.getElementById('check1').checked = false;
                document.getElementById('check3').disabled = true;
                document.getElementById('check3').checked = false;
                document.getElementById('check4').disabled = true;
                document.getElementById('check4').checked = false;
                document.getElementById('check5').disabled = true;
                document.getElementById('check5').checked = false;
                DatosReportes = ['asesor'];

            }else{
                DatosReportes.push(stringdatos);
            }
        }else{
            document.getElementById('check3').disabled = false;
            document.getElementById('check4').disabled = false;
            document.getElementById('check5').disabled = false;
            DatosReportes = DatosReportes.filter((item) => item !== stringdatos)
        }
    }

    function secondsToString(seconds) {
        var hour = Math.floor(seconds / 3600);
        hour = (hour < 10)? '0' + hour : hour;
        var minute = Math.floor((seconds / 60) % 60);
        minute = (minute < 10)? '0' + minute : minute;
        var second = seconds % 60;
        second = (second < 10)? '0' + second : second;
        return hour + ':' + minute + ':' + second;
    }

    $scope.TipoUsuario = $sessionStorage.rol;
    var ip = "";
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;
    var datos = {};

    $scope.serviciosRepTriage = false;
    $scope.usuariosRepTriage = false;
    $scope.checkboxModelUsuarioTriage = false;
    $scope.checkboxModelServicioTriage = false;
    $scope.checkboxModelUsuario = false;
    $scope.usuariosRep = false;
    $scope.checkboxModelServicio = false;
    $scope.serviciosRep = false;
    $scope.descargarReporteExcel = false;
    $scope.MostrarDescarga = false;
    var idusuarios = [];

    datos = {accion: 'DatosEmpresa'};
    servicios.ModuloReportes(datos).then(function success(response) {
        $scope.NombreEmpresa = response.data.respuesta[0].NombreEmpresa;
        $scope.NIT = response.data.respuesta[0].nit;
    });

    datos = {accion: 'traerip'};
    servicios.ModuloReportes(datos).then(function success(response) {
        ip = response.data.respuesta;
    });

    $scope.DescargarPDF = function (ContenidoID, nombre) {
        var pdf = new jsPDF('p', 'pt', 'letter');
        html = $('#' + ContenidoID).html();
        specialElementHandlers = {};
        margins = {top: 10, bottom: 20, left: 20, width: 522};
        pdf.fromHTML(html, margins.left, margins.top, {'width': margins.width}, function (dispose) {
        pdf.save(nombre + '.pdf');
        }, margins);
    }

    $scope.DescargarEXCEL = function () {
        location.href = "http://" + ip + "" + $urlBase + "reportes.php";
    }

    $scope.SacarReporte = function (opcion) {
        $scope.isLoading = true;
        document.getElementById("tablas").innerHTML = '';
        $scope.showcalificaciones = false;
        $scope.DescargaReporteEstados = false;
        if ($scope.fechaFinal == undefined || $scope.fechaInicial == undefined) {
            swal("Atención", "Debe de seleccionar un rango de fechas para el reporte");
            $scope.isLoading = false;
            return;
        } else if ($scope.checkboxModelUsuario == true && $scope.checkboxModelServicio == false) {
            if ($scope.UsuarioReporte == undefined) {
                swal("Atención", "Debe seleccionar un Usuario para generar el Reporte");
                $scope.isLoading = false;
                return;
            }
            $('#GenerandoReporte').modal('hide');
                $http.get("app/model/PhpReportes/reportesExcelSoloUsuario.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&idusuario=" + $scope.UsuarioReporte + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede+"&DatosReportes="+DatosReportes).then(function (response) {
                    if (response.data.respuesta == "Enviado Correctamente") {
                        if(response.data.CountAtendidos == '0'){
                            swal("Atención", "No hay turnos en estas fechas");
                            $scope.isLoading = false;
                        }else{
                            document.getElementById("tablas").innerHTML = '';
                            $scope.showbuscarcliente = false;
                            $('#modalDescarga').modal('show');
                            $('#GenerandoReporte').modal('hide');
                            $scope.showbuscarcliente = false;
                            $scope.showbuscarAsesor = false;
                            $scope.showtablafechas = false;
                            $scope.showtablahoras = false;
                            $scope.MostrarDescarga = true;
                            $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                            $scope.descargarReporteExcel = true;
                            $scope.showcantidad = true;
                            $scope.showdatos = true;
                            $scope.Atendidos = response.data.CountAtendidos;
                            $scope.Ausentes = response.data.CountAusentes;
                            $scope.Transferidos = response.data.CountTransferidos;
                            $scope.Turnos = response.data.CountTurnos;
                            $scope.DatosG = response.data.DatosG;
                            $scope.titulos = Object.keys(response.data.DatosG[0]);
                        }
                        $scope.isLoading = false;
                    }
                });
        } else if ($scope.checkboxModelUsuario == false && $scope.checkboxModelServicio == true) {
            if ($scope.servicioReporte == undefined || $scope.servicioReporte == "") {
                swal("Atención", "Debe seleccionar un Servicio para generar el Reporte");
                $scope.isLoading = false;
                return;
            }
            $('#GenerandoReporte').modal('hide');
                $http.get("app/model/PhpReportes/reportesExcelSoloServicio.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&idservicio=" + $scope.servicioReporte + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede+"&DatosReportes="+DatosReportes).then(function (response) {
                        if (response.data.respuesta == "Enviado Correctamente") {
                            if(response.data.CountAtendidos == '0'){
                                swal("Atención", "No hay turnos en estas fechas");
                            }else{
                                document.getElementById("tablas").innerHTML = '';
                                $('#modalDescarga').modal('show');
                                $('#GenerandoReporte').modal('hide');
                                $scope.showbuscarcliente = false;
                                $scope.showbuscarAsesor = false;
                                $scope.showtablafechas = false;
                                $scope.showtablahoras = false;
                                $scope.MostrarDescarga = true;
                                $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                                $scope.descargarReporteExcel = true;                           
                                $scope.showcantidad = true;
                                $scope.showdatos = true;
                                $scope.Atendidos = response.data.CountAtendidos;
                                $scope.Ausentes = response.data.CountAusentes;
                                $scope.Transferidos = response.data.CountTransferidos;
                                $scope.Turnos = response.data.CountTurnos;
                                $scope.DatosG = response.data.DatosG;
                                $scope.titulos = Object.keys(response.data.DatosG[0]);
                            }
                            $scope.isLoading = false;
                        }
                });
        } else if ($scope.checkboxModelUsuario == true && $scope.checkboxModelServicio == true) {
            if ($scope.UsuarioReporte == undefined || $scope.servicioReporte == undefined) {
                swal("Atención", "Debe seleccionar un Usuario o Servicio para generar el Reporte");
                $scope.isLoading = false;
                return;
            }
            $('#GenerandoReporte').modal('hide');
                $http.get("app/model/PhpReportes/reportesExcelServicioYUsuario.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&idservicio=" + $scope.servicioReporte + "&idusuario=" + $scope.UsuarioReporte + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede+"&DatosReportes="+DatosReportes).then(function (response) {
                        if (response.data.respuesta == "Enviado Correctamente") {
                            if(response.data.CountAtendidos == '0'){
                                swal("Atención", "No hay turnos en estas fechas");
                            }else{
                                document.getElementById("tablas").innerHTML = '';
                                $('#modalDescarga').modal('show');
                                $('#GenerandoReporte').modal('hide');
                                $scope.MostrarDescarga = true;
                                $scope.showbuscarcliente = false;
                                $scope.showbuscarAsesor = false;
                                $scope.showtablafechas = false;
                                $scope.showtablahoras = false;
                                $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                                $scope.descargarReporteExcel = true;
                                $scope.showcantidad = true;
                                $scope.showdatos = true;
                                $scope.Atendidos = response.data.CountAtendidos;
                                $scope.Ausentes = response.data.CountAusentes;
                                $scope.Transferidos = response.data.CountTransferidos;
                                $scope.Turnos = response.data.CountTurnos;
                                $scope.DatosG = response.data.DatosG;
                                $scope.titulos = Object.keys(response.data.DatosG[0]);
                            }
                            $scope.isLoading = false;
                        }
                        
                });
        } else if ($scope.checkboxModelUsuario == false && $scope.checkboxModelServicio == false) {
            if (opcion == 'servicio') { 
                if(DatosReportes.length > 0){
                    if(DatosReportes.includes('cliente')){
                        $scope.showbuscarAsesor = false;
                        $scope.showcantidad = false;
                        $scope.showdatos = false;
                        datos = {
                            accion: 'traerClientesConsultar',
                            fechai: convertDatePickerTimeToMySQLTime($scope.fechaInicial),
                            fechaf: convertDatePickerTimeToMySQLTime($scope.fechaFinal)
                        };
                        servicios.ModuloReportes(datos).then(function success(response) {
                            if(response.data.respuesta == '0'){
                                swal("Atención", "No hay turnos en estas fechas");
                                $scope.isLoading = false;
                            }else{
                                document.getElementById("tablas").innerHTML = '';
                                $('#modalDescarga').modal('show');
                                $scope.showbuscarcliente = true;
                                $scope.showbuscarAsesor = false;
                                $scope.showtablafechas = false;
                                $scope.showtablahoras = false;
                                $scope.pacientes = response.data.respuesta;
                                $scope.clienteseleccionado = function (idpaciente){
                                    $http.get("app/model/PhpReportes/reportesExcelGeneralDatosReportes.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede+"&clientes="+idpaciente+"&DatosReportes="+DatosReportes).then(function (response) {
                                        $scope.MostrarDescarga = true;
                                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                                        $scope.descargarReporteExcel = true;
                                        $scope.showdatos = true;
                                        $scope.showcantidad = true;
                                        $scope.showtablafechas = false;
                                        $scope.showtablahoras = false;
                                        $scope.Atendidos = response.data.CountAtendidos;
                                        $scope.Ausentes = response.data.CountAusentes;
                                        $scope.Transferidos = response.data.CountTransferidos;
                                        $scope.Turnos = response.data.CountTurnos;
                                        $scope.DatosG = response.data.DatosG;
                                        $scope.titulos = Object.keys(response.data.DatosG[0]);
                                        $scope.isLoading = false;
                                    });
                                }
                            }
                        });
                    }else if(DatosReportes.includes('asesor')){
                        $scope.showbuscarcliente = false;
                        $scope.showtablafechas = false;
                        $scope.showtablahoras = false;
                        $scope.showcantidad = false;
                        $scope.showdatos = false;
                        $scope.showbuscarcliente = false;
                        datos = {
                            accion: 'traerAsesorConsultar',
                            fechai: convertDatePickerTimeToMySQLTime($scope.fechaInicial),
                            fechaf: convertDatePickerTimeToMySQLTime($scope.fechaFinal)
                        };
                        servicios.ModuloReportes(datos).then(function success(response) {
                            if(response.data.respuesta == '0'){
                                swal("Atención", "No hay turnos en estas fechas");
                                $scope.isLoading = false;
                            }else{
                                document.getElementById("tablas").innerHTML = '';
                                $('#modalDescarga').modal('show');
                                $scope.showbuscarAsesor = true;
                                $scope.Usuarios = response.data.respuesta;
                                var datos = response.data.respuesta;
                                for (let i = 0; i < Object.keys(datos).length; i++) {
                                    idusuarios[i] = datos[i]['IdUsuario'];
                                }
                                $scope.asesorseleccionado = function (idAsesor,rol){
                                    $http.get("app/model/PhpReportes/reportesExcelGeneralDatosReportes.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede+"&asesor="+idAsesor+"&rol="+rol+"&DatosReportes="+DatosReportes).then(function (response) {
                                        $scope.MostrarDescarga = true;
                                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                                        $scope.descargarReporteExcel = true;
                                        $scope.showdatos = true;
                                        $scope.showcantidad = true;
                                        $scope.showtablafechas = false;
                                        $scope.showtablahoras = false;
                                        $scope.Atendidos = response.data.CountAtendidos;
                                        $scope.Ausentes = response.data.CountAusentes;
                                        $scope.Transferidos = response.data.CountTransferidos;
                                        $scope.Turnos = response.data.CountTurnos;
                                        $scope.DatosG = response.data.DatosG;
                                        $scope.titulos = Object.keys(response.data.DatosG[0]);
                                        $scope.isLoading = false;
                                    });
                                }
                            }
                        });
                    }else{
                        $('#GenerandoReporte').modal('hide');
                        $http.get("app/model/PhpReportes/reportesExcelGeneralDatosReportes.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede+"&DatosReportes="+DatosReportes).then(function (response) {
                            if (response.data.respuesta == "Enviado Correctamente") {
                                if(DatosReportes.includes('fechas')){
                                    if(response.data.CountAtendidos == '0'){
                                        swal("Atención", "No hay turnos en estas fechas");
                                        $scope.isLoading = false;
                                    }else{
                                    document.getElementById("tablas").innerHTML = '';
                                    $scope.showtablafechas = true;
                                    $scope.showtablahoras = true;
                                    $scope.showdatos = true;                                                                   
                                    $('#modalDescarga').modal('show');
                                    $scope.showbuscarcliente = false;
                                    $scope.showbuscarAsesor = false;
                                    $scope.showcantidad = true;
                                    $scope.MostrarDescarga = true;
                                    $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                                    $scope.descargarReporteExcel = true;
                                    $scope.Atendidos = response.data.CountAtendidos;
                                    $scope.Ausentes = response.data.CountAusentes;
                                    $scope.Transferidos = response.data.CountTransferidos;
                                    $scope.Turnos = response.data.CountTurnos;
                                    $scope.DatosG = response.data.DatosG;
                                    $scope.titulos = Object.keys(response.data.DatosG[0]);
                                    $scope.tablaFechas = response.data.Fechas;
                                    $scope.titulosFechas = Object.keys(response.data.Fechas[0]);
                                    $scope.tablaHoras = response.data.horas;
                                    $scope.titulosHora = Object.keys(response.data.horas[0]);
                                    $scope.isLoading = false;
                                    }
                                }else{
                                    if(response.data.CountAtendidos == '0'){
                                        swal("Atención", "No hay turnos en estas fechas");
                                        $scope.isLoading = false;
                                    }else{
                                        document.getElementById("tablas").innerHTML = '';
                                        $('#GenerandoReporte').modal('hide');
                                        $('#modalDescarga').modal('show');
                                        $scope.showtablafechas = false;
                                        $scope.showtablahoras = false;
                                        $scope.showbuscarcliente = false;
                                        $scope.showbuscarAsesor = false;
                                        $scope.MostrarDescarga = true;
                                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                                        $scope.descargarReporteExcel = true;
                                        $scope.showcantidad = true;
                                        $scope.showdatos = true;
                                        $scope.Atendidos = response.data.CountAtendidos;
                                        $scope.Ausentes = response.data.CountAusentes;
                                        $scope.Transferidos = response.data.CountTransferidos;
                                        $scope.Turnos = response.data.CountTurnos;
                                        $scope.DatosG = response.data.DatosG;
                                        $scope.titulos = Object.keys(response.data.DatosG[0]);
                                        $scope.isLoading = false;
                                    }
                                }
                            }
                        });
                    }
                    
                }else{
                    $http.get("app/model/PhpReportes/reportesExcelGeneral.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&idservicio=" + $scope.servicioReporte + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede+"&DatosReportes="+DatosReportes).then(function (response) {
                        if (response.data.respuesta == "Enviado Correctamente") {
                            if(response.data.CountAtendidos == '0'){
                                swal("Atención", "No hay turnos en estas fechas");
                                $scope.isLoading = false;
                            }else{
                                document.getElementById("tablas").innerHTML = '';
                                $('#modalDescarga').modal('show');
                                $('#GenerandoReporte').modal('hide');
                                $scope.showtablafechas = false;
                                $scope.showtablahoras = false;
                                $scope.showbuscarcliente = false;
                                $scope.showbuscarAsesor = false;
                                $scope.MostrarDescarga = true;
                                $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                                $scope.descargarReporteExcel = true;                           
                                $scope.showcantidad = true;
                                $scope.showdatos = true;
                                $scope.Atendidos = response.data.CountAtendidos;
                                $scope.Ausentes = response.data.CountAusentes;
                                $scope.Transferidos = response.data.CountTransferidos;
                                $scope.Turnos = response.data.CountTurnos;
                                $scope.DatosG = response.data.DatosG;
                                $scope.titulos = Object.keys(response.data.DatosG[0]);
                                $scope.isLoading = false;
                            }
                        }
                    });
                }
            } else if (opcion == 'estadoasesores') {
                $('#GenerandoReporte').modal('hide');
                $http.get("app/model/PhpReportes/reportesExcelEstadoAsesor.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede).then(function (response) {
                    if (response.data.respuesta == "Enviado Correctamente") {
                        $scope.showtablafechas = false;
                        $scope.showtablahoras = false;
                        $scope.showcantidad = false;
                        $scope.showdatos = false;
                        $scope.showbuscarcliente = false;
                        $scope.showbuscarAsesor = false;
                        $('#GenerandoReporte').modal('hide');
                        $('#modalDescarga').modal('show');
                        $scope.MostrarDescarga = true;
                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/ReporteEstados.xlsx";
                        $scope.descargarReporteExcel = true;
                        $scope.DescargaReporteEstados = true;
                        var usuarios =  response.data.datos;
                        console.log(usuarios);
                        //var titulos = Object.keys(response.data.datos[0]);
                        //titulos.shift();
                        //var datcant = Object.keys(response.data.datos[0]["estado"]);
                        //var datosest = response.data.datos;<td>`+datosest[i]["fecha"][k]+`</td>
                        if(response.data.datos){
                            var html = '';
                            document.getElementById("tablas").innerHTML = '';
                            for (let i = 0; i < Object.keys(usuarios).length; i++) {
                                html +=
                                `<div style ='width: 44%;margin-left: 28%;'>
                                    <h5 class="modal-title " style="color: gray; font-weight: bold;">`+usuarios[i]["NombreCompleto"]+`</h5><br>
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>`;
                                                for (let j = 0; j < Object.keys(usuarios[i]['Fecha']).length; j++) {
                                                    html+= `
                                                        
                                                            <th scope="col" style= "width: 100%; border: none; font-size: 15px;
                                                            color: gray;">Fecha:&nbsp;&nbsp;&nbsp;&nbsp;`+usuarios[i]['Fecha'][j]+`</th>
                                                            <tr class="titleTr">
                                                                <th class="td">Estado</th>
                                                                <th class="td">Tiempo</th>
                                                            </tr>`;

                                                    for (let k = 0; k <  Object.keys(usuarios[i]["FechaTiempos"][j]).length; k++) {
                                                        html+=`<tr>
                                                            <td class="th" style="font-size: 15px; color: gray;">`+usuarios[i]["FechaTiempos"][j][k]["Titulo"]+`</td>
                                                            <td class="th" style="font-size: 15px; color: gray;">`+secondsToString(usuarios[i]["FechaTiempos"][j][k]["Tiempo"])+`</td>
                                                        </tr>`;
                                                    }
                                                }
                                            html+=`</tr>
                                        </thead>
                                        <tbody>`;
                                        html +=`</tbody>
                                    </table>
                                </div>`;
                            }
                            document.getElementById("tablas").innerHTML = html;
                            $scope.isLoading = false;
                        }
                    }
                });
            }
        }
    }

    $scope.SacarReporteTriage = function (opcion) {
        $scope.DescargaReporteEstados = false;
        $scope.showcalificaciones = false;
        if ($scope.fechaFinalTriage == undefined || $scope.fechaInicialTriage == undefined) {
            swal("Atención", "Debe seleccionar un rango de fechas para el reporte");
            return;
        } else if ($scope.checkboxModelUsuarioTriage == true && $scope.checkboxModelServicioTriage == false) {
            if ($scope.UsuarioReporteTriage == undefined) {
                swal("Atención", "Debe seleccionar un Usuario para generar el Reporte");
                return;
            }
            $http.get("app/model/PhpReportes/reportesExcelSoloUsuarioTriage.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinalTriage) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicialTriage) + "&idusuario=" + $scope.UsuarioReporteTriage+"&DatosReportes="+DatosReportes).then(function (response) {
                    if (response.data.respuesta == "Enviado Correctamente") {
                        $('#modalDescarga').modal('show');
                        $scope.MostrarDescarga = true;
                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                        $scope.descargarReporteExcel = true;
                    }
                });
        } else if ($scope.checkboxModelUsuarioTriage == false && $scope.checkboxModelServicioTriage == true) {
            if ($scope.servicioReporteTriage == undefined || $scope.servicioReporteTriage == "") {
                swal("Atención", "Debe seleccionar un Servicio para generar el Reporte");
                return;
            }
            $http.get("app/model/PhpReportes/reportesExcelSoloServicioTriage.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinalTriage) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicialTriage) + "&idservicio=" + $scope.servicioReporteTriage)
                .then(function (response) {
                    if (response.data.respuesta == "Enviado Correctamente") {
                        $('#modalDescarga').modal('show');
                        $scope.MostrarDescarga = true;
                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                        $scope.descargarReporteExcel = true;
                    }
                });
        } else if ($scope.checkboxModelUsuarioTriage == true && $scope.checkboxModelServicioTriage == true) {
            if ($scope.UsuarioReporteTriage == undefined || $scope.servicioReporteTriage == undefined) {
                swal("Atención", "Debe seleccionar un Usuario o Servicio para generar el Reporte");
                return;
            }
            $http.get("app/model/PhpReportes/reportesExcelServicioYUsuarioTriage.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinalTriage) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicialTriage) + "&idservicio=" + $scope.servicioReporteTriage + "&idusuario=" + $scope.UsuarioReporteTriage)
                .then(function (response) {
                    if (response.data.respuesta == "Enviado Correctamente") {
                        $('#modalDescarga').modal('show');
                        $scope.MostrarDescarga = true;
                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                        $scope.descargarReporteExcel = true;
                    }
                });
        } else if ($scope.checkboxModelUsuarioTriage == false && $scope.checkboxModelServicioTriage == false) {
            $http.get("app/model/PhpReportes/reportesExcelGeneralTriage.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinalTriage) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicialTriage) + "")
                .then(function (response) {
                    if (response.data.respuesta == "Enviado Correctamente") {
                        $('#modalDescarga').modal('show');
                        $scope.MostrarDescarga = true;
                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                        $scope.descargarReporteExcel = true;
                    }
                });
        }
    }

    $scope.SacarReportePDF = function () {
        $scope.DescargaReporteEstados = false;
        $scope.showcalificaciones = false;
        var accionReporte = "";
        if ($scope.fechaFinal == undefined || $scope.fechaInicial == undefined) {
            swal("Atención", "Debe de seleccionar un rango de fechas para el reporte");
            return;
        } else if ($scope.checkboxModelUsuario == true && $scope.checkboxModelServicio == false) {
            if ($scope.UsuarioReporte == undefined) {
                swal("Atención", "Debe seleccionar un Usuario para generar el Reporte");
                return;
            }
            window.open("http://" + ip + "" + $urlBase +
                    "generarReportePDF.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) +
                    "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) +
                    "&accion=SoloUsuario&idusuario=" + $scope.UsuarioReporte);
        } else if ($scope.checkboxModelUsuario == false && $scope.checkboxModelServicio == true) {
            if ($scope.servicioReporte == undefined || $scope.servicioReporte == "") {
                swal("Atención", "Debe seleccionar un Servicio para generar el Reporte");
                return;
            }
            window.open("http://" + ip + "" + $urlBase +
                    "PhpReportes/generarReportePDF.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) +
                    "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) +
                    "&accion=SoloServicio&idServicio=" + $scope.servicioReporte);
        } else if ($scope.checkboxModelUsuario == true && $scope.checkboxModelServicio == true) {
            if ($scope.UsuarioReporte == undefined || $scope.servicioReporte == undefined) {
                swal("Atención", "Debe seleccionar un Usuario o Servicio para generar el Reporte");
                return;
            }
            window.open("http://" + ip + "" + $urlBase +
                    "PhpReportes/generarReportePDF.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) +
                    "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) +
                    "&accion=ServicioYUsuario&idServicio=" + $scope.servicioReporte + "&idusuario=" + $scope.UsuarioReporte);
        } else if ($scope.checkboxModelUsuario == false && $scope.checkboxModelServicio == false) {
            window.open("http://" + ip + "" + $urlBase + "generarReportePDF.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&accion=general");
        }
    }

    $scope.CambiarCheckUsuarios = function () {
        if ($scope.checkboxModelUsuario) {
            $scope.usuariosRep = true;
        } else {
            $scope.usuariosRep = false;
        }
    }

    $scope.CambiarCheckServicios = function () {
        if ($scope.checkboxModelServicio) {
            $scope.serviciosRep = true;
        } else {
            $scope.serviciosRep = false;
        }
    }

    $scope.CambiarCheckUsuariosTriage = function () {
        if ($scope.checkboxModelUsuarioTriage) {
            $scope.usuariosRepTriage = true;
        } else {
            $scope.usuariosRepTriage = false;
        }
    }

    $scope.CambiarCheckServiciosTriage = function () {
        if ($scope.checkboxModelServicioTriage) {
            $scope.serviciosRepTriage = true;
        } else {
            $scope.serviciosRepTriage = false;
        }
    }

    function convertDatePickerTimeToMySQLTime(str) {
        var month, day, year, hours, minutes, seconds;
        var date = new Date(str),
        month = ("0" + (date.getMonth() + 1)).slice(-2),
        day = ("0" + date.getDate()).slice(-2);
        hours = ("0" + date.getHours()).slice(-2);
        minutes = ("0" + date.getMinutes()).slice(-2);
        seconds = ("0" + date.getSeconds()).slice(-2);
        var mySQLDate = [date.getFullYear(), month, day].join("-");
        //var mySQLTime = [hours, minutes, seconds].join(":");
        //return [mySQLDate, mySQLTime].join(" ");
        return mySQLDate;
    }

    //
    datos = {
        accion: 'cargarServiciosReport',
        IdSede: $sessionStorage.IdSede,
        emp_id: $sessionStorage.IdEmpresa
    };
    servicios.Servicios(datos).then(function success(response) {
        $scope.servicios = response.data.respuesta;
    });

    datos = {accion: 'cargarServiciosTriage'};
    servicios.ModuloReportes(datos).then(function success(response) {
        $scope.serviciosTriage = response.data.respuesta;
    });

    datos = {accion: 'traerUsuariosConsultar'};
    servicios.ModuloReportes(datos).then(function success(response) {
        $scope.usuarios = response.data.respuesta;
        $scope.usuariosTriage = response.data.respuestatriage;
    });

    $scope.SacarReporteCalificaciones = function () {
        $scope.showbuscarcliente = false;
        $scope.showbuscarAsesor = false;
        $scope.showtablafechas = false;
        $scope.showtablahoras = false;
        $scope.showcalificaciones = false;
        $scope.MostrarDescarga = false;
        $scope.DescargaReporteEstados = false;
        if ($scope.fechaFinal == undefined || $scope.fechaInicial == undefined) {
            swal("Atención", "Debe seleccionar un rango de fechas para el reporte");
            return;
        }
        if ($scope.checkboxModelUsuario == true) {
            if ($scope.UsuarioReporte == undefined) {
                swal("Atención", "Debe seleccionar un Usuario para generar el Reporte");
                return;
            } else {
                $http.get("app/model/reporteIndividualCalif.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&idusuario=" + $scope.UsuarioReporte + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede)
                    .then(function (response) {
                        if (response.data.respuesta == "Enviado Correctamente") {
                            $('#modalDescarga').modal('show');
                            $scope.MostrarDescarga = true;
                            $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                            $scope.descargarReporteExcel = true;
                        }
                    });
            }
        } else {
            $http.get("app/model/reporteGeneralCalif.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) + "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede).then(function (response) {
                    if (response.data.respuesta == "Enviado Correctamente") {
                        document.getElementById("tablas").innerHTML = '';
                        $scope.showcantidad = false;
                        $scope.showdatos = false;
                        $scope.showcalificaciones = true;
                        $('#modalDescarga').modal('show');
                        $scope.MostrarDescarga = true;
                        $scope.linkdescarga = "http://" + ip + "" + $urlBase + "reportes/Reporte.xlsx";
                        $scope.descargarReporteExcel = true;
                        $scope.CalificacionesTabla = response.data.detalle;
                    }
                });
        }
    }

    $scope.SacarReportePDFCalificaciones = function () {
        $scope.showcalificaciones = false;
        var accionReporte = "";
        if ($scope.fechaFinal == undefined || $scope.fechaInicial == undefined) {
            swal("Atención", "Debe seleccionar un rango de fechas para el reporte");
            return;
        } else if ($scope.checkboxModelUsuario == true) {
            if ($scope.UsuarioReporte == undefined) {
                swal("Atención", "Debe seleccionar un Usuario para generar el Reporte");
                return;
            } else {
                window.open("http://" + ip + "" + $urlBase +
                        "generarReportePDF.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) +
                        "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) +
                        "&accion=CalifUsuario&idusuario=" + $scope.UsuarioReporte + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede);
            }

        } else if ($scope.checkboxModelUsuario == false) {
            window.open("http://" + ip + "" + $urlBase +
                    "generarReportePDF.php?fechafinal=" + convertDatePickerTimeToMySQLTime($scope.fechaFinal) +
                    "&fechaInicial=" + convertDatePickerTimeToMySQLTime($scope.fechaInicial) +
                    "&accion=CalifGeneral" + "&IdEmpresa="+ $sessionStorage.IdEmpresa + "&IdSede="+$sessionStorage.IdSede);
        }
    }
    
    $scope.correo_r = {};
    $scope.CorreoRemitente = function() {
        $scope.correo_r.accion = "CorreoRemitente";
        servicios.Dashboard($scope.correo_r).then(function success(response) {
            if(response.data.respuesta == 'Bien'){
                $scope.correo_r.correo = response.data.correo;
                $scope.correo_r.contrasena = response.data.contrasena;
                swal("Atención", "Datos guardados correctamente");
            }else{
                swal("Atención", "Error al guardar los datos");
            }
        });
    }

    TraerCorreoRemitente();
    function TraerCorreoRemitente() {
        datos = {
            accion: "TraerCorreoRemitente"
        }
        servicios.Dashboard(datos).then(function success(response) {
            if(response.data.respuesta == 'Bien'){
                $scope.correo_r.correo = response.data.correo;
                $scope.correo_r.contrasena = response.data.contrasena;
            }else{
            }
        });
    }

    CargarCorreosDestino();
    function CargarCorreosDestino() {
        datos = {
            accion: 'CargarCorreosDestino'
        }
        servicios.Dashboard(datos).then(function success(response) {
            if(response.data.respuesta == 'Bien'){
                $scope.correos = response.data.correos;
            }
        });
    }
    
    $scope.tituloBotonRegistro = 'Registrar';
    idDestinoEditar = '';
    $scope.correo_d = {};   
    $scope.CorreoDestino = function() {
        $scope.correo_d.accion = "CorreoDestino";
        if(idDestinoEditar != ''){
            datos = {
                accion: 'EditarCorreoDestino',
                correo: $scope.correo_d.correo,
                id: idDestinoEditar
            }
            servicios.Dashboard(datos).then(function success(response) {
                if(response.data.respuesta == 'Bien'){
                    swal("Atención", "Correo editado correctamente");
                    $scope.correo_d = {};
                    CargarCorreosDestino();
                    $scope.tituloBotonRegistro = 'Registrar';
                }
            });
        }else{
            servicios.Dashboard($scope.correo_d).then(function success(response) {
                if(response.data.respuesta == 'Bien'){
                    CargarCorreosDestino();
                    idDestinoEditar = '';
                    $scope.tituloBotonRegistro = 'Registrar';
                    $scope.correo_d = {};
                }
            });
        }
        
    }

    $scope.EditarCorreoDestino = function(id,correo) {
        idDestinoEditar = id;
        $scope.correo_d.correo = correo;
        $scope.tituloBotonRegistro = 'Editar';
    }

    $scope.EliminarCorreoDestino = function(id,correo) {
        swal({
                title: "Desea eliminar el correo ? " + correo,
                text: "",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Eliminar",
                closeOnConfirm: false
            },
            function () {
                datos = {
                    accion: "EliminarCorreoDestino",
                    id: id
                };
                servicios.Dashboard(datos).then(function success(response) {
                    if(response.data.respuesta == 'Bien'){
                        swal("Atención", "Correo eliminado correctamente");
                        CargarCorreosDestino();
                        idDestinoEditar = '';
                        $scope.tituloBotonRegistro = 'Registrar';
                    }
                });
            });    
    }

    $scope.ReporteProgramadoo = function() {
        datos = {
            accion: "reporteProgramado"
        };
        servicios.ReporteProgramadoo(datos).then(function success(response) {
        });
    }

    $scope.correo_destino = '';
    $scope.EnviarCorreoPrueba = function() {
        if($scope.correo_destino == '' || $scope.correo_destino == undefined ){
        }else{
            datos = {
                accion: "EnviarPrueba",
                correo_destino: $scope.correo_destino
            };
            servicios.ReporteProgramadoo(datos).then(function success(response) {
            });
        }
    }
    
    $scope.llenartablapacientes = function () {
        datos = {
            accion: "cargarTabla",
            Cedula: $scope.Cedula,
            fechai: convertDatePickerTimeToMySQLTime($scope.fechaInicial),
            fechaf: convertDatePickerTimeToMySQLTime($scope.fechaFinal)
        };
        servicios.ModuloReportes(datos).then(function success(response) {
            if (response.data.tablausu == "nada") {
                $scope.pacientes = {};
            } else {
                $scope.pacientes = response.data.tablausu;
            }
        });
    }

    $scope.llenartablaAsesores = function () {
        datos = {
            accion: "cargarTablaAsesores",
            Cedula: $scope.Cedula,
            idusuarios : idusuarios,
            fechai: convertDatePickerTimeToMySQLTime($scope.fechaInicial),
            fechaf: convertDatePickerTimeToMySQLTime($scope.fechaFinal)
        };
        servicios.ModuloReportes(datos).then(function success(response) {
            if (response.data.tablausu == "nada") {
                $scope.Usuarios = {};
            } else {
                $scope.Usuarios = response.data.tablausu;
            }
        });
    }

    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
           
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            console.log(datos);
            for(let i=0; i< claves.length; i++){
                //
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    
                    console.log(datos[clave].menu_direccion);
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
    
}