angular.module('TurnoMasterV2').controller('PreguntasController', PreguntasController);
PreguntasController.$inject = ['$scope', '$state', '$localStorage', 'servicios', '$sessionStorage'];
function PreguntasController($scope, $state, $localStorage, servicios, $sessionStorage) {

    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }


    if ($localStorage.idusuarioAdmin != undefined && $sessionStorage.estado != undefined) {
        if ($localStorage.rol == "ASESOR" && $sessionStorage.estado == "Asesor") {
            $state.go('Mando');
        } else if ($localStorage.rol == "ADMINISTRADOR" && $sessionStorage.estado == "Admin") {
            $state.go('dashboard');
        }
    }
    
    $scope.TipoUsuario = $sessionStorage.rol;
    llenarTabla();

    function llenarTabla() {
        datos = {
            accion: "cargarTabla",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Preguntas(datos).then(function success(response) {
            $scope.modulo = response.data.respuesta;
        });
    }

    $scope.GuardarPregunta = function () {
        if ($scope.NModulo == "" || $scope.NModulo == undefined) {
            swal("Atención", "Llenar el campo obligatorio");
            return;
        }
        datos = {
            accion: "GuardarPregunta",
            pregunta: $scope.NModulo,
            IdSede : $sessionStorage.IdSede, 
            emp_id : $sessionStorage.IdEmpresa
        };
        servicios.Preguntas(datos).then(function success(response) {
            $scope.NModulo = "";
            llenarTabla();
        });
    }

    $scope.EliminarPregunta = function (Idpregunta, nombrepregunta, opcion) {
        if (opcion == "var") {
            idPreguntaEliminar = Idpregunta;
            $scope.PreguntaEliminar = nombrepregunta;
        }
        if (opcion == "Eliminar") {
            datos = { 
                accion: "EliminarPregunta",
                Idpregunta: idPreguntaEliminar,
                IdSede : $sessionStorage.IdSede, 
                emp_id : $sessionStorage.IdEmpresa
            };
            servicios.Preguntas(datos).then(function success(response) {
                $("#eliminarpregunta").modal("hide");
                swal("Atención", "Eliminado Correctamente");
                llenarTabla();
            });
        }
    };
    
    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
           
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            console.log(datos);
            for(let i=0; i< claves.length; i++){
                //
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    
                    console.log(datos[clave].menu_direccion);
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}
