angular.module('TurnoMasterV2').controller('PacientesController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', 'urlBase', '$http', 'Upload'];

function InitController($scope, $state, $sessionStorage, servicios, $urlBase, $http, $Upload) {

    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    function convertDatePickerTimeToMySQLTime(str) {
        var month, day, year, hours, minutes, seconds;
        var date = new Date(str),
                month = ("0" + (date.getMonth() + 1)).slice(-2),
                day = ("0" + date.getDate()).slice(-2);
        // hours = ("0" + date.getHours()).slice(-2);
        // minutes = ("0" + date.getMinutes()).slice(-2);
        // seconds = ("0" + date.getSeconds()).slice(-2);

        var mySQLDate = [date.getFullYear(), month, day].join("-");
        // var mySQLTime = [hours, minutes, seconds].join(":");
        // return [mySQLDate, mySQLTime].join(" ");
        return [mySQLDate].join(" ");
    }

    function comprobarempty(objeto) {
        if (objeto == "" || objeto == undefined) {
            return true;
        } else {
            return false;
        }
    }

    $scope.PanelPacientes = true;
    $scope.PanelEPS = false;


    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;

    $scope.serv = {};
    $scope.servEditar = {};
    $scope.MostrarAlerta = false;

    var ip = "";
    datos = {
        accion: 'traerip',
        IdSede: $sessionStorage.IdSede,
        emp_id: $sessionStorage.IdEmpresa
    };

    servicios.Pacientes(datos).then(function success(response) {
        ip = response.data.respuesta;
    });


    $scope.ExportarExcelPaciente = function () {
        $http.get("app/model/FormatoExcelPersonas.php?emp_id="+$sessionStorage.IdEmpresa+"&IdSede="+$sessionStorage.IdSede)
            .then(function (response) {
                if (response.data.respuesta == "Enviado Correctamente") {
                    $('#modalDescarga').modal('show');
                    $scope.MostrarDescarga = true;
                    $scope.linkdescargaPersonas = "http://" + ip + "" + $urlBase + "Formatos/Formato.xlsx";
                    $scope.descargarReporteExcel = true;
                }
            });
    }

    CargarDatos();
    function CargarDatos() {
        datos = {
            accion: "CargarClientes",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Pacientes(datos).then(function success(response) {
            $scope.mando = response.data.respuesta;
        });
    }

    $scope.llenartablapacientes = function () {
        datos = {
            accion: "cargarTabla",
            Cedula: $scope.Cedula,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Pacientes(datos).then(function success(response) {
            if (response.data.tablausu == "nada") {
                $scope.mando = {};
            } else {
                $scope.mando = response.data.tablausu;
            }
        });
    }

    var fecha;
    $scope.CapturarFecha = function () {
        fecha = $scope.FechaNacimiento;
    }

    $scope.guardarPacientes = function () {
        console.log($scope.usuInsertar);
        if(comprobarempty($scope.usuInsertar.Cedula) ||
            comprobarempty($scope.usuInsertar.NombreCompleto)
            // comprobarempty($scope.usuInsertar.EPS)
        ){
            swal("Atención","Los campos Nombre, # de identificación y eps son obligatorios");
        }else{
            $scope.FechaNacimiento = "";
            $scope.usuInsertar.Fecha = fecha;
            $scope.usuInsertar.accion = "guardarPersona";
            $scope.usuInsertar.IdSede = $sessionStorage.IdSede;
            $scope.usuInsertar.emp_id = $sessionStorage.IdEmpresa;
            servicios.Pacientes($scope.usuInsertar).then(function success(response) {
                if (response.data.respuesta == "Registro Guardado Correctamente") {
                    swal("Atención", response.data.respuesta);
                    $scope.usuInsertar = {};
                    CargarDatos();
                } else {
                    swal("Atención", response.data.respuesta);
                }
            });
        };
    }

    $scope.cerrarAlerta = function () {
        $scope.MostrarAlerta = false;
    }

    $scope.FormEditarPersonaAdmin = function () {
        if(comprobarempty($scope.usuEditarPer.Cedula) ||
            comprobarempty($scope.usuEditarPer.NombreCompleto) || 
            comprobarempty($scope.usuEditarPer.EPS)
        ){
            swal("Atención","Los campos Nombre, # de identificación y eps son obligatorios");
        }else{
            $scope.usuEditarPer.accion = "editarPersona";
            $scope.usuEditarPer.IdSede = $sessionStorage.IdSede;
            $scope.usuEditarPer.emp_id = $sessionStorage.IdEmpresa;
            servicios.Pacientes($scope.usuEditarPer).then(function success(response) {
                if (response.data.respuesta == "Editado Correctamente") {
                    $('#EditarModal').modal('hide');
                    CargarDatos();
                }
            });
        }
    }

    $scope.EditarPesonaAdmin = function (idpersona2) {
        datos = {
            accion: "TraerDatosEditar",
            IdPersona: idpersona2,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Pacientes(datos).then(function success(response) {
            $scope.usuEditarPer = {
                idPersona: response.data.respuesta[0].IdPersona,
                NombreCompleto: response.data.respuesta[0].NombreCompleto,
                Cedula: response.data.respuesta[0].Cedula,
                Sexo: response.data.respuesta[0].Sexo,
                Direccion: response.data.respuesta[0].Direccion,
                Barrio: response.data.respuesta[0].Barrio,
                Telefono: response.data.respuesta[0].Telefono,
                Fecha: response.data.respuesta[0].FechaNacimiento,
                EPS: parseInt(response.data.respuesta[0].EPS)
            };
        });
    }

    var idPersonaEliminar = "";
    $scope.EliminarPersona = function (Idpersona, nombreUsuario, opcion) {
        if (opcion == "var") {
            idPersonaEliminar = Idpersona;
            $scope.UsuarioEliminar = nombreUsuario;
        }
        if (opcion == "Eliminar") {
            datos = {
                accion: "eliminarPaciente",
                IdPersona: idPersonaEliminar,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Pacientes(datos).then(function success(response) {
                if (response.data.respuesta == "Eliminado") {
                    $('#eliminarCita').modal('hide');
                    $scope.mando = {};
                    CargarDatos();
                }
            });
        }
    }

    $scope.abrirModalCargarExcelPaciente = function () {
        $('#modalCarga').modal('show');
    }

    $scope.cargarArchivoPaciente = function (file) {
        let UrlPahtName = window.location.pathname;
        $Upload.upload({
            url: 'http://' + ip + UrlPahtName +'app/model/EnviarArchivoImportar.php?opcion=Pacientes',
            data: {
                file: file
            },
        }).then(function success(response) {
            if (response.data.accion == "error") {
                swal("Atención", response.data.motivo);
                return;
            } else if (response.data.accion == "hecho") {
                $http.get("http://" + ip + UrlPahtName +"app/model/ImportarPacientes.php?IdSede="+$sessionStorage.IdSede+"&emp_id="+$sessionStorage.IdEmpresa).then(function (response) {
                    $('#modalCarga').modal('hide');
                    swal("Atención", "Pacientes Cargados Correctamente");
                    CargarDatos();
                });
            }
        }, function (resp) {
            swal("Atención", "Se presento algun error en la cargada del archivo");
        }, function (evt) {
                
        });
    }

    $scope.ConfigurarEPSPacientes = function(){
        $scope.PanelPacientes ? $scope.PanelPacientes = false : $scope.PanelPacientes = true;
        $scope.PanelEPS ? $scope.PanelEPS = false : $scope.PanelEPS = true;

    }

    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }

   
    $scope.CargarEPS = function(){
        let datos = {
            accion: "CargarEPS",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Pacientes(datos).then(function success(response) {
            $scope.EPSList = response.data.respuesta;
            console.log($scope.EPSList);
        });
    }

    $scope.CargarEPS();

    $scope.CrearEPS = function(){
        if(comprobarempty($scope.NombreEPS)){
            swal("Atención", "Debe digitar el nombre de la EPS");
        }else{
            let datos = {
                accion: "CrearEPS",
                EPS: $scope.NombreEPS,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Pacientes(datos).then(function success(response) {
                if (response.data.respuesta == "Existe") {
                    swal("Atención", "La EPS a ingresar ya existe");
                }else if(response.data.respuesta == "Error"){
                    swal("Atención", "Se ha presentado un error");
                }else{
                    swal("Atención", "EPS registrada correctamente");
                    $scope.NombreEPS = '';
                    $scope.CargarEPS();
                }
            });
        }
    }

    $scope.EPSEditar = {};
    $scope.EditarEPS = function(IdEps){
        let datos = {
            accion: "EditarEPS",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa,
            IdEps: IdEps
        };
        servicios.Pacientes(datos).then(function success(response) {
            let dato = response.data.respuesta;
            $scope.EPSEditar = {
                nombre: dato[0].nombre_eps,
                IdEps: dato[0].id_eps,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            $('#ModalEditarEPS').modal('show');
        });
    }

    $scope.FormEditarEPS = function(){
        if(comprobarempty($scope.EPSEditar.nombre)){
            swal("Atención", "Debe digitar el nombre de la EPS");
        }else{
            $scope.EPSEditar.accion = "FormEditarEPS";
            servicios.Pacientes($scope.EPSEditar).then(function success(response) {
                if (response.data.respuesta == "Existe") {
                    swal("Atención", "La EPS a ingresar ya existe");
                }else if(response.data.respuesta == "Error"){
                    swal("Atención", "Se ha presentado un error");
                }else{
                    swal("Atención", "EPS editada correctamente");
                    $scope.EPSEditar = {};
                    $scope.CargarEPS();
                    $('#ModalEditarEPS').modal('hide');
                }
            });
        }
    }

    $scope.EliminarEPS = function(IdEps,nombreEPS) {
        swal({
          title: "Esta seguro que desea eliminar la EPS: " + nombreEPS,
          type: "warning",
          showCancelButton: true,
          confirmButtonClass: "btn-danger",
          confirmButtonText: "Eliminar",
          closeOnConfirm: false
        },
        function () {
            datos = {
                accion: "EliminarEPS",
                IdEps: IdEps,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Pacientes(datos).then(function success(response) {
                swal("Atención", "EPS eliminada correctamente");
                $scope.CargarEPS();
            });
        });
    }


    $scope.AbrirEntrega = function() {
        $('#ModalEntrega').modal('show');  
    }

    $scope.ExportarExcelEntrega = function () {
        $http.get("app/model/FormatoExcelEntrega.php?emp_id="+$sessionStorage.IdEmpresa+"&IdSede="+$sessionStorage.IdSede)
            .then(function (response) {
                if (response.data.respuesta == "Enviado Correctamente") {
                    $('#modalDescarga').modal('show');
                    $scope.MostrarDescarga = true;
                    $scope.linkdescargaPersonas = "http://" + ip + "" + $urlBase + "Formatos/FormatoEntrega.xlsx";
                    $scope.descargarReporteExcel = true;
                }
            });
    }
    
    $scope.abrirModalCargarExcelEntrega = function () {
        $('#modalCargaEntrega').modal('show');
    }

    $scope.cargarArchivoEntrega = function (file) {
        let UrlPahtName = window.location.pathname;
        $Upload.upload({
            url: 'http://' + ip + UrlPahtName +'app/model/EnviarArchivoImportar.php?opcion=Entrega',
            data: {
                file: file
            },
        }).then(function success(response) {
            if (response.data.accion == "error") {
                swal("Atención", response.data.motivo);
                return;
            } else if (response.data.accion == "hecho") {
                $http.get("http://" + ip + UrlPahtName +"app/model/ImportarEntrega.php?IdSede="+$sessionStorage.IdSede+"&emp_id="+$sessionStorage.IdEmpresa).then(function (response) {
                    $('#modalCargaEntrega').modal('hide');
                    swal("Atención", "Entregas Cargadas Correctamente");
                    CargarDatos();
                });
            }
        }, function (resp) {
            swal("Atención", "Se presento algun error en la cargada del archivo");
        }, function (evt) {
                
        });
    }

    $scope.entrega = {};
    $scope.CrearEntregaManual = function() {
        console.log($scope.entrega);
        if(comprobarempty($scope.entrega.cedula) || comprobarempty($scope.entrega.fecha)){
            swal("Atención", "Se debe ingresar la Cédula y fecha limite");
        }else{
            $scope.entrega.accion = "CrearEntregaManual";
            $scope.entrega.IdSede = $sessionStorage.IdSede;
            $scope.entrega.emp_id = $sessionStorage.IdEmpresa;
            $scope.entrega.fecha = convertDatePickerTimeToMySQLTime($scope.entrega.fecha);
            servicios.Pacientes($scope.entrega).then(function success(response) {
               
                if (response.data.respuesta == "Bien") {
                    $scope.entrega = {};
                    swal("Atención", "Entrega registrada correctamente");
                }//else if(response.data.respuesta == "Error"){
                //     swal("Atención", "Se ha presentado un error");
                // }else{
                //     swal("Atención", "EPS registrada correctamente");
                //     $scope.NombreEPS = '';
                //     $scope.CargarEPS();
                // }
            });
        }
    }

}