angular.module('TurnoMasterV2').controller('ModuloController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios'];

function InitController($scope, $state, $sessionStorage, servicios) {

    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    $scope.NModulo == "";
    var idModuloEliminar = 0;
    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.MostrarAlerta = false;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;

    llenarTabla();
    function llenarTabla() {
        datos = {
            accion: "cargarTabla",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Modulo(datos).then(function success(response) {           
            $scope.modulo = response.data.modulos;
        });
    }

    $scope.guardarModulo = function () {
        if ($scope.NModulo == "" || $scope.NModulo == undefined) {
            swal("Atención", "Por favor ingrese un numero de Modulo para guardar");            
        } else {
            datos = {
                accion: "guardarModulo",
                numModulo: $scope.NModulo,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Modulo(datos).then(function success(response) {
                if (response.data.respuesta == "El Modulo se ha guardado Correctamente") {
                    swal("Atención", "El Modulo se ha guardado Correctamente");
                    $scope.NModulo = "";
                    llenarTabla();
                } else {
                    swal("Atención", response.data.respuesta);
                }
            });
        }
    }

    $scope.cerrarAlerta = function () {
        $scope.MostrarAlerta = false;
    }

    $scope.EliminarModulo = function (Id, opcion,IdModulo) {
        if (opcion == "var") {
            idModuloEliminar = Id;
            $scope.moduloEliminar = IdModulo;
        }
        if (opcion == "Eliminar") {
            datos = {
                accion: "eliminarModulo",
                numModulo: idModuloEliminar,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Modulo(datos).then(function success(response) {
                if (response.data.respuesta == "Eliminado") {
                    $('#exampleModal').modal('hide');
                    llenarTabla();
                    swal("Atención", "Módulo eliminado correctamente");
                }
            });
        }
    }
    
    var IdModuloEditar;
    $scope.EditarModulo = function (IdModulo, opcion) {
        if (opcion == "var") {
            IdModuloEditar = IdModulo;
            datos = {
                accion: "traerModuloEditar",
                Id: IdModulo,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Modulo(datos).then(function success(response) {
                if (response.data.respuesta != "Error") {
                    $scope.EditModulo = response.data.respuesta;
                    $('#editarModulo').modal('show');
                }
            });
        }else if (opcion == "Editar") {
            datos = {
                accion: "EditarModulo",
                numModulo: $scope.EditModuloNuevo,
                Id: IdModuloEditar,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Modulo(datos).then(function success(response) {
                if (response.data.respuesta == "Editado") {
                    $('#editarModulo').modal('hide');
                    llenarTabla();
                    swal("Atención", "Módulo editado correctamente");
                }
            });
        }
    }
    
    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            console.log(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}