angular.module('TurnoMasterV2').controller('MandoDoctorGeneralController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', '$interval', '$window'];

function InitController($scope, $state, $sessionStorage, servicios, $interval, $window) {

    if ($sessionStorage.idusuario === undefined) {
        $state.go('login');
    } else {
        if ($sessionStorage.rol == "ADMINISTRADOR") {
            $state.go('dashboard');
        }
    }

    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    })


    function secondsToString(seconds) {
        var hour = Math.floor(seconds / 3600);
        hour = (hour < 10)? '0' + hour : hour;
        var minute = Math.floor((seconds / 60) % 60);
        minute = (minute < 10)? '0' + minute : minute;
        var second = seconds % 60;
        second = (second < 10)? '0' + second : second;
        return minute + ':' + second;
    }

    $scope.rolUsuario = $sessionStorage.rol;
    $scope.tablaMando = false;
    $scope.numModulo = $sessionStorage.modulo;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;

    CambiarEstadoUsuario();
    function CambiarEstadoUsuario() {
        datos = {
            accion: "CambiarEstadoUsuario",
            idusuario: IdUsuario,
            estado: 'DISPONIBLE',
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos);
    }

    var datos = {};
    var TurnoActual = {};
    var TurnoActual2 = {};
    var IdUsuario = $sessionStorage.idusuario;
    var limite = 0;
    var IdPersonaAtendida = 0;
    var idEncuestaGlobal = 0;
    var idPersonaGlobal = 0;
    var SinTurnos = "no hay";
    var transfereciaPor = "";
    var idusuarioTransferencia = "";
    var PacienteActual = {};

    $scope.ShowTerminarTurno = false;
    $scope.ShowObservaciones = false;
    $scope.ShowRepetirLlamado = false;
    $scope.ShowEditarEncuesta = false;
    $scope.ShowConfirmarTurno = false;
    $scope.ShowDisponible = true;
    $scope.TransServicio = false;
    $scope.TransUsuario = false;
    $scope.botonesTransferir = true;
    $scope.minRecorridos = "00:00";
    $scope.minMax = "00:00";
    var IntervalTiempoMax;
    var ObservacionObligatoria = "No";
    var habilitarCalificador = false;

    $interval(function () {
        reportarUsuario();
    }, 60000);

    function reportarUsuario() {
        datos = {
            accion: "ReportarUsuario",
            idusuario: IdUsuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos);
    }

    function reiniciarTiempo() {
        $interval.cancel(IntervalTiempoMax);
        $scope.minRecorridos = "00:00";
        $scope.minMax = "00:00";
        $scope.claseColorMinMax = "minMaxGris";
        ObservacionObligatoria = "No";
    }

    function ConsultaTiempoLLamado(IdTemporal) {
        console.log(IdTemporal);
        let datos = {
            accion: "TiempoLLamado",
            IdTemporal: IdTemporal,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            $sessionStorage.TiempoTransLLamado =  response.data.respuesta;
        });
    }

    function EmpezarTiempo(min) {
        console.log("min" , min);
        $interval.cancel(IntervalTiempoMax);
        $scope.minRecorridos = "00:00";
        $scope.minMax = "00:00";
        $scope.claseColorMinMax = "minMaxGris";
        var minEnSegundos = min * 60;
        if (min > 9) {
            $scope.minMax = min + ":00";
        } else {
            $scope.minMax = "0" + min + ":00";
        }

        IntervalTiempoMax = $interval(function () {
            let fechaActual = HoraActualJS();
            let a = new Date($sessionStorage.TiempoTransLLamado);
            let b = new Date(fechaActual);
            let c = ((b-a)/1000);
            $scope.minRecorridos = secondsToString(c);
            if (c >= minEnSegundos) {
                $scope.claseColorMinMax = "minMaxRojo";
                ObservacionObligatoria = "Si";
            }
        }, 1000);
    }

    function HoraActualJS() {
        let fechaActual = new Date();
        let fday = fechaActual.getDate();
        let fmonth = fechaActual.getMonth() + 1;
        let fyear = fechaActual.getFullYear();

        let fhora = fechaActual.getHours();
        let fmin = fechaActual.getMinutes();
        let fseg = fechaActual.getSeconds();
        if(fhora < 10){
            fhora = 0+""+fhora; 
        }
        if(fmin < 10){
            fmin = 0+""+fmin;
        }
        if(fseg < 10){
            fseg = 0+""+fseg;
        }
        if(fmonth < 10){
            fmonth = 0+""+fmonth; 
        }
        if(fday < 10){
            fday = 0+""+fday 
        }
         return `${fyear}-${fmonth}-${fday} ${fhora}:${fmin}:${fseg}`;
    }

    $scope.Disponible = function () {
        $scope.tablaMando = true;
        $scope.botonDispobile = true;
        datos = {
            accion: "Llamar",
            IdUsuario: IdUsuario,
            Modulo: $sessionStorage.modulo,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            if (response.data.respuesta == "No Hay Paciente En el Momento") {
                swal("Atención", "No hay usuarios en el momento");
                $scope.botonDispobile = false;
            } else {
                PacienteActual = response.data.respuestaPaciente[0];
                $sessionStorage.PacienteActual = PacienteActual;
                $scope.nombrePaciente = PacienteActual["NombreCompleto"];
                $scope.CEDULA = PacienteActual["Cedula"];
                $scope.ShowConfirmarTurno = true;
                $scope.ShowRepetirLlamado = true;
                $scope.ShowDisponible = false;
                ConsultaTiempoLLamado(PacienteActual["IdTablaTemporal"]);
            }
        });
    }

    function tiene_numeros(texto) {
        var numeros = "0123456789.-/!·$%&/()=?¿+`´Ç¨^`+_:-.;|@#~€¬| ";
        for (i = 0; i < texto.length; i++) {
            if (numeros.indexOf(texto.charAt(i), 0) != -1) {
                return true;
            }
        }
        return false;
    }

    $scope.LlamarTurnoEspecifico = function () {
        if (tiene_numeros($scope.turnoespecifico)) {
            return;
        }
        if ($scope.turnoespecifico.length >= 4) {
            swal("Atención", "El Prefijo solo puede contener 3 Letras");
            return;
        }
        var numTurno = 0;
        if ($scope.turnoespecificoNumero > 0 && $scope.turnoespecificoNumero < 10) {
            numTurno = "00" + $scope.turnoespecificoNumero;
        } else if ($scope.turnoespecificoNumero > 9 && $scope.turnoespecificoNumero < 100) {
            numTurno = "0" + $scope.turnoespecificoNumero;
        } else if ($scope.turnoespecificoNumero > 99 && $scope.turnoespecificoNumero < 1000) {
            numTurno = $scope.turnoespecificoNumero;
        }
        var turno = $scope.turnoespecifico + "-" + numTurno;
        datos = {
            accion: "LlamarTurnoEspecifico",
            TurnoEspecifico: turno.toUpperCase(),
            Modulo: $sessionStorage.modulo,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            $scope.turno = turno.toUpperCase();
            $scope.turnoEspec = "";
            $scope.turnoespecifico = "";
            $scope.turnoespecificoNumero = "";
        });
    }

    $scope.transturno = function (opcion) {
        if (opcion == "servicio") {
            transfereciaPor = "Servicio";
            datos = {
                accion: "ServicioTransTabla",
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.MandoDoctorGeneral(datos).then(function success(response) {
                $scope.servicioTransferir = response.data.respuesta;
            });
            $scope.TransServicio = true;
            $scope.TransUsuario = false;
            $scope.TransEspecialidad = false;
        }
        if (opcion == "usuario") {
            transfereciaPor = "Usuario";
            datos = {
                accion: "UsuarioTransTabla",
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.MandoDoctorGeneral(datos).then(function success(response) {
                $scope.UsuariosTransferir = response.data.respuesta;
            });
            $scope.TransServicio = false;
            $scope.TransUsuario = true;
            $scope.TransEspecialidad = false;
        }
        if (opcion == "especialidad") {
            transfereciaPor = "especialidad";
            datos = {
                accion: "EspecialidadTransTabla",
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.MandoDoctorGeneral(datos).then(function success(response) {
                $scope.EspecialidadTransferir = response.data.respuesta;
            });
            $scope.TransServicio = false;
            $scope.TransUsuario = false;
            $scope.TransEspecialidad = true;
        }
        $scope.botonesTransferir = false;
    }

    var idservicioTransferencia = 0;

    $scope.ClicTransferirServicio = function (idservicio, nombreServicio) {
        $scope.TransServicio = false;
        idservicioTransferencia = idservicio;
        $scope.botonesposicionLlamado = true;
        $scope.servicioTransferir2 = nombreServicio;
        $scope.botonesTransferir = false;
        $scope.TransUsuario = false;
    }

    $scope.ClicTransferirUsuario = function (idUsuario, nombreUsuario) {
        $scope.TransUsuario = false;
        idusuarioTransferencia = idUsuario;
        $scope.botonesposicionLlamado = true;
        $scope.servicioTransferir2 = nombreUsuario;
    }

    var idEspecialidadTransferencia = 0;

    $scope.ClicTransferirEspecialidad = function (idEspecialidad, nombreEspecialidad) {
        $scope.TransEspecialidad = false;
        idEspecialidadTransferencia = idEspecialidad;
        $scope.botonesposicionLlamado = true;
        $scope.servicioTransferir2 = nombreEspecialidad;
    }

    $scope.posicionColaLlamado = function (opcion) {
        var posicion = "";
        if (opcion == "Arriba") {
            posicion = "1";
        }
        if (opcion == "Abajo") {
            posicion = "0";
        }
        if (transfereciaPor == "Servicio") {
            datos = {
                accion: "TransferirTurnoServicio",
                IdUsuario: IdUsuario,
                posicionCola: posicion,
                ServicioAtransferir: idservicioTransferencia,
                PacienteActual: PacienteActual,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.MandoDoctorGeneral(datos);
        } else if (transfereciaPor == "Usuario") {
            datos = {
                accion: "TransferirTurnoUsuario",
                IdUsuario: IdUsuario,
                posicionCola: posicion,
                idusuarioTransferencia: idusuarioTransferencia,
                PacienteActual: PacienteActual,
                NombrePaciente: $sessionStorage.PacienteActual.NombreCompleto,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.MandoDoctorGeneral(datos);
        } else if (transfereciaPor == "especialidad") {
            datos = {
                accion: "TransferirTurnoEspecialidad",
                IdUsuario: IdUsuario,
                posicionCola: posicion,
                idEspecialidadTransferencia: idEspecialidadTransferencia,
                PacienteActual: PacienteActual,
                NombrePaciente: $sessionStorage.PacienteActual.NombreCompleto,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.MandoDoctorGeneral(datos);
        }
        reiniciarTiempo();
        $('#exampleModal').modal('hide');
        $scope.botonDispobile = false;
        $scope.ShowDisponible = true;
        $scope.ShowConfirmarTurno = false;
        $scope.ShowRepetirLlamado = false;
        $scope.ShowObservaciones = false;
        $scope.ShowEditarEncuesta = false;
        $scope.ShowTerminarTurno = false;
        $scope.TablaMando = false;
        datos = {
            accion: "CambiarEstadoUsuario",
            idusuario: IdUsuario,
            estado: 'DISPONIBLE',
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos);
        llenarTabla1();
    }

    $scope.ClickSi = function () {
        habilitarCalificador = true;
        datos = {
            accion: "ClicSi",
            IdUsuario: IdUsuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            console.log(PacienteActual);
            EmpezarTiempo(PacienteActual["tiempoMax"]);
            $scope.ShowDisponible = false;
            $scope.ShowConfirmarTurno = false;
            $scope.ShowRepetirLlamado = false;
            $scope.ShowObservaciones = false;
            $scope.ShowEditarEncuesta = false;
            $scope.ShowTerminarTurno = true;
            $scope.ShowObservaciones = true;
            $scope.Cedula = "";
        });
    }

    $scope.Transferencia = function () {
        $scope.botonesposicionLlamado = false;
        $scope.TransServicio = false;
        $scope.TransUsuario = false;
        $scope.botonesTransferir = true;
    }

    $scope.ClickNo = function () {
        datos = {
            accion: "CambiarEstadoUsuario",
            idusuario: IdUsuario,
            estado: 'DISPONIBLE',
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function mySuccess(response) {
            datos = {
                accion: "PersonaNoDisponible",
                PacienteActual: PacienteActual,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.MandoDoctorGeneral(datos).then(function mySuccess(response) {
                $scope.ShowDisponible = true;
                $scope.ShowConfirmarTurno = false;
                $scope.ShowRepetirLlamado = false;
                $scope.ShowObservaciones = false;
                $scope.ShowEditarEncuesta = false;
                $scope.ShowTerminarTurno = false;
                $scope.tablaMando = false;
                $scope.botonDispobile = false;
            });
        });
        reiniciarTiempo();
    }

    $scope.llenartablamando = function () {
        datos = {
            accion: "cargarTabla",
            Cedula: $scope.Cedula,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            if (response.data.tablausu == "nada") {
                $scope.mando = {};
            } else {
                $scope.mando = response.data.tablausu;
            }
        });
    }

    var fecha;
    $scope.CapturarFecha = function () {
        fecha = $scope.FechaNacimiento;
    }

    $scope.guardarPersona = function () {
        $scope.FechaNacimiento = "";
        $scope.usuInsertar.Fecha = fecha;
        $scope.usuInsertar.accion = "guardarPersona";
        var datos = {};
        datos = {
            accion: "cargarPoblacion",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            $scope.Poblacion = response.data;
        });
        servicios.MandoDoctorGeneral($scope.usuInsertar).then(function success(response) {
            if (response.data.respuesta == "Registro Guardado Correctamente") {
                $scope.alerta = response.data.respuesta;
                $scope.tipoAlerta = "alert-success";
                $scope.MostrarAlerta = true;
                IdPersonaAtendida = response.data.IdPersona;
                $scope.usuEncuestar = {};
                $('#EncuestaModal').modal('show');
            } else { 
                $scope.alerta = response.data.respuesta;
                $scope.tipoAlerta = "alert-danger";
                $scope.MostrarAlerta = true;
            }
        });
        $('#CrearPersonaModal').modal('hide');
    }

    $scope.guardarEncuesta = function () {
        $scope.usuEncuestar.accion = "guardarEncuesta";
        $scope.usuEncuestar.IdUsuario = $sessionStorage.idusuario;
        $scope.usuEncuestar.IdServicio = TurnoActual.respuesta[0].IdServicio;
        $scope.usuEncuestar.IdPersona = IdPersonaAtendida;
        servicios.MandoDoctorGeneral($scope.usuEncuestar).then(function success(response) {
            if (response.data.respuesta == "Registro Guardado Correctamente") {
                $scope.alerta = response.data.respuesta;
                $scope.tipoAlerta = "alert-success";
                $scope.MostrarAlerta = true;
                $('#EncuestaModal').modal('hide');
                $('#exampleModal').modal('hide');
                idEncuestaGlobal = response.data.idEncuesta;
            } else {
                $scope.alerta = response.data.respuesta;
                $scope.tipoAlerta = "alert-danger";
                $scope.MostrarAlerta = true;
            }
        });
    }

    $scope.DatosPersona = function (idpersona, nombre) {
        $scope.NOMBREPERSONA = nombre;
        $scope.usuEncuestar = {};
        IdPersonaAtendida = idpersona;
        var datos = {};
        datos = {
            accion: "cargarPoblacion"
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            $scope.Poblacion = response.data;
        });
    }

    $scope.cerrarAlerta = function () {
        $scope.MostrarAlerta = false;
    }

    var estadoUsuario = "";
    function llenarTabla1() {
        if (estadoUsuario == "Cerrado") {
            if ($scope.ShowDisponible == true) {
                datos = {
                    accion: "CambiarEstadoUsuario",
                    idusuario: IdUsuario,
                    estado: 'DISPONIBLE',
                    IdSede: $sessionStorage.IdSede,
                    emp_id: $sessionStorage.IdEmpresa
                };
                servicios.MandoDoctorGeneral(datos);
            } else {
                datos = {
                    accion: "CambiarEstadoUsuario",
                    idusuario: IdUsuario,
                    estado: 'ATENDIENDO',
                    IdSede: $sessionStorage.IdSede,
                    emp_id: $sessionStorage.IdEmpresa
                };
                servicios.MandoDoctorGeneral(datos);
            }
            estadoUsuario = "en Linea";
        }
        datos = {
            accion: "cargarTablaNumTurnos",
            IdUsuario: $sessionStorage.idusuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            $scope.servicios = response.data.respuesta;
            if (response.data.contar > 0) {
                $scope.persona = {};
                if (SinTurnos == "no hay") {
                    SinTurnos = "si hay";
                    notifi();
                }
                $scope.persona = response.data.respuesta;
            } else {
                $scope.persona = {};
                SinTurnos = "no hay";
            }
        }, function myError(response) {
            alert("error en la red");
        });
    }

    var interval = $interval(function () {
        if ($scope.ShowDisponible == true) {
            $scope.tablaMando = false;
        } else {
            $scope.tablaMando = true;
        }
        llenarTabla1();
    }, 7000);

    $scope.Limpiarmodalcrearpersona = function () {
        $scope.usuInsertar = {
            NombreCompleto: "",
            Cedula: $scope.Cedula,
            Sexo: "",
            Direccion: "",
            Barrio: "",
            Telefono: "",
        };
    }

    $scope.EditarPesona = function (idpersona2) {
        datos = {
            accion: "TraerDatosEditar",
            IdPersona: idpersona2,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            $scope.usuEditarPer = {
                idPersona: response.data.respuesta[0].IdPersona,
                NombreCompleto: response.data.respuesta[0].NombreCompleto,
                Cedula: response.data.respuesta[0].Cedula,
                Sexo: response.data.respuesta[0].Sexo,
                Direccion: response.data.respuesta[0].Direccion,
                Barrio: response.data.respuesta[0].Barrio,
                Telefono: response.data.respuesta[0].Telefono,
                Fecha: response.data.respuesta[0].FechaNacimiento,
            };
        });
    }

    $scope.FormEditarPersona = function () {
        $scope.usuEditarPer.accion = "editarPersona";
        $scope.usuEditarPer.IdSede = $sessionStorage.IdSede;
        $scope.usuEditarPer.emp_id = $sessionStorage.IdEmpresa;
        servicios.MandoDoctorGeneral($scope.usuEditarPer).then(function success(response) {
            if (response.data.respuesta == "Editado Correctamente") {
                $('#EditarModal').modal('hide');
            }
        });
    }

    $scope.RepetirLlamado = function () {
        datos = {
            accion: "RepetirLlamado",
            PacienteActual: PacienteActual,
            Modulo: $sessionStorage.modulo,
            Turno: PacienteActual['NombrePaciente'],
            tv: PacienteActual['LlamadoTv'],
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            if (response.data.respuesta == "Llamado") {
            }
        });
    }

    $scope.GuardarObservacion = function () {
        datos = {
            accion: "GuardarObservacionAsesor",
            ObservacionAsesor: $scope.ObservacionAsesor,
            PacienteActual: PacienteActual,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            $('#ObservacionModal').modal('hide');
        });
    }

    $scope.ClickObserbacion = function () {
        $scope.ObservacionAsesor = "";
    }

    $scope.TerminarTurno = function () {
        habilitarCalificador = false;
        datos = {
            accion: "TerminarTurno",
            pacienteActual: PacienteActual,
            IdUsuario: IdUsuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            datos = {
                accion: "CambiarEstadoUsuario",
                idusuario: IdUsuario,
                estado: 'DISPONIBLE',
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            $sessionStorage.TiempoTransLLamado = 0;
            servicios.MandoDoctorGeneral(datos);
            $scope.botonDispobile = false;
            $scope.ShowDisponible = true;
            $scope.ShowConfirmarTurno = false;
            $scope.ShowRepetirLlamado = false;
            $scope.ShowObservaciones = false;
            $scope.ShowEditarEncuesta = false;
            $scope.ShowTerminarTurno = false;
            PacienteActual = {};
            reiniciarTiempo();
        });
    }

    $scope.EditarEncuesta = function () {
        $scope.usuEncuestar = {};
        datos = {
            accion: "TraerDatosEncuesta",
            IdEncuesta: idEncuestaGlobal
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            $scope.usuEncuestar = {
                Asunto: response.data.respuesta[0].Asunto,
                Escolaridad: response.data.respuesta[0].NivelEscolaridad,
                TipoPoblacion: response.data.respuesta[0].TipoPoblacion
            };
        });
    }

    $scope.FormEditarEncuesta = function () {
        $scope.usuEncuestar.accion = "editarEncuesta";
        $scope.usuEncuestar.idencuesta = idEncuestaGlobal;
        servicios.MandoDoctorGeneral($scope.usuEncuestar).then(function success(response) {
            if (response.data.respuesta == "Editado Correctamente") {
                $('#EncuestaEditarModal').modal('hide');
            }
        });
    }

    function notifi() {
        var audio = document.getElementById("audio");
        alert("Turno Nuevo");
        audio.play();
    }

    $scope.cerrarSesionMando = function () {
        datos = {
            accion: "CambiarEstadoUsuario",
            idusuario: IdUsuario,
            estado: 'CAJA CERRADA',
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos);
        delete $sessionStorage.modulo;
        $interval.cancel(interval);
    }

    datos = {
        accion: "CambiarEstadoUsuario",
        idusuario: IdUsuario,
        estado: 'DISPONIBLE',
        IdSede: $sessionStorage.IdSede,
        emp_id: $sessionStorage.IdEmpresa
    };
    servicios.MandoDoctorGeneral(datos);

    $scope.LlamarservicioDoctor = function (idpersona, cedula, nombrepersona, idtablatemp, idauditoria, objeto) {
        $scope.tablaMando = true;
        datos = {
            accion: "LlamarIndividual",
            Modulo: $sessionStorage.modulo,
            idtablatemporal: objeto['IdTablaTemporal'],
            IdUsuario: $sessionStorage.idusuario,
            idauditoria: objeto['IdAuditoria'],
            nombrePersona: objeto['NombrePaciente'],
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.MandoDoctorGeneral(datos).then(function success(response) {
            PacienteActual = response.data.respuesta;
            console.log(PacienteActual);
            $scope.nombrePaciente = PacienteActual["NombreCompleto"];
            $scope.CEDULA = PacienteActual["Cedula"];
            $scope.SERVICIOATENDER = PacienteActual["Servicio"];
            $scope.ShowConfirmarTurno = true;
            $scope.ShowRepetirLlamado = true;
            $scope.ShowDisponible = false;
            ConsultaTiempoLLamado(PacienteActual["IdTablaTemporal"]);
            llenarTabla1();
        });
    }

    
    var preguntasCalificadas =[];

    $(document).bind('keydown', 'alt+m', function () {
        Calificar(1);
    });
    $(document).bind('keydown', 'alt+r', function () {
        Calificar(2);
    });
    $(document).bind('keydown', 'alt+b', function () {
        Calificar(3);
    });
    $(document).bind('keydown', 'alt+w', function () {
        Calificar(4);
    });

    function Calificar(calificacion) {
       
        if (!HabilitarCalif) {
            return;
        }
        datos = {
            accion: "Calificar",
            IdUsuario: IdUsuario,
            NumCalif: calificacion,
            IdAuditoria: PacienteActual["IdAuditoria"],
            IdPregunta: IdPreguntaSeleccionada,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        
        servicios.Calificacion(datos).then(function success(response) {
            if(calificacion == 1){
                reportarCalificacion(response.data.idCalificacion);
            }
            preguntasCalificadas.push(IdPreguntaSeleccionada);
            IdPreguntaSeleccionada = 0;
            $scope.MostrarCargar = true;
            var intervalCalif = $interval(function () {
                $interval.cancel(intervalCalif);
                HabilitarCalif = false;
                $scope.ListPreguntasShow = true;
                $scope.MostrarCargar = false;
            }, 2000);
        });
    }

///
    function reportarCalificacion(idcalificacion) {
        datos = {
            accion: "reportarCalificacionCorreo",
            idcalificacion: idcalificacion
        };
        servicios.Reportar(datos).then(function success(response) {
        });
    }

    $scope.CalificacionUsuario = function () {
        $scope.ListPreguntasShow = true;
        if (PacienteActual == undefined || habilitarCalificador == false) {
            swal("Atención", "Debe estar atendiendo a un cliente para poder calificar");
            return;
        }
        datos = {
            accion: "cargarTabla",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Preguntas(datos).then(function success(response) {
            $scope.listaPreguntas = response.data.respuesta;
            $('#ModalCalifcarUsuario').modal('show');
        });
    }

    $scope.ClicPregunta = function (pregunta, idpregunta) {
        if(preguntasCalificadas.includes(idpregunta)){
            swal("Atención", "La pregunta ya cuenta con una calificación en el turno actual");
        }else{
            HabilitarCalif = true;
            IdPreguntaSeleccionada = idpregunta;
            $scope.PreguntaElegida = pregunta;
            $scope.ListPreguntasShow = false;
        }
    }

    $scope.CancelarCalificacion = function () {
        if (HabilitarCalif) {
            return;
        }
        $('#ModalCalifcarUsuario').modal('hide');
        HabilitarCalif = false;
    }
    $scope.CancelarCalificacion2 = function () {
        $scope.PreguntaElegida = "";
        $scope.ListPreguntasShow = true;
        HabilitarCalif = false;
    }

}