angular.module('TurnoMasterV2').controller('MandoController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', '$interval', '$window', 'urlBase', '$http', 'Upload', '$localStorage'];

function InitController($scope, $state, $sessionStorage, servicios, $interval, $window, $urlBase, $http, $Upload, $localStorage) {

    if ($sessionStorage.idusuario === undefined) {
        $state.go('login');
    } else {
        if ($sessionStorage.rol == "ADMINISTRADOR") {
            $state.go('dashboard');
        }
    }
    function comprobarempty(objeto) {
        if (objeto == "" || objeto == undefined) {
            return true;
        } else {
            return false;
        }
    }
    function convertirFecha(str) {
        var month, day, year, hours, minutes, seconds;
        var date = new Date(str),
        month = ("0" + (date.getMonth() + 1)).slice(-2),
        day = ("0" + date.getDate()).slice(-2);
        hours = ("0" + date.getHours()).slice(-2);
        minutes = ("0" + date.getMinutes()).slice(-2);
        seconds = ("0" + date.getSeconds()).slice(-2);
        var mySQLDate = [date.getFullYear(), month, day].join("-");
        //var mySQLTime = [hours, minutes, seconds].join(":");
        //return [mySQLDate].join(" ");
        return mySQLDate;
    }

    function FechaHoraActual() {
        var month, day, year, hours, minutes, seconds;
        var date = new Date(),
        month = ("0" + (date.getMonth() + 1)).slice(-2),
        day = ("0" + date.getDate()).slice(-2);
        hours = ("0" + date.getHours()).slice(-2);
        minutes = ("0" + date.getMinutes()).slice(-2);
        seconds = ("0" + date.getSeconds()).slice(-2);
        var mySQLDate = [date.getFullYear(), month, day].join("-");
        var mySQLTime = [hours, minutes, seconds].join(":");
        return mySQLDate + " " + mySQLTime;
    }


    function secondsToString(seconds) {
        var hour = Math.floor(seconds / 3600);
        hour = (hour < 10)? '0' + hour : hour;
        var minute = Math.floor((seconds / 60) % 60);
        minute = (minute < 10)? '0' + minute : minute;
        var second = seconds % 60;
        second = (second < 10)? '0' + second : second;
        return minute + ':' + second;
    }

    $sessionStorage.MenuSelect = 'Mando';
    $scope.informacioncitas = true;
    var habilitarCalificador = false;
    var letra;

    $('#turnoespecifico').keydown(function(e) {
        if (e.keyCode == 32) {
            return false;
        }
    });

    $scope.ValidarSololetras = function() {
        var regex = /^[a-zA-Z]+$/;
        if($scope.turnoespecifico === ''){
            alert("esapacio");
        }
        if(regex.test($scope.turnoespecifico) && $scope.turnoespecifico !== ''){
            letra = $scope.turnoespecifico;
            $scope.turnoespecifico = letra;
        }else {
            $scope.turnoespecifico = letra;
        }
    }
    
    $scope.tablaMando = false;
    $scope.numModulo = $sessionStorage.modulo;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;

    function CambiarEstadoUsuario(idusuario,estado) {
        datos = {
            accion: "CambiarEstadoUsuario",
            idusuario: idusuario,
            estado: estado,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos);
    }  
    
    var datos = {};
    var TurnoActual = {};
    var TurnoActual2 = {};
    var terminarturnoestado = "";
    var IdUsuario = $sessionStorage.idusuario;
    var IdPersonaAtendida = 0;
    var idEncuestaGlobal = 0;
    var SinTurnos = "no hay";
    var transfereciaPor = "";
    var idusuarioTransferencia = "";
    var estadoenviartriage = "";
    $scope.ShowTerminarTurno = false;
    $scope.ShowObservaciones = false;
    $scope.ShowRepetirLlamado = false;
    $scope.ShowEditarEncuesta = false;
    $scope.ShowConfirmarTurno = false;
    $scope.ShowDisponible = true;
    $scope.ShowEstado = true;
    $scope.ShowTriage = true;
    $scope.ShowCita = true;
    $scope.TransServicio = false;
    $scope.TransUsuario = false;
    $scope.botonesTransferir = true;
    $scope.MandoDerecha = true;
    $scope.MandoDerechacita = false;
    $scope.MostrarDescarga = false;
    $scope.minRecorridos = "00:00";
    $scope.minMax = "00:00";
    var IntervalTiempoMax;
    var ObservacionObligatoria = "No";
    $scope.HabilitarNombrePaciente = "disabled";

    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
        $('[data-toggle="modal"]').tooltip()
    })

    LlenarEspecialidades();

    function LlenarEspecialidades() {
        datos = {
            accion: "TraerEspecialidades",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.Especialidades = response.data.respuesta;
        });
    }
   

    function reiniciarTiempo() {
        $interval.cancel(IntervalTiempoMax);
        $scope.minRecorridos = "00:00";
        $scope.minMax = "00:00";
        $scope.claseColorMinMax = "minMaxGris";
        ObservacionObligatoria = "No";
    }


    //var TiempoTransLLamado;

    function ConsultaTiempoLLamado(IdTemporal) {
        console.log(IdTemporal);
        let datos = {
            accion: "TiempoLLamado",
            IdTemporal: IdTemporal,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            //$sessionStorage.TiempoTransLLamado =  response.data.respuesta;
        });
    }
    
    function EmpezarTiempo(min) {
        console.log("min" , min);
        $interval.cancel(IntervalTiempoMax);
        $scope.minRecorridos = "00:00";
        $scope.minMax = "00:00";
        $scope.claseColorMinMax = "minMaxGris";
        var minEnSegundos = min * 60;
        if (min > 9) {
            $scope.minMax = min + ":00";
        } else {
            $scope.minMax = "0" + min + ":00";
        }
        
        var enviado = 1;
        IntervalTiempoMax = $interval(function () {
            console.log("a");
            let fechaActual = HoraActualJS();
            let a = new Date($sessionStorage.TiempoTransLLamado);
            let b = new Date(fechaActual);
            let c = ((b-a)/1000);
            $scope.minRecorridos = secondsToString(c);
            if (c >= minEnSegundos) {
                $scope.claseColorMinMax = "minMaxRojo";
                ObservacionObligatoria = "Si";
                if(enviado == 1){
                    var subject = 'Notificacion Tiempo superado'
                    var body = "  <h4><b>Notificacion Tiempo superado</b></h4>" +
                    "  Turno: " +$scope.turno
                    "  <br>" +
                    "  <br>" +
                    "  Asesor: " + $sessionStorage.nombreUsuario+
                    "</div>" +
                    "  <div>" +
                    "   <hr/>" +
                    " </div>";
                    $http.get("app/model/enviarNotificacion.php?subject="+subject+"&body="+body)
                    .then(function (response) {
                    });
                    enviado = 0;
                }
            }
        }, 1000);
    }
    
    

    function HoraActualJS() {
        let fechaActual = new Date();
        let fday = fechaActual.getDate();
        let fmonth = fechaActual.getMonth() + 1;
        let fyear = fechaActual.getFullYear();

        let fhora = fechaActual.getHours();
        let fmin = fechaActual.getMinutes();
        let fseg = fechaActual.getSeconds();
        if(fhora < 10){
            fhora = 0+""+fhora; 
        }
        if(fmin < 10){
            fmin = 0+""+fmin;
        }
        if(fseg < 10){
            fseg = 0+""+fseg;
        }
        if(fmonth < 10){
            fmonth = 0+""+fmonth; 
        }
        if(fday < 10){
            fday = 0+""+fday 
        }
         return `${fyear}-${fmonth}-${fday} ${fhora}:${fmin}:${fseg}`;
    }


    reportarUsuario();
    function reportarUsuario() {
        datos = {
            accion: "ReportarUsuario",
            idusuario: IdUsuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos);
        if($sessionStorage.MenuSelect == 'Mando'){
            setTimeout(reportarUsuario, 60000);
        }
    }
    
    var ip = "";
    traerip();
    function traerip() {
        datos = {
            accion: 'traerip'
        };
        servicios.Mando(datos).then(function success(response) {
            ip = response.data.respuesta;
        });  
    }

    $scope.Salircita = function () {
        $scope.MandoDerecha = true;
        $scope.MandoDerechacita = false;
    }

    $scope.Entrarcita = function () {
        $scope.MandoDerecha = false;
        $scope.MandoDerechacita = true;
        try {
            $scope.turnoAtender = TurnoActual.respuesta[0].Turno;
        } catch (e) {
            $scope.turnoAtender = "";
        }
    }

    $scope.ExportarExcel = function () {
        $http.get("app/model/FormatoExcelCitas.php")
            .then(function (response) {
                if (response.data.respuesta == "Enviado Correctamente") {
                    $('#modalDescarga').modal('show');
                    $scope.MostrarDescarga = true;
                    $scope.linkdescarga2 = "http://" + ip + "" + $urlBase + "reportes/Magisoft.xlsx";
                    $scope.descargarReporteExcel = true;
                }
            });
    }

    var tiempollama;

    $scope.Disponible = function () {
        terminarturnoestado = "";
        $scope.tablaMando = true;
        $scope.botonDispobile = true;
        datos = {
            accion: "Llamar",
            IdUsuario: IdUsuario,
            Modulo: $sessionStorage.modulo,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.tipo == "NO HAY TURNOS") {
                SinTurnos = false;
                swal("Atención", "No hay turnos Disponibles");
                $scope.botonDispobile = false;
            } else {
                CambiarEstadoUsuario(IdUsuario, 'ATENDIENDO');
                TurnoActual = response.data;
                TurnoActual2 = response.data;
                $localStorage.TurnoActual = response.data;
                if (response.data.respuesta[0].NombrePaciente == "" || response.data.respuesta[0].NombrePaciente == "Sin Registro") {
                    $scope.turno = response.data.respuesta[0].Turno;
                } else {
                    $scope.turno = response.data.respuesta[0].CedulaPersona + " -- " +response.data.respuesta[0].NombrePaciente + " -- " + response.data.respuesta[0].Turno;
                }
                if (response.data.respuesta[0].IdPersona != ""){
                    IdPersonaAtendida = response.data.respuesta[0].IdPersona;
                }
                let EnvioMensajeId = IdPersonaAtendida;
                let EnvioMensajeTxt = `Sr@. ${response.data.respuesta[0].NombrePaciente}  su turno esta siendo llamado.`;
                datos = {
                    accion: "EnviarMensajePersonaTxT",
                    IdSede: $sessionStorage.IdSede,
                    emp_id: $sessionStorage.IdEmpresa,
                    Idusuario: IdUsuario,
                    EnvioMensajeId: EnvioMensajeId,
                    EnvioMensajeTxt: EnvioMensajeTxt
                };
                servicios.MensajesDeTxt(datos).then(function success(response) {
                });
                console.log(response.data.respuesta[0].Servicio);
                $scope.servicio = response.data.respuesta[0].Servicio;
                //tiempollama = parseInt(response.data.respuesta[0].tiempoMax);
                $scope.ShowDisponible = false;
                $scope.ShowEstado = false;
                $scope.ShowConfirmarTurno = true;
                $scope.ShowRepetirLlamado = true;
                $scope.botonDispobile = false;
                $scope.ShowCita = false;
                ConsultaTiempoLLamado(TurnoActual.respuesta[0]["IdTablaTemporal"]);
            }
            llenarTabla1();
        });
        
    }

    function tiene_numeros(texto) {
        var numeros = "0123456789.-/!·$%&/()=?¿+`´Ç¨^`+_:-.;|@#~€¬| ";
        for (i = 0; i < texto.length; i++) {
            if (numeros.indexOf(texto.charAt(i), 0) != -1) {
                return true;
            }
        }
        return false;
    }

    $scope.LlamarTurnoEspecifico = function () {
        if (tiene_numeros($scope.turnoespecifico)) {
            swal("Atención", "El Prefijo solo puede contener Letras");
            return;
        }
        if ($scope.turnoespecifico.length >= 4) {
            swal("Atención", "El Prefijo solo puede contener 3 Letras");
            return;
        }
        var numTurno = 0;
        if ($scope.turnoespecificoNumero > 0 && $scope.turnoespecificoNumero < 10) {
            numTurno = "00" + $scope.turnoespecificoNumero;
        } else if ($scope.turnoespecificoNumero > 9 && $scope.turnoespecificoNumero < 100) {
            numTurno = "0" + $scope.turnoespecificoNumero;
        } else if ($scope.turnoespecificoNumero > 99 && $scope.turnoespecificoNumero < 1000) {
            numTurno = $scope.turnoespecificoNumero;
        }
        var turno = $scope.turnoespecifico + "-" + numTurno;
        datos = {
            accion: "LlamarTurnoEspecifico",
            TurnoEspecifico: turno.toUpperCase(),
            Modulo: $sessionStorage.modulo,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa,
            IdUsuario: IdUsuario
        };
        servicios.Mando(datos).then(function success(response) {
           
            $scope.turno = turno.toUpperCase();
            $scope.turnoEspec = "";
            $scope.turnoespecifico = "";
            $scope.turnoespecificoNumero = "";
        });
    }

    $scope.transturno = function (opcion) {
        if (opcion == "servicio") {
            transfereciaPor = "Servicio";
            datos = {
                accion: "ServicioTransTabla",
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Mando(datos).then(function success(response) {
                $scope.servicioTransferir = response.data.respuesta;
            });
            $scope.TransServicio = true;
            $scope.TransUsuario = false;
        }
        if (opcion == "usuario") {
            transfereciaPor = "Usuario";
            datos = {
                accion: "UsuarioTransTabla",
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Mando(datos).then(function success(response) {
                $scope.UsuariosTransferir = response.data.respuesta;
            });
            $scope.TransServicio = false;
            $scope.TransUsuario = true;
        }
        $scope.botonesTransferir = false;
    }
    var idservicioTransferencia = 0;

    $scope.ClicTransferirServicio = function (idservicio, nombreServicio) {
        $scope.TransServicio = false;
        idservicioTransferencia = idservicio;
        $scope.botonesposicionLlamado = true;
        $scope.servicioTransferir2 = nombreServicio;
    }

    $scope.ClicTransferirUsuario = function (idUsuario, nombreUsuario) {
        $scope.TransUsuario = false;
        idusuarioTransferencia = idUsuario;
        $scope.botonesposicionLlamado = true;
        $scope.servicioTransferir2 = nombreUsuario;
    }

    $scope.posicionColaLlamado = function (opcion) {
        var posicion = "";
        if (opcion == "Arriba") {
            posicion = "1";
        }
        if (opcion == "Abajo") {
            posicion = "0";
        }
        if (transfereciaPor == "Servicio") {
            datos = {
                accion: "TransferirTurnoServicio",
                idpersona: IdPersonaAtendida,
                IdAuditoria: TurnoActual.respuesta[0].IdAuditoria,
                idEncuesta: idEncuestaGlobal,
                IdTemporal: TurnoActual.respuesta[0].IdTablaTemporal,
                IdUsuario: IdUsuario,
                NombrePersona: TurnoActual.respuesta[0].NombrePaciente,
                posicionCola: posicion,
                ServicioAtransferir: idservicioTransferencia,
                Turno: TurnoActual.respuesta[0].Turno,
                Cedula: TurnoActual.respuesta[0].CedulaPersona,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Mando(datos);
        } else if (transfereciaPor == "Usuario") {
            datos = {
                accion: "TransferirTurnoUsuario",
                idpersona: IdPersonaAtendida,
                IdAuditoria: TurnoActual.respuesta[0].IdAuditoria,
                idEncuesta: idEncuestaGlobal,
                IdTemporal: TurnoActual.respuesta[0].IdTablaTemporal,
                IdUsuario: IdUsuario,
                NombrePersona: TurnoActual.respuesta[0].NombrePaciente,
                posicionCola: posicion,
                idusuarioTransferencia: idusuarioTransferencia,
                Turno: TurnoActual.respuesta[0].Turno,
                ServicioAtransferir: TurnoActual.respuesta[0].IdServicio,
                Cedula: TurnoActual.respuesta[0].CedulaPersona,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Mando(datos);
        }

        $('#exampleModal').modal('hide');
        $scope.botonDispobile = false;
        $scope.ShowDisponible = true;
        $scope.ShowEstado = true;
        $scope.ShowConfirmarTurno = false;
        $scope.ShowRepetirLlamado = false;
        $scope.ShowObservaciones = false;
        $scope.ShowEditarEncuesta = false;
        $scope.ShowTerminarTurno = false;
        if (ObservacionObligatoria == "Si") {
            $scope.ObservacionAsesorObligatoria = "";
            $('#ObservacionObligatoriaModal').modal('show');
        }
        reiniciarTiempo();
        CambiarEstadoUsuario(IdUsuario, 'DISPONIBLE');
        /*
        datos = {
            accion: "CambiarEstadoUsuario",
            idusuario: IdUsuario,
            estado: 'DISPONIBLE'
        };
        servicios.Mando(datos);
        */
        TurnoActual = {};
        delete $localStorage.TurnoActual;
        llenarTabla1();
    }

    $scope.ClickSi = function () {
        habilitarCalificador = true;
        datos = {
            accion: "ClicSi",
            IdUsuario: IdUsuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            EmpezarTiempo(TurnoActual.respuesta[0]["tiempoMax"]);
            if(comprobarempty(TurnoActual.respuesta[0]["HoraClickSi"])){
                $sessionStorage.TiempoTransLLamado = FechaHoraActual();
                TurnoActual.respuesta[0]["HoraClickSi"] = FechaHoraActual();
            }else{
                $sessionStorage.TiempoTransLLamado = TurnoActual.respuesta[0]["HoraClickSi"];
            }
            $scope.ShowDisponible = false;
            $scope.ShowEstado = false;
            $scope.ShowConfirmarTurno = false;
            $scope.ShowRepetirLlamado = false;
            $scope.ShowObservaciones = true;
            $scope.ShowEditarEncuesta = false;
            $scope.ShowTerminarTurno = true;
            $scope.Cedula = "";
            $scope.ShowCita = true;
        });
        llenarTabla1();
    }

    $scope.Transferencia = function () {
        datos = {
            accion: "probarConexion"
        };
        servicios.Mando(datos).then(function success(response) {
            transfereciaPor = "";
            $scope.TURNOTRANSFERIR = TurnoActual.respuesta[0].Turno;
            $scope.botonesposicionLlamado = false;
            $scope.TransServicio = false;
            $scope.TransUsuario = false;
            $scope.botonesTransferir = true;
        });
    }

    $scope.ClickNo = function () {
        CambiarEstadoUsuario(IdUsuario, 'DISPONIBLE');
        /*
        datos = {
            accion: "CambiarEstadoUsuario",
            idusuario: IdUsuario,
            estado: 'DISPONIBLE'
        };
        servicios.Mando(datos).then(function mySuccess(response) {
            
        });
        */
        if (TurnoActual.tipo == "Aplazados") {
            datos = {
                accion: "LimiteLlamados",
                idusuario: IdUsuario,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Mando(datos).then(function success(response) {
                var ultimolla = TurnoActual2.respuesta[0].UltimoLlamado;
                //compara el limite con el ultimo llamado del turno
                if (parseInt(ultimolla) >= parseInt(response.data.respuesta) - 1) {
                    //Elimino El turno, porque se exedio en las vaces de llamado
                    datos = {
                        accion: "EliminarTurno",
                        idAuditoria: TurnoActual2.respuesta[0].IdAuditoria,
                        IdTablaTemporal: TurnoActual2.respuesta[0].IdTablaTemporal,
                        NumLlamados: response.data.respuesta,
                        IdUsuario: IdUsuario,
                        IdSede: $sessionStorage.IdSede,
                        emp_id: $sessionStorage.IdEmpresa
                    };
                    servicios.Mando(datos).then(function success(response) {});
                } else {
                    datos = {
                        accion: "aumentarLlamadoAplazado",
                        IdTablaTemporal: TurnoActual2.respuesta[0].IdTablaTemporal,
                        IdUsuario: IdUsuario,
                        IdSede: $sessionStorage.IdSede,
                        emp_id: $sessionStorage.IdEmpresa
                    };
                    servicios.Mando(datos).then(function success(response) {});
                }
            });
        } else {
            datos = {
                accion: "aumentarLlamadoAplazado",
                IdTablaTemporal: TurnoActual.respuesta[0].IdTablaTemporal,
                IdUsuario: IdUsuario,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Mando(datos).then(function success(response) {});
        }

        $scope.ShowDisponible = true;
        $scope.ShowEstado = true;
        $scope.ShowConfirmarTurno = false;
        $scope.ShowRepetirLlamado = false;
        $scope.ShowObservaciones = false;
        $scope.ShowEditarEncuesta = false;
        $scope.ShowTerminarTurno = false;
        $scope.ShowCita = true;
        TurnoActual = {};
        delete $localStorage.TurnoActual;
        reiniciarTiempo();
        llenarTabla1();
    }

    $scope.llenartablamando = function () {
        if ($scope.Cedula == "" || $scope.Cedula == undefined || $scope.Cedula == null) {
            $scope.mando = {};
            return;
        }
        datos = {
            accion: "cargarTabla",
            Cedula: $scope.Cedula,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.tablausu == "nada") {
                $scope.mando = {};
            } else {
                $scope.mando = response.data.tablausu;
            }
        });
    }

    $scope.llenartablamando2 = function () {
        if ($scope.Cedulapa == "" || $scope.Cedulapa == undefined || $scope.Cedulapa == null) {
            $scope.mando2 = {};
            return;
        }
        datos = {
            accion: "cargarTabla",
            Cedula: $scope.Cedulapa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.tablausu == "nada") {
                $scope.mando2 = {};
            } else {
                $scope.mando2 = response.data.tablausu;
            }
        });
    }

    $scope.llenartablaDoctor = function () {
        if ($scope.Nombre == "" || $scope.Nombre == undefined || $scope.Nombre == null) {
            $scope.mandodoctor = {};
            return;
        }
        datos = {
            accion: "cargarTablaNomDoctor",
            Nombre: $scope.Nombre,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.tablaNomDoctor == "nada") {
                $scope.mandodoctor = {};
            } else {
                $scope.mandodoctor = response.data.tablaNomDoctor;
            }
        });
    }

    $scope.llenartablamandoCitas = function () {
        if ($scope.Cedula == "" || $scope.Cedula == undefined || $scope.Cedula == null) {
            $scope.mando = {};
            return;
        }
        datos = {
            accion: "cargarTablaCitas",
            Cedula: $scope.Cedula,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.tablausu == "nada") {
                $scope.mando = {};
            } else {
                $scope.mando = response.data.tablausu;
            }
        });
    }

    function LLenarTablaGeneral() {
        datos = {
            accion: "cargarTablaCitasGeneral",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.tablausu == "nada") {
                $scope.mando = {};
            } else {
                $scope.mando = response.data.tablausu;
            }
        });
    }

    var fecha;
    $scope.CapturarFecha = function () {
        fecha = $scope.FechaNacimiento;
    }

    var fechacita;
    $scope.CapturarFechaCita = function () {
        fechacita = $scope.FechaCita;
    }

    var fechacita2;
    $scope.CapturarFechaCita2 = function () {
        fechacita2 = $scope.FechaCita2;
    }

    $scope.crearPersonaOcultarModal = function () {
        $('#CrearCitaModal').modal('hide');
    }

    $scope.guardarPersona = function () {
        $scope.FechaNacimiento = "";
        $scope.usuInsertar.Fecha = fecha;
        $scope.usuInsertar.accion = "guardarPersona";
        $scope.usuInsertar.IdSede = $sessionStorage.IdSede;
        $scope.usuInsertar.emp_id = $sessionStorage.IdEmpresa;
        servicios.Mando($scope.usuInsertar).then(function success(response) {
            if (response.data.respuesta == "Registro Guardado Correctamente") {
                $scope.alerta = response.data.respuesta;
                $scope.tipoAlerta = "alert-success";
                $scope.MostrarAlerta = true;
                IdPersonaAtendida = response.data.IdPersona;
                $scope.usuEncuestar = {};
                $('#EncuestaModal').modal('show');
            } else { 
                $scope.alerta = response.data.respuesta;
                $scope.tipoAlerta = "alert-danger";
                $scope.MostrarAlerta = true;
            }
        });
        $('#CrearPersonaModal').modal('hide');
        $('#CrearCitaModal').modal('show');
    }

    $scope.ConfirmarCita = function (IdPersona, IdCita, Nombreper) {
        terminarturnoestado = "confirmaron";
        if (JSON.stringify(TurnoActual) == '{}') {
            datos = {
                accion: 'ConfirmarCitaSinTurno',
                IdUsuario: IdUsuario,
                IdPersona: IdPersona,
                IdCita: IdCita,
                Nombreper: Nombreper,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            }
            servicios.Mando(datos).then(function success(response) {
                if (response.data.respuesta == "Registro Guardado Correctamente") {
                    $scope.mando = {};
                    TurnoActual = {};
                }
            });
        } else {
            var datos = {};
            datos = {
                accion: 'ConfirmarCita',
                IdUsuario: IdUsuario,
                IdPersona: IdPersona,
                IdCita: IdCita,
                Nombreper: Nombreper,
                idtemporal: TurnoActual.respuesta[0].IdTablaTemporal,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            }
            servicios.Mando(datos).then(function success(response) {
                if (response.data.respuesta == "Registro Guardado Correctamente") {
                    $scope.mando = {};
                    TurnoActual = {};
                }
            });
        }
    }

    var estadoUsuario = "";

    function llenarTabla1() {
        if (estadoUsuario == "Cerrado") {
            if ($scope.ShowDisponible == true) {
                CambiarEstadoUsuario(IdUsuario, 'DISPONIBLE');
            } else {
                CambiarEstadoUsuario(IdUsuario, 'ATENDIENDO');
            }
            estadoUsuario = "en Linea";
        }

        if ($scope.botonDispobile == true) {
            $scope.botonDispobile = false;
        }
        datos = {
            accion: "cargarTablaNumTurnos",
            IdUsuario: $sessionStorage.idusuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.servicios = response.data.respuesta;
            $scope.observaciones = response.data.respuesta[0].MotivoDuracion.split(',')
            if (response.data.contar > 0) {
                if (SinTurnos == "no hay") {
                    SinTurnos = "si hay";
                    notifi();
                }
            } else {
                SinTurnos = "no hay";
            }
        }, function myError(response) {
        });
    }

    llenarTabla1();

    function llenarTabla1citas() {
        if (estadoUsuario == "Cerrado") {
            if ($scope.ShowDisponible == true) {
                CambiarEstadoUsuario(IdUsuario, 'ATENDIENDO');
            } else {
                CambiarEstadoUsuario(IdUsuario, 'ATENDIENDO');
            }
            estadoUsuario = "en Linea";
        }
        if ($scope.botonDispobile == true) {
            $scope.botonDispobile = false;
        }
        datos = {
            accion: "cargarTablaNumTurnosCitas",
            IdUsuario: $sessionStorage.idusuario,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.respuesta === 'vacio') {
                $scope.servicioscitas = {};
            } else {
                $scope.servicioscitas = response.data.respuesta;
                $scope.observaciones = response.data.respuesta[0].MotivoDuracion.split(',')
                if (response.data.contar > 0) {
                    if (SinTurnos == "no hay") {
                        SinTurnos = "si hay";
                        notifi();
                    }
                } else {
                    SinTurnos = "no hay";
                }
            }
        }, function myError(response) {
        });
    }
    
    var interval = $interval(function () {
        if ($scope.ShowDisponible == true) {
            $scope.tablaMando = false;
        } else {
            $scope.tablaMando = true;
        }
        llenarTabla1();
        llenarTabla1citas();
        CargarCitasCalendario();
    }, 10000);

    $scope.Limpiarmodalcrearpersona = function () {
        $scope.usuInsertar = {
            NombreCompleto: "",
            Cedula: $scope.Cedula,
            Sexo: "",
            Direccion: "",
            Barrio: "",
            Telefono: "",
        };
    }

    $scope.EditarPesona = function (idpersona2) {
        datos = {
            accion: "TraerDatosEditar",
            IdPersona: idpersona2,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.usuEditarPer = {
                idPersona: response.data.respuesta[0].IdPersona,
                NombreCompleto: response.data.respuesta[0].NombreCompleto,
                Cedula: response.data.respuesta[0].Cedula,
                Sexo: response.data.respuesta[0].Sexo,
                Direccion: response.data.respuesta[0].Direccion,
                Barrio: response.data.respuesta[0].Barrio,
                Telefono: response.data.respuesta[0].Telefono,
                Fecha: response.data.respuesta[0].FechaNacimiento,
            };
        });
    }

    $scope.EditarCita = function (idcita, nombrepersona, cedula, fechacita, nombredoctor, IdDoctor, especialidad, usu) {
        var llamar = "";
        for (var i = 0; i < fechacita.length; i++) {
            if (fechacita[i] == " ") {
                llamar = llamar + "T";
            } else {
                llamar = llamar + fechacita[i];
            }
        }
        $scope.usuEditarCita = {
            Idcita: idcita,
            NombreCompleto: nombrepersona,
            Cedula: cedula,
            FechaCitavalue: llamar,
            NombreDoctor: nombredoctor,
            EspecialidadEditar: parseInt(usu.IdTipoRol)
        };
        iddoctorelejido = IdDoctor;
    }

    $scope.LimpiarDoctorEditar = function () {
        $scope.Nombre = "";
        $scope.usuEditarCita.NombreDoctor = "";
        iddoctorelejido = 0;
    }

    var idpersonaelejidocrearcita = "";
    $scope.ElegirPacienteCita = function (NombrePaciente, CedulaPaciente, IdUsuario) {
        idpersonaelejidocrearcita = IdUsuario;
        $scope.NombreCompletocita = NombrePaciente;
        $scope.CedulaCita = CedulaPaciente;
    }

    var iddoctorcrearelejido = "";
    $scope.ElegirdoctorcrearCita = function (IdUsuario, NombreDoctor) {
        iddoctorcrearelejido = IdUsuario;
        $scope.NombreDoctor = NombreDoctor;
    }

    function ValidarDoctorEspecialidadEditar() {
        if (($scope.usuEditarCita.NombreDoctor == "" || $scope.usuEditarCita.NombreDoctor == undefined)) {
            if ($scope.usuEditarCita.EspecialidadEditar == "" || $scope.usuEditarCita.EspecialidadEditar == undefined) {
                swal("Atención", "Debe ingresar un doctor o una especialidad");
                return false;
            }
        }
        if ($scope.usuEditarCita.NombreDoctor != "" && $scope.usuEditarCita.NombreDoctor != undefined) {
            if ($scope.usuEditarCita.EspecialidadEditar != "" && $scope.usuEditarCita.EspecialidadEditar != undefined) {
                swal("Atención", "Debe ingresar Solo el doctor o una especialidad");
                return false;
            }
        }
        if ($scope.usuEditarCita.NombreDoctor != "" && $scope.usuEditarCita.NombreDoctor != undefined) {
            if ($scope.usuEditarCita.EspecialidadEditar == "" || $scope.usuEditarCita.EspecialidadEditar == undefined) {
                return true;
            }
        }
        if ($scope.usuEditarCita.EspecialidadEditar != "" && $scope.usuEditarCita.EspecialidadEditar != undefined) {
            if ($scope.usuEditarCita.NombreDoctor == "" || $scope.usuEditarCita.NombreDoctor == undefined) {
                return true;
            }
        }
    }

    $scope.limpiarDoct = function () {
        $scope.NombreDoctor = "";
    }

    function convertDatePickerTimeToMySQLTime(str) {
        var month, day, year, hours, minutes, seconds;
        var date = new Date(str),
        month = ("0" + (date.getMonth() + 1)).slice(-2),
        day = ("0" + date.getDate()).slice(-2);
        hours = ("0" + date.getHours()).slice(-2);
        minutes = ("0" + date.getMinutes()).slice(-2);
        seconds = ("0" + date.getSeconds()).slice(-2);
        var mySQLDate = [date.getFullYear(), month, day].join("-");
        var mySQLTime = [hours, minutes, seconds].join(":");
        return [mySQLDate, mySQLTime].join(" ");
    }

    $scope.NombreDoctorSelect = function() {
        if(comprobarempty($scope.NombreDoctor)){
            
            $scope.SelectEspecialidadCita = true;
        }else{
            $scope.SelectEspecialidadCita = false;
        }
    }

    $scope.EspecialidadSelect = function() {
        if(comprobarempty($scope.Especialidad)){
            $scope.SelectDoctorCita = true;
        }else{
            $scope.SelectDoctorCita = false;
        }
    }
    
    $scope.guardarCita = function () {
        if (!ValidarDoctorEspecialidad()) {
            return;
        }
        var idEspecialidad = 0;
        if ($scope.Especialidad == undefined) {
            idEspecialidad = 0;
        } else {
            idEspecialidad = $scope.Especialidad;
        }
        if ($scope.NombreDoctor == undefined) {
            iddoctorelejido = 0;
        } else {
            iddoctorelejido = $scope.NombreDoctor;
        }
        if ($scope.CedulaCita == undefined || $scope.CedulaCita == "") {
            swal("Atención", "debe elegir un paciente para registrar la cita");
            return;
        } else {
            iddoctorelejido = $scope.NombreDoctor;
        }
        if ($scope.ConfirmarCitaCheck == undefined) {
            ConfirmarCitaCheck = 0;
        } else {
            if ($scope.ConfirmarCitaCheck == true) {
                ConfirmarCitaCheck = 1;
            } else {
                ConfirmarCitaCheck = 0;
            }
        }
        var datos = {};
        if(TurnoActual.respuesta){
            datos = {
                accion: "guardarCita",
                FechaCita: convertDatePickerTimeToMySQLTime($scope.FechaCita2),
                IdDoctor: $scope.NombreDoctor,
                IdUsuario:$sessionStorage.idusuario,
                IdPersona: $scope.CedulaCita,
                especialidad: $scope.Especialidad,
                nombrePaciente: $scope.NombreCompletocita,
                Turno : $scope.turno,
                idtemporal: TurnoActual.respuesta[0].IdTablaTemporal,
                ConfirmarCita: ConfirmarCitaCheck,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
        }else{
            datos = {
                accion: "guardarCita",
                FechaCita: convertDatePickerTimeToMySQLTime($scope.FechaCita2),
                IdDoctor: $scope.NombreDoctor,
                IdUsuario:$sessionStorage.idusuario,
                IdPersona: $scope.CedulaCita,
                especialidad: $scope.Especialidad,
                nombrePaciente: $scope.NombreCompletocita,
                idtemporal: 0,
                ConfirmarCita: ConfirmarCitaCheck,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
        }
        
        if($scope.Especialidad == 0){
            servicios.Mando(datos).then(function success(response) {
                if (response.data.respuesta != "" || response.data.respuesta != null || response.data.respuesta != undefined) {
                    swal("Atención", "Registro Guardado Correctamente");
                    $('#CrearCitaModal').modal('hide');
                    $scope.ConfirmarCitaCheck = '';
                    var NuevoEvento= {
                        title:  response.data.respuesta[0]['NombreCompleto'],
                        start:  convertDatePickerTimeToMySQLTime($scope.FechaCita2),
                        text:  response.data.Idcita
                    };
                    $('#CalendarioWeb').fullCalendar('renderEvent',NuevoEvento);
                    $scope.crearEvent={};
                } else {
                    $scope.alerta = response.data.respuesta;
                    $scope.tipoAlerta = "alert-danger";
                    $scope.MostrarAlerta = true;
                }
            });
        }else{
            servicios.Mando(datos).then(function success(response) {
                if (response.data.respuesta != "" || response.data.respuesta != null || response.data.respuesta != undefined) {
                    swal("Atención", "Registro Guardado Correctamente");
                    $('#CrearCitaModal').modal('hide');
                    $scope.ConfirmarCitaCheck = '';
                    var NuevoEvento= {
                        title:  response.data.respuesta[0]['NombreRol'],
                        start:  convertDatePickerTimeToMySQLTime($scope.FechaCita2),
                        text:  response.data.Idcita
                    };
                    $('#CalendarioWeb').fullCalendar('renderEvent',NuevoEvento);
                    $scope.crearEvent={};
                } else {
                    $scope.alerta = response.data.respuesta;
                    $scope.tipoAlerta = "alert-danger";
                    $scope.MostrarAlerta = true;
                }
            }); 
        }
    }

    var iddoctorelejido = "";
    $scope.ElegirdoctorCita = function (IdUsuario, NombreDoctor) {
        iddoctorelejido = IdUsuario;
        $scope.usuEditarCita.NombreDoctor = NombreDoctor;
        $scope.Nombre = "";
        $scope.mandodoctor = {};
    }

    function ValidarDoctorEspecialidad() {
        if (($scope.NombreDoctor == "" || $scope.NombreDoctor == undefined)) {
            if ($scope.Especialidad == "" || $scope.Especialidad == undefined) {
                swal("Atención", "Debe ingresar un doctor o una especialidad");
                return false;
            }
        }
        if ($scope.NombreDoctor != "" && $scope.NombreDoctor != undefined) {
            if ($scope.Especialidad != "" && $scope.Especialidad != undefined) {
                swal("Atención", "Debe ingresar Solo el doctor o una especialidad");
                return false;
            }
        }
        if ($scope.NombreDoctor != "" && $scope.NombreDoctor != undefined) {
            if ($scope.Especialidad == "" || $scope.Especialidad == undefined) {
                return true;
            }
        }
        if ($scope.Especialidad != "" && $scope.Especialidad != undefined) {
            if ($scope.NombreDoctor == "" || $scope.NombreDoctor == undefined) {
                return true;
            }
        }
    }

    $scope.FormEditarCita = function () {
        $scope.usuEditarCita.accion = "editarCita";
        $scope.usuEditarCita.iddoctorelejido = iddoctorelejido;
        $scope.usuEditarCita.FechaCitaNueva = fechacita;
        $scope.usuEditarCita.IdSede = $sessionStorage.IdSede;
        $scope.usuEditarCita.emp_id = $sessionStorage.IdEmpresa;
        if (!ValidarDoctorEspecialidadEditar()) {
            return;
        }
        var idEspecialidadEditar = 0;
        var iddoctorelejidoEditar = 0;
        if ($scope.usuEditarCita.FechaCita == undefined) {
            $scope.usuEditarCita.FechaCita = $scope.usuEditarCita.FechaCitavalue;
        } else {
            $scope.usuEditarCita.FechaCita = convertDatePickerTimeToMySQLTime($scope.usuEditarCita.FechaCita);
        }
        if ($scope.usuEditarCita.EspecialidadEditar == undefined) {
            $scope.usuEditarCita.EspecialidadEditar = 0;
        } else {
            $scope.usuEditarCita.EspecialidadEditar.Especialidad;
        }
        if ($scope.usuEditarCita.NombreDoctor == undefined) {
            $scope.usuEditarCita.iddoctorelejido = 0;
        } else {
            $scope.usuEditarCita.NombreDoctor;
        }
        servicios.Mando($scope.usuEditarCita).then(function success(response) {
            if (response.data.respuesta == "Editado Correctamente") {
                $scope.usuEditarCita = {};
                $scope.Cedula = "";
                $scope.mando = {};
                $('#EditarCitaModal').modal('hide');
            }
        });
    }

    $scope.FormEditarPersona = function () {
        $scope.usuEditarPer.accion = "editarPersona";
        $scope.usuEditarPer.IdSede =  $sessionStorage.IdSede;
        $scope.usuEditarPer.emp_id =  $sessionStorage.IdEmpresa;
        servicios.Mando($scope.usuEditarPer).then(function success(response) {
            if (response.data.respuesta == "Editado Correctamente") {
                $('#EditarModal').modal('hide');
            }
        });
        $scope.llenartablamando();
    }

    $scope.RepetirLlamado = function () {
        datos = {
            accion: "RepetirLlamado",
            Modulo: $sessionStorage.modulo,
            Turno: TurnoActual.respuesta[0]['Turno'],
            tv: TurnoActual.respuesta[0]['LlamadoTv'],
            NombrePaciente: TurnoActual.respuesta[0]['NombrePaciente'],
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.respuesta == "Llamado") {
            }
        });
    }

    $scope.GuardarObservacion = function () {
        $scope.ObservacionAsesor;
        datos = {
            accion: "GuardarObservacionAsesor",
            ObservacionAsesor: $scope.ObservacionAsesor,
            IdAuditoria: TurnoActual.respuesta[0].IdAuditoria,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $('#ObservacionModal').modal('hide');
        });
    }

    $scope.turnoAtender = "";

    $scope.TerminarTurno = function () {
        habilitarCalificador = false;
        datos = {
            accion: "TerminarTurno",
            terminarturnoestado: terminarturnoestado,
            idpersona: IdPersonaAtendida,
            IdAuditoria: TurnoActual2.respuesta[0].IdAuditoria,
            idEncuesta: idEncuestaGlobal,
            IdTemporal: TurnoActual2.respuesta[0].IdTablaTemporal,
            IdUsuario: IdUsuario,
            idservicio: TurnoActual2.respuesta[0].IdServicio,
            tiempoMaxServicio: TurnoActual2.respuesta[0].tiempoMax,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (ObservacionObligatoria == "Si") {
                $scope.ObservacionAsesorObligatoria = "";
                $('#ObservacionObligatoriaModal').modal('show');
            } else {
                TurnoActual = {};
            }
            reiniciarTiempo();
            CambiarEstadoUsuario(IdUsuario, 'DISPONIBLE');
            $sessionStorage.TiempoTransLLamado = 0;
            $scope.botonDispobile = false;
            $scope.ShowDisponible = true;
            $scope.ShowEstado = true;
            $scope.ShowConfirmarTurno = false;
            $scope.ShowRepetirLlamado = false;
            $scope.ShowObservaciones = false;
            $scope.ShowEditarEncuesta = false;
            $scope.ShowTerminarTurno = false;
            $scope.turno = '';
            $scope.servicio = '';
            delete $localStorage.TurnoActual;
            preguntasCalificadas = [];
        });
        servicios.NubeQr().then(function success(response) {
           
        });
        llenarTabla1();
    }

    $scope.GuardarObservacionObligatoria = function () {
        if ($scope.ObservacionAsesorObligatoria == "" || $scope.ObservacionAsesorObligatoria == null || $scope.ObservacionAsesorObligatoria == undefined) {
            swal("Atención", "La observación es Obligatoria");
            return;
        }
        console.log($scope.ObservacionAsesorObligatoriaOtro)
        console.log($scope.ObservacionAsesorObligatoria)
        datos = {
            accion: "ObservacionObligatoria",
            IdAuditoria: TurnoActual2.respuesta[0].IdAuditoria,
            observacionObligatoria: $scope.ObservacionAsesorObligatoria == 'otro' ? $scope.ObservacionAsesorObligatoriaOtro :$scope.ObservacionAsesorObligatoria,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $('#ObservacionObligatoriaModal').modal('hide');
        });
    }

    $scope.EditarEncuesta = function () {
        $scope.usuEncuestar = {};
        datos = {
            accion: "TraerDatosEncuesta",
            IdEncuesta: idEncuestaGlobal
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.usuEncuestar = {
                Asunto: response.data.respuesta[0].Asunto,
                Escolaridad: response.data.respuesta[0].NivelEscolaridad,
                TipoPoblacion: response.data.respuesta[0].TipoPoblacion
            };
        });
    }


    function notifi() {
        var audio = document.getElementById("audio");
        swal("Atención", "Turno Nuevo");
        audio.play();
    }

    $scope.cerrarSesionMando = function () {
        CambiarEstadoUsuario(IdUsuario, 'FUERA DE LINEA');
        /*
        datos = {
            accion: "CambiarEstadoUsuario",
            idusuario: IdUsuario,
            estado: 'FUERA DE LINEA'
        };
        servicios.Mando(datos);
        */
        delete $sessionStorage.modulo;
        $interval.cancel(interval);
        datos = {
            accion: "cambiarEstado",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa,
            Idusuario: IdUsuario,
            IdEstado: '7'
        };
        servicios.Mando(datos).then(function success(response) {
        });    
    }

    CambiarEstadoUsuario(IdUsuario, 'DISPONIBLE');
   
    var estado = 0;

    var idCitaEliminar = "";
    $scope.EliminarCita = function (IdCita, nombreUsuario, opcion) {
        if (opcion == "var") {
            idCitaEliminar = IdCita;
            $scope.UsuarioEliminar = nombreUsuario;
        }
        if (opcion == "Eliminar") {
            datos = {
                accion: "eliminarCita",
                IdCita: idCitaEliminar,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Mando(datos).then(function success(response) {
                if (response.data.respuesta == "Eliminado") {
                    $('#eliminarCita').modal('hide');
                    $scope.mando = {};
                }
            });
        }
    }

    $scope.Llamarservicio = function (idservicio, nombreservicio, idtablatemp) {
        $scope.tablaMando = true;
        datos = {
            accion: "LlamarIndividual",
            IdUsuario: IdUsuario,
            Modulo: $sessionStorage.modulo,
            IdServicio: idservicio,
            idtablatemp: idtablatemp,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.tipo == "NO HAY TURNOS") {
                SinTurnos = false;
                swal("Atención", "Ya no hay turnos Disponibles del servicio " + nombreservicio);
            } else {
                TurnoActual = response.data;
                TurnoActual2 = response.data;
                $localStorage.TurnoActual = response.data;
                if (response.data.respuesta[0].NombrePaciente == "" || response.data.respuesta[0].NombrePaciente == "Sin Registro") {
                    $scope.turno = response.data.respuesta[0].Turno;
                } else {
                    $scope.turno = response.data.respuesta[0].CedulaPersona + " -- " +response.data.respuesta[0].NombrePaciente + " -- " + response.data.respuesta[0].Turno;
                }
                if (response.data.respuesta[0].IdPersona != ""){
                    IdPersonaAtendida = response.data.respuesta[0].IdPersona;
                }
                $scope.servicio = response.data.respuesta[0].Servicio;
                $scope.modulo = response.data.modulos;
                $scope.ShowDisponible = false;
                $scope.ShowEstado = false;
                $scope.ShowConfirmarTurno = true;
                $scope.ShowRepetirLlamado = true;
                tiempollama = parseInt(response.data.respuesta[0].tiempoMax);
                ConsultaTiempoLLamado(TurnoActual.respuesta[0]["IdTablaTemporal"]);
                 //EmpezarTiempo(parseInt(response.data.respuesta[0].tiempoMax));
            }
        });
    }

    $scope.Llamarserviciocliente = function (idservicio, nombreservicio, idtablatemp) {
        llenarTabla1();
        $scope.tablaMando = true;
        datos = {
            accion: "LlamarIndividualCliente",
            IdUsuario: IdUsuario,
            Modulo: $sessionStorage.modulo,
            IdServicio: idservicio,
            idtablatemp: idtablatemp
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.tipo == "NO HAY TURNOS") {
                SinTurnos = false;
                swal("Atención", "Ya no hay turnos Disponibles del servicio " + nombreservicio);
            } else {
                TurnoActual = response.data;
                TurnoActual2 = response.data;
                $localStorage.TurnoActual = response.data;
                if (response.data.respuesta[0].NombrePaciente == "" || response.data.respuesta[0].NombrePaciente == "Sin Registro") {
                    $scope.turno = response.data.respuesta[0].Turno;
                } else {
                    $scope.turno = response.data.respuesta[0].NombrePaciente + " -- " + response.data.respuesta[0].Turno;
                }
                if (response.data.respuesta[0].IdPersona != ""){
                    IdPersonaAtendida = response.data.respuesta[0].IdPersona;
                }
                $scope.servicio = response.data.respuesta[0].Servicio;
                $scope.modulo = response.data.modulos;
                $scope.ShowDisponible = false;
                $scope.ShowEstado = false;
                $scope.ShowConfirmarTurno = true;
                $scope.ShowRepetirLlamado = true;
                EmpezarTiempo(parseInt(response.data.respuesta[0].tiempoMax));
            }
        });
    }

    $scope.evento1 = function () {
        $scope.eventoPri = "formPrincipal";
        $scope.ShowformPrincipal = false;
    }

    $scope.SacarTurnoTriage = function () {
        estadoenviartriage = "TURNO";
    }

    $scope.abrirModalCargarExcel = function () {
        $('#modalCarga').modal('show');
    }

    $scope.cargarArchivo = function (file) {
        $Upload.upload({
            url: 'http://' + ip + '/TurnoMasterV2/app/model/EnviarArchivoImportar.php?opcion=Citas',
            data: {
                file: file
            },
        }).then(function success(response) {
            if (response.data.accion == "error") {
                swal("Atención", response.data.motivo);
                return;
            } else if (response.data.accion == "hecho") {
                $http.get("http://" + ip + "/TurnoMasterV2/app/model/ImportarCitas.php?IdSede="+$sessionStorage.IdSede+"&emp_id="+$sessionStorage.IdEmpresa).then(function (response) {
                    if (response.data.respuesta == "bien") {
                        $('#modalCarga').modal('hide');
                        $scope.citasCargadas = response.data.insertados;
                        $('#CitasCargadas').modal('show');
                    } else {
                        swal("Atención", response.data.respuesta);
                    }
                });
            }
        }, function (resp) {
            swal("Atención", "Se presento algun error en la cargada del archivo");
        }, function (evt) {
        });
    }






    $scope.BotonCrearCitaClick = function () {
        $scope.SelectDoctorCita = true;
        $scope.SelectEspecialidadCita = true;
        $scope.MostrarAlerta = false;
        $scope.NombreCompletocita = "";
        $scope.CedulaCita = "";
        $scope.FechaCita2 = "";
        $scope.NombreDoctor = "";
        $scope.Especialidad = 0;
        $scope.HabilitarNombrePaciente = "disabled";
        datos = {
            accion: "TraerDoctores",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.Doctores = response.data.doctores;
        });
    }

    $scope.buscarPersonaPanel = false;
    $scope.buscarDoctorPanel = false;
    var contBuscarPersona = 0;
    var contBuscarDoctor = 0;

    $scope.BuscarPersona = function () {
        contBuscarPersona++;
        if ($scope.buscarPersonaPanel) {
            $scope.buscarPersonaPanel = false;
            $scope.buscarDoctorPanel = false;
        } else {
            $scope.buscarPersonaPanel = true;
            $scope.buscarDoctorPanel = false;
        }
    }

    $scope.BuscarDoctor = function () {
        contBuscarDoctor++;
        if ($scope.buscarDoctorPanel) {
            $scope.buscarPersonaPanel = false;
            $scope.buscarDoctorPanel = false;
        } else {
            $scope.buscarPersonaPanel = false;
            $scope.buscarDoctorPanel = true;
        }
    }

    $scope.BuscarPersona = function () {
        if ($scope.CedulaCita == "" || $scope.CedulaCita == undefined) {
            swal("Atención", "Para realizar la busqueda debe ingresar la cedula del paciente");
            return;
        }
        datos = {
            accion: "BuscarPersonaCedula",
            cedula: $scope.CedulaCita,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if (response.data.contarPaciente > 0) {
                $scope.NombreCompletocita = response.data.paciente[0].NombreCompleto;
            } else {
                $scope.NombreCompletocita = "";
                $scope.HabilitarNombrePaciente = "";
            }
        });
    }

    $scope.VerAgenda = function () {
        datos = {
            accion: "TraerDoctoresDia",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.doctores = response.data.doctores;
        });
        $('#VerAgenda').modal('show');
    }

    var IdDoctorCitaNueva = 0;

    $scope.VerAgendaDoctor = function (idDoctor, NombreDoctor) {
        $scope.exportarAgendaDoctor = '';
        datos = {
            accion: "TraerAgendaDoctor",
            IdUsuario: idDoctor,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.NOMBREDELDOCTOR = NombreDoctor;
            $scope.agendascita = response.data.Agenda;
            IdDoctorCitaNueva = idDoctor;
        });
        $('#VerAgenda').modal('hide');
        $('#AgendaDoctor').modal('show');
    }

    //
    $scope.ExportarAgendaMedicos = function(){
        if($scope.exportarAgendaDoctor == '' || $scope.exportarAgendaDoctor == undefined){
            swal("Atención", "Debe seleccionar un filtro");
        }else{
            datos = {
                accion: "ExportarAgendaMedicos",
                IdUsuario: $scope.exportarAgendaDoctor
            };
            servicios.ExportarAgendaMedicos(datos).then(function success(response) {
                if (response.data.respuesta == "Enviado Correctamente") {
                    $('#VerAgenda').modal('hide');
                    $('#modalDescargaAgenda').modal('show');
                    $scope.MostrarDescarga = true;
                    $scope.exportarAgendaDoctor = '';
                    $scope.linkdescargaagenda = "http://" + ip + "" + $urlBase + "reportes/ReporteAgendaMedicos.xlsx";
                    $scope.descargarReporteExcel = true;
                }
            });
        }
    }

    $scope.BotonCrearCitaClickDoctor = function () {
        $('#AgendaDoctor').modal('hide');
        $scope.MostrarAlerta = false;
        $scope.NombreCompletocita = "";
        $scope.CedulaCita = "";
        $scope.FechaCita2 = "";
        $scope.NombreDoctor = parseInt(IdDoctorCitaNueva);
        $scope.Especialidad = 0;
        $scope.HabilitarNombrePaciente = "disabled";
        datos = {
            accion: "TraerDoctores",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.Doctores = response.data.doctores;
        });
    }

    $scope.CancelarCalificacion = function () {
        if (HabilitarCalif) {
            return;
        }
        $('#ModalCalifcarUsuario').modal('hide');
        HabilitarCalif = false;
    }

    var HabilitarCalif = false;
    $scope.ListPreguntasShow = true;
    var IdPreguntaSeleccionada;

    $scope.ClicPregunta = function (pregunta, idpregunta) {
        if(preguntasCalificadas.includes(idpregunta)){
            swal("Atención", "La pregunta ya cuenta con una calificación en el turno actual");
        }else{
            HabilitarCalif = true;
            IdPreguntaSeleccionada = idpregunta;
            $scope.PreguntaElegida = pregunta;
            $scope.ListPreguntasShow = false;
        }
    }

    $scope.CancelarCalificacion2 = function () {
        $scope.PreguntaElegida = "";
        $scope.ListPreguntasShow = true;
        HabilitarCalif = false;
    }

    $scope.CalificacionUsuario = function () {
        $scope.ListPreguntasShow = true;
        if ($localStorage.TurnoActual == undefined || habilitarCalificador == false) {
            swal("Atención", "Debe estar atendiendo a un cliente para poder calificar");
            return;
        }
        datos = {
            accion: "cargarTabla",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Preguntas(datos).then(function success(response) {
            $scope.listaPreguntas = response.data.respuesta;
            $('#ModalCalifcarUsuario').modal('show');
        });
    }

    if ($localStorage.TurnoActual != undefined) {
        TurnoActual = $localStorage.TurnoActual;
        TurnoActual2 = $localStorage.TurnoActual;
        $scope.turno = TurnoActual.respuesta[0]['Turno'];
        $scope.servicio = TurnoActual.respuesta[0]['Servicio'];
        $scope.ShowDisponible = false;
        $scope.ShowEstado = false;
        $scope.ShowConfirmarTurno = true;
        $scope.ShowRepetirLlamado = true;
        $scope.botonDispobile = false;
        $scope.ClickSi();
        //EmpezarTiempo(parseInt(TurnoActual.respuesta[0]['tiempoMax']));
    } else {
        $scope.ShowDisponible = true;
        $scope.ShowEstado = true;
        $scope.ShowConfirmarTurno = false;
        $scope.ShowRepetirLlamado = false;
        $scope.botonDispobile = true;
    }

    var preguntasCalificadas =[];

    $(document).bind('keydown', 'shift+m', function () {
        Calificar(1);
    });
    $(document).bind('keydown', 'shift+r', function () {
        Calificar(2);
    });
    $(document).bind('keydown', 'shift+b', function () {
        Calificar(3);
    });
    $(document).bind('keydown', 'shift+e', function () {
        Calificar(4);
    });

    function Calificar(calificacion) {
        if (!HabilitarCalif) {
            return;
        }
        datos = {
            accion: "Calificar",
            IdUsuario: IdUsuario,
            NumCalif: calificacion,
            IdAuditoria: $localStorage.TurnoActual["respuesta"][0]["IdAuditoria"],
            IdPregunta: IdPreguntaSeleccionada,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        
        servicios.Calificacion(datos).then(function success(response) {
            if(calificacion == 1){
                reportarCalificacion(response.data.idCalificacion);
            }
            preguntasCalificadas.push(IdPreguntaSeleccionada);
            IdPreguntaSeleccionada = 0;
            $scope.MostrarCargar = true;
            var intervalCalif = $interval(function () {
                $interval.cancel(intervalCalif);
                HabilitarCalif = false;
                $scope.ListPreguntasShow = true;
                $scope.MostrarCargar = false;
            }, 2000);
        });
    }

///
    function reportarCalificacion(idcalificacion) {
        datos = {
            accion: "reportarCalificacionCorreo",
            idcalificacion: idcalificacion
        };
        servicios.Reportar(datos).then(function success(response) {
        });
    }

    //estado de los asesores
    //actualizar el estado del asesor
    actualizarEstado();
    function actualizarEstado() {
        datos = {
            accion: "actualizarEstado",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa,
            Idusuario: $sessionStorage.idusuario
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.asesor = {
                estadoActual: parseInt(response.data.respuesta[0]['estado_id'])
            };
        });
    }

    ///cambiar estado asesores
    $scope.cambiarEstado = function() {
        datos = {
            accion: "cambiarEstado",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa,
            Idusuario: $sessionStorage.idusuario,
            IdEstado: $scope.asesor.estadoActual
        };
        //
        servicios.Mando(datos).then(function success(response) {
            if(response.data.respuesta[0].estado_titulo!='Disponible'){
                $scope.ShowDisponible = false;
            }else{
                $scope.ShowDisponible = true;
            }
        });    
        //
    }

    //llenar tabla estados
    llenarTablaEstadoAsesor();
    function llenarTablaEstadoAsesor() {
        datos = {
        accion: "TraerEstadoAsesores",
        IdSede: $sessionStorage.IdSede,
        emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.estadoAsesores = response.data.respuesta;
        });
    }

    $scope.CargarEPS = function(){
        let datos = {
            accion: "CargarEPS",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Pacientes(datos).then(function success(response) {
            $scope.EPSList = response.data.respuesta;
        });
    }

    $scope.CargarEPS();

    //
    $scope.usu = {};
    $scope.FormRegistrarPersona = function(){
        if(comprobarempty($scope.usu.Cedula) ||
            comprobarempty($scope.usu.NombreCompleto) || 
            comprobarempty($scope.usu.EPS)
        ){
            swal("Atención","Los campos Nombre, # de identificación y eps son obligatorios");
        }else{
            $scope.usu.accion =  "guardarPersona";
            $scope.usu.IdSede =  $sessionStorage.IdSede;
            $scope.usu.emp_id =  $sessionStorage.IdEmpresa;
            $scope.usu.Fecha =  convertirFecha($scope.usu.Fecha);
            servicios.Pacientes($scope.usu).then(function success(response) {
                if(response.data.respuesta == 'Registro Guardado Correctamente'){
                    $('#RegistrarPersona').modal('hide');
                    swal("Atención", "Persona registrada correctamente");
                    $scope.usu = {};
                }
            });
        }
    }

    $scope.VerCalendario = function() {
        $scope.informacioncitas = !$scope.informacioncitas;
        $scope.calendariocitas = !$scope.calendariocitas;
        if($scope.calendariocitas){
            CargarCitasCalendario();
        }
    }

    $scope.datoscita = {};

    function mostrarCitaEspecifica(IdCita){
        $scope.datoscita = {};
        datos = {
            accion: "mostrarCitaEspecifica",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa,
            IdCita: IdCita
        };
        servicios.Mando(datos).then(function success(response) {
            $scope.datoscita = {
                NombreMedico: response.data.respuesta[0]['medicoNombre'],
                NombrePaciente: response.data.respuesta[0]['pacienteNombre'],
                Fecha: response.data.respuesta[0]['FechaCita'],
                Idcita: response.data.respuesta[0]['Idcita'],
                Estado: response.data.respuesta[0]['Estado']
            }
            $('#modalCitaEspecifica').modal('show');
        });
    };

    var arreglo = {};

    function CalendarioCitas() {
        $(document).ready(function () {
            $('#CalendarioWeb').fullCalendar({
                customButtons: {
                    myCustomButton: {
                        text: 'Eliminar citas',
                        click: function() {
                            $scope.BotonCrearCitaClick();
                            $('#modalEliminarV').modal('show');
                        }
                    }
                },
                header: {
                    left: 'today,prev,next',
                    center: 'title',
                    right: 'month, agendaDay,list,myCustomButton'
                },
                dayClick: function (date, jsEvent, view) {
                    
                },
                eventClick: function(info,jsEvent,view) {
                    $scope.eventoeliminarCall = info._id;
                    mostrarCitaEspecifica(info.text);
                },
                events: arreglo,
            });
        }); 
    }
    
    function CargarCitasCalendario() {
        datos = {
            accion: "CargarCitasCalendario",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if(response.data.respuesta != 'no hay citas actualmente'){
                arreglo = response.data.respuesta;
                
            }else{
                arreglo = {};
            }
            CalendarioCitas();
        });
        $('#CalendarioWeb').fullCalendar('destroy');
    }

    $scope.EliminarCitaEs = function (id,Idevento){
        datos = {
            accion: "EliminarCitaEspecifica",
            IdCita: id,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.Mando(datos).then(function success(response) {
            if(response.data.respuesta == 'Bien'){
                $('#CalendarioWeb').fullCalendar('removeEvents',Idevento);
                swal("Atención", "Registro eliminado correctamente");
                $('#modalCitaEspecifica').modal('hide');
            }
        }); 
    }

    $scope.EliminarPorFecha = function (){
        datos = {
            accion:"EliminarRangoFechas",
            FechaI:$scope.fechaInicial,
            FechaF:$scope.fechaFinal,
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        }
        servicios.Mando(datos).then(function success(response) {
            if(response.data.respuesta == 'Bien'){
                swal("Atención", "Registros eliminados correctamente");
                $('#modalEliminarV').modal('hide');
            }
        }); 
    }
    

    $scope.AcpetarEliminarCitasMedico = function() {
        if(comprobarempty($scope.NombreDoctorCitaEliminar)){
            swal("Atención", "Debe seleccionar un medico para eliminar las citas");
        }else{
        swal({
                title: "Esta seguro que desea eliminar las citas?",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Eliminar",
                closeOnConfirm: false
            },
            function () {
                datos = {
                    accion: "AcpetarEliminarCitasMedico",
                    idDoctor: $scope.NombreDoctorCitaEliminar,
                    IdSede: $sessionStorage.IdSede,
                    emp_id: $sessionStorage.IdEmpresa
                };
                servicios.Mando(datos).then(function success(response) {
                    $('#modalEliminarV').modal('hide');
                    swal("Atención", "Citas eliminadas correctamente");
                });
            });
        }
    }

    $scope.BuscarPersonaReg = function() {
        if(comprobarempty($scope.usu.Cedula)){
            swal("Atención", "Debe digitar el número de identificación");
        }else{
            let datos = {
                accion: "BuscarPersonaReg",
                cedula: $scope.usu.Cedula,
                IdSede: $sessionStorage.IdSede,
                emp_id: $sessionStorage.IdEmpresa
            };
            servicios.Pacientes(datos).then(function success(response) {
                $scope.usu = {
                    Cedula : response.data.respuesta[0]["Cedula"],
                    NombreCompleto : response.data.respuesta[0]["NombreCompleto"],
                    Sexo : response.data.respuesta[0]["Sexo"],
                    Direccion : response.data.respuesta[0]["Direccion"],
                    Barrio : response.data.respuesta[0]["Barrio"],
                    Telefono : response.data.respuesta[0]["Telefono"],
                    Fecha : response.data.respuesta[0]["FechaNacimiento"],
                    EPS : parseInt(response.data.respuesta[0]["EPS"])
                };
            });
        }
    }


   
}
