angular.module('TurnoMasterV2').controller('HoraAgendaController', InitController);
InitController.$inject = ['$scope', '$state','$localStorage', '$sessionStorage', 'servicios', 'urlBase', '$http'];

function InitController($scope, $state,$localStorage, $sessionStorage, servicios, $urlBase, $http) {
        
    $scope.horarios = false;
    $scope.dias = true;
    $scope.TipoUsuario = $localStorage.rolAdmin;
    var arraydias = [];
    $sessionStorage.emp_id = $sessionStorage.IdEmpresa;
    $scope.check = function (dato) {
        let datos = {
            accion: "SeleccionarDia",
            id_dia: dato,
            emp_id: $sessionStorage.emp_id,
            IdSede: $sessionStorage.IdSede
        }
        servicios.HoraAgenda(datos).then(function success(rsp) {
            $scope.Horarios = rsp.data.respuesta;
        });
    }

    $scope.Verhorario = function (idDia){
        $scope.horarios = true;
        $scope.dias = false;
        $localStorage.idDia = idDia;
        datos = {
            accion: "cargarHorario",
            dia: $localStorage.idDia,
            emp_id: $sessionStorage.emp_id,
            IdSede: $sessionStorage.IdSede
        }
        servicios.HoraAgenda(datos).then(function success(rsp) {
            $scope.Horarios = rsp.data.respuesta;
        });
    }

    $scope.volver = function (){
        $scope.horarios = false;
        $scope.dias = true;
        $localStorage.idDia = '';
        cargardias();
    }
    //  FUNCION PARA CONVERTIR EL FORMATO DE HORA DB PARA LA VENTA
    function convertirHora(str) {
        var month, day, year, hours, minutes, seconds;
        var date = new Date(str),
        month = ("0" + (date.getMonth() + 1)).slice(-2),
        day = ("0" + date.getDate()).slice(-2);
        hours = ("0" + date.getHours()).slice(-2);
        minutes = ("0" + date.getMinutes()).slice(-2);
        seconds = ("0" + date.getSeconds()).slice(-2);
        var mySQLDate = [date.getFullYear(), month, day].join("-");
        var mySQLTime = [hours, minutes, seconds].join(":");
        return [mySQLTime].join(" ");
    }
    cargardias();
    function cargardias() {
        datos = {
            accion: "cargardias",
            emp_id: $sessionStorage.emp_id,
            IdSede: $sessionStorage.IdSede
        }
        servicios.HoraAgenda(datos).then(function success(rsp) {
            $scope.dias = rsp.data.respuesta;
            console.log($scope.dias);
        });
    }

    

    $scope.eliminarHorario = function (IdHorarioAgenda) {
        datos = {
            accion: "eliminarHorario",
            emp_id: $sessionStorage.emp_id,
            IdSede: $sessionStorage.IdSede,
            IdHorarioAgenda: IdHorarioAgenda
        }
        servicios.HoraAgenda(datos).then(function success(rsp) {
            if (rsp.data.respuesta == 'bien') {
                swal("Atención", "La hora fue eliminada correctamente");
                $scope.Verhorario($localStorage.idDia);
            } else {
                swal("Atención", "No se puedo eliminar la hora seleccionada");
            }
        });
    }

    $scope.generarHorario = function () {

        $scope.hora.accion = "generarHorario";
        $scope.hora.horaInicial = convertirHora($scope.hora.horaInicial);
        $scope.hora.horaFinal = convertirHora($scope.hora.horaFinal);
        $scope.hora.idDia = $localStorage.idDia;
        $scope.hora.emp_id = $sessionStorage.emp_id;
        $scope.hora.IdSede = $sessionStorage.IdSede;
        servicios.HoraAgenda($scope.hora).then(function success(rsp) {
            if (rsp.data == "bien") {
                swal("Atención", "Horas agregadas correctamente");
                $scope.Verhorario($scope.hora.idDia);
                $scope.hora.horaInicial = "";
                $scope.hora.horaFinal = ""
            } else {
                swal("Atención", "Error en agregar las horas");
                $scope.hora.horaInicial = "";
                $scope.hora.horaFinal = ""
            }
        });
    }
}