angular.module('TurnoMasterV2').directive('dateInput', function(){
    return {
        restrict : 'A',
        scope : {
            ngModel : '='
        },
        link: function (scope) {
            if (scope.ngModel) scope.ngModel = new Date(scope.ngModel);
        }
    }
}).controller('GraficosController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios', 'urlBase', '$http'];
function InitController($scope, $state, $sessionStorage, servicios, $urlBase, $http) {
    $scope.timelapse = '14';
    $scope.id_servicio = '0';
    $scope.id_asesor = '0';
    $scope.colors= ["#540AC1",
    "#37EFEF",
    "#FCD400",
    "#FE4564",
    "#01C3A8",
    "#0002BF",
    "#FF33AC",
    "#AC33FF",
    "#33ACFF"];
    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    if ($sessionStorage.idusuario === undefined) {
        $state.go('login');
    } else {
        if ($sessionStorage.rol == "ASESOR") {
            $state.go('Mando');
        }
    }
    //
    var IdEmpresa = $sessionStorage.IdEmpresa;
    var IdSede = $sessionStorage.IdSede;
    //
    $scope.TipoUsuario = $sessionStorage.rol;
/*---------------------------------Grafica Barras-------------------------- */
    //Funcion para cargar los graficos de barras
    $scope.cargarGraficos = function (first = true,ff,fi) {
        if($scope.timelapse != '*'){
            $scope.fechaFinal = moment().format('YYYY-MM-DDT23:59:59.000z')
            $scope.fechaInicial = moment().subtract($scope.timelapse, 'days').format('YYYY-MM-DDT00:00:00.000z')
            if ($scope.fechaFinal === undefined || $scope.fechaInicial === undefined) {
                swal("Atención", "Debe seleccionar un rango de fechas!");
            } else {
                
                datos = {
                    accion: "cargarGraficos",
                    fechaI: $scope.fechaInicial,
                    fechaF: $scope.fechaFinal,
                    idempresa:IdEmpresa,
                    id_servicio:$scope.id_servicio,
                    id_asesor:$scope.id_asesor,
                    IdSede:IdSede
                };
                servicios.graficos(datos).then(function success(rsp) {
                    $scope.servicios = rsp.data.servicios;
                    $scope.asesores = rsp.data.asesores;
                    $scope.PromedioEsperaEnSala = rsp.data.promedios[0].PromedioEsperaEnSala;
                    $scope.PromedioEsperaConAsesor = rsp.data.promedios[0].PromedioEsperaConAsesor;
                    $scope.PromedioEsperaTotal = rsp.data.promedios[0].PromedioEsperaTotal;
                    graficaBarrasHora('horas', rsp.data.conteosPorHora, 'Servicios terminados x Horas',rsp.data.min);
                    graficaBarrasDia('cola', rsp.data.encola, 'Servicios En Cola x Dias');
                    graficaBarrasCola('dias', rsp.data.conteosPorDia, 'Servicios terminados x Dias');
                    graficaBarrasAsesor('asesor', rsp.data.serviciosPorUsuario, 'Servicios terminados x asesor');
                    graficaBarrasVentanillas('ventanillas', rsp.data.servicioVentanillas, 'Servicios x ventanillas');
                    graPiePromedios('promedios', rsp.data.promedios[0], 'Promedios');
                    graficaBarrasAusentes('ausentes', rsp.data.ausentes, 'Servicios ausentes x asesor');
                });
            }
        }else if(first == false){
            if (ff === undefined || fi === undefined) {
                swal("Atención", "Debe seleccionar un rango de fechas!");
            } else {
                $scope.fechaFinal = moment(ff).format('YYYY-MM-DDT23:59:59.000z')
                $scope.fechaInicial = moment(fi).format('YYYY-MM-DDT00:00:00.000z')
                datos = {
                    accion: "cargarGraficos",
                    fechaI: $scope.fechaInicial,
                    fechaF: $scope.fechaFinal,
                    idempresa:IdEmpresa,
                    id_servicio:$scope.id_servicio,
                    IdSede:IdSede
                };
                servicios.graficos(datos).then(function success(rsp) {
                    $scope.servicios = rsp.data.servicios;
                    $scope.PromedioEsperaEnSala = rsp.data.promedios[0].PromedioEsperaEnSala;
                    $scope.PromedioEsperaConAsesor = rsp.data.promedios[0].PromedioEsperaConAsesor;
                    $scope.PromedioEsperaTotal = rsp.data.promedios[0].PromedioEsperaTotal;
                    graficaBarrasHora('horas', rsp.data.conteosPorHora, 'Servicios terminados x Horas',rsp.data.min);
                    graficaBarrasDia('dias', rsp.data.conteosPorDia, 'Servicios terminados x Dias');
                    graficaBarrasCola('cola', rsp.data.encola, 'Servicios En Cola x Dias');
                    graficaBarrasAsesor('asesor', rsp.data.serviciosPorUsuario, 'Servicios terminados x asesor');
                    graficaBarrasVentanillas('ventanillas', rsp.data.servicioVentanillas, 'Servicios x ventanillas');
                    graPiePromedios('promedios', rsp.data.promedios[0], 'Promedios');
                    graficaBarrasAusentes('ausentes', rsp.data.ausentes, 'Servicios ausentes x asesor');
                });
            }
        }else{
            $scope.fechaFinal = undefined;
            $scope.fechaInicial = undefined;
        }
    };
    $scope.cargarGraficos();
    function graficaBarrasHora(valor, datos, titulo, minmax) {
        const keys = [];
        let min = parseInt(minmax.min_time.substring(0, 2));
        let max = parseInt(minmax.max_time.substring(0, 2));
        keys.push(min>12?min-12+' PM':min+' AM')
        for (let index = min+1; index < max; index++) {
            keys.push(index>12?index-12+' PM':index+' AM') 
        }
        const datos1 = Object.keys(datos);
        let objetoOrdenado = [];
        datos1.forEach(key => {
            
            objetoOrdenado.push({name:key,data:datos[key]})
        });
        const values = objetoOrdenado.map(item => {
            const data = new Array(keys.length).fill(0); // Inicializa un array de ceros con la misma longitud que el array de horas
          
            for (const hora in item.data) {
              const index = keys.indexOf(hora + ' AM');
              if (index !== -1) {
                data[index] += item.data[hora];
              }
            }
          
            return { name: item.name, data };
          });
        var myChartB = Highcharts.chart('graBarrashoras', {
            chart: {
                type: 'line'
            },
            title: {
                text: titulo
            },
            xAxis: {
                categories: keys,
            },
            colors:$scope.colors,
            yAxis: {
                title: {
                    text: titulo
                }
            },
            series:  values
        });
    }
    function graficaBarrasAsesor(valor, datos, titulo) {
        
        const keys = Object.keys(datos);

        let objetoOrdenado = [];
        keys.forEach(key => {
            objetoOrdenado.push({name:key,data:datos[key]})
        });
        const names = Object.keys(datos[keys[0]]);
            const values = [];
        for (let index = 0; index < names.length; index++) {
            let data = [];
            const element = names[index];
            Object.keys(datos).forEach(key => {
                data.push(datos[key][element]);
            });
            values.push({name:element,data:data})
        }
        
        var myChartB = Highcharts.chart('graBarrasAsesor', {
            chart: {
                type: 'column'
            },
            title: {
                text: titulo
            },
            xAxis: {
                categories: keys,
            },
            colors:$scope.colors, 
            yAxis: {
                title: {
                    text: titulo
                }
            },
            series: values
        });
    }
    function graficaBarrasAusentes(valor, datos, titulo) {
        
        const keys = Object.keys(datos);

        let objetoOrdenado = [];
        keys.forEach(key => {
            objetoOrdenado.push({name:key,data:datos[key]})
        });
        const names = Object.keys(datos[keys[0]]);
            const values = [];
        for (let index = 0; index < names.length; index++) {
            let data = [];
            const element = names[index];
            Object.keys(datos).forEach(key => {
                data.push(datos[key][element]);
            });
            values.push({name:element,data:data})
        }
        var myChartB = Highcharts.chart('graBarrasAusente', {
            chart: {
                type: 'column'
            },
            title: {
                text: titulo
            },
            xAxis: {
                categories: keys,
            },
            colors:$scope.colors, 
            yAxis: {
                title: {
                    text: titulo
                }
            },
            series: values
        });
    }
    function graficaBarrasVentanillas(valor, datos, titulo) {
        
        const keys = Object.keys(datos);

        let objetoOrdenado = [];
        keys.forEach(key => {
            objetoOrdenado.push({name:key,data:datos[key]})
        });
        console.log(keys)
        const names = Object.keys(datos[keys[0]]);
            const values = [];
        for (let index = 0; index < names.length; index++) {
            let data = [];
            const element = names[index];
            Object.keys(datos).forEach(key => {
                data.push(datos[key][element]);
            });
            values.push({name:element,data:data})
        }
        
        console.log(values)
        var myChartB = Highcharts.chart('graficaBarrasVentanillas', {
            chart: {
                type: 'column'
            },
            title: {
                text: titulo
            },
            xAxis: {
                categories: keys,
            },
            colors:$scope.colors, 
            yAxis: {
                title: {
                    text: titulo
                }
            },
            series: values
        });
    }

    function graficaBarrasDia(valor, datos, titulo) {
        
        const keys = Object.keys(datos);

        let objetoOrdenado = [];
        keys.forEach(key => {
            objetoOrdenado.push({name:key,data:datos[key]})
        });
        const names = Object.keys(datos[keys[0  ]]);
            const values = [];
        for (let index = 0; index < names.length; index++) {
            let data = [];
            const element = names[index];
            Object.keys(datos).forEach(key => {
                data.push(datos[key][element]);
            });
            values.push({name:element,data:data})
        }
        
        var myChartB = Highcharts.chart('graBarrasDias', {
            chart: {
                type: 'column'
            },
            title: {
                text: titulo
            },
            xAxis: {
                categories: keys,
            },
            colors:$scope.colors, 
            yAxis: {
                title: {
                    text: titulo
                }
            },
            series: values
        });
    }

    function graficaBarrasCola(valor, datos, titulo) {
        
        const keys = Object.keys(datos);

        let objetoOrdenado = [];
        keys.forEach(key => {
            objetoOrdenado.push({name:key,data:datos[key]})
        });
        const names = Object.keys(datos[keys[0  ]]);
            const values = [];
        for (let index = 0; index < names.length; index++) {
            let data = [];
            const element = names[index];
            Object.keys(datos).forEach(key => {
                data.push(datos[key][element]);
            });
            values.push({name:element,data:data})
        }
        var myChartB = Highcharts.chart('graBarrasCola', {
            chart: {
                type: 'column'
            },
            title: {
                text: titulo
            },
            xAxis: {
                categories: keys,
            },
            colors:$scope.colors, 
            yAxis: {
                title: {
                    text: titulo
                }
            },
            series: values
        });
    }

    function graPiePromedios(valor, datos, titulo) {
        Highcharts.chart('graPiePromedios', {
            chart: {
                type: 'pie'
            },
            title: {
                text: titulo
            },
            tooltip: {
                valueSuffix: ' Min'
            },
            
            colors:$scope.colors, 
            plotOptions: {
                series: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: [{
                        enabled: true,
                        distance: 20
                    }, {
                        enabled: true,
                        distance: -40,
                        format: '{point.percentage:.1f}%',
                        style: {
                            fontSize: '1.2em',
                            textOutline: 'none',
                            opacity: 0.7
                        },
                        filter: {
                            operator: '>',
                            property: 'Promedio',
                            value: 10
                        }
                    }]
                }
            },
            series: [
                {
                    name: 'Promedios',
                    colorByPoint: true,
                    data: [
                        {
                            name: 'Promedio Espera En Sala',
                            y: parseFloat(datos.PromedioEsperaEnSala)
                        },
                        {
                            name: 'Promedio Espera Con Asesor',
                            sliced: true,
                            selected: true,
                            y: parseFloat(datos.PromedioEsperaConAsesor)
                        },
                        {
                            name: 'Promedio Espera Total',
                            y: parseFloat(datos.PromedioEsperaTotal)
                        }
                    ]
                }
            ]
        });
        /*var myChartB = Highcharts.chart('graPiePromedios', {
            chart: {
                type: 'pie'
            },
            title: {
                text: titulo
            },
            colors:$scope.colors,
            series: {
                name: 'Promedio Espera En Sala',
                data: $scope.PromedioEsperaEnSala,
            },{
                
                name: 'Promedio Espera Con Asesor',
                data: $scope.PromedioEsperaConAsesor,
            }
                    {
                        name: ,
                        selected: true,
                        y: 
                    },
                    {
                        name: 'Promedio Espera Total',
                        y: $scope.PromedioEsperaTotal
                    }
                ]
            }
        });*/
    }

    //-------------- Graficos de Calificaciones ------------------------//
    $scope.cargarGraficosC = function () {
        if ($scope.fechaFinal === undefined || $scope.fechaInicial === undefined) {
            swal("Atención", "Debe seleccionar un rango de fechas!");
        } else {
            datos = {
                accion: "cargarGraficosC",
                fechaI: $scope.fechaInicial,
                fechaF: $scope.fechaFinal,
                idempresa:IdEmpresa,
                IdSede:IdSede
            };
            servicios.graficos(datos).then(function success(rsp) {
                graficaBarras2(5, rsp.data.graBC, 'Calificaciones', 'red', '#F4E821', '#007ACC', '#00953C');
                graficaPie2(5, rsp.data.graPC, 'Calificaciones', 'Calificaciones en el rango de fechas seleccionado' , 'red', '#F4E821', '#007ACC', '#00953C');
                $('#exampleModalLong').modal('show');
            });
        }
    };

    function graficaBarras2(valor, datos, titulo, c1, c2, c3, c4) {
        var myChartB = Highcharts.chart('graBarras' + valor, {
            chart: {
                type: 'column'
            },
            title: {
                text: titulo
            },
            colors: [c1, c2, c3, c4],
            xAxis: {
                categories: datos.fechas,

            },
            yAxis: {
                title: {
                    text: 'Servicios'
                }
            },
            series: datos.series
        });
    }

    function graficaPie2(valor, datos, titulo, subTitulo, c1, c2, c3, c4) {
        var myChartP = Highcharts.chart('graPie' + valor, {
            chart: {
                plotBackgroundColor: null,
                plotBorderWidth: null,
                plotShadow: false,
                type: 'pie'
            },
            title: {
                text: titulo
            },
            colors: [c1, c2, c3, c4],
            subtitle: {
                text: subTitulo
            },
            tooltip: {
                pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
            },
            accessibility: {
                point: {
                    valueSuffix: '%'
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        format: '<b>{point.name}</b>: {point.percentage:.1f} %'
                    }
                }
            },
            series: datos
        });
    }

    var datosTA1 ='';
    var datosTA2 ='';
    var datosTA3 ='';

    $scope.graficaspruebas = function () {
        if ($scope.fechaFinal === undefined || $scope.fechaInicial === undefined) {
            swal("Atención", "Debe seleccionar un rango de fechas!");
        } else {
            datos = {accion: "graficaspruebas", fechaI: $scope.fechaInicial, fechaF: $scope.fechaFinal,idempresa:Empresa};
            servicios.graficosPrueba(datos).then(function success(rsp) {
                datosTA1 = rsp.data.TA1;
                datosTA2 = rsp.data.TA2;
                datosTA3 = rsp.data.TA3;
                var myChartTA1 = Highcharts.chart('TA1', {
                    title: {
                        text: 'Cantidad de turnos por hora filtrado desde: ' +datosTA1.fecha,
                        },
                    yAxis: {
                        title: {
                            text: 'Cantidad de turnos'
                        }
                    },
                    xAxis: {
                        categories : datosTA1.categories,
                        title: {
                            text: 'Horas'
                        }
                    },
                    series: datosTA1.series,
                    responsive: {
                        rules: [{
                            condition: {
                            maxWidth: 500
                            },
                            chartOptions: {
                            legend: {
                                layout: 'horizontal',
                                align: 'center',
                                verticalAlign: 'bottom'
                            }
                            }
                        }]
                    }
                });

                var myChartTA2 = Highcharts.chart('TA2', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: "Promedio de atencion en minutos"
                    },
                    //colors: [c1, c2, c3, c4],
                    xAxis: {
                        categories: datosTA2.fecha,
                    },
                    yAxis: {
                        title: {
                            text: 'Promedio de tiempo de atención en minutos'
                        }
                    },
                    series: datosTA2.series,

                });
                
                var myChartTA3 = Highcharts.chart('TA3', {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'pie'
                    },
                    title: {
                        text: 'Browser market shares in January, 2018'
                    },
                    series: datosTA3
                });
            });
        }
    };
    

    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
           
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            console.log(datos);
            for(let i=0; i< claves.length; i++){
                //
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    
                    console.log(datos[clave].menu_direccion);
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}

