angular.module('TurnoMasterV2').controller('ConfigTvController', dashboardController);
dashboardController.$inject = ['$scope', '$state', '$localStorage', 'servicios', 'Upload', 'urlBase', '$http', '$sessionStorage'];
function dashboardController($scope, $state, $localStorage, $servicios, $Upload, $urlBase, $http, $sessionStorage) {
    
    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    if ($localStorage.idusuarioAdmin != undefined && $sessionStorage.estado != undefined) {
        if ($localStorage.rol == "ASESOR" && $sessionStorage.estado == "Asesor") {
            $state.go('Mando');
        } else if ($localStorage.rol == "ADMINISTRADOR" && $sessionStorage.estado == "Admin") {
            $state.go('dashboard');
        }
    }
    
    if(!$localStorage.idTv){
        datos = { 
            accion: "CargarPrimerTv",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        $servicios.ConfigTv(datos).then(function success(response) {
            let validar = response.data.respuesta;
            if(validar == "bien"){
                $localStorage.idTv = response.data.tv;
            }
        });
    }

    $scope.BtnConfigurarTodos = false;
    var ipservidor;

    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $localStorage.nombreUsuarioAdmin;

    CantidadTvs();
    function CantidadTvs() {
        datos = { 
            accion: "CantidadTvs",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        $servicios.ConfigTv(datos).then(function success(response) {
            let Ctvs = response.data.respuesta;
            if(Ctvs == "bien"){
                $scope.BtnConfigurarTodos = true;
            }else{
                $scope.BtnConfigurarTodos = false;
            }
        });
    }
    
    trearipservidor();
    function trearipservidor() {
        datos = { 
            accion: "trearipservidor",
            IdSede: $sessionStorage.IdSede,
            emp_id: $sessionStorage.IdEmpresa
        };
        $servicios.ConfigTv(datos).then(function success(response) {
            ipservidor = response.data.respuesta;
        });
    }
    
    var datos = {};
    var idTv;

    $scope.progressBar = false;
    $scope.ValueBar = 0;
    $scope.uploadPicEnable = false;
    $scope.GuardarDatosEnable = false;

    var IpVisualizador = "";
    var TipoDispositivo;
    datos.accion = 'traerIpVisualizador';
    datos.IdSede = $sessionStorage.IdSede;
    datos.emp_id = $sessionStorage.IdEmpresa;
    $servicios.ConfigTv(datos).then(function success(response) {
        IpVisualizador = response.data.respuesta;
        $scope.IpVisualizador = response.data.respuesta;
        $scope.tamanoFuente = response.data.DatosVisualizador[0]['TamanoLetra'];
        $scope.mensajeRotativo = response.data.DatosVisualizador[0]['mensaje'];
        $scope.VolumenVoz = response.data.DatosVisualizador[0]['VolumenVoz'];
        $scope.Dispositivo = response.data.DatosVisualizador[0]['TipoVisualizador'];
        TipoDispositivo = $scope.Dispositivo;
        $scope.NumTv = $localStorage.idTv;
        $scope.ModVisual = response.data.DatosVisualizador[0]['TvCode'];
        traerVideos();
        trearipservidor();
    });

    $scope.cargarImagen = function (file) {
        trearipservidor();
        let UrlPahtName = window.location.pathname;
        var datos = {};
        if(TipoDispositivo == '0' || TipoDispositivo == 0){
            ruta = 'http://' + ipservidor + UrlPahtName + 'app/model';
        }else{
            ruta = 'http://' + IpVisualizador + '/Visualizador' + $localStorage.idTv;
        }
        $Upload.upload({
            url: ruta + '/EnviarImagen.php', data: {file: file},
        }).then(function success(response) {
            if (response.data.accion == "hecho") {
                var datos = {};
                datos.accion = "guardarLogo";
                datos.NumeroTv = $localStorage.idTv;
                datos.nombreLogo = file.name;
                $servicios.ConfigTv(datos).then(function success(response) {
                    if (response.data.respuesta == "Logo Guardado Correctamente") {
                        $scope.LogoTv = "";
                        datos.accion = "CambiarParametrosVisualizador";
                        datos.NumeroTv = $localStorage.idTv;
                        $servicios.ConfigTv(datos);
                        swal("Atención", "El Logo se ha Cargado Exitosamente");
                        $scope.GuardarConfig();
                    }
                });
            }
        }, function (resp) {

        }, function (evt) {
        });
    }

    $scope.uploadPic = function (file) {
        trearipservidor();
        if ($scope.VolumenVideo == "" || $scope.VolumenVideo == undefined || (!($scope.VolumenVideo >= 0 && $scope.VolumenVideo <= 10))) {
            swal("Atención", "Debe ingresar un valor de volumen del 0 al 10");
            return;
        }
        var nombreVideo = file.name.replace(".mp4", "");
        var datos = {};
        datos.accion = "validarDatosVideo";
        datos.nombreVideo = nombreVideo;
        datos.NumeroVideo = $scope.NumeroVideo;
        datos.NumeroTv = $localStorage.idTv;
        $servicios.ConfigTv(datos).then(function success(response) {
            if (response.data.respuesta == "Bien") {
                $scope.uploadPicEnable = true;
                $scope.GuardarDatosEnable = true;
                $scope.progressBar = true;
                let UrlPahtName = window.location.pathname;
                if(TipoDispositivo == '0' || TipoDispositivo == 0){
                    ruta = 'http://' + ipservidor + UrlPahtName +'app/model';
                }else{
                    ruta = 'http://' + IpVisualizador + '/Visualizador' + $localStorage.idTv;
                }
                $Upload.upload({
                    url: ruta + '/ConfigTvVideos.php', data: {file: file},
                }).then(function success(response) {
                    if (response.data.accion == "hecho") {
                        var datos = {};
                        datos.accion = "guardarVideo";
                        datos.nombreVideo = nombreVideo;
                        datos.NumeroVideo = $scope.NumeroVideo;
                        datos.Volumen = $scope.VolumenVideo;
                        datos.NumeroTv = $localStorage.idTv;
                        $servicios.ConfigTv(datos).then(function success(response) {
                            if (response.data.respuesta == "Video Guardado") {
                                $scope.progressBar = false;
                                $scope.ValueBar = 0;
                                $scope.NumeroVideo = "";
                                $scope.picFile = "";
                                $scope.uploadPicEnable = false;
                                $scope.GuardarDatosEnable = false;
                                $scope.VolumenVideo = "";
                                traerVideos();
                                swal("Atención", "El video se ha Cargado Exitosamente");
                                $scope.GuardarConfig();
                            }
                        });
                    }
                }, function (resp) {
                    $scope.uploadPicEnable = false;
                    $scope.GuardarDatosEnable = false;
                    $scope.progressBar = false;
                    swal("Atención", "Se produjo un error en la subida del archivo");
                }, function (evt) {
                    var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
                    $scope.ValueBar = progressPercentage;
                });
            } else {
                swal("Atención", "El id o el Nombre del video ya se encuentra registrado");
            }
        });
    }

    function traerVideos() {
        datos.accion = 'traerVideos';
        datos.NumeroTv = $localStorage.idTv;
        $servicios.ConfigTv(datos).then(function success(response) {
            $scope.video = response.data.respuesta;
        });
    }

    $scope.EditarVolumen = function (idvideo, volumen)
    {
        if (volumen == "" || volumen == undefined) {
            swal("Atención", "Debe ingresar un valor numero para el volumen");
            return;
        } else{
            if (!(volumen >= 0 && volumen <= 10)) {
                swal("Atención", "El Volumen debe ser Mayor o igual a 0 y Menor o igual a 10");
                return;
            }
        }
        datos.accion = 'guardarvolumen';
        datos.idvideo = idvideo;
        datos.numTv = $localStorage.idTv;
        datos.volumen = volumen;
        $servicios.ConfigTv(datos).then(function success(response) {
        });
        $scope.GuardarConfig();
    }

    $scope.GuardarConfig = function () {
        trearipservidor();
        var datos = {};
        datos.accion = "guardarDatos";
        datos.NumeroTv = $localStorage.idTv;
        datos.MensajeR = $scope.mensajeRotativo;
        datos.Fuente = $scope.tamanoFuente;
        datos.VolumenVoz = $scope.VolumenVoz;
        datos.IpVisualizador = $scope.IpVisualizador;
        datos.TipoVisualizador = $scope.Dispositivo;
        datos.ModVisual = $scope.ModVisual;
        datos.IdSede = $sessionStorage.IdSede;
        datos.emp_id = $sessionStorage.IdEmpresa;
        $servicios.ConfigTv(datos).then(function success(response) {
            if (response.data.respuesta == "Guardado Correctamente") {
                swal("Atención", "Datos Guardados Correctamente");
                $scope.TvSeleccionado = $localStorage.idTv;
                $scope.SeleccionarTv();
            }
        });
    }

    $scope.cerrarAlerta = function () {
        $scope.MostrarAlerta = false;
    }

    $scope.EliminarVideo = function (idvideo, nombrevideo) {
        let UrlPahtName = window.location.pathname;
        if(TipoDispositivo == '0' || TipoDispositivo == 0){
            ruta = 'http://' + ipservidor + UrlPahtName + 'app/model';
        }else{
            ruta = 'http://' + IpVisualizador + '/Visualizador' + $localStorage.idTv;
        }
        $http.get( ruta + "/eliminarVideos.php?idvideo=" + idvideo + "&nombrevideo=" + nombrevideo + "&idTv=" + $localStorage.idTv).then(function (response) {
            if (response.data.respuesta == "video Eliminado") {
                traerVideos();
                swal("Atención", "El video " + nombrevideo + " se ha Eliminado Correctamente");
                $scope.GuardarConfig();
            }
        });
    }

    $scope.esconderContrasena = false;
    $scope.esconderEditarIP = true;

    $scope.abrirModal = function () {
        $scope.esconderContrasena = false;
        $scope.esconderEditarIP = true;
        $scope.ContraEditarIp = "";
        $('#modalEditarIPVisualizador').modal('show'); // abrir
    }

    $scope.EntrarEditarIp = function () {
        if ($scope.ContraEditarIp == "1235813A100") {
            $scope.esconderContrasena = true;
            $scope.esconderEditarIP = false;
            datos.accion = "traerIpVisualizador";
            datos.NumeroTv = $localStorage.idTv;
            $servicios.ConfigTv(datos).then(function success(response) {
                $scope.ipvisualizador = response.data.respuesta;
            });
        } else {
            swal("Atención", "la Contraseña es erronea");
        }
    }

    $scope.editarIpVisualizadorNueva = function () {
        $scope.esconderContrasena = false;
        $scope.esconderEditarIP = true;
        datos.accion = "EditarIpVisualizador";
        datos.NumeroTv = $localStorage.idTv;
        datos.IpNueva = $scope.ipvisualizador;
        $servicios.ConfigTv(datos).then(function success(response) {
            $('#modalEditarIPVisualizador').modal('hide');
        });
    }

    $scope.SeleccionTv = function () {
        datos = {};
        datos.accion = "TraerTv";
        $servicios.ConfigTv(datos).then(function success(response) {
            $scope.tvs = response.data.respuesta;
            $scope.TvSeleccionado = parseInt($localStorage.idTv);
        });
        $('#ModalCreacionTv').modal('show');
    }

    function Limpiar() {
        $scope.IpVisualizador = "";
        $scope.tamanoFuente = "";
        $scope.mensajeRotativo = "";
        $scope.VolumenVoz = "";
        $scope.NumTv = $localStorage.idTv;
    }
    
    $scope.SeleccionarTv = function () {
        datos.accion = 'traerIpVisualizadorIndividual';
        datos.IdVisualizador = $scope.TvSeleccionado;
        $servicios.ConfigTv(datos).then(function success(response) {
            IpVisualizador = response.data.respuesta;
            $scope.IpVisualizador = response.data.respuesta;
            $localStorage.idTv = response.data.DatosVisualizador[0]['estado'];
            $scope.tamanoFuente = response.data.DatosVisualizador[0]['TamanoLetra'];
            $scope.mensajeRotativo = response.data.DatosVisualizador[0]['mensaje'];
            $scope.VolumenVoz = response.data.DatosVisualizador[0]['VolumenVoz'];
            $scope.NumTv = $localStorage.idTv;
            traerVideos();
        });
        $('#ModalCreacionTv').modal('hide');
    }

    $scope.CrearTv = function () {
        datos.accion = 'CrearTv';
        datos.NumTv = $scope.NumVisualizadorCrear;
        $servicios.ConfigTv(datos).then(function success(response) {
            if (response.data.respuesta == "Creado Correctamente") {
                $scope.tvs = response.data.DatosVisualizador;
                $scope.NumVisualizadorCrear = "";
            } else {
                swal("Atención", "El Visualizador # " + $scope.NumVisualizadorCrear + " ya se encuentra registrado");
            }
        });
    }

    $scope.EliminarTv = function (idTvEliminar) {
        datos.accion = 'EliminarTv';
        datos.NumTv = idTvEliminar;
        $servicios.ConfigTv(datos).then(function success(response) {
            if (response.data.respuesta == "Eliminado Correctamente") {
                $scope.tvs = response.data.DatosVisualizador;
            } else {
                swal("Atención", response.data.respuesta);
            }
        });
    }
    
    $scope.ConfigurarTodos = function() {
        $scope.NumTv = "TODOS";
        $localStorage.idTv = "TODOS";
        $scope.BtnConfigurarTodos = false;
    }
    

    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
           
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            console.log(datos);
            for(let i=0; i< claves.length; i++){
                //
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    
                    console.log(datos[clave].menu_direccion);
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}

