angular.module('TurnoMasterV2').controller('ConfigTurnosPerdidosController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios'];
function InitController($scope, $state, $sessionStorage, servicios) {

    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;
    $scope.MostrarAlerta = false;

    $scope.checkboxModel = {
        value1: true,
        value2: 'YES'
    };
    
    $scope.checkboxModelQr = {
        value1: false,
        value2: 'NO'
    };

    llenarDatos();
    function llenarDatos() {
        datos = {
            accion: "cargarDatos"
        };
        servicios.ConfigTurnosPerdidos(datos).then(function success(response) {
            if (response.data.respuesta == "sin datos") {
                $scope.tiempoEspera = "0";
                $scope.NumeroLlamado = "0";
            } else {
                $scope.tiempoEspera = response.data.respuesta[0].TiempoEspera;
                $scope.NumeroLlamado = response.data.respuesta[0].NumeroLlamado;
            }
            if (response.data.permiso == 0) {
                $scope.checkboxModel.value1 = false;
            } else {
                $scope.checkboxModel.value1 = true;
            }
            if (response.data.permisoQR == 0) {
                $scope.checkboxModelQr.value1 = false;
            } else {
                $scope.checkboxModelQr.value1 = true;
            }
            
        
            Capt();
        });
    }

    function Capt() {
        if ($scope.checkboxModel.value1) {
            $scope.opcion = "Si";
        } else {
            $scope.opcion = "No";
        }
        if ($scope.checkboxModelQr.value1) {
            $scope.opcionQr = "Si";
        } else {
            $scope.opcionQr = "No";
        }
        
    }

    $scope.CapturarOpcion = function () {
        if ($scope.checkboxModel.value1) {
            $scope.opcion = "Si";
        } else {
            $scope.opcion = "No";
        }
    }
   
    
    $scope.CapturarOpcionQr = function () {
        if ($scope.checkboxModelQr.value1) {
            $scope.opcionQr = "Si";
        } else {
            $scope.opcionQr = "No";
        }
    }

    $scope.GuardarConfig = function () {
        var permiso;
        var permisoQr;
        if ($scope.checkboxModel.value1) {
            permiso = 1;
        } else {
            permiso = 0;
        };
        if ($scope.opcionQr == "Si") {
            permisoQr = 1;
        } else {
            permisoQr = 0;
        };
        datos = {
            accion: "guardarDatos",
            tiempoEspera: $scope.tiempoEspera,
            NumeroLlamado: $scope.NumeroLlamado,
            permiso: permiso,
            IdSede : $sessionStorage.IdSede,
            emp_id : $sessionStorage.IdEmpresa,
            permisoQr:permisoQr
        };
        servicios.ConfigTurnosPerdidos(datos).then(function success(response) {
            if (response.data.respuesta == "Guardado Correctamente") {
                swal("Atención", response.data.respuesta);
                llenarDatos();
            }
        });
    }

    $scope.cerrarAlerta = function () {
        $scope.MostrarAlerta = false;
    }

    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}