angular.module('TurnoMasterV2').controller('ConfigAtrilController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage','servicios','Upload','urlBase', '$http', 'servicios'];
function InitController($scope, $state, $sessionStorage,$servicios, $Upload, $urlBase, $http, servicios) {

    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    if ($sessionStorage.idusuario === undefined) {
        $state.go('login');
    } else {
        if ($sessionStorage.rol == "ASESOR") {
            $state.go('Mando');
        }
    }

    function comprobarempty(objeto) {
        if (objeto == "" || objeto == undefined) {
            return true;
        } else {
            return false;
        }
    }

    var ipservidor;

    trearipservidor();
    function trearipservidor() {
        datos = { 
            accion: "trearipservidor"
         };
        $servicios.ConfigTv(datos).then(function success(response) {
            ipservidor = response.data.respuesta;
        });
    }

    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;

    $scope.MostrarAlerta = false;

    $scope.checkboxModel = {
        value1: true,
        value2: 'YES'
    };
    
    $scope.checkboxModelQr = {
        value1: true,
        value2: 'YES'
    };

    $scope.checkboxModelNv = {
        value1: true,
        value2: 'YES'
    };

    $scope.checkboxModelTd = {
        value1: true,
        value2: 'YES'
    };

    $scope.checkboxModelPermisoSms = {
        value1: true,
        value2: 'YES'
    };

    llenarDatos();
    function llenarDatos() {
        datos = {
            accion: "cargarDatos"
        };
        servicios.ConfigAtril(datos).then(function success(response) {
            if (response.data.respuesta == "sin datos") {
                $scope.tiempoEspera = "0";
            } else {
                $scope.Mensaje = response.data.respuesta[0].mensaje;
            }
            if (response.data.permiso == 0) {
                $scope.checkboxModel.value1 = false;
            } else {
                $scope.checkboxModel.value1 = true;
            }
            if (response.data.PermisoQr == 0) {
                    $scope.checkboxModelQr.value1 = false;
            } else {
                $scope.checkboxModelQr.value1 = true;
            }
            if (response.data.PermisoNv == 0) {
                $scope.checkboxModelNv.value1 = false;
            } else {
                $scope.checkboxModelNv.value1 = true;
            }
            if (response.data.PermisoTd == 0) {
                $scope.checkboxModelTd.value1 = false;
            } else {
                $scope.checkboxModelTd.value1 = true;
            }
            if (response.data.PermisoSms == 0) {
                $scope.checkboxModelPermisoSms.value1 = false;
            } else {
                $scope.checkboxModelPermisoSms.value1 = true;
            }
            Capt();
        });
    }

    function Capt() {
        if ($scope.checkboxModel.value1) {
            $scope.opcion = "Si";
        } else {
            $scope.opcion = "No";
        }
        if ($scope.checkboxModelQr.value1) {
            $scope.opcionQr = "Si";
        } else {
            $scope.opcionQr = "No";
        }
        if ($scope.checkboxModelNv.value1) {
            $scope.opcionNv = "Si";
        } else {
            $scope.opcionNv = "No";
        }
        if ($scope.checkboxModelTd.value1) {
            $scope.opcionTd = "Si";
        } else {
            $scope.opcionTd = "No";
        }
        if ($scope.checkboxModelPermisoSms.value1) {
            $scope.opcionPermisoSms = "Si";
        } else {
            $scope.opcionPermisoSms = "No";
        }
    }

    $scope.CapturarOpcionAtril = function () {
        if ($scope.checkboxModel.value1) {
            $scope.opcion = "Si";
        } else {
            $scope.opcion = "No";
        }
    }

    $scope.CapturarOpcionQr = function () {
        if ($scope.checkboxModelQr.value1) {
            $scope.opcionQr = "Si";
        } else {
            $scope.opcionQr = "No";
        }
    }

    $scope.CapturarOpcionNv = function () {
        if ($scope.checkboxModelNv.value1) {
            $scope.opcionNv = "Si";
        } else {
            $scope.opcionNv = "No";
        }
    }

    $scope.CapturarOpcionTd = function () {
        if ($scope.checkboxModelTd.value1) {
            $scope.opcionTd = "Si";
        } else {
            $scope.opcionTd = "No";
        }
    }

    $scope.CapturarOpcionPermisoSms = function () {
        if ($scope.checkboxModelPermisoSms.value1) {
            $scope.opcionPermisoSms = "Si";
        } else {
            $scope.opcionPermisoSms = "No";
        }
    }


    $scope.contarCaracteres = function () {
        $scope.contarCaracteres2 = $scope.Mensaje.length;
    }

    $scope.GuardarConfigAtril = function () {
        if($scope.contarCaracteres2 == undefined){
            var permiso;
            var permisoQr;
            var permisoNv;
            var permisoTd;
            var permisoSms;
            if ($scope.checkboxModel.value1) {
                permiso = 1;
            } else {
                permiso = 0;
            }
            if ($scope.checkboxModelQr.value1) {
                permisoQr = 1;
            } else {
                permisoQr = 0;
            }
            if ($scope.checkboxModelNv.value1) {
                permisoNv = 1;
            } else {
                permisoNv = 0;
            }
            if ($scope.checkboxModelTd.value1) {
                permisoTd = 1;
            } else {
                permisoTd = 0;
            }
            if ($scope.checkboxModelPermisoSms.value1) {
                permisoSms = 1;
            } else {
                permisoSms = 0;
            }
            datos = {
                accion : "guardarDatos", 
                Mensaje : $scope.Mensaje, 
                permisoCedula : permiso, 
                permisoQr : permisoQr,
                permisoNv : permisoNv,
                permisoTd : permisoTd,
                permisoSms: permisoSms,
                // permisoNv : 5,
                IdSede : $sessionStorage.IdSede,
                emp_id : $sessionStorage.IdEmpresa
            };
            servicios.ConfigAtril(datos).then(function success(response) {
                if (response.data.respuesta == "Guardado Correctamente") {
                    swal("Atención", response.data.respuesta);
                    llenarDatos();
                }
            });
        }else{
            if ($scope.Mensaje.length > 100) {
                swal("Atención", "No se permite mas de 100 caracteres en el mensaje");
                return;
            }
            var permiso;
            var permisoQr;
            if ($scope.checkboxModel.value1) {
                permiso = 1;
            } else {
                permiso = 0;
            }
            if ($scope.checkboxModelQr.value1) {
                permisoQr = 1;
            } else {
                permisoQr = 0;
            }
            if ($scope.checkboxModelNv.value1) {
                permisoNv = 1;
            } else {
                permisoNv = 0;
            }
            if ($scope.checkboxModelTd.value1) {
                permisoTd = 1;
            } else {
                permisoTd = 0;
            }
            datos = {
                accion : "guardarDatos",
                Mensaje : $scope.Mensaje,
                permisoCedulaaaa : permiso,
                permisoQr : permisoQr,
                permisoNv : permisoNv,
                permisoTd : permisoTd,
                // permisoNv : 5,
                IdSede : $sessionStorage.IdSede,
                emp_id : $sessionStorage.IdEmpresa
            };
            servicios.ConfigAtril(datos).then(function success(response) {
                if (response.data.respuesta == "Guardado Correctamente") {
                    swal("Atención", response.data.respuesta);
                    llenarDatos();
                }
            });
        }
    }

    $scope.cerrarAlerta = function () {
        $scope.MostrarAlerta = false;
    }

    $scope.cargarLogoAtril = function (file) {
        let UrlPahtName = window.location.pathname;
        ruta = 'http://' + ipservidor + UrlPahtName +'app/model';
        $Upload.upload({
            url: ruta + '/EnviarImagenAtril.php', data: {file: file},
        }).then(function success(response) {
            if(response.data.accion == "hecho"){
                swal("Atención","Logo cargado correctamente");
            }else{
                swal("Atención","Error al cargar el logo");
            }
        }, function (resp) {
        }, function (evt) {
        });
    }

    var idOpcion = "";
    function cargarTercerNivel() {
        datos = {
            accion : "cargarTercerNivel",
            IdSede : $sessionStorage.IdSede,
            emp_id : $sessionStorage.IdEmpresa
        };
        servicios.ConfigAtril(datos).then(function success(response) {
            if(response.data.nivel != "error"){
                $scope.TituloNivel = response.data.nivel[0]['oidr_nombre'];
                idOpcion = response.data.nivel[0]['oidr_id'];
                $scope.OpcionesNivel = response.data.opcionesnv;
            }
        }); 
    }

    $scope.AbrirTercerNivel = function () {
        $('#ModalTercerNival').modal('show');
        cargarTercerNivel();
    }

    cargarTercerNivel();
    $scope.EditarTituloNivel = function() {
        let titulonivel = $scope.TituloNivel;
        datos = {
            accion : "EditarTituloNivel",
            titulonivel : titulonivel,
            idOpcion : idOpcion,
            IdSede : $sessionStorage.IdSede,
            emp_id : $sessionStorage.IdEmpresa
        };
        servicios.ConfigAtril(datos).then(function success(response) {
            if(response.data.respuesta != "error"){
                cargarTercerNivel();
                swal("Atención", "Editado correctamente");
            }
        });
    }

    $scope.CrearOpcionNivel = function() {
        let nombreOnv = $scope.NuevaOpcion;
        if(comprobarempty(nombreOnv)){
            swal("Atención", "Debe digitar el campo para crear una nueva opción");
        }else{
            datos = {
                accion : "CrearOpcionNivel",
                nombreOnv : nombreOnv,
                idOpcion : idOpcion,
                IdSede : $sessionStorage.IdSede,
                emp_id : $sessionStorage.IdEmpresa
            };
            servicios.ConfigAtril(datos).then(function success(response) {
                if(response.data.respuesta == "limite"){
                    swal("Atención", "Se ha alcanzado el limite de opciones");
                }else if(response.data.respuesta == "bien"){
                    swal("Atención", "Opción guardada correctamente");
                    cargarTercerNivel();
                    $scope.NuevaOpcion = '';
                }else{
                    swal("Atención", "Eror al guardar la opción");
                }
            });
        }   
    }

    $scope.EditarOpcionesNv = function(idopnv) {
        let nombre_onv = document.getElementById("onv"+idopnv).value;
        datos = {
            accion : "EditarOpcionesNv",
            idonv : idopnv,
            nombre_onv : nombre_onv,
            IdSede : $sessionStorage.IdSede,
            emp_id : $sessionStorage.IdEmpresa
        };
        servicios.ConfigAtril(datos).then(function success(response) {
            if(response.data.respuesta != "error"){
                cargarTercerNivel();
                swal("Atención", "Editado correctamente");
            }
        }); 
    }

    $scope.EliminarOpcionesNv = function(soidr_id,soidr_nombre) {
        swal({
            title: "Eliminar",
            text: "¿Desea eliminar la opción? " + soidr_nombre,
            type: "warning",
            animation: "slide-from-top",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Eliminar",
            cancelButtonText: "Cancelar",
            closeOnConfirm: false,
            closeOnCancel: true
        },
        function (isConfirm) {
            if (isConfirm) {
                let datos = {
                    accion: "EliminarOpcionesNv",
                    soidr_id: soidr_id,
                    IdSede : $sessionStorage.IdSede,
                    emp_id : $sessionStorage.IdEmpresa
                };
                servicios.ConfigAtril(datos).then(function success(response) {
                    let dato = response.data.respuesta;
                    if(dato == "eliminado"){
                        cargarTercerNivel();
                        swal("Atención", "Opción eliminada correctamente");
                    }else{
                        swal("Atención", "Error al eliminar la opción");
                    }
                });
            }
        });
    }

    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}