angular.module('TurnoMasterV2').controller('CalendarioController', InitController);
InitController.$inject = ['$scope', '$state', '$localStorage', 'servicios', 'urlBase', '$http', '$sessionStorage'];
function InitController($scope, $state, $localStorage, servicios, $urlBase, $http, $sessionStorage) {
    

    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }

    InicioCalendario ();
    
    function InicioCalendario (){
        datos = {
            accion: "CargarEventos",
            emp_id : $sessionStorage.IdEmpresa,
            IdSede : $sessionStorage.IdSede,
        };
        servicios.Calendario(datos).then(function success(response) {
            let eventos = response.data.respuesta;
            Calendario(eventos);
        });
    } 
    
    function Calendario(eventos) {
        $('#CalendarioWeb').fullCalendar({      
            header:{
                left:'today,prev,next,Miboton',
                center: 'title',
                right:'month,agendaDay,list,',
            },
            height: 550,
            with : 60,
            dayClick: function (date, jsEvent, view) {
                $scope.crearEvent.fecha = date.format();
                $scope.crearEvent.titulo = "Servicio Agendado";
                $scope.AjustarHora();
                $(this).css('background-color', '#CC313D');  
                $('#txtFecha').val(date.format());
                $("#examplemodal").modal();
                $('#CalendarioWeb').fullCalendar('render');
                $scope.showAgregar = true;
                $scope.showEliMod = false;
            },
            events:eventos,
            eventClick:function(calEvent,jsEvent,view){
                var arrayDeCadenas = calEvent.start._i.split(" ");
                $("#txtHora").val( arrayDeCadenas[1]);
                $scope.crearEvent.start = arrayDeCadenas[1];
                $("#txtFecha").val(arrayDeCadenas[0]);
                $scope.crearEvent.fecha = arrayDeCadenas[0];
                $scope.AjustarHora();
                $("#txtTitulo").val(calEvent.title);
                $scope.crearEvent.titulo =calEvent.title;
                $scope.id_eventoModifi=calEvent.id_evento;
                $scope.id_eventoeliminar=calEvent.id_evento;
                $scope.id_eventoModifiCall=calEvent._id;
                $scope.id_eventoeliminarCall=calEvent._id;
                datos={
                    accion:'AgregarCC',
                    id_evento:calEvent.id_evento,
                    Cedula: $sessionStorage.Cedula,
                }
                servicios.Dashboard(datos).then(function success(response) {  
                    $scope.showAgregar = false;
                    $scope.showEliMod = true;
                    if(response.data.respuesta==$sessionStorage.Cedula){
                        $("#examplemodal").modal();
                        $('#CalendarioWeb').fullCalendar('refetchEvents');
                    }
                })
            }
        });
    }

    function LimpiarFormulario(){
        $("#txtTitulo").val('');
        $("#tituloevento").val('');
    }

    $scope.TraerServicios = function () {
        for (var i = 0; i < arrayEmpresas.length; i++) {
            if ($scope.empresas.empresa == arrayEmpresas[i]["emp_id"]) {
                $scope.nombreEmpresaT = arrayEmpresas[i]["NombreEmpresa"];
            }
        }
        idEmpresaS = $scope.empresas.empresa;
        idusuario = $sessionStorage.idusuario;
        $scope.empresas.accion = "TraerServicios";
        $scope.empresas.idusuario = idusuario;

        if ($scope.empresas.empresa == null) {
            alert("¡Por favor seleccione una entidad!");
        } else {
            if ($scope.empresas.sede == null) {
                alert("¡Por favor seleccione una sede!");
            } else {
                $sessionStorage.IdSede = $scope.empresas.sede;
                servicios.Dashboard($scope.empresas).then(function success(response) {
                if (response.data.respuesta != "Nohay") {
                    $scope.ShowSolicitarTurno = false;
                    $scope.ShowServicios = true;
                    $scope.servicios = response.data.respuesta;
                } else {
                    alert("La empresa no tiene servicios activos");
                }
            });
            }
        }
        CargarEventos();
    };

    $scope.TraerSubServicios = function (IdServicio) {
        for (var i = 0; i < arrayEmpresas.length; i++) {
            if ($scope.empresas.empresa == arrayEmpresas[i]["emp_id"]) {
                $scope.nombreEmpresaT = arrayEmpresas[i]["NombreEmpresa"];
            }
        }
        idEmpresaS = $scope.empresas.empresa;
        idusuario = $sessionStorage.idusuario;
        $scope.empresas.accion = "TraerSubServicios";
        $scope.empresas.idusuario = idusuario;
        $sessionStorage.IdServicio = IdServicio;
        $scope.empresas.IdServicio = IdServicio;
        servicios.Dashboard($scope.empresas).then(function success(response) {
            if (response.data.estado != "NO tiene subservicio") {
                $scope.ShowSubServicios = true;
                $scope.ShowServicios = false;
                $scope.NameSubServicio = response.data.respuesta;
            } else {
                delete $sessionStorage.IdSubservicio;
                $("#tiposolicitud").modal("show");
                $scope.traerColaServicio(IdServicio);
            }
        });
    };

    $scope.ConSubServicios = function (IdSubservicio, IdRelacionServicio) {
        $sessionStorage.IdServicio = IdSubservicio;
        $sessionStorage.IdRelacionServicio = IdRelacionServicio;
        $("#tiposolicitud").modal("show");
    };

    $scope.AhoraMismo = function () {
        $("#tiposolicitud").modal("hide");
        IdUsuario = $sessionStorage.idusuario;
        IdEmpresa = $sessionStorage.IdEmpresa;
        IdSede = $sessionStorage.IdSede;
        IdServicio = $sessionStorage.IdServicio;
        datos = {
            accion: "TraerTurnoAhoraMismo",
            IdUsuario: IdUsuario,
            IdEmpresa: IdEmpresa,
            IdSede: IdSede,
            IdServicio: IdServicio,
            IdRelacionServicio: $sessionStorage.IdRelacionServicio,
            Cedula: $sessionStorage.Cedula,
        };
        servicios.Dashboard(datos).then(function success(response) {
            if (response.data.respuesta === "maximoAlcanzado" ||response.data.respuesta === "Nohay") {
                alert("El servicio alcanzo el máximo de atenciones el día de hoy!");
            } else {
                $scope.ShowServicios = false;
                $scope.ShowSubServicios = false;
                $scope.ShowTikect = true;
                $scope.ShowAjustarHora = false;
                Turno = response.data.Turno;
                Fecha = response.data.Fecha;
                Cedula = $sessionStorage.Cedula;
                Nombre = $sessionStorage.nombreUsuario;
                var str = Fecha;
                Fecha2 = str.split(" ");
                $scope.TurnoSolicitado = {
                    Turno: Turno,
                    Hora:Fecha2[1],
                    Fecha:Fecha2[0],
                    Nombre: Nombre,
                    Cedula: Cedula
                }
            }
        });
    };

    $scope.AjustarHora = function () {
        TraerHoras();
        $("#tiposolicitud").modal("hide");
    };

    $scope.ver = function () {
        $scope.ShowServicios = false;
        $scope.ShowAjustarHora = true;
        $scope.ShowSubServicios = false;
        $("#tiposolicitud").modal("hide");
    };

    $scope.Enviarhora = function (id_evento) {
        Fecha = $scope.crearEvent.fecha;
        HoraAjustada = $scope.ajustar.hora;
        IdUsuario = $sessionStorage.idusuario;
        IdEmpresa = $sessionStorage.IdEmpresa;
        IdSede = $sessionStorage.IdSede;
        IdServicio = $sessionStorage.IdServicio;
        datos = {
            accion: "TraerTurnoAgendado",
            IdUsuario: IdUsuario,
            IdEmpresa: IdEmpresa,
            IdSede: IdSede,
            id_evento:id_evento,
            IdServicio: IdServicio,
            Fecha:Fecha,
            HoraAjustada: HoraAjustada,
            IdRelacionServicio: $sessionStorage.IdRelacionServicio,
            Cedula: $sessionStorage.Cedula,
        };
        servicios.Dashboard(datos).then(function success(response) {
            if (response.data.respuesta === "maximoAlcanzado" || response.data.respuesta === "Nohay") {
                alert("El servicio alcanzo el máximo de atenciones el día de hoy!");
            } else {
                $scope.ShowServicios = false;
                $scope.ShowSubServicios = false;
                $scope.ShowTikect = true;
                $scope.ShowAjustarHora = false;
                Turno = response.data.Turno;
                Fecha = response.data.Fecha;
                Cedula = $sessionStorage.Cedula;
                Nombre = $sessionStorage.nombreUsuario;
                var str = Fecha;
                Fecha2 = str.split(" ");
                $scope.TurnoSolicitado = {
                    Turno: Turno,
                    Hora:Fecha2[1],
                    Fecha:Fecha2[0],
                    Nombre: Nombre,
                    Cedula: Cedula
                }
                var arreglo = {};
            }
        });
    };

    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
           
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            console.log(datos);
            for(let i=0; i< claves.length; i++){
                //
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    
                    console.log(datos[clave].menu_direccion);
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}