angular.module('TurnoMasterV2').controller('AsigServiciosController', InitController);
InitController.$inject = ['$scope', '$state', '$sessionStorage', 'servicios'];
function InitController($scope, $state, $sessionStorage, servicios) {
    
    if($sessionStorage.rol == "SUPERVISOR"){
        $scope.MenuNormal = false;
        $scope.MenuSupervisor = true;
        ValidarMenuSupervisor($sessionStorage.idusuario);
    }else{
        $scope.MenuSupervisor = false;
        $scope.MenuNormal = true;
    }


    $scope.TipoUsuario = $sessionStorage.rol;
    $scope.NombreUsuario = $sessionStorage.nombreUsuario;
    $scope.usuarios = {};

    CargarUsuario();
    function CargarUsuario() {
        datos = {
            accion: "CargarUsuarios",
            IdSede: $sessionStorage.IdSede, 
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.RelacionUsuSer(datos).then(function success(response) {
            $scope.usuarios = response.data.respuesta;
        });
    }

    function LlenarTablas(idUsuario) {
        datos = {
            accion: "ServicioRelacionados",
            idUsuario: idUsuario,
            IdSede: $sessionStorage.IdSede, 
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.RelacionUsuSer(datos).then(function success(response) {
            $scope.ServicioRelacionado = response.data.respuesta;
        });
        datos = {
            accion: "ServicioNoRelacionados",
            idUsuario: idUsuario,
            IdSede: $sessionStorage.IdSede, 
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.RelacionUsuSer(datos).then(function success(response) {
            $scope.ServicioNoRelacionado = response.data.respuesta;
        });
    }

    $scope.UsuarioSeleccionado = function () {
        LlenarTablas($scope.usuarioSelect);
    }
    
    $scope.AgregarServicio = function (idservicio) {
        datos = {
            accion: "RelacionarServicio",
            idUsuario: $scope.usuarioSelect,
            idServicio: idservicio,
            IdSede: $sessionStorage.IdSede, 
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.RelacionUsuSer(datos).then(function success(response) {
            LlenarTablas($scope.usuarioSelect);
        });
    }
    
    $scope.EliminarServicio = function (idservicio) {
        datos = {
            accion: "EliminarRelacionarServicio",
            idUsuario: $scope.usuarioSelect,
            idServicio: idservicio,
            IdSede: $sessionStorage.IdSede, 
            emp_id: $sessionStorage.IdEmpresa
        };
        servicios.RelacionUsuSer(datos).then(function success(response) {
            LlenarTablas($scope.usuarioSelect);
        });
    }

    function ValidarMenuSupervisor(idusuarioAdmin) {
        let datos = {
            accion: "ValidarMenuSupervisor",
            idusuarioAdmin: idusuarioAdmin
        };
        servicios.Dashboard(datos).then(function success(response) {
            let datos = response.data.respuesta;
            let claves = Object.keys(datos);
            for(let i=0; i< claves.length; i++){
                let clave = claves[i];
                if(datos[clave].control == '1' ){
                    switch (datos[clave].menu_direccion) {                        
                        case "Usuarios":
                            datos[clave].stilo = "estiloselecUsuarios";
                            datos[clave].icono = "fas fa-user";
                            break;
                        case "Modulo":
                            datos[clave].stilo = "estiloselecModulo";
                            datos[clave].icono = "fa fa-user-md";
                            break;
                        case "Servicios":
                            datos[clave].stilo = "estiloselecServicio";
                            datos[clave].icono = "fas fa-users";
                            break;
                        case "AsigServicios":
                            datos[clave].stilo = "estiloselecAsingServicio";
                            datos[clave].icono = "fa fa-user-plus";
                            break;
                        case "ConfigTurnosPerdidos":
                            datos[clave].stilo = "estiloselecConfigTurnosPerdidos";
                            datos[clave].icono = "fas fa-cogs";
                            break;
                        case "Graficos":
                            datos[clave].stilo = "estiloselecGraficos";
                            datos[clave].icono = "fas fa-chart-area";
                            break;
                        case "Reportes":
                            datos[clave].stilo = "estiloselecReportes";
                            datos[clave].icono = "fas fa-file-invoice";
                            break;
                        case "ConfigTv":
                            datos[clave].stilo = "estiloselecConfigTv";
                            datos[clave].icono = "fa fa-desktop";
                            break;
                        case "Pacientes":
                            datos[clave].stilo = "estiloselecPacientes";
                            datos[clave].icono = "fa fa-user";
                            break;
                        case "Preguntas":
                            datos[clave].stilo = "estiloselecPreguntas";
                            datos[clave].icono = "fa fa-question-circle";
                            break;
                        case "HoraAgenda":
                            datos[clave].stilo = "estiloselecHoraAgenda";
                            datos[clave].icono = "fa fa-book";
                            break;
                        case "ConfigAtril":
                            datos[clave].stilo = "estiloselecConfigAtril";
                            datos[clave].icono = "fa fa-cog";
                            break;
                      }
                }
            }
            $scope.direcciones = datos;
        });
    }
}